/************************************************************************/
/*                                                                      */
/* UNLOAD.C - Unload resident interrupt driver                          */
/*                                                                      */
/* Notes:                                                               */
/*                                                                      */
/*    Compile using MSC 5.1, large model (/AL).                         */
/*                                                                      */
/*       cl /c /Oailt /Gs /W3 /AL unload.c                              */
/*       link unload;                                                   */
/*                                                                      */
/************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <dos.h>

#include "tsr.h"

/************************************************************************/
/*                                                                      */
/************************************************************************/
void main (void)
{
	union REGS regs;
	struct SREGS sregs;
	unsigned pspseg;
	char *initblkptr;
	DOS_MEMBLK *memblkptr;

	/************************************/
	/* check if interrupt vector in use */
	/************************************/
	regs.h.ah = DOS_GETINT;
	regs.h.al = TSR_INT;
	intdosx (&regs, &regs, &sregs);
	if (!sregs.es && !regs.x.bx) {
		printf ("TSR is not loaded !\n");
		exit (1);
	}
	pspseg = sregs.es - 0x10;

	/*********************************************/
	/* unchain int_handler from interrupt vector */
	/*********************************************/
	regs.h.ah = DOS_SETINT;
	regs.h.al = TSR_INT;
	sregs.ds = 0;
	regs.x.dx = 0;
	intdosx (&regs, &regs, &sregs);

	/******************************/
	/* get first DOS memory block */
	/******************************/
	regs.h.ah = DOS_GETINITBLK;
	intdosx (&regs, &regs, &sregs);
	FP_SEG (initblkptr) = sregs.es;
	FP_OFF (initblkptr) = regs.x.bx;
	FP_SEG (memblkptr) = *((unsigned *) (initblkptr - 2));
	FP_OFF (memblkptr) = 0;

	/***************************************/
	/* free memory blocks allocated to TSR */
	/***************************************/
	for (;;) {
		if (memblkptr->ownerpsp == pspseg) {
			regs.h.ah = DOS_FREEMEM;
			sregs.es = FP_SEG (memblkptr) + 1;
			intdosx (&regs, &regs, &sregs);
		}
		if (memblkptr->signature == 'Z')
			break;
		FP_SEG (memblkptr) += memblkptr->segsize + 1;
	}
}
