/************************************************************************/
/*                                                                      */
/* TSR.C - Resident interrupt driver skeleton for MAGIC.                */
/*                                                                      */
/* Notes:                                                               */
/*                                                                      */
/*    Compile using MSC 5.1, large model (/AL).                         */
/*                                                                      */
/*       cl /c /Oailt /Gs /W3 /AL tsr.c                                 */
/*       link tsr /stack:2000 /cp:1;                                    */
/*                                                                      */
/*    When linking, use the /STACK:nnnn option to specify the maximum   */
/*    amount of stack required (in decimal).  Note that this stack is   */
/*    used to store local (automatic) variables only during startup.    */
/*    During the invocation of int_handler, the MAGIC caller's stack is */
/*    used instead.  Also, in order to shrink the size allocated by the */
/*    C startup code to the default data segment, use the /CP:nnnn      */
/*    option to specify the maximum segment allocation for the TSR (in  */
/*    decimal).  Typically, /CP:1 should be specified.  This causes the */
/*    maximum allocation to be set to the minimum required.             */
/*    Use the link /MAP option to analyse TSR memory requirements.      */
/*                                                                      */
/************************************************************************/

#include <stdlib.h>
#include <stdio.h>
#include <dos.h>

#include "tsr.h"

/************************************************************************/
/*                                                                      */
/* The empty definitions for _nullcheck, _setargv, _setenvp are used to */
/* save memory.  These definitions may be removed if required.          */
/*                                                                      */
/************************************************************************/
void _nullcheck (void);
#pragma alloc_text (_TEXT, _nullcheck)
void _nullcheck (void)
{
}

/************************************************************************/
/*                                                                      */
/************************************************************************/
void _setargv (void)
{
}

/************************************************************************/
/*                                                                      */
/************************************************************************/
void _setenvp (void)
{
}

/************************************************************************/
/*                                                                      */
/************************************************************************/
void interrupt cdecl far int_handler
	(unsigned es, unsigned ds, unsigned di, unsigned si, unsigned bp,
	 unsigned sp, unsigned bx, unsigned dx, unsigned cx, unsigned ax,
	 unsigned ip, unsigned cs, unsigned flags)
{
	unsigned rows, cols;			/* row & col size of MAGIC display block	*/
	unsigned len;					/* length of buffer								*/
	char far *bufptr;				/* pointer to MAGIC data buffer				*/

	_enable ();
	rows = cx >> 8;
	cols = cx & 0x00FF;
	len = rows * cols;
	FP_SEG (bufptr) = es;
	FP_OFF (bufptr) = di;

	flags &= ~CARRY_FLAG;
	switch (ax) {
	case 0x0000:	/* MAGIC write command */
		printf ("\n%.*s\n", len, bufptr);
		break;
	case 0x0100:	/* MAGIC read command */
		printf ("\n");
		scanf ("%10s", bufptr);
		break;
	default:
		flags |= CARRY_FLAG;
		break;
	}
}

/************************************************************************/
/*                                                                      */
/************************************************************************/
void main (void)
{
	unsigned far *mem_high;
	void (far *funcptr) ();
	union REGS regs;
	struct SREGS sregs;

	/************************************/
	/* check if interrupt vector in use */
	/************************************/
	regs.h.ah = DOS_GETINT;
	regs.h.al = TSR_INT;
	intdosx (&regs, &regs, &sregs);
	if (sregs.es || regs.x.bx)
		exit (1);

	/*******************************************/
	/* chain int_handler onto interrupt vector */
	/*******************************************/
	funcptr = (void (far *)()) int_handler;
	regs.h.ah = DOS_SETINT;
	regs.h.al = TSR_INT;
	sregs.ds = FP_SEG (funcptr);
	regs.x.dx = FP_OFF (funcptr);
	intdosx (&regs, &regs, &sregs);

	/**********************************/
	/* expand allocated memory to max */
	/**********************************/
#if MAX_MALLOC
	{
		char *p;
		p = malloc (MAX_MALLOC);
		free (p);
	}
#endif

	/********************************/
	/* exit to dos, remain resident */
	/********************************/
	regs.h.ah = DOS_TSRPROC;
	regs.h.al = 0;
	FP_SEG (mem_high) = _psp;
	FP_OFF (mem_high) = 2;
	regs.x.dx = *mem_high - _psp;
	intdosx (&regs, &regs, &sregs);
}

