/*-------------------------------------------------------------------------*/
/* This module includes a sample USERPROC routine.                         */
/*-------------------------------------------------------------------------*/
#include <string.h>
#include <ctype.h>
#include <malloc.h>

#include "usertsr.h"

/*-------------------------------------------------------------------------*/
/* Functions                                                               */
/*-------------------------------------------------------------------------*/
void    cdecl main (void);

long   *far cdecl add_sub (char *op, long *num1, long *num2);
double *far cdecl mul_div (char *op, double *num1, double *num2);
char   *far cdecl concat_ (char *str1, char *str2);
long   *far cdecl check_digit (long *mode, char *value);

/*-------------------------------------------------------------------------*/
/* define                                                                  */
/*-------------------------------------------------------------------------*/
#define FUNC_CNT     4

/*-------------------------------------------------------------------------*/
/*                                                                         */
/*-------------------------------------------------------------------------*/
static FUNC_DSC fdsc_tbl[FUNC_CNT] =
   {
      { (Uchar *) "add_sub", add_sub, 3, (Uchar *) "ALLL" },
      { (Uchar *) "mul_div", mul_div, 3, (Uchar *) "ADDD" },
      { (Uchar *) "concat_", concat_, 2, (Uchar *) "AAA"  },
      { (Uchar *) "check_digit", check_digit, 2, (Uchar *) "LAL" }
   };

static TSR_MODULE tsr_module =
   {  0, NULL_PTR, NULL_PTR, FUNC_CNT, fdsc_tbl, (Uchar *) "myudf" };

/*-------------------------------------------------------------------------*/
/*                                                                         */
/*-------------------------------------------------------------------------*/
void cdecl main (void)
{
   /*------------------------------------------------------------------*/
   /* 1) if you plan to use floating point operations, you may need to */
   /*    place a dummy floating operation here to help your compiler   */
   /*    find its floating point libraries (i.e. Borland C)            */
   /*                                                                  */
   /* 2) second parameter specifies memory amount which is left for    */
   /*    TSR. Be careful!                                              */
   /*------------------------------------------------------------------*/
   userproc_tsr (&tsr_module, 512L);
}

/*-------------------------------------------------------------------------*/
/*                                                                         */
/*-------------------------------------------------------------------------*/
long *far cdecl add_sub (char *op, long *num1, long *num2)
{
   static long num3;
   switch (*op)
   {
      case 'A':
         num3 = *num1 + *num2;
         break;
      case 'S':
         num3 = *num1 - *num2;
         break;
      default:
         num3 = 0;
         break;
   }
   return (&num3);
}

/*-------------------------------------------------------------------------*/
/*                                                                         */
/*-------------------------------------------------------------------------*/
double *far cdecl mul_div (char *op, double *num1, double *num2)
{
   static double num3;

   switch (*op)
   {
      case 'M':
         num3 = *num1 * *num2;
         break;
      case 'D':
         if (*num2 == 0)
            num3 = 0;
         else
            num3 = *num1 / *num2;
         break;
      default:
         num3 = 0;
         break;
   }
   return (&num3);
}

/*-------------------------------------------------------------------------*/
/*                                                                         */
/*-------------------------------------------------------------------------*/
char *far cdecl concat_ (char *str1, char *str2)
{
   static char str3[100];
   int  len1;
   int  len2;

   len1 = strlen (str1);
   len2 = strlen (str2);
   if (len1 + len2 + 1 > sizeof (str3))
      return ("");
   strcpy (str3, str1);
   strcat (str3, "_");
   strcat (str3, str2);
   return (str3);
}

/*------------------------------------------------------------------------*/
/*                                                                        */
/*------------------------------------------------------------------------*/
long *far cdecl check_digit (long *mode, char *value)
{
   static char weight_vals[10] = {1, 2, 5, 3, 6, 4, 8, 7, 10, 9};
   static long res;
   int    pos;
   int    len;
   int    mul;
   int    mod;
   char   c;
   int    digits;

   res = 0L;
   len = strlen (value);
   mod = (int) *mode;
   switch (mod)
   {
      case 0:
         mul = 2;
         for (pos = len; pos > 0; pos--)
         {
            c = value[pos - 1];
            digits = (c - '0') * mul;
            res += digits + (digits > 9 ? 1 : 0);
            mul = 3 - mul;
         }
         res %= 10;
         if (res)
            res = 10 - res;
         break;
      case 1:
         for (pos = len; pos > 0; pos--)
         {
            mul = weight_vals[(len - pos) % 10];
            c = value[pos - 1];
            c = toupper (c);
            if (isdigit (c))
               digits = (c - '0') * mul;
            else
               if ((c >= 'A') && (c <= 'Z'))
                  digits = (c - 'A' + 1) * mul;
               else
                  digits = 0;
            res += digits;
         }
         res %= 11;
         if (res)
            res = 11 - res;
         break;
   }

   return (&res);
}

