/*-------------------------------------------------------------------------*/
/* This module includes a sample USERPROC routine.                         */
/*-------------------------------------------------------------------------*/
#include "usertsr.h"

/*-------------------------------------------------------------------------*/
/* Functions                                                               */
/*-------------------------------------------------------------------------*/
void cdecl main (void);

void far cdecl add_sub (char *op, long *num1, long *num2, long *num3);
void far cdecl mul_div (char *op, long *num1, long *num2, long *num3);

/*-------------------------------------------------------------------------*/
/* define                                                                  */
/*-------------------------------------------------------------------------*/
#define FUNC_CNT     2

/*-------------------------------------------------------------------------*/
/*                                                                         */
/*-------------------------------------------------------------------------*/
static FUNC_DSC fdsc_tbl[FUNC_CNT] = 
{
   { (Uchar far *) "add_sub", (void far *) add_sub, 4, (Uchar far *) "ALLL" },
   { (Uchar far *) "mul_div", (void far *) mul_div, 4, (Uchar far *) "ALLL" }
};

static TSR_MODULE tsr_module =
   {  0, NULL_PTR, NULL_PTR, FUNC_CNT, fdsc_tbl, (Uchar *) "myproc" };

/*-------------------------------------------------------------------------*/
/*                                                                         */
/*-------------------------------------------------------------------------*/
void cdecl main (void)
{
   /*------------------------------------------------------------------*/
   /* 1) if you plan to use floating point operations, you may need to */
   /*    place a dummy floating operation here to help your compiler   */
   /*    find its floating point libraries (i.e. Borland C)            */
   /*                                                                  */
   /* 2) second parameter specifies memory amount which is left for    */
   /*    TSR. Be careful!                                              */
   /*------------------------------------------------------------------*/
   userproc_tsr (&tsr_module, 1024L);
}

/*-------------------------------------------------------------------------*/
/*                                                                         */
/*-------------------------------------------------------------------------*/
void far cdecl add_sub (char *op, long *num1, long *num2, long *num3)
{
   switch (*op)
   {
      case 'A':
         *num3 = *num1 + *num2;
         break;
      case 'S':
         *num3 = *num1 - *num2;
         break;
      default:
         *num3 = 0;
         break;
   }
}

/*-------------------------------------------------------------------------*/
/*                                                                         */
/*-------------------------------------------------------------------------*/
void far cdecl mul_div (char *op, long *num1, long *num2, long *num3)
{
   switch (*op)
   {
      case 'M':
         *num3 = *num1 * *num2;
         break;
      case 'D':
         if (*num2 == 0)
            *num3 = 0;
         else
            *num3 = *num1 / *num2;
         break;
      default:
         *num3 = 0;
         break;
   }
}
