UNIT HandleIniFile;
{$D-}
(* ----------------------------------------------------------------------
   Part of 4DESC - A Simple 4DOS File Description Editor
       and 4FF   - 4DOS File Finder

   (c) 1992 Copyright by David Frey,
                         Urdorferstrasse 30
                         8952 Schlieren ZH
                         Switzerland

       Code created using Turbo Pascal 6.0 (c) Borland International 1990

   DISCLAIMER: This unit is freeware: you are allowed to use, copy
               and change it free of charge, but you may not sell or hire
               this part of 4DESC. The copyright remains in our hands.

               If you make any (considerable) changes to the source code,
               please let us know. (send a copy or a listing).
               We would like to see what you have done.

               We, David Frey and Tom Bowden, the authors, provide absolutely
               no warranty of any kind. The user of this software takes the
               entire risk of damages, failures, data losses or other
               incidents.

   This unit handles the reading of settings stored in 4TOOLS.INI.

   ----------------------------------------------------------------------- *)

INTERFACE

CONST INIFileExists : BOOLEAN = FALSE;

PROCEDURE ReadIniFile;

FUNCTION  ReadSettingsChar(Section,Name: STRING; Default: CHAR): CHAR;
FUNCTION  ReadSettingsString(Section,Name: STRING; Default: STRING): STRING;
FUNCTION  ReadSettingsInt(Section,Name: STRING; Default: INTEGER): INTEGER;
FUNCTION  ReadSettingsColor(Section,Name: STRING; Default: INTEGER): BYTE;

IMPLEMENTATION USES Dos, StringDateHandling;

CONST INIFileName = '4TOOLS.INI';
      MaxLines    = 41;

VAR INIFile : TEXT;
    INIPath : DirStr;
    MaxLine : INTEGER;
    Line    : ARRAY[1..MaxLines] OF STRING[48];

    Name    : NameStr;
    Ext     : ExtStr;

PROCEDURE ReadIniFile;

VAR semicol : BYTE;
    ReadLine: STRING;
    s       : STRING;

BEGIN
 (* Search strategy for 4TOOLS.INI :
      i) Directory where this application has started from.
     ii) Environment variable 4TOOLS
    iii) Path                                                   *)

 FSplit(ParamStr(0),INIPath,Name,Ext);
 IF INIPath[Length(INIPath)] = '\' THEN Delete(INIPath,Length(INIPath),1);
 s := GetEnv('4TOOLS');
 IF s > '' THEN
  BEGIN
   IF s[Length(s)] = '\' THEN Delete(s,Length(s),1);
   INIPath := INIPath + ';'+s;
  END;
 INIPath := INIPath + ';'+GetEnv('PATH');
 IF INIPath[Length(INIPath)] = '\' THEN Delete(INIPath,Length(INIPath),1);
 INIPath := FSearch(INIFileName,INIPath);

 INIFileExists := (INIPath > '');
 IF INIFileExists THEN
  BEGIN
   Assign(INIFile,INIPath);
   Reset(INIFile);
   INIFileExists := (IOResult = 0);

   IF IniFileExists THEN
    BEGIN
     MaxLine := 1;
     WHILE NOT Eof(INIFile) AND (MaxLine <= MaxLines) DO
      BEGIN
       ReadLn(INIFile,ReadLine);
       StripLeadingSpaces(ReadLine);

       IF ReadLine[1] <> ';' THEN
        BEGIN
         semicol := Pos(';',ReadLine);
         IF semicol > 0 THEN ReadLine := Copy(ReadLine,1,semicol-1);

         IF Length(ReadLine) > 0 THEN
          BEGIN
           StripTrailingSpaces(ReadLine);
           Line[MaxLine] := DownStr(ReadLine); INC(MaxLine);
          END;
        END; (* IF Line[1] <> ';' .. *)
      END; (* WHILE *)

     IF NOT Eof(INIFile) THEN
      BEGIN
       WriteLn('WARNING: '''',INIFileName,'''' exceeding ',MaxLines,' lines!');
       WriteLn('         Parts of your settings will be ignored.');
      END;

     Close(INIFile);
    END; (* INIFileExists .. *)
  END; (* INIFileExists .. *)
END; (* ReadIniFile *)

FUNCTION  ReadSettingsString(Section,Name: STRING; Default: STRING): STRING;

VAR LineNr: BYTE;
    eq    : BYTE;
    s,res : STRING;

BEGIN
 LineNr := 1;
 Section := '['+DownStr(Section)+']';
 WHILE (Line[LineNr] <> Section) AND (LineNr <= MaxLine) DO INC(LineNr);
 IF Line[LineNr] = Section THEN
  BEGIN
   DownString(Name); res := ''; s := '';
   REPEAT
    s  := Line[LineNr]; eq := Pos('=',s);
    IF eq > 0 THEN s := Copy(s,1,eq-1);
    StripTrailingSpaces(s);
    INC(LineNr);
   UNTIL (s = Name) OR (LineNr > MaxLine);

   IF s = Name THEN
    BEGIN
     res := Copy(Line[LineNr-1],eq+1,255);
     StripLeadingSpaces(res);
    END
   ELSE res := Default;
  END
 ELSE res:= Default;
 ReadSettingsString := res;
END;

FUNCTION  ReadSettingsChar(Section,Name: STRING; Default: CHAR): CHAR;

VAR s : STRING;

BEGIN
 s := ReadSettingsString(Section,Name,Default);
 ReadSettingsChar := s[1];
END;

FUNCTION  ReadSettingsInt(Section,Name: STRING; Default: INTEGER): INTEGER;

VAR s  : STRING;
    res: INTEGER;
    v  : INTEGER;

BEGIN
 Str(Default,s);
 s := ReadSettingsString(Section,Name,s);
 Val(s,v,res);
 IF res > 0 THEN v := Default;
 ReadSettingsInt := v;
END;

FUNCTION  ReadSettingsColor(Section,Name: STRING; Default: INTEGER): BYTE;

CONST color : ARRAY[0..15] OF STRING[12] =
              ('black'   ,'blue'        ,'green'     ,'cyan'     ,
               'red'     ,'magenta'     ,'brown'     ,'lightgray',
               'darkgray','lightblue'   ,'lightgreen','lightcyan',
               'lightred','lightmagenta','yellow'    ,'white');

VAR s  : STRING;
    c  : BYTE;

BEGIN
 Str(Default,s);
 s := ReadSettingsString(Section,Name,'');

 IF s > '' THEN
  BEGIN
   c := 0;
   WHILE (color[c] <> s) AND (c<16) DO INC(c);
   IF color[c] <> s THEN c := Default;
  END
 ELSE c := Default;
 ReadSettingsColor := c;
END;

BEGIN
 ReadIniFile;
END.
