UNIT Globals;
{$D-}
(* ----------------------------------------------------------------------
   Part of 4FF   - 4DOS File Finder

   (c) 1992 Copyright by David Frey,
                         Urdorferstrasse 30
                         8952 Schlieren ZH
                         Switzerland

   DISCLAIMER: This unit is freeware: you are allowed to use, copy
               and change it free of charge, but you may not sell or hire
               this part of 4DESC. The copyright remains in our hands.

               If you make any (considerable) changes to the source code,
               please let us know. (send a copy or a listing).
               We would like to see what you have done.

               We, David Frey and Tom Bowden, the authors, provide absolutely
               no warranty of any kind. The user of this software takes the
               entire risk of damages, failures, data losses or other
               incidents.


       Code created using Turbo Pascal 6.0 (c) Borland International 1990

   This unit provides the string handling and the date/time handling.

   ----------------------------------------------------------------------- *)

INTERFACE USES Dos, StringDateHandling;

CONST MaxComments       = 1024;
      MaxFileSpecs      =    6;
      DescLen           =   50;

TYPE  DescStr           = STRING[DescLen];
      DescArrayType     = ARRAY[1..MaxComments]  OF DescStr;
      NameExtStr        = STRING[8+1+3];
      FileSpecArrayType = ARRAY[1..MaxFileSpecs] OF NameExtStr;

(* command line flags: *)

VAR   ExactAttr                : BOOLEAN;
      DoScanLZHArchives        : BOOLEAN;
      DoScanZIPArchives        : BOOLEAN;
      SubDirectories, AllDrives: BOOLEAN;
      BareOutput               : BOOLEAN;
      Drive                    : CHAR;

(* Global variables *)

VAR   Attr                     : BYTE;
      DirSize,   TotalSize     : LONGINT;
      FileCount, TotalFileCount: WORD;

VAR   FileName                 : NameExtStr;
      Search                   : SearchRec;
      Path                     : PathStr;
      Name                     : NameStr;
      Dir                      : DirStr;
      Ext                      : ExtStr;

VAR   InfoArray                : ARRAY[0..5] OF LONGINT;
      AttrStr, FileStr, SizeStr: STRING;
      Date                     : DateStr;
      Time                     : TimeStr;
      DateRec                  : DateTime;

VAR   csize                    : LONGINT;    (* compressed size *)
      fstamp                   : DateTime;   (* last mod file date/time (turbo format) *)
      s                        : STRING;

(* Templates for FormatStr *)

VAR   DateTempl : STRING[4];
      TimeTempl : STRING[4];
      DescTempl : STRING[5];

VAR   MaxViewLength: BYTE;

(* Buffer related  variables: *)

CONST MaxBufSize = 65500;

TYPE  PBuffer = ^TBuffer;
      TBuffer = ARRAY[0..MaxBufSize] OF BYTE;

VAR   BufPtr    : LONGINT;
      BytesRead : WORD;
      BufSize   : WORD;
      FilePtr   : LONGINT;

VAR   Buffer    : PBuffer;

PROCEDURE InstallLZHBuffer;
PROCEDURE FreeLZHBuffer;
FUNCTION  ReadByte: BYTE;

IMPLEMENTATION

PROCEDURE InstallLZHBuffer;

BEGIN
 IF MaxAvail < MaxBufSize THEN BufSize:= WORD(MaxAvail)
                          ELSE BufSize:= MaxBufSize;

 GetMem(Buffer,BufSize);
 IF Buffer = NIL THEN
  BEGIN
   WriteLn(Output);
   WriteLn(Output,'Fatal Error : Unable to allocate Buffer!');
   HALT(255);
  END;
END; (* InstallLZHBuffer *)

PROCEDURE FreeLZHBuffer;

BEGIN
 FreeMem(Buffer,BufSize);
END; (* FreeLZHBuffer *)

FUNCTION ReadByte: BYTE;

BEGIN
 ReadByte := Buffer^[BufPtr]; INC(BufPtr); INC(FilePtr);
END; (* ReadByte *)


BEGIN
 Str(Length(DateFormat),DateTempl); DateTempl := '%'+DateTempl+'s';
 Str(Length(TimeFormat),TimeTempl); TimeTempl := '%'+TimeTempl+'s';
 MaxViewLength := 80-33-Length(DateFormat)-Length(TimeFormat);
 Str(MaxViewLength,DescTempl);      DescTempl := '%-'+DescTempl+'s';
END.