PROGRAM ResEdit;

{$M 32768}

RESOURCE ResEdit;

USES PmTypes,PMObject,Crt,PmDialog,ResDlg;


CONST
     CM_GROUPBOX=500;
     CM_LISTBOX=501;
     CM_BUTTON=502;
     CM_ICON=503;
     CM_CHECKBOX=504;
     CM_RADIOBOX=505;
     CM_ENTRYFIELD=506;
     CM_TEXT=507;
     CM_NEWRES=508;
     CM_DELETERES=509;
     CM_SELECTRES=510;
     CM_EDITSTYLE=511;
     CM_EDITCOLORS=512;
     CM_EDITPRESPARAMS=513;
     CM_ARRANGE=514;
     CM_OPTION=515;
     cm_help1=516;

TYPE PDlgList=^TDlgList;
     TDlgList=RECORD
                    Typ:LONGWORD;
                    Text:STRING;
                    Flags:LONGWORD;
                    Color,BackColor:INTEGER;
                    x,y,cx,cy:LONGINT;
                    id:LONGWORD;
                    idConstName:STRING;
                    Next:PDlgList;
              END;

     PResList=^TResList;
     TResList=RECORD
                    Typ:WORD;
                    Data:POINTER;
                    Next:PResList;
              END;

     TArcParams=RECORD
                      lp,lq,lr,ls:LONGWORD;
                END;

TYPE TMyApp=OBJECT(TMDIApplication)
                  Grid:BYTE;
                  Options:LONGWORD;
                  Untitled:BOOLEAN;
                  FileName:STRING;
                  DlgCount:LONGWORD;
                  DlgList:PDlgList;
                  ActualDlg:PDlgList;
                  DlgWin,DlgFrWin:HWND;
                  SelectedDlg:HWND;
                  DlgActive,DragActive:BOOLEAN;
                  Dragx,Dragy,Dragcx,Dragcy:INTEGER;
                  Selection:BOOLEAN;
                  Selectx,Selecty,Selectcx,Selectcy:INTEGER;
                  MoveMode,MoveStart:BOOLEAN;
                  SizeLowNS,SizeHighNS:BOOLEAN;
                  SizeLeftWE,SizeRightWE:BOOLEAN;
                  SizeLeftUp,SizeLeftDown:BOOLEAN;
                  SizeRightUp,SizeRightDown:BOOLEAN;
                  CONSTRUCTOR Init;
                  DESTRUCTOR Done;
                  PROCEDURE HandleCommand(Win:HWND;Command:WORD):VIRTUAL;
                  PROCEDURE MDICreateNotify(MDIFrWin,MDIWin:HWND;Data:POINTER):VIRTUAL;
                  PROCEDURE MDIWMMouseMove(Win:HWND;x,y:INTEGER;Data:POINTER):VIRTUAL;
                  PROCEDURE DrawRec;
                  PROCEDURE WMButton1Down(Win:HWND;x,y:INTEGER):VIRTUAL;
                  PROCEDURE MDIWMButton1DoubleClick(Win:HWND;x,y:INTEGER;Data:POINTER):VIRTUAL;
                  PROCEDURE MDIWMButton1Down(Win:HWND;x,y:INTEGER;Data:POINTER):VIRTUAL;
                  PROCEDURE WMMenuSelect(Win:HWND;para1:POINTER):VIRTUAL;
                  PROCEDURE MakePermanent;
                  PROCEDURE NewDlgItem(Typ:LONGWORD);
                  PROCEDURE MDIRedraw(rc:RECTL;_hps:HPS;Win:HWND;data:POINTER):VIRTUAL;
                  FUNCTION MDIHandleEvent(Win:HWND;Msg:LONGWORD;
                                          para1,para2:POINTER;
                                          VAR Handled:BOOLEAN;
                                          Data:POINTER):LONGWORD:VIRTUAL;
                  PROCEDURE DrawElement(Dlg:PDlgList;_hps:HPS);
                  PROCEDURE DrawDlgString(Dlg:PDlgList;x,y:INTEGER;_hps:HPS);
                  FUNCTION CheckSelection(x,y:INTEGER):PDlgList;
                  PROCEDURE MakeSelection(Dlg:PDlgList);
                  PROCEDURE UnsetSelection;
                  PROCEDURE MDIWMButton1Up(Win:HWND;x,y:INTEGER;Data:POINTER):VIRTUAL;
                  PROCEDURE WMButton1Up(Win:HWND;x,y:INTEGER):VIRTUAL;
                  PROCEDURE UnsetMoveMode;
                  PROCEDURE MDIHandleScanEvent(Win:HWND;scan:Word;Data:POINTER):VIRTUAL;
                  PROCEDURE SaveProject;
                  PROCEDURE EraseProject;
                  PROCEDURE WMClose(VAR Msg:TMessage):VIRTUAL WM_CLOSE;
                  PROCEDURE WMMDIClose(Win:HWND;Data:POINTER):VIRTUAL;
                  PROCEDURE NewResource(Typ:WORD;Data:POINTER);
                  PROCEDURE DisableControls;
                  PROCEDURE EnableControls;
                  PROCEDURE AppCreateNotify(AppFrWin,AppWin:HWND):VIRTUAL;
                  PROCEDURE NewDlgEntry;
                  PROCEDURE EditStyle;
                  PROCEDURE Arrange;
                  PROCEDURE WMSize(VAR Msg:TMessage):VIRTUAL WM_SIZE;
                  PROCEDURE MDIWMSize(Win:HWND;Data:POINTER):VIRTUAL;
            END;

VAR MyApp:TMyApp;

    MovePtr:LONGWORD;
    ArrowPtr:LONGWORD;
    SIZENWSEPtr:LONGWORD;
    SIZENESWPtr:LONGWORD;
    SIZEWEPtr:LONGWORD;
    SIZENSPtr:LONGWORD;
    Resources:PResList;

TYPE TSizel=RECORD
                  x,y:LONGWORD;
            END;

IMPORTS
       FUNCTION WinDrawBorder(flCmd,clrBack,ClrFore,cy,cx:LONGWORD;
                               VAR rec:RECTL;hp:HPS):LONGWORD:   PMWIN index 731;
       PROCEDURE WinReleasePS(_hps:HPS):                         PMWIN index 848;
       FUNCTION  WinGetPS(Win:HWND):HPS:                         PMWIN index 757;
       FUNCTION WinCreateWindow(pPresParams:POINTER;
                                pCtlData:POINTER;
                                id:LONGWORD;
                                hwndInsertBehind:HWND;
                                hwndOwner:HWND;
                                cy,cx,y,x:LONGWORD;
                                flStyle:LONGWORD;
                                pszName:PSZ;
                                Class:LONGWORD;
                                hwndParent:HWND):HWND:          PMWIN index 909;
       FUNCTION WinSetWindowPos(fl:LONGWORD;
                                 cy,cx,y,x:LONGWORD;
                                 hwndInsertBehind:HWND;
                                 _hwnd:HWND):LONGWORD:           PMWIN index 875;
       FUNCTION WinQueryWindow(cmd:LONGWORD;
                               _hwnd:HWND):LONGWORD:            PMWIN index 834;
       FUNCTION WinSubClassWindow(Proc:POINTER;
                                  Win:HWND):POINTER:            PMWIN index 929;
       FUNCTION WinDefWindowProc(para2,para1:POINTER;msg:LONGWORD;
                                  Win:HWND):LONGWORD:           PMWIN index 911;
       FUNCTION WinFillRect(lColor:LONGWORD;
                            VAR prcl:RECTL;
                            _hps:HPS):LONGWORD:                 PMWIN index 743;
       FUNCTION GpiSetColor(lColor:LONGWORD;
                            _hps:HPS):LONGINT:                  PMGPI index 517;
       FUNCTION GpiSetBackColor(lColor:LONGINT;
                                _hps:HPS):LONGWORD:             PMGPI index 504;
       FUNCTION GpiSetBackMix(lMixMode:LONGINT;
                              _hps:HPS):LONGWORD:               PMGPI index 505;
       FUNCTION GpiCharStringAt(VAR pchString;
                                lCount:LONGWORD;
                                VAR pptlPoint:POINTL;
                                _hps:HPS):LONGWORD:             PMGPI index 359;
       PROCEDURE WinSetPointer(hptr:LONGWORD;
                               Desktop:HWND):                   PMWIN index 866;
       FUNCTION WinQuerySysPointer(Copy:LONGWORD;Ident:LONGWORD;
                                   Desktop:HWND):LONGWORD:      PMWIN index 828;
       FUNCTION WinLoadPointer(id:LONGWORD;
                               hmod:LONGWORD;
                               Desktop:HWND):LONGWORD:          PMWIN index 780;
       FUNCTION WinDestroyWindow(_hwnd:HWND):
                                  LONGWORD:                     PMWIN index 728;
       PROCEDURE GpiSetArcParams(VAR p:TArcParams;_hps:HPS):    PMGPI index 502;
       PROCEDURE GpiFullArc(fix,dro:LONGWORD;_hps:HPS):         PMGPI index 393;
       FUNCTION GpiMove(VAR Point:POINTL;hp:HPS):LONGWORD:      PMGPI index 404;
       FUNCTION GpiConvert(VAR p:POINTL;c:LONGWORD;
                            Dest,Sourc:LONGWORD;
                            _hps:HPS):LONGWORD:                 PMGPI index 364;
       FUNCTION WinOpenWindowDC(Win:HWND):LONGWORD:             PMWIN index 794;
       FUNCTION GpiCreatePS(fl:LONGWORD;VAR g:TSIZEL;
                            _hdc:LONGWORD;hab:LONGWORD):HPS:    PMGPI index 369;
       FUNCTION WinQuerySysValue(iSysValue:LONGWORD;
                                  hwndDesktop:HWND):
                                  LONGWORD:                      PMWIN index 829;
       FUNCTION WinSetWindowText(psztext:PSZ;
                                _hwnd:HWND):LONGWORD:            PMWIN index 877;
       PROCEDURE GpiLine(point:POINTL;_hps:HPS):                 PMGPI index 398;
END;

CONST
     {WinDrawBorder() flags}

     DB_PATCOPY     =$0000;
     DB_PATINVERT   =$0001;
     DB_DESTINVERT  =$0002;
     DB_AREAMIXMODE =$0003;
     DB_RAISED      =$0400;
     DB_DEPRESSED   =$0800;

     {Dialog Window Classes}
     WC_NULL        =0;
     WC_BUTTON      =1;
     WC_GROUPBOX    =2;
     WC_CHECKBOX    =3;
     WC_RADIOBOX    =4;
     WC_ENTRYFIELD  =5;
     WC_TEXT        =6;
     WC_LISTBOX     =7;

     {System pointers}

     SPTR_ARROW     =1;
     SPTR_TEXT      =2;
     SPTR_WAIT      =3;
     SPTR_SIZE      =4;
     SPTR_MOVE      =5;
     SPTR_SIZENWSE  =6;
     SPTR_SIZENESW  =7;
     SPTR_SIZEWE    =8;
     SPTR_SIZENS    =9;
     SPTR_APPICON   =10;
     SPTR_CPTR      =39;

 { co-ordinates space for GpiConvert }
CONST
   CVTC_WORLD               =1;
   CVTC_MODEL               =2;
   CVTC_DEFAULTPAGE         =3;
   CVTC_PAGE                =4;
   CVTC_DEVICE              =5;

   {implicit associate flag for GpiCreatePS}
   GPIA_NOASSOC             =0;
   GPIA_ASSOC               =$4000;

   {format for GpiCreatePS}
   GPIF_DEFAULT             =0;
   GPIF_SHORT               =$0100;
   GPIF_LONG                =$0200;

   {units for GpiCreatePS and others}
   PU_ARBITRARY             =$0004;
   PU_PELS                  =$0008;
   PU_LOMETRIC              =$000C;
   PU_HIMETRIC              =$0010;
   PU_LOENGLISH             =$0014;
   PU_HIENGLISH             =$0018;
   PU_TWIPS                 =$001C;

PROCEDURE ConvertPoints(VAR x,y,cx,cy:LONGINT);
VAR t:LONGINT;
BEGIN
     cx:=cx div 3;
     cx:=cx*2;
     cy:=cy div 2;

     x:=x div 3;
     x:=x*2;
     y:=y div 2;
END;

PROCEDURE TMyApp.Arrange;
VAR dummy:PDlgList;
BEGIN
     IF not DlgActive THEN exit;
     IF DlgList=NIL THEN exit;
     Dummy:=DlgList^.next;
     WHILE dummy<>NIL DO
     BEGIN
          inc(dummy^.x,grid DIV 2);
          dummy^.x:=dummy^.x DIV Grid;
          dummy^.x:=dummy^.x*Grid;
          inc(dummy^.y,Grid DIV 2);
          dummy^.y:=dummy^.y DIV Grid;
          dummy^.y:=dummy^.y*Grid;
          dummy:=dummy^.next;
     END;
     UnsetSelection;
     InvalidateMDIWindow(DlgWin);
END;

PROCEDURE TMyApp.NewResource(Typ:WORD;Data:POINTER);
VAR Dummy:PResList;
BEGIN
     IF Resources=NIL THEN
     BEGIN
          New(Resources);
          dummy:=Resources;
     END
     ELSE
     BEGIN
          dummy:=Resources;
          while dummy^.next<>NIL DO dummy:=dummy^.Next;
          new(dummy^.Next);
          dummy:=dummy^.next;
     END;
     dummy^.typ:=typ;
     dummy^.Data:=Data;
     dummy^.Next:=NIL;
END;

PROCEDURE SortGroups;
VAR res:PResList;
    Dlg,dummy,dummy1,Last,Group:PDlgList;
BEGIN
     res:=Resources;
     WHILE res<>NIL DO
     BEGIN
          IF res^.typ=R_DIALOG THEN
          BEGIN
               Dlg:=res^.Data;
               WHILE Dlg<>NIL DO
               BEGIN
                    CASE Dlg^.Typ OF
                    WC_GROUPBOX:
                    BEGIN
                         {Look for all controls lying in this Groupbox}
                         group:=Dlg;
                         Last:=Dlg;
                         dummy:=Last^.next;
                         WHILE dummy<>NIL DO
                         BEGIN
                             IF dummy^.x>=group^.x then if dummy^.y>=group^.y then
                             IF dummy^.x<=group^.x+group^.cx then
                             IF dummy^.y<=group^.y+group^.cy then
                             BEGIN
                                  Last^.Next:=Dummy^.Next;
                                  Dummy^.Next:=Dlg^.next;
                                  Dlg^.next:=dummy;
                                  Dlg:=Dlg^.next;
                             END;
                             last:=dummy;
                             dummy:=dummy^.next;
                        END;
                    END;
                  END; {case}
                  Dlg:=Dlg^.Next;
               END;
          END;
          Res:=Res^.Next;
     END;
END;

PROCEDURE TMyApp.WMSize(VAR Msg:TMessage);
VAR Save:BYTE;
BEGIN
     UnsetSelection;
     Save:=ChildCount;
     ChildCount:=0;
     Inherited.WMSize(Msg);
     ChildCount:=Save;
END;

PROCEDURE TMyApp.MDIWMSize(Win:HWND;Data:POINTER);
BEGIN
     UnsetSelection;
END;

PROCEDURE TMyApp.SaveProject;
VAR f:TEXT;
    Res:PResList;
    Dlg:PDlgList;
    s:string;
Label l;
BEGIN
     FileSaveDlgWildCards:='*.rc';
     IF Untitled THEN
     BEGIN
l:
          IF not FileSaveDialog(AppWinHandle,FileName) THEN exit;
     END;
     Untitled:=FALSE;
     Assign(f,FileName);
     reset(f,1);
     if ioresult=0 THEN
     BEGIN
          close(f);
          IF not ConfirmBox(MB_ICONQUESTION,'File exists. Overwrite ??')
           THEN goto l;
     END;
     rewrite(f,1);
     IF ioresult<>0 THEN
     BEGIN
          ErrorBox(MB_ICONHAND,'Could not write file !');
          exit;
     END;
     Writeln(f,'/* Speed-386 Dialog editor */');
     Writeln(f,'/* Source file for RCOMP */');
     Writeln(f,'');

     SortGroups;
     Res:=Resources;
     WHILE Res<>NIL DO
     BEGIN
          CASE Res^.Typ OF
             R_DIALOG:
             BEGIN
                  Dlg:=Res^.Data;
                  IF Dlg^.idConstName<>'' THEN s:=Dlg^.idConstName
                  ELSE s:=tostr(Dlg^.id);
                  Writeln(f,'DLGTEMPLATE '+s);
                  Writeln(f,'BEGIN');
                  Writeln(f,'     DIALOG "'+Dlg^.text+'",'+s+','+
                         tostr(Dlg^.x)+','+tostr(Dlg^.y)+','+
                         tostr(Dlg^.cx)+','+tostr(Dlg^.cy));
                  Writeln(f,'     STYLE FS_DLGBORDER|WS_VISIBLE');
                  Writeln(f,'     FLAGS FCF_NOBYTEALIGN|FCF_TITLEBAR|FCF_SYSMENU');
                  Writeln(f,'     PRESPARAMS PP_FONTNAMESIZE, "8.Helv"');
                  Writeln(f,'     BEGIN');
                  Dlg:=Dlg^.Next;
                  WHILE Dlg<>NIL DO
                  BEGIN
                       IF Dlg^.idConstName<>'' THEN s:=Dlg^.idConstName
                       ELSE s:=tostr(Dlg^.id);
                       ConvertPoints(Dlg^.x,Dlg^.y,Dlg^.cx,Dlg^.cy);
                       CASE Dlg^.Typ OF
                          WC_GROUPBOX:
                          BEGIN
                               Writeln(f,'');
                               Writeln(f,'          GROUPBOX "'+Dlg^.Text+'",'+s+','+
                                       tostr(Dlg^.x)+','+tostr(Dlg^.y)+','+
                                       tostr(Dlg^.cx)+','+tostr(Dlg^.cy));
                               s:='';
                               CalcBasicStyles(Dlg^.Flags,s);
                               IF s='' THEN s:='NO_STYLE';
                               Writeln(f,'          STYLE '+s);
                          END;
                          WC_BUTTON:
                          BEGIN
                               Writeln(f,'          DEFPUSHBUTTON "'+
                                       Dlg^.Text+'",'+s+','+
                                       tostr(Dlg^.x)+','+tostr(Dlg^.y)+','+
                                       tostr(Dlg^.cx)+','+tostr(Dlg^.cy));
                               s:='';
                               CalcBasicStyles(Dlg^.Flags,s);
                               IF s='' THEN s:='NO_STYLE';
                               Writeln(f,'          STYLE '+s);
                          END;
                          WC_LISTBOX:
                          BEGIN
                               Writeln(f,'          CONTROL "'+
                                       Dlg^.Text+'",'+s+','+
                                       tostr(Dlg^.x)+','+tostr(Dlg^.y)+','+
                                       tostr(Dlg^.cx)+','+tostr(Dlg^.cy));
                               Writeln(f,'          TYPE WC_LISTBOX');
                               s:='';
                               CalcBasicStyles(Dlg^.Flags,s);
                               s:=s+'|CBS_DROPDOWNLIST';
                               IF s='' THEN s:='NO_STYLE';
                               Writeln(f,'          STYLE '+s);
                               Writeln(f,'          FLAGS NO_FLAGS');
                          END;
                          WC_RADIOBOX:
                          BEGIN
                               Writeln(f,'          AUTORADIOBUTTON "'+
                                      Dlg^.Text+'",'+s+','+
                                      tostr(Dlg^.x)+','+tostr(Dlg^.y)+','+
                                      tostr(Dlg^.cx)+','+tostr(Dlg^.cy));
                               s:='';
                               CalcBasicStyles(Dlg^.Flags,s);
                               IF s='' THEN s:='NO_STYLE';
                               Writeln(f,'          STYLE '+s);
                          END;
                          WC_CHECKBOX:
                          BEGIN
                              Writeln(f,'          AUTOCHECKBOX "'+
                                      Dlg^.Text+'",'+s+','+
                                      tostr(Dlg^.x)+','+tostr(Dlg^.y)+','+
                                      tostr(Dlg^.cx)+','+tostr(Dlg^.cy));
                              s:='';
                              CalcBasicStyles(Dlg^.Flags,s);
                              IF s='' THEN s:='NO_STYLE';
                              Writeln(f,'          STYLE '+s);
                          END;
                          WC_ENTRYFIELD:
                          BEGIN
                              Writeln(f,'          ENTRYFIELD "'+
                                      Dlg^.Text+'",'+s+','+
                                      tostr(Dlg^.x)+','+tostr(Dlg^.y)+','+
                                      tostr(Dlg^.cx)+','+tostr(Dlg^.cy));
                              s:='';
                              CalcBasicStyles(Dlg^.Flags,s);
                              CalcEditStyles(Dlg^.Flags,s);
                              IF s='' THEN s:='NO_STYLE';
                              Writeln(f,'          STYLE '+s);
                          END;
                          WC_TEXT:
                          BEGIN
                               Writeln(f,'          LTEXT "'+
                                       Dlg^.Text+'",'+s+','+
                                       tostr(Dlg^.x)+','+tostr(Dlg^.y)+','+
                                       tostr(Dlg^.cx)+','+tostr(Dlg^.cy));
                               s:='';
                               CalcBasicStyles(Dlg^.Flags,s);
                               IF s='' THEN s:='NO_STYLE';
                               Writeln(f,'          STYLE '+s);
                          END;
                       END; {case}
                       Dlg:=Dlg^.Next;
                  END;
                  Writeln(f,'     END');
                  Writeln(f,'END');
             END;
          END; {case}
          Writeln(f,'');
          Writeln(f,'');
          Res:=Res^.Next;
     END;
     Writeln(f,'');
     Writeln(f,'/* End of resource file */');
     Writeln(f,'END');
     close(f);
END;

PROCEDURE TMyApp.EraseProject;
VAR dummy,dummy1:PResList;
    dlgdummy1,dlgdummy2:PDlgList;
BEGIN
     DlgActive:=FALSE;  {No dialog window opened}
     DragActive:=FALSE; {No drag active}
     Selection:=FALSE;
     MoveMode:=FALSE;
     MoveStart:=FALSE;
     SizeLowNS:=FALSE;
     SizeHighNS:=FALSE;
     SizeLeftWE:=FALSE;
     SizeRightWE:=FALSE;
     SizeLeftUp:=FALSE;
     SizeLeftDown:=FALSE;
     SizeRightUp:=FALSE;
     SizeRightDown:=FALSE;
     dummy:=Resources;
     WHILE dummy<>NIL DO
     BEGIN
          dummy1:=dummy^.next;
          CASE dummy^.typ OF
              R_DIALOG:
              BEGIN
                   dlgdummy1:=dummy^.Data;
                   WHILE dlgdummy1<>NIL DO
                   BEGIN
                        dlgDummy2:=DlgDummy1^.Next;
                        Dispose(DlgDummy1);
                        DlgDummy1:=DlgDummy2;
                   END;
              END;
          END; {case}
          dispose(dummy);
          dummy:=dummy1;
     END;
     Resources:=NIL;
END;


PROCEDURE TMyApp.MDIHandleScanEvent(Win:HWND;scan:Word;Data:POINTER);
VAR dummy,Last:PDlgList;
BEGIN
     CASE Scan OF
        kbDel:
        BEGIN
             IF Selection THEN
             BEGIN
                  {Delete the selected Control}
                  Last:=NIL;
                  dummy:=DlgList;
                  WHILE dummy<>NIL DO
                  BEGIN
                       IF dummy=ActualDlg THEN
                       BEGIN
                            IF Last=NIL THEN DlgList:=Dummy^.Next
                            ELSE Last^.Next:=dummy^.Next;
                            dispose(dummy);
                            UnsetSelection;
                            InvalidateMDIWindow(DlgWin);
                            exit;
                       END;
                       Last:=dummy;
                       dummy:=dummy^.next;
                  END;
             END;
        END;
     END; {case}
END;

PROCEDURE TMyApp.DrawDlgString(Dlg:PDlgList;x,y:INTEGER;_hps:HPS);
VAR
    pt:POINTL;
    FaceName:STRING;
    s:STRING;
BEGIN
     facename:='Helv';
     CreateLogFont(_hps,facename,13,5,0);
     GpiSetColor(Dlg^.Color,_hps);
     GpiSetBackColor(Dlg^.BackColor,_hps);
     GpiSetBackMix(2,_hps); {BM_OverPaint}
     pt.x:=x;
     pt.y:=y;
     s:=Dlg^.text;
     WHILE pos('~',s)<>0 DO delete(s,pos('~',s),1);
     GpiCharStringAt(s[1],Length(s),pt,_hps);
END;


PROCEDURE DrawScroller(x,y:INTEGER;_hps:HPS);
VAR rc:RECTL;
BEGIN
     rc.yBottom:=y;
     rc.xleft:=x;
     rc.ytop:=y+14;
     rc.xright:=x+12;
     WinDrawBorder(DB_RAISED,CLR_PALEGRAY,CLR_BLACK,1,1,rc,_hps);
     inc(rc.xLeft);
     inc(rc.yBottom);
     dec(rc.XRight);
     dec(rc.yTop);
     WinFillRect(CLR_PALEGRAY,rc,_hps);
END;

PROCEDURE DrawUpperScroller(x,y:INTEGER;_hps:HPS);
VAR Start,Endp:POINTL;
BEGIN
     DrawScroller(x,y,_hps);
     GpiSetColor(CLR_WHITE,_hps);
     Start.x:=x+3;
     Start.y:=y+5;
     GpiMove(Start,_hps);
     Endp.x:=x+6;
     Endp.y:=y+8;
     GpiLine(Endp,_hps);
     GpiMove(Endp,_hps);
     inc(Endp.x,3);
     Endp.y:=y+5;
     GpiLine(Endp,_hps);
END;

PROCEDURE DrawLowerScroller(x,y:INTEGER;_hps:HPS);
VAR Start,Endp:POINTL;
BEGIN
     DrawScroller(x,y,_hps);
     GpiSetColor(CLR_WHITE,_hps);
     Start.x:=x+3;
     Start.y:=y+8;
     GpiMove(Start,_hps);
     Endp.x:=x+6;
     Endp.y:=y+5;
     GpiLine(Endp,_hps);
     GpiMove(Endp,_hps);
     inc(Endp.x,3);
     Endp.y:=y+8;
     GpiLine(Endp,_hps);
END;

PROCEDURE DrawVScrollBar(Dlg:PDlgList;_hps:HPS);
VAR rc:RECTL;
    x,y:LONGINT;
BEGIN
     rc.yBottom:=Dlg^.y;
     rc.yTop:=Dlg^.y+Dlg^.cy;
     rc.XLeft:=Dlg^.x+Dlg^.cx;
     dec(rc.xleft,15);
     rc.XRight:=rc.xleft+16;
     inc(rc.XLeft,1);
     dec(rc.XRight,1);
     dec(rc.YTop,1);
     WinDrawBorder(DB_DEPRESSED,CLR_PALEGRAY,CLR_BLACK,1,1,rc,_hps);

     inc(rc.xLeft);
     inc(rc.yBottom);
     dec(rc.XRight);
     dec(rc.yTop);
     WinFillRect(CLR_PALEGRAY,rc,_hps);

     x:=Dlg^.x+Dlg^.cx;
     dec(x,13);
     y:=Dlg^.y+Dlg^.cy;
     dec(y,16);
     DrawUpperScroller(x,y,_hps);
     y:=Dlg^.y;
     inc(y);
     DrawLowerScroller(x,y,_hps);
END;

PROCEDURE TMyApp.DrawElement(Dlg:PDlgList;_hps:HPS);
VAR rc:RECTL;
    arcp:TArcParams;
    point:POINTL;
    sp:PString;
BEGIN
     CASE Dlg^.Typ OF
            WC_NULL:
            BEGIN
                 sp:=Dlg^.Text;
                 WinSetWindowText(sp,DlgWin);
            END;
            WC_BUTTON:
            BEGIN
                 {Draw the button}
                 rc.yBottom:=Dlg^.y;
                 rc.yTop:=Dlg^.y+Dlg^.cy;
                 rc.XLeft:=Dlg^.x;
                 rc.XRight:=Dlg^.x+Dlg^.cx;
                 inc(rc.XLeft,1);
                 dec(rc.XRight,1);
                 dec(rc.YTop,1);
                 WinDrawBorder(DB_RAISED,CLR_PALEGRAY,CLR_BLACK,1,1,rc,_hps);
                 inc(rc.xLeft);
                 inc(rc.yBottom);
                 dec(rc.XRight);
                 dec(rc.yTop);
                 WinFillRect(CLR_PALEGRAY,rc,_hps);
                 rc.yBottom:=Dlg^.y-1;
                 rc.yTop:=Dlg^.y+Dlg^.cy;
                 rc.XLeft:=Dlg^.x;
                 rc.XRight:=Dlg^.x+Dlg^.cx;
                 WinDrawBorder(DB_PATCOPY,CLR_PALEGRAY,CLR_DARKGRAY,1,1,rc,_hps);
                 DrawDlgString(Dlg,Dlg^.x+10,Dlg^.y+10,_hps);
            END;
            WC_CHECKBOX:
            BEGIN
                 {Draw the button}
                 rc.yBottom:=Dlg^.y+(Dlg^.cy DIV 2);
                 dec(rc.yBottom,2);
                 rc.yTop:=rc.yBottom+12;
                 rc.XLeft:=Dlg^.x;
                 rc.XRight:=rc.xLeft+13;
                 inc(rc.XLeft,1);
                 dec(rc.XRight,1);
                 dec(rc.YTop,1);
                 WinDrawBorder(DB_RAISED,CLR_PALEGRAY,CLR_BLACK,1,1,rc,_hps);
                 inc(rc.xLeft);
                 inc(rc.yBottom);
                 dec(rc.XRight);
                 dec(rc.yTop);
                 WinFillRect(CLR_PALEGRAY,rc,_hps);
                 rc.yBottom:=Dlg^.y+(Dlg^.cy div 2);
                 dec(rc.yBottom,3{7});
                 rc.yTop:=rc.yBottom+13;
                 rc.XLeft:=Dlg^.x;
                 rc.XRight:=rc.xLeft+13;
                 WinDrawBorder(DB_PATCOPY,CLR_PALEGRAY,CLR_DARKGRAY,1,1,rc,_hps);
                 DrawDlgString(Dlg,Dlg^.x+15,rc.yBottom+2,_hps);
            END;
            WC_RADIOBOX:
            BEGIN
                 {Draw the button}
                 rc.yBottom:=Dlg^.y+(Dlg^.cy DIV 2);
                 dec(rc.yBottom,2);
                 rc.yTop:=rc.yBottom+12;
                 rc.XLeft:=Dlg^.x;
                 rc.XRight:=rc.xLeft+13;
                 inc(rc.XLeft,1);
                 dec(rc.XRight,1);
                 dec(rc.YTop,1);
                 arcp.lp:=6;
                 arcp.lq:=6;
                 arcp.lr:=0;
                 arcp.ls:=0;
                 point.x:=rc.xleft+6;
                 point.y:=rc.yBottom+6;
                 GpiMove(point,_hps);
                 GpiSetArcParams(arcp,_hps);
                 GpiSetColor(CLR_DARKGRAY,_hps);
                 GpiFullArc(65536,DRO_OUTLINE,_hps);
                 arcp.lp:=5;
                 arcp.lq:=5;
                 arcp.lr:=0;
                 arcp.ls:=0;
                 point.x:=rc.xleft+6;
                 point.y:=rc.yBottom+6;
                 GpiMove(point,_hps);
                 GpiSetArcParams(arcp,_hps);
                 GpiSetColor(CLR_DARKGRAY,_hps);
                 GpiFullArc(65536,DRO_OUTLINE,_hps);
                 arcp.lp:=4;
                 arcp.lq:=4;
                 arcp.lr:=0;
                 arcp.ls:=0;
                 point.x:=rc.xleft+6;
                 point.y:=rc.yBottom+6;
                 GpiMove(point,_hps);
                 GpiSetArcParams(arcp,_hps);
                 GpiSetColor(CLR_WHITE,_hps);
                 GpiFullArc(65536,DRO_OUTLINE,_hps);
                 DrawDlgString(Dlg,Dlg^.x+17,rc.yBottom+2,_hps);
            END;
            WC_ENTRYFIELD:
            BEGIN
                 rc.xleft:=Dlg^.x;
                 rc.xright:=Dlg^.x+Dlg^.cx;
                 rc.yBottom:=Dlg^.y;
                 rc.yTop:=Dlg^.y+Dlg^.cy;
                 WinDrawBorder(DB_DEPRESSED,CLR_PALEGRAY,CLR_DARKGRAY,1,1,rc,_hps);
                 inc(rc.xLeft);
                 inc(rc.yBottom);
                 dec(rc.XRight);
                 dec(rc.yTop);
                 WinFillRect(CLR_WHITE,rc,_hps);
            END;
            WC_LISTBOX:
            BEGIN
                 rc.xleft:=Dlg^.x;
                 rc.xright:=Dlg^.x+Dlg^.cx;
                 rc.yBottom:=Dlg^.y;
                 rc.yTop:=Dlg^.y+Dlg^.cy;
                 WinDrawBorder(DB_DEPRESSED,CLR_PALEGRAY,CLR_DARKGRAY,1,1,rc,_hps);
                 inc(rc.xLeft);
                 inc(rc.yBottom);
                 dec(rc.XRight);
                 dec(rc.yTop);
                 WinFillRect(CLR_WHITE,rc,_hps);
                 DrawVScrollBar(Dlg,_hps);
            END;
            WC_TEXT:DrawDlgString(Dlg,Dlg^.X,Dlg^.y+4,_hps);
            WC_GROUPBOX:
            BEGIN
                 {Draw the GroupBox}
                 rc.yBottom:=Dlg^.y;
                 rc.yTop:=Dlg^.y+Dlg^.cy;
                 rc.XLeft:=Dlg^.x;
                 rc.XRight:=Dlg^.x+Dlg^.cx;
                 WinDrawBorder(DB_DEPRESSED,CLR_PALEGRAY,CLR_BLACK,1,1,rc,_hps);
                 inc(rc.xLeft);
                 inc(rc.yBottom);
                 dec(rc.xRight);
                 dec(rc.yTop);
                 {WinFillRect(CLR_PALEGRAY,rc,_hps);}
                 rc.yBottom:=Dlg^.y;
                 rc.yTop:=Dlg^.y+Dlg^.cy;
                 rc.XLeft:=Dlg^.x;
                 rc.XRight:=Dlg^.x+Dlg^.cx;
                 inc(rc.xleft,1);
                 dec(rc.xright,1);
                 inc(rc.yBottom,1);
                 dec(rc.yTop,1);
                 WinDrawBorder(DB_RAISED,CLR_PALEGRAY,CLR_DARKGRAY,1,1,rc,_hps);
                 DrawDlgString(Dlg,Dlg^.X+10,Dlg^.y+Dlg^.CY-5,_hps);
            END;
     END; {case}
END;

PROCEDURE TMyApp.MDIRedraw(rc:RECTL;_hps:HPS;Win:HWND;Data:POINTER);
VAR dummy:PDlgList;
    bcol:INTEGER;
    _hps1:HPS;
BEGIN
     _hps1:=WinGetPS(DlgWin);  {Create New presentation space}
     dummy:=DlgList;
     WHILE dummy<>NIL DO
     BEGIN
          DrawElement(Dummy,_hps1);
          dummy:=dummy^.next;
     END;
     WinReleasePS(_hps1);
END;


PROCEDURE TMyApp.MDICreateNotify(MDIFrWin,MDIWin:HWND;Data:POINTER);
BEGIN
     DlgFrWin:=MDIFrWin;
     DlgWin:=MDIWin;
     SetWindowPos(MDIFrWin,20,20,300,200);
END;


PROCEDURE TMyApp.DrawRec;
VAR _hps:HPS;
    rc:RECTL;
    x,y,cx,cy:LONGINT;
BEGIN
     GetWindowPos(DlgWin,x,y,cx,cy);
     IF Dragy+Dragcy>cy-30 THEN
     BEGIN
          Dragy:=cy-Dragcy-30;
     END;

     IF Dragx+Dragcx>cx-10 THEN
     BEGIN
          Dragx:=cx-Dragcx-10;
     END;

     IF Dragx<10 THEN Dragx:=10;
     IF Dragy<10 THEN Dragy:=10;

     rc.xleft:=Dragx;
     rc.ybottom:=Dragy;
     rc.xright:=Dragx+Dragcx;
     rc.ytop:=Dragy+Dragcy;
     _hps:=WinGetPS(DlgWin);
     WinDrawBorder(DB_DESTINVERT,CLR_PALEGRAY,CLR_BLACK,2,2,rc,_hps);
     WinReleasePS(_hps);
END;


PROCEDURE TMyApp.MakePermanent;
VAR
    _hps:HPS;
BEGIN
     IF not DragActive THEN exit;
     DrawRec;  {Delete rec}
     ActualDlg^.x:=DragX;
     ActualDlg^.y:=DragY;
     ActualDlg^.CX:=DragCX;
     ActualDlg^.CY:=DragCY;
     DragActive:=FALSE;
     _hps:=WinGetPS(DlgWin);
     DrawElement(ActualDlg,_hps);
     WinReleasePS(_hps);
END;

PROCEDURE TMyApp.WMMenuSelect(Win:HWND;para1:POINTER);
BEGIN
     MakePermanent;
END;


PROCEDURE DrawSelRec(Win:HWND;x,y:INTEGER);
VAR rc:RECTL;
    _hps:HPS;
BEGIN
     rc.xleft:=x;
     rc.ybottom:=y;
     rc.xright:=x+8;
     rc.ytop:=y+8;
     _hps:=WinGetPS(Win);
     WinDrawBorder(DB_DESTINVERT,CLR_PALEGRAY,CLR_BLACK,8,8,rc,_hps);
     WinReleasePS(_hps);
END;

PROCEDURE TMyApp.UnsetSelection;
VAR LenX,LenY:INTEGER;
BEGIN
     IF not Selection THEN Exit;
     Selection:=FALSE;
     DrawSelRec(DlgWin,SelectX-4,SelectY+Selectcy-4);
     DrawSelRec(DlgWin,Selectx-4,Selecty-4);
     DrawSelRec(DlgWin,Selectx+Selectcx-4,Selecty-4);
     DrawSelRec(DlgWin,Selectx+Selectcx-4,Selecty+Selectcy-4);
     LenY:=(SelectY+SelectCY DIV 2)-4;
     DrawSelRec(DlgWin,SelectX-4,LenY);
     DrawSelRec(DlgWin,SelectX+SelectCX-4,LenY);
     LenX:=(SelectX+SelectCX DIV 2)-4;
     DrawSelRec(DlgWin,LenX,SelectY-4);
     DrawSelRec(DlgWin,LenX,SelectY+SelectCY-4);
     MoveMode:=FALSE;
END;

PROCEDURE TMyApp.MakeSelection(Dlg:PDlgList);
VAR LenX,LenY:INTEGER;
BEGIN
     IF Selection THEN UnsetSelection;
     Selection:=TRUE;
     SelectX:=Dlg^.x;
     SelectY:=Dlg^.y;
     Selectcx:=Dlg^.cx;
     Selectcy:=Dlg^.cy;
     DrawSelRec(DlgWin,SelectX-4,SelectY+Selectcy-4);
     DrawSelRec(DlgWin,Selectx-4,Selecty-4);
     DrawSelRec(DlgWin,Selectx+Selectcx-4,Selecty-4);
     DrawSelRec(DlgWin,Selectx+Selectcx-4,Selecty+Selectcy-4);
     LenY:=(SelectY+SelectCY DIV 2)-4;
     DrawSelRec(DlgWin,SelectX-4,LenY);
     DrawSelRec(DlgWin,SelectX+SelectCX-4,LenY);
     LenX:=(SelectX+SelectCX DIV 2)-4;
     DrawSelRec(DlgWin,LenX,SelectY-4);
     DrawSelRec(DlgWin,LenX,SelectY+SelectCY-4);
END;

FUNCTION TMyApp.CheckSelection(x,y:INTEGER):PDlgList;
VAR Dummy,Selected:PDlgList;
BEGIN
     Dummy:=DlgList;
     Selected:=NIL;
     WHILE dummy<>NIL DO
     BEGIN
          IF x>=Dummy^.x THEN IF y>=Dummy^.y THEN IF
           x<=Dummy^.x+Dummy^.cx THEN IF y<=Dummy^.y+Dummy^.cy THEN
            Selected:=Dummy;
          Dummy:=Dummy^.Next;
     END;
     IF Selected<>NIL THEN MakeSelection(Selected);
     CheckSelection:=Selected;
END;

PROCEDURE TMyApp.UnsetMoveMode;
VAR _hps:HPS;
BEGIN
     IF not MoveMode THEN exit;
     MoveMode:=FALSE;
     UnsetSelection;
     DrawRec;  {Delete rec}
     ActualDlg^.X:=DragX;
     ActualDlg^.Y:=DragY;
     ActualDlg^.CX:=DragCX;
     ActualDlg^.CY:=DragCY;

     InvalidateMDIWindow(DlgWin);
     MakeSelection(ActualDlg);
     WinSetPointer(ArrowPtr,HWND_DESKTOP);
END;


PROCEDURE TMyApp.MDIWMButton1Up(Win:HWND;x,y:INTEGER;Data:POINTER);
BEGIN
     MoveStart:=FALSE;
     SizeLowNS:=FALSE;
     SizeLeftWE:=FALSE;
     SizeHighNS:=FALSE;
     SizeRightWE:=FALSE;
     SizeLeftUp:=FALSE;
     SizeLeftDown:=FALSE;
     SizeRightUp:=FALSE;
     SizeRightDown:=FALSE;
     IF MoveMode THEN UnsetMoveMode;
END;

PROCEDURE TMyApp.EditStyle;
BEGIN
     IF not DlgActive THEN exit;
     IF Selection THEN
     BEGIN
          CASE ActualDlg^.Typ OF
             WC_BUTTON:ButtonDlg(ActualDlg^.Text,ActualDlg^.IdConstName,
                                 ActualDlg^.Flags,ActualDlg^.id);
             WC_CHECKBOX:CheckBoxDlg(ActualDlg^.Text,ActualDlg^.IdConstName,
                                     ActualDlg^.Flags,ActualDlg^.id);
             WC_RADIOBOX:RadioBoxDlg(ActualDlg^.Text,ActualDlg^.IdConstName,
                                     ActualDlg^.Flags,ActualDlg^.id);
             WC_GROUPBOX:GroupBoxDlg(ActualDlg^.Text,ActualDlg^.IdConstName,
                         ActualDlg^.Flags,ActualDlg^.id);
             WC_TEXT:TextDlg(ActualDlg^.Text,ActualDlg^.IdConstName,
                             ActualDlg^.Flags,ActualDlg^.id);
             WC_ENTRYFIELD:EntryDlg(ActualDlg^.Text,ActualDlg^.IdConstName,
                             ActualDlg^.Flags,ActualDlg^.id);
             WC_LISTBOX:ListBoxDlg(ActualDlg^.Text,ActualDlg^.IdConstName,
                                   ActualDlg^.Flags,ActualDlg^.id);
             ELSE Beep(500,50);
          END; {case}
          UnsetSelection;
          InvalidateMDIWindow(DlgWin);
     END
     ELSE
     BEGIN
          DialogDlg(DlgList^.Text,DlgList^.IdConstName,DlgList^.Flags,
                    DlgList^.id);
          UnsetSelection;
          InvalidateMDIWindow(DlgWin);
     END;
END;

PROCEDURE TMyApp.MDIWMButton1DoubleClick(Win:HWND;x,y:INTEGER;Data:POINTER);
VAR Dlg:PDlgList;
BEGIN
     IF not DlgActive THEN exit;
     IF Selection THEN
     BEGIN
          Dlg:=CheckSelection(x,y);
          IF Dlg=ActualDlg THEN EditStyle;
     END
     ELSE EditStyle;
END;

PROCEDURE TMyApp.WMButton1Up(Win:HWND;x,y:INTEGER);
BEGIN
     MoveStart:=FALSE;
     IF MoveMode THEN UnsetMoveMode;
END;


PROCEDURE TMyApp.WMButton1Down(Win:HWND;x,y:INTEGER);
BEGIN
     MakePermanent;
END;

PROCEDURE TMyApp.MDIWMButton1Down(Win:HWND;x,y:INTEGER;Data:POINTER);
VAR Dlg:PDlgList;
BEGIN
     IF DragActive THEN
     BEGIN
          MakePermanent;
          MakeSelection(ActualDlg);
          MoveMode:=TRUE;
          DragX:=ActualDlg^.Y;
          DragY:=ActualDlg^.Y;
          DragCX:=ActualDlg^.CX;
          DragCY:=ActualDlg^.CY;
          ActualDlg:=ActualDlg;
          DrawRec;
          exit;
     END;
     IF ((SizeLowNS)OR(SizeHighNS)OR(SizeLeftWE)OR(SizeRightWE)
         OR(SizeLeftUp)OR(SizeLeftDown)OR(SizeRightUp)OR(SizeRightDown)) THEN
     BEGIN
          MoveStart:=TRUE;
          DragX:=SelectX;
          DragY:=SelectY;
          DragCX:=SelectCX;
          DragCY:=SelectCY;
          exit;
     END;
     Dlg:=CheckSelection(x,y);
     IF Dlg<>NIL THEN
     BEGIN
          MoveStart:=TRUE;
          DragX:=x;
          DragY:=y;
          DragCX:=Dlg^.CX;
          DragCY:=Dlg^.CY;
          ActualDlg:=Dlg;
          exit;
     END;
     UnsetSelection;
     WinSetPointer(ArrowPtr,HWND_DESKTOP);
END;

PROCEDURE TMyApp.MDIWMMouseMove(Win:HWND;x,y:INTEGER;Data:POINTER);
VAR _hps:HPS;
    rc:RECTL;
    _hptr:LONGWORD;
    temp:INTEGER;
LABEL l;
BEGIN
     IF DragActive THEN
     BEGIN
          WinSetPointer(ArrowPtr,HWND_DESKTOP);
          DrawRec;  {Delete old rec}
          Dragx:=x;
          Dragy:=y;
          DrawRec;
          exit;
     END;
     IF MoveMode THEN
     BEGIN
l:
          IF SizeHighNS THEN
          BEGIN
               DrawRec;
               IF DragY+8<y THEN DragCY:=y-DragY;
               DrawRec;
               exit;
          END;
          IF SizeLowNS THEN
          BEGIN
               DrawRec;
               temp:=DragY+DragCY;
               IF temp>DragY+8 THEN
               BEGIN
                    DragY:=y;
                    DragCY:=temp-DragY;
               END;
               DrawRec;
               exit;
          END;
          IF SizeLeftWE THEN
          BEGIN
               DrawRec;
               temp:=DragX+DragCX;
               IF temp>DragX+8 THEN
               BEGIN
                    DragX:=x;
                    DragCX:=temp-DragX;
               END;
               DrawRec;
               exit;
          END;
          IF SizeRightWE THEN
          BEGIN
               DrawRec;
               IF DragX+8<x THEN DragCX:=x-DragX;
               DrawRec;
               exit;
          END;
          IF SizeLeftUp THEN
          BEGIN
               DrawRec;
               temp:=DragX+DragCX;
               IF temp>DragX+8 THEN
               BEGIN
                    DragX:=x;
                    DragCX:=temp-DragX;
               END;
               IF DragY+8<y THEN DragCY:=y-DragY;
               DrawRec;
               exit;
          END;
          IF SizeRightDown THEN
          BEGIN
               DrawRec;
               IF DragX+8<x THEN DragCX:=x-DragX;
               temp:=DragY+DragCY;
               IF temp>DragY+8 THEN
               BEGIN
                    DragY:=y;
                    DragCY:=temp-DragY;
               END;
               DrawRec;
               exit;
          END;
          IF SizeRightUp THEN
          BEGIN
               DrawRec;
               IF DragY+8<y THEN DragCY:=y-DragY;
               IF DragX+8<x THEN DragCX:=x-DragX;
               DrawRec;
               exit;
          END;
          IF SizeLeftDown THEN
          BEGIN
               DrawRec;
               temp:=DragY+DragCY;
               IF temp>DragY+8 THEN
               BEGIN
                    DragY:=y;
                    DragCY:=temp-DragY;
               END;
               temp:=DragX+DragCX;
               IF temp>DragX+8 THEN
               BEGIN
                    DragX:=x;
                    DragCX:=temp-DragX;
               END;
               DrawRec;
               exit;
          END;
          WinSetPointer(MovePtr,HWND_DESKTOP);
          DrawRec;  {Delete old rec}
          DragX:=x;
          DragY:=y;
          DrawRec;
          exit;
     END;
     IF MoveStart THEN
     BEGIN
          IF x<>DragX THEN
          BEGIN
               MoveStart:=FALSE;
               MoveMode:=TRUE;
               DrawRec;
               goto l;
          END;
          IF y<>DragY THEN
          BEGIN
               MoveStart:=FALSE;
               MoveMode:=TRUE;
               DrawRec;
               goto l;
          END;
     END;
     SizeLowNS:=FALSE;
     SizeHighNS:=FALSE;
     SizeLeftWE:=FALSE;
     SizeRightWE:=FALSE;
     SizeLeftUp:=FALSE;
     SizeLeftDown:=FALSE;
     SizeRightUp:=FALSE;
     SizeRightDown:=FALSE;
     IF Selection THEN
     BEGIN
          IF x>=SelectX-6 THEN IF x<=SelectX THEN
          BEGIN
               IF y>=SelectY-6 THEN IF y<=SelectY THEN
               BEGIN
                    SizeLeftDown:=TRUE;
                    WinSetPointer(SIZENESWPtr,HWND_DESKTOP);
                    exit;
               END;
               IF y>=SelectY+SelectCY-6 THEN IF y<=SelectY+SelectCY THEN
               BEGIN
                    SizeLeftUp:=TRUE;
                    WinSetPointer(SIZENWSEPtr,HWND_DESKTOP);
                    exit;
               END;
               temp:=SelectY+SelectCY DIV 2;
               IF y>=temp-6 THEN IF y<=temp THEN
               BEGIN
                    SizeLeftWE:=TRUE;
                    WinSetPointer(SIZEWEPtr,HWND_DESKTOP);
                    exit;
               END;
          END;
          IF x>=SelectX+SelectCX-6 THEN IF x<=SelectX+SelectCX THEN
          BEGIN
               IF y>=SelectY-6 THEN IF y<=SelectY THEN
               BEGIN
                    SizeRightDown:=TRUE;
                    WinSetPointer(SIZENWSEPtr,HWND_DESKTOP);
                    exit;
               END;
               IF y>=SelectY+SelectCY-6 THEN IF y<=SelectY+SelectCY THEN
               BEGIN
                    SizeRightUp:=TRUE;
                    WinSetPointer(SIZENESWPtr,HWND_DESKTOP);
                    exit;
               END;
               temp:=SelectY+SelectCY DIV 2;
               IF y>=temp-6 THEN IF y<=temp THEN
               BEGIN
                    SizeRightWE:=TRUE;
                    WinSetPointer(SIZEWEPtr,HWND_DESKTOP);
                    exit;
               END;
          END;
          temp:=SelectX+SelectCX DIV 2;
          IF x>=temp-6 THEN IF x<=temp THEN
          BEGIN
               IF y>=SelectY-6 THEN IF y<=SelectY THEN
               BEGIN
                    SizeLowNS:=TRUE;
                    WinSetPointer(SIZENSPtr,HWND_DESKTOP);
                    exit;
               END;
               IF y>=SelectY+SelectCY-6 THEN IF y<=SelectY+SelectCY THEN
               BEGIN
                    SizeHighNS:=TRUE;
                    WinSetPointer(SIZENSPtr,HWND_DESKTOP);
                    exit;
               END;
          END;
     END;
     WinSetPointer(ArrowPtr,HWND_DESKTOP);
END;

PROCEDURE TMyApp.NewDlgItem(Typ:LONGWORD);
VAR Dummy:PDlgList;
    s:STRING;
    Flags:LONGWORD;
BEGIN
     DragX:=20;
     DragY:=10;
     Flags:=0;
     CASE Typ OF
        WC_NULL:
        BEGIN
             DragCX:=0;
             DragCY:=0;
             s:='Dialog window';
             Flags:=WS_VISIBLE OR WS_SAVEBITS OR FCF_TITLEBAR OR
                    FCF_SYSMENU OR FS_DLGBORDER OR FS_WINDOWALIGN;
        END;
        WC_BUTTON:
        BEGIN
             DragCX:=60;
             DragCY:=30;
             s:='Push';
             Flags:=WS_VISIBLE OR WS_TABSTOP;
        END;
        WC_LISTBOX:
        BEGIN
             DragCX:=100;
             DragCY:=80;
             s:='';
             Flags:=WS_VISIBLE OR WS_TABSTOP;
        END;
        WC_GROUPBOX:
        BEGIN
             DragCX:=80;
             DragCY:=60;
             s:='Group';
             Flags:=WS_VISIBLE OR WS_GROUP;
        END;
        WC_CHECKBOX:
        BEGIN
             DragCX:=60;
             DragCY:=20;
             s:='Check';
             Flags:=WS_VISIBLE OR WS_TABSTOP;
        END;
        WC_RADIOBOX:
        BEGIN
             DragCX:=60;
             DragCY:=20;
             s:='Radio';
             Flags:=WS_VISIBLE OR WS_TABSTOP;
        END;
        WC_ENTRYFIELD:
        BEGIN
             DragCX:=60;
             DragCY:=14;
             s:='';
             Flags:=WS_VISIBLE OR WS_TABSTOP OR ES_MARGIN OR ES_AUTOSCROLL;
        END;
        WC_TEXT:
        BEGIN
             DragCX:=60;
             DragCY:=20;
             s:='Text';
             Flags:=WS_VISIBLE OR WS_GROUP;
        END;
     END; {case}

     IF DlgList=NIL THEN
     BEGIN
          New(DlgList);
          dummy:=DlgList;
     END
     ELSE
     BEGIN
          dummy:=DlgList;
          WHILE dummy^.Next<>NIL DO dummy:=dummy^.next;
          New(Dummy^.Next);
          dummy:=dummy^.Next;
     END;

     Dummy^.Typ:=Typ;
     Dummy^.Color:=CLR_BLACK;
     Dummy^.Flags:=Flags;
     Dummy^.BackColor:=CLR_PALEGRAY;
     Dummy^.Text:=s;
     Dummy^.x:=Dragx;
     Dummy^.y:=Dragy;
     Dummy^.cx:=Dragcx;
     Dummy^.cy:=Dragcy;
     IF Typ=WC_NULL THEN
     BEGIN
          Dummy^.id:=DlgCount;
          inc(DlgCount);
     END
     ELSE Dummy^.id:=100;
     IF Typ=WC_GROUPBOX THEN Dummy^.Color:=CLR_BLUE;
     Dummy^.idConstName:='';
     Dummy^.Next:=NIL;

     IF Typ<>WC_NULL THEN
     BEGIN
          ActualDlg:=Dummy;
          DrawRec;
          DragActive:=TRUE;
     END;
END;

FUNCTION TMyApp.MDIHandleEvent(Win:HWND;Msg:LONGWORD;
                                para1,para2:POINTER;
                                VAR Handled:BOOLEAN;Data:POINTER):LONGWORD;
VAR r:LONGWORD;
    H:BOOLEAN;
BEGIN
     r:=Inherited.MDIHandleEvent(Win,Msg,para1,para2,Handled,Data);
     H:=FALSE;
     IF not Handled THEN Handled:=H;
     MDIHandleEvent:=r;
END;

PROCEDURE TMyApp.NewDlgEntry;
VAR x,y,cx,cy:LONGINT;
    xtemp,ytemp:LONGINT;
    pt:POINTL;
    _hps:HPS;
    _hdc:LONGWORD;
    g:TSizel;
BEGIN
     GetWindowPos(DlgWin,x,y,cx,cy);
     ConvertPoints(x,y,cx,cy);
     dec(cx,6);
     dec(cy,14);
     DlgList^.x:=x;
     DlgList^.y:=y;
     DlgList^.cx:=cx;
     DlgList^.cy:=cy;
     NewResource(R_DIALOG,DlgList);
     DlgList:=NIL;
     DlgActive:=FALSE;
     WinDestroyWindow(DlgWin);
END;

PROCEDURE TMyApp.HandleCommand(Win:HWND;Command:WORD);
VAR x,y,cx,cy:LONGINT;
    _hps:HPS;
    rc:RECTL;
    Dlg:TDialog;
    ResType:WORD;
BEGIN
     Inherited.HandleCommand(Win,Command);
     CASE Command OF
         CM_NEWRES:
         BEGIN
              IF DlgActive THEN UnsetSelection;
              ResType:=NewResDlg;
              IF ResType<>0 THEN
              BEGIN
                   IF DlgActive THEN NewDlgEntry;  {Append actual resource to list}
                   DlgActive:=FALSE;
                   EnableControls;
                   CASE ResType OF
                    R_DIALOG:
                    BEGIN
                       {Dlg Resource}
                       DlgWin:=CreateMDIChild(0,'Dialog window',NIL,0,CLR_BLACK,CLR_PALEGRAY);
                       IF DlgWin<>0 THEN DlgActive:=TRUE;
                       NewDlgItem(WC_NULL);
                    END;
                  END; {case}

             END;
         END;
         CM_NEW:
         BEGIN
              IF DlgActive THEN UnsetSelection;
              IF Resources<>NIL THEN
               IF ConfirmBox(MB_ICONQUESTION,'Save modified project ??')
                 THEN SaveProject;
              EraseProject;
              SetMenuState(CM_NEWRES,TRUE);
              SetMenuState(CM_DELETERES,TRUE);
              SetMenuState(CM_SELECTRES,TRUE);
              DlgCount:=1000;
         END;
         CM_BUTTON:NewDlgItem(WC_BUTTON);
         CM_LISTBOX:NewDlgItem(WC_LISTBOX);
         CM_GROUPBOX:NewDlgItem(WC_GROUPBOX);
         CM_CHECKBOX:NewDlgItem(WC_CHECKBOX);
         CM_RADIOBOX:NewDlgItem(WC_RADIOBOX);
         CM_ENTRYFIELD:NewDlgItem(WC_ENTRYFIELD);
         CM_TEXT:NewDlgItem(WC_TEXT);
         CM_EDITSTYLE:
         BEGIN
              IF DlgActive THEN UnsetSelection;
              EditStyle;
         END;
         CM_ARRANGE:Arrange;
         CM_OPTION:
         BEGIN
              IF DlgActive THEN UnsetSelection;
              OptionsDlg(Grid,Options);
         END;
         CM_ABOUT:
         BEGIN
              IF DlgActive THEN UnsetSelection;
              Dlg.Init(1,AppWinFrameHandle,0,500,NIL);
              Dlg.ExecDialog(x);
              Dlg.Done;
         END;
     END; {case}
END;

PROCEDURE TMyApp.WMClose(VAR Msg:TMessage);
BEGIN
     IF DlgActive THEN NewDlgEntry;

     IF Resources<>NIL THEN
      IF ConfirmBox(MB_ICONQUESTION,'Save modified project ??')
        THEN SaveProject;
     EraseProject;
     Inherited.WMClose(Msg);
END;

PROCEDURE TMyApp.WMMDIClose(Win:HWND;Data:POINTER);
BEGIN
     IF DlgActive THEN NewDlgEntry;
     DisableControls;
     Inherited.WMMDIClose(Win,Data);
END;

PROCEDURE TMyApp.DisableControls;
BEGIN
     SetMenuState(CM_GROUPBOX,FALSE);
     SetMenuState(CM_LISTBOX,FALSE);
     SetMenuState(CM_BUTTON,FALSE);
     SetMenuState(CM_ICON,FALSE);
     SetMenuState(CM_CHECKBOX,FALSE);
     SetMenuState(CM_RADIOBOX,FALSE);
     SetMenuState(CM_ENTRYFIELD,FALSE);
     SetMenuState(CM_TEXT,FALSE);
     SetMenuState(CM_EDITSTYLE,FALSE);
     SetMenuState(CM_EDITCOLORS,FALSE);
     SetMenuState(CM_EDITPRESPARAMS,FALSE);
     SetMenuState(CM_ARRANGE,FALSE);
END;

PROCEDURE TMyApp.EnableControls;
BEGIN
     SetMenuState(CM_GROUPBOX,TRUE);
     SetMenuState(CM_LISTBOX,TRUE);
     SetMenuState(CM_BUTTON,TRUE);
     SetMenuState(CM_ICON,TRUE);
     SetMenuState(CM_CHECKBOX,TRUE);
     SetMenuState(CM_RADIOBOX,TRUE);
     SetMenuState(CM_ENTRYFIELD,TRUE);
     SetMenuState(CM_TEXT,TRUE);
     SetMenuState(CM_EDITSTYLE,TRUE);
     SetMenuState(CM_EDITCOLORS,TRUE);
     SetMenuState(CM_EDITPRESPARAMS,TRUE);
     SetMenuState(CM_ARRANGE,TRUE);
END;


CONSTRUCTOR TMyApp.Init;
BEGIN
     Inherited.Init;
     InsertResources(TRUE,FALSE,TRUE);
     Untitled:=TRUE;
     FileName:='Untitled.rc';
     DlgActive:=FALSE;  {No dialog window opened}
     DragActive:=FALSE; {No drag active}
     Selection:=FALSE;
     MoveMode:=FALSE;
     MoveStart:=FALSE;
     SizeLowNS:=FALSE;
     SizeHighNS:=FALSE;
     SizeLeftWE:=FALSE;
     SizeRightWE:=FALSE;
     SizeLeftUp:=FALSE;
     SizeLeftDown:=FALSE;
     SizeRightUp:=FALSE;
     SizeRightDown:=FALSE;
     MovePtr:=WinQuerySysPointer(0,SPTR_MOVE,HWND_DESKTOP);
     ArrowPtr:=WinQuerySysPointer(0,SPTR_ARROW,HWND_DESKTOP);
     SIZENWSEPtr:=WinQuerySysPointer(0,SPTR_SIZENWSE,HWND_DESKTOP);
     SIZENESWPtr:=WinQuerySysPointer(0,SPTR_SIZENESW,HWND_DESKTOP);
     SIZEWEPtr:=WinQuerySysPointer(0,SPTR_SIZEWE,HWND_DESKTOP);
     SIZENSPtr:=WinQuerySysPointer(0,SPTR_SIZENS,HWND_DESKTOP);
     DlgList:=NIL;
     Resources:=NIL;
     DlgCount:=1000;
     Grid:=6;
END;

PROCEDURE TMyApp.AppCreateNotify(AppFrWin,AppWin:HWND);
BEGIN
     Inherited.AppCreateNotify(AppFrWin,AppWin);
     DisableControls;
     SetMenuState(CM_NEWRES,FALSE);
     SetMenuState(CM_DELETERES,FALSE);
     SetMenuState(CM_SELECTRES,FALSE);
END;

DESTRUCTOR TMyApp.Done;
BEGIN
END;


BEGIN
     MyApp.Init;
     MyApp.Run(1000,'Speed-Resource Editor ALPHA (Oct 94)',CLR_BLACK,CLR_WHITE);
     MyApp.Done;
END.
