UNIT RcDialog;

INTERFACE

USES RcTypes;

VAR
    TempDialog:PDialog;

CONST
    DialogCount:Word=0;

    MaxDialogStyles=53;
    DialogStyles:ARRAY[1..MaxDialogStyles] OF TStyle=(
    (Name:'NO_STYLE';Style:0),
    (Name:'WS_VISIBLE';Style:$80000000),
    (Name:'WS_DISABLED';Style:$40000000),
    (name:'WS_CLIPCHILDREN';Style:$20000000),
    (name:'WS_CLIPSIBLINGS';Style:$10000000),
    (name:'WS_PARENTCLIP';Style:$08000000),
    (name:'WS_SAVEBITS';Style:$04000000),
    (name:'WS_SYNCPAINT';Style:$02000000),
    (name:'WS_MINIMIZED';Style:$01000000),
    (name:'WS_MAXIMIZED';Style:$00800000),
    (name:'WS_ANIMATE';Style:$00400000),
    (name:'WS_GROUP';Style:$00010000),
    (name:'WS_TABSTOP';Style:$00020000),
    (name:'WS_MULTISELECT';Style:$00040000),
    (Name:'FS_ICON';Style:$00000001),
    (Name:'FS_ACCELTABLE';Style:$00000002),
    (Name:'FS_SHELLPOSITION';Style:$00000004),
    (Name:'FS_TASKLIST';Style:$00000008),
    (Name:'FS_NOBYTEALIGN';Style:$00000010),
    (Name:'FS_NOMOVEWITHOWNER';Style:$00000020),
    (Name:'FS_SYSMODAL';Style:$00000040),
    (Name:'FS_DLGBORDER';Style:$00000080),
    (Name:'FS_BORDER';Style:$00000100),
    (Name:'FS_SCREENALIGN';Style:$00000200),
    (Name:'FS_MOUSEALIGN';Style:$00000400),
    (Name:'FS_SIZEBORDER';Style:$00000800),
    (Name:'FS_AUTOICON';Style:$00001000),
    (Name:'FS_DBE_APPSTAT';Style:$00008000),
    (Name:'FS_STANDARD';Style:$0000000F),
    (Name:'BS_BITMAP';Style:$40),
    (Name:'BS_ICON';Style:$80),
    (Name:'WS_NOTHING';Style:0),
    (Name:'WS_NORMAL';Style:$80010000),    {WS_GROUP|WS_VISIBLE}
    (Name:'CBS_SIMPLE';Style:$0001),
    (Name:'CBS_DROPDOWN';Style:$0002),
    (Name:'CBS_DROPDOWNLIST';Style:$0004),
    (Name:'ES_LEFT';Style:$00000000),
    (Name:'ES_CENTER';Style:$00000001),
    (Name:'ES_RIGHT';Style:$00000002),
    (Name:'ES_AUTOSCROLL';Style:$00000004),
    (Name:'ES_MARGIN';Style:$00000008),
    (Name:'ES_AUTOTAB';Style:$00000010),
    (Name:'ES_READONLY';Style:$00000020),
    (Name:'ES_COMMAND';Style:$00000040),
    (Name:'ES_UNREADABLE';Style:$00000080),
    (Name:'ES_AUTOSIZE';Style:$00000200),
    (Name:'MLS_WORDWRAP';Style:$00000001),
    (Name:'MLS_BORDER';Style:$00000002),
    (Name:'MLS_VSCROLL';Style:$00000004),
    (Name:'MLS_HSCROLL';Style:$00000008),
    (Name:'MLS_READONLY';Style:$00000010),
    (Name:'MLS_IGNORETAB';Style:$00000020),
    (Name:'MLS_DISABLEUNDO';Style:$00000040)
    );


    MaxDialogFlags=87;
    DialogFlags:ARRAY[1..MaxDialogFlags] OF TStyle=(
    (Name:'NO_FLAGS';Style:0),
    (Name:'FCF_TITLEBAR';Style:$00000001),
    (Name:'FCF_SYSMENU';Style:$00000002),
    (Name:'FCF_MENU';Style:$00000004),
    (Name:'FCF_SIZEBORDER';Style:$00000008),
    (Name:'FCF_MINBUTTON';Style:$00000010),
    (Name:'FCF_MAXBUTTON';STyle:$00000020),
    (Name:'FCF_MINMAX';Style:$00000030),
    (Name:'FCF_VERTSCROLL';Style:$00000040),
    (Name:'FCF_HORZSCROLL';Style:$00000080),
    (Name:'FCF_DLGBORDER';Style:$00000100),
    (Name:'FCF_BORDER';Style:$00000200),
    (Name:'FCF_SHELLPOSITION';Style:$00000400),
    (Name:'FCF_TASKLIST';Style:$00000800),
    (Name:'FCF_NOBYTEALIGN';Style:$00001000),
    (Name:'FCF_NOMOVEWITHOWNER';Style:$00002000),
    (Name:'FCF_ICON';Style:$00004000),
    (Name:'FCF_ACCELTABLE';Style:$00008000),
    (Name:'FCF_SYSMODAL';Style:$00010000),
    (Name:'FCF_SCREENALIGN';Style:$00020000),
    (Name:'FCF_MOUSEALIGN';Style:$00040000),
    (Name:'FCF_HIDEBUTTON';Style:$01000000),
    (Name:'FCF_HIDEMAX';Style:$01000020),
    (Name:'FCF_DBE_APPSTAT';Style:$80000000),
    (Name:'FCF_AUTOICON';Style:$40000000),
    (Name:'FCF_STANDARD';Style:$0000CC3F),
    (Name:'FCF_NOTHING';Style:0),
    (Name:'SPBS_ALLCHARACTERS';Style:$00000000),
    (Name:'SPBS_NUMERICONLY';Style:$00000001),
    (Name:'SPBS_READONLY';Style:$00000002),
    (Name:'SPBS_MASTER';Style:$00000010),
    (Name:'SPBS_SERVANT';Style:$00000000),
    (Name:'SPBS_JUSTDEFAULT';Style:$00000000),
    (Name:'SPBS_JUSTLEFT';Style:$00000008),
    (Name:'SPBS_JUSTRIGHT';Style:$00000004),
    (Name:'SPBS_JUSTCENTER';Style:$0000000C),
    (Name:'SPBS_NOBORDER';Style:$00000020),
    (Name:'SPBS_FASTSPIN';Style:$00000100),
    (Name:'SPBS_PADWITHZEROS';Style:$00000080),
    (Name:'SLS_HORIZONTAL';Style:$00000000),
    (Name:'SLS_VERTICAL';Style:$00000001),
    (Name:'SLS_CENTER';Style:$00000000),
    (Name:'SLS_BOTTOM';Style:$00000002),
    (Name:'SLS_TOP';Style:$00000004),
    (Name:'SLS_LEFT';Style:$00000002),
    (Name:'SLS_RIGHT';Style:$00000004),
    (Name:'SLS_SNAPTOINCREMENT';Style:$00000008),
    (Name:'SLS_BUTTONSBOTTOM';Style:$00000010),
    (Name:'SLS_BUTTONSTOP';Style:$00000020),
    (Name:'SLS_BUTTONSLEFT';Style:$00000010),
    (Name:'SLS_BUTTONSRIGHT';Style:$00000020),
    (Name:'SLS_OWNERDRAW';Style:$00000040),
    (Name:'SLS_READONLY';Style:$00000080),
    (Name:'SLS_RIBBONSTRIP';Style:$00000100),
    (Name:'SLS_HOMEBOTTOM';Style:$00000000),
    (Name:'SLS_HOMETOP';Style:$00000200),
    (Name:'SLS_HOMELEFT';Style:$00000000),
    (Name:'SLS_HOMERIGHT';Style:$00000200),
    (Name:'SLS_PRIMARYSCALE1';Style:$00000000),
    (Name:'SLS_PRIMARYSCALE2';Style:$00000400),
    (Name:'VS_BITMAP';Style:$0001),
    (Name:'VS_ICON';Style:$0002),
    (Name:'VS_TEXT';Style:$0004),
    (Name:'VS_RGB';Style:$0008),
    (Name:'VS_COLORINDEX';Style:$0010),
    (Name:'VS_BORDER';Style:$0020),
    (Name:'VS_ITEMBORDER';Style:$0040),
    (Name:'VS_SCALEBITMAPS';Style:$0080),
    (Name:'VS_RIGHTTOLEFT';Style:$0100),
    (Name:'VS_OWNERDRAW';Style:$0200),
    (Name:'SS_TEXT';Style:$0001),
    (Name:'SS_GROUPBOX';Style:$0002),
    (Name:'SS_ICON';Style:$0003),
    (Name:'SS_BITMAP';Style:$0004),
    (name:'SS_FGNDRECT';Style:$0005),
    (Name:'SS_HALFTONERECT';Style:$0006),
    (Name:'SS_BKGNDRECT';Style:$0007),
    (Name:'SS_FGNDFRAME';Style:$0008),
    (Name:'SS_HALFTONEFRAME';Style:$0009),
    (Name:'SS_BKGNDFRAME';Style:$000a),
    (Name:'SS_SYSICON';Style:$000b),
    (Name:'SS_AUTOSIZE';Style:$0040),
    (Name:'LS_MULTIPLESEL';Style:$00000001),
    (Name:'LS_OWNERDRAW';Style:$00000002),
    (Name:'LS_NOADJUSTPOS';Style:$00000004),
    (Name:'LS_HORZSCROLL';Style:$00000008),
    (Name:'LS_EXTENDEDSEL';Style:$00000010)
    );

    MaxDialogTypes=23;
    DialogTypes:Array[1..MaxDialogtypes] OF TStyle=(
     (Name:'WC_FRAME';Style:$0001),
     (Name:'WC_COMBOBOX';Style:$0002),
     (Name:'WC_BUTTON';Style:$0003),
     (Name:'WC_MENU';Style:$0004),
     (Name:'WC_STATIC';Style:$0005),
     (Name:'WC_ENTRYFIELD';Style:$0006),
     (Name:'WC_LISTBOX';Style:$0007),
     (Name:'WC_SCROLLBAR';Style:$0008),
     (Name:'WC_TITLEBAR';Style:$0009),
     (Name:'WC_MLE';Style:$000A),
     (Name:'WC_APPSTAT';Style:$0010),
     (Name:'WC_KBDSTAT';Style:$0011),
     (name:'WC_PECIC';Style:$0012),
     (Name:'WC_DBE_KKPOPUP';Style:$0013),
     (Name:'WC_SPINBUTTON';Style:$0020),
     (Name:'WC_CONTAINER';Style:$0025),
     (Name:'WC_SLIDER';Style:$0026),
     (Name:'WC_VALUESET';Style:$0027),
     (Name:'WC_NOTEBOOK';Style:$0028),
     (Name:'WC_PENFIRST';Style:$0029),
     (Name:'WC_PENLAST';Style:$002C),
     (Name:'WC_MMPMFIRST';Style:$0040),
     (Name:'WC_MMPMLAST';Style:$004f)
     );




PROCEDURE ParseDialog;
PROCEDURE Write_res_Dialogs;
PROCEDURE Write_Dialogs;


IMPLEMENTATION

PROCEDURE NewDialog(VAR dial,d:PDialog);
BEGIN
     IF Dial=NIL THEN
     BEGIN
          New(Dial);
          d:=Dial;
     END
     ELSE
     BEGIN
          d:=Dial;
          while d^.next<>NIL do d:=d^.next;
          new(d^.next);
          d:=d^.next;
     END;
     d^.SubSize:=0;
     d^.Interior:=NIL;
     d^.next:=NIL;
     d^.Flags:=0;
     d^.Style:=0;
     d^.Art:=0;
     d^.InteriorCount:=0;
     d^.DataCount:=0;
     d^.PresParambytes:=0;
END;

PROCEDURE Write_res_Dialogs;
var d,d1:PDialog;
    b:byte;
    textofs:WORD;
BEGIN
     d:=Dialogs;
     WHILE d<>NIL DO
     BEGIN
          WriteWord(d^.SubSize AND 65535);
          WriteWord(d^.Subsize SHR 16);
          WriteWord($0352);
          WriteWord($0e);
          WriteWord(1);
          WriteWord($ffff);
          WriteWord(0);
          WriteWord(0);
          WriteWord(d^.InteriorCount);
          WriteWord(0);
          WriteWord(0{1???????????});
          WriteWord(length(d^.Title));       {Length of dialog title}
          textofs:=44+d^.InteriorCount*30;   {Offset of the text from start}
          WriteWord(textofs); {Offset of dialog title}
          WriteWord(d^.Style AND 65535);
          WriteWord(d^.Style SHR 16);
          WriteWord(d^.x);
          WriteWord(d^.y);
          WriteWord(d^.x1);
          WriteWord(d^.y1);
          WriteWord(d^.ident);
          inc(textofs,length(d^.title)+1);
          IF d^.PresParambytes=0 THEN WriteWord($ffff)
          ELSE
          BEGIN
               WriteWord(textofs+4);
          END;
          WriteWord(textofs); {length of dialog including title}
          inc(textofs,d^.presparambytes+4);
          d1:=d^.Interior;
          WHILE d1<>NIL DO
          BEGIN
               WriteWord(0);
               WriteWord(0);
               WriteWord(0);
               WriteWord(d1^.Art);
               WriteWord(length(d1^.title));
               WriteWord(textofs);
               inc(textofs,length(d1^.title)+1);
               WriteWord(d1^.flags and 65535);
               WriteWord(d1^.flags shr 16);
               WriteWord(d1^.x);
               WriteWord(d1^.y);
               WriteWord(d1^.x1);
               WriteWord(d1^.y1);
               WriteWord(d1^.ident);
               IF d1^.PresParambytes=0 THEN WriteWord($ffff)
               ELSE
               BEGIN
                    WriteWord(textofs);
                    inc(textofs,d1^.presparambytes);
               END;
               IF d1^.datacount=0 THEN WriteWord($ffff)
               ELSE
               BEGIN
                    WriteWord(textofs);
                    inc(textofs,d1^.datacount SHL 1);
               END;
               d1:=d1^.next;
          END;
          WriteStr(d^.Title);
          WriteWord(d^.Flags AND 65535);
          WriteWord(d^.Flags SHR 16);
          IF d^.PresParambytes>0 THEN
          BEGIN
               Blockwrite(Zielf,d^.Presparams[0],d^.PresParamBytes);
               if ioresult<>0 then error('File write error');
          END;

          d1:=d^.Interior;
          IF d1=NIL THEN
          BEGIN
               b:=0;
               Blockwrite(Zielf,b,1);
               if ioresult<>0 then error('File write error');
          END
          ELSE
          BEGIN
               WHILE d1<>NIL DO
               BEGIN
                    WriteStr(d1^.title);
                    IF d1^.PresParambytes>0 THEN
                    BEGIN
                         Blockwrite(Zielf,d1^.Presparams[0],d1^.PresParamBytes);
                         if ioresult<>0 then error('File write error');
                    END;
                    IF d1^.datacount>0 THEN
                      FOR b:=1 TO d1^.datacount DO WriteWord(d1^.Data[b-1]);
                    d1:=d1^.next;
               END;
          END;
          d:=d^.next;
     END;
END;


PROCEDURE Write_Dialogs;
VAR w:Word;
    d:PDialog;
BEGIN
     DialogOffset:=MenuOffset;
     d:=Dialogs;
     WHILE d<>NIL DO
     BEGIN
          WriteWord(4);                     {Typ:Dialog}
          writeword(d^.ident);              {Bezeichner des Menus}
          writeword(d^.subsize AND 65535);  {Lnge der Eintrge fr dieses Menu}
          writeword(d^.subsize SHR 16);
          writeWord(3);                     {Object number}
          writeWord(DialogOffset AND 65535);  {Relativer Resourcenoffset}
          writeWord(DialogOffset SHR 16);
          inc(DialogOffset,d^.SubSize);
          d:=d^.next;
     END;
END;

PROCEDURE Calc_DialogSize(VAR d:PDialog);
VAR d1:PDialog;
BEGIN
     d^.Subsize:=48;
     inc(d^.subsize,length(d^.title)+1);
     inc(d^.subsize,d^.presparambytes);
     d1:=d^.Interior;
     WHILE d1<>NIL DO
     BEGIN
          inc(d^.Subsize,30);
          inc(d^.subsize,length(d1^.title)+1);
          inc(d^.subsize,d1^.datacount SHL 1);
          inc(d^.subsize,d1^.presparambytes);
          d1:=d1^.next;
     END;
END;


PROCEDURE Get_Caption(VAR Params:String;VAR Name:STRING;
                      VAR ident,x,y,x1,y1:WORD);
VAR s:String;
    c:Integer;
    i1:LONGINT;
BEGIN
     SplitLine(Params,s,',');
     IF s='' THEN Error('Syntax error');
     IF s[1]<>'"' THEN Error('String expected');
     IF s[length(s)]<>'"' THEN Error('String constant exceeds line');
     dec(s[0]);
     delete(s,1,1);
     Name:=s;
     SplitLine(Params,s,',');
     val(s,i1,c);
     if c<>0 then
     BEGIN
          IF not SearchConstant(s,i1) THEN
            error('Illegal numeric format');
     END;
     ident:=i1;
     SplitLine(Params,s,',');
     val(s,i1,c);
     if c<>0 then
     BEGIN
          IF not SearchConstant(s,i1) THEN
            error('Illegal numeric format');
     END;
     x:=i1;
     SplitLine(Params,s,',');
     val(s,i1,c);
     if c<>0 then
     BEGIN
          IF not SearchConstant(s,i1) THEN
            error('Illegal numeric format');
     END;
     y:=i1;
     SplitLine(Params,s,',');
     val(s,i1,c);
     if c<>0 then
     BEGIN
          IF not SearchConstant(s,i1) THEN
            error('Illegal numeric format');
     END;
     x1:=i1;
     val(Params,i1,c);
     if c<>0 then
     BEGIN
          IF not SearchConstant(s,i1) THEN
            error('Illegal numeric format');
     END;
     y1:=i1;
END;


PROCEDURE Get_Style(VAR Style:LONGINT);
VAR s,Temp:STRING;
    t:BYTE;
Label l;
BEGIN
     IF commanditem<>__STYLE THEN Error('STYLE expected');
     s:=params;
     SplitLine(s,params,',');
l:
     SplitLine(Params,Temp,'|');
     FOR t:=1 TO length(Temp) DO Temp[t]:=upcase(temp[t]);
     FOR t:=1 TO MaxDialogStyles DO
     BEGIN
          IF DialogStyles[t].Name=temp THEN
          BEGIN
               Style:=Style or DialogStyles[t].Style;
               IF params<>'' THEN goto l;
               exit;
          END;
     END;
     Error('Illegal dialog style:'+temp);
END;

PROCEDURE Get_Typ(VAR Typ:WORD);
VAR s,Temp:STRING;
    t:BYTE;
Label l;
BEGIN
     IF commanditem<>__TYPE THEN Error('TYPE expected');
     s:=params;
     SplitLine(s,params,',');
l:
     SplitLine(Params,Temp,'|');
     FOR t:=1 TO length(Temp) DO Temp[t]:=upcase(temp[t]);
     FOR t:=1 TO MaxDialogTypes DO
     BEGIN
          IF DialogTypes[t].Name=temp THEN
          BEGIN
               Typ:=Typ or DialogTypes[t].Style;
               IF params<>'' THEN goto l;
               exit;
          END;
     END;
     Error('Illegal dialog type:'+temp);
END;

PROCEDURE Get_Flags(VAR Flags:LONGINT);
VAR s,Temp:STRING;
    t:BYTE;
Label l;
BEGIN
     IF commanditem<>__FLAGS THEN Error('FLAGS expected');
     s:=Params;
     SplitLine(s,params,',');
l:
     SplitLine(Params,Temp,'|');
     FOR t:=1 TO length(Temp) DO Temp[t]:=upcase(temp[t]);
     FOR t:=1 TO MaxDialogFlags DO
     BEGIN
          IF DialogFlags[t].Name=temp THEN
          BEGIN
               Flags:=Flags or DialogFlags[t].Style;
               IF params<>'' THEN goto l;
               exit;
          END;
     END;
     Error('Illegal dialog flag:'+temp);
END;


PROCEDURE Get_Data(d:PDialog);
VAR s:string;
    i1:LONGINT;
    c:Integer;
Label l;
BEGIN
     IF commanditem<>__CTLDATA THEN Error('CTLDATA expected');
     SplitLine(Params,s,',');
     IF s='' THEN Error('Syntax error');
l:
     val(s,i1,c);
     if c<>0 then
     BEGIN
          IF not SearchConstant(s,i1) THEN
            error('Illegal numeric format');
     END;
     IF ((i1<0)OR(i1>65535)) THEN Error('Range check');
     d^.Data[d^.DataCount]:=i1;
     inc(d^.DataCount);
     SplitLine(Params,s,',');
     IF s<>'' THEN goto l;
END;

PROCEDURE ReadDialog(d:PDialog);
VAR d1:PDialog;
Label l;
BEGIN
     Read_Line;
     IF commanditem<>__DIALOG THEN Error('DIALOG expected');
     Get_Caption(Params,d^.Title,d^.ident,d^.x,d^.y,d^.x1,d^.y1);
     Read_Line;
     Get_Style(d^.Style);
     Read_Line;
     Get_Flags(d^.Flags);
     Read_Line;
     IF commanditem=__PRESPARAMS THEN GetPresParams(d);
     IF commanditem<>__BEGIN THEN Error('BEGIN expected');
     Read_Line;
     WHILE commanditem<>__END DO
     BEGIN
          IF commanditem<>__END THEN
          BEGIN
               NewDialog(d^.Interior,d1);
               INC(d^.InteriorCount);
          END;
          CASE commanditem OF
             __END:exit;
             __ICON:
             BEGIN
                  d1^.Art:=5; {WC_Static}
                  d1^.Flags:=3; {SS_ICON}
             END;
             __BITMAP:
             BEGIN
                  d1^.Art:=5; {WC_Static}
                  d1^.Flags:=4; {SS_BITMAP}
             END;
             __LTEXT,__RTEXT,__CTEXT:
             BEGIN
                  d1^.Art:=5; {WC_STATIC}
                  CASE commanditem OF
                    __LTEXT:d1^.Flags:=1;      {SS_TEXT|DT_LEFT}
                    __CTEXT:d1^.Flags:=$0101;  {SS_TEXT|DT_CENTER}
                    __RTEXT:d1^.Flags:=$0201;  {SS_TEXT|DT_RIGHT}
                  END; {case}
             END;
             __GROUPBOX:
             BEGIN
                  d1^.Art:=5; {WC_STATIC}
                  d1^.Flags:=2; {SS_GROUPBOX}
             END;
             __AUTORADIOBUTTON:
             BEGIN
                  d1^.Art:=3; {WC_BUTTON}
                  d1^.Flags:=4; {BS_AUTORADIOBUTTON}
             END;
             __MLE:
             BEGIN
                  d1^.Art:=$0a; {WC_MLE}
             END;
             __AUTOCHECKBOX:
             BEGIN
                  d1^.Art:=3; {WC_BUTTON}
                  d1^.Flags:=2; {BS_AUTOCHECKBOX}
             END;
             __RADIOBUTTON:
             BEGIN
                  d1^.Art:=3; {WC_BUTTON}
                  d1^.Flags:=3; {BS_RADIOBUTTON}
             END;
             __CONTROL:
             BEGIN
                  Get_Caption(Params,d1^.Title,d1^.ident,d1^.x,d1^.y,d1^.x1,d1^.y1);
                  Read_Line;
                  Get_Typ(d1^.Art);
                  Read_Line;
                  Get_Style(d1^.Flags);
                  Read_Line;
                  Get_Flags(d1^.Flags);
                  Read_Line;
                  IF commanditem=__CTLDATA THEN
                  BEGIN
                       Get_Data(d1);
                       Read_Line;
                  END;
                  goto l;
             END;
             __CHECKBOX:
             BEGIN
                  d1^.Art:=3; {WC_BUTTON}
                  d1^.Flags:=1; {BS_CHECKBOX}
             END;
             __COMBOBOX:d1^.Art:=2; {WC_COMBOBOX}
             __LISTBOX:d1^.Art:=7; {WC_LISTBOX}
             __ENTRYFIELD:d1^.Art:=6; {WC_ENTRYFILED}
             __SCROLLBAR:d1^.Art:=8; {WC_SCROLLBAR}
             __SLIDER:d1^.Art:=$26; {WC_SLIDER}
             __VALUESET:d1^.Art:=$27; {WC_VALUESET}
             __CONTAINER:d1^.Art:=$25; {WC_CONTAINER}
             __SPINBUTTON:d1^.Art:=$20; {WC_SPINBUTTON}
             __FRAME:d1^.Art:=1; {WC_FRAME}
             __PUSHBUTTON,__DEFPUSHBUTTON:
             BEGIN
                  d1^.Art:=3; {WC_BUTTON}
                  IF commanditem=__DEFPUSHBUTTON THEN d1^.Flags:=$0400; {BS_DEFAULT}
             END;
             ELSE Error('Illegal dialog control');
          END;
          Get_Caption(Params,d1^.Title,d1^.ident,d1^.x,d1^.y,d1^.x1,d1^.y1);
          Read_Line;
          Get_Style(d1^.Flags);
          Read_Line;
l:
          IF commanditem=__PRESPARAMS THEN GetPresParams(d1);
     END;
END;


PROCEDURE ParseDialog;
VAR i:WORD;
    c:Integer;
    i1:LONGINT;
    d:PDialog;
BEGIN
     INC(DialogCount);
     val(params,i,c);
     if c<>0 then
     BEGIN
          IF not SearchConstant(params,i1) THEN
            error('Illegal numeric format');
          i:=i1;
     END;
     params:='';
     NewDialog(Dialogs,d);
     d^.ident:=i;
     Read_Line;
     IF commanditem<>__BEGIN THEN Error('BEGIN expected');
     ReadDialog(d);
     Calc_DialogSize(d);
END;

BEGIN
END.