/**************************************************************************
 * Source Id :
 *
 * $Id: utils.h,v 1.5 1994/09/08 06:55:52 kevinl Exp $
 *-------------------------------------------------------------------------
 * Project Notes :
 *
 *  Diamond Base
 *  ============
 *      A solid database implementation, spurred on by the continuing
 *  Metal (Lead) Base saga.
 *
 *  Project Team :
 *        A. Davison
 *        K. Lentin
 *        D. Platt
 *
 *	Project Commenced : 05-02-1993
 *
 *-------------------------------------------------------------------------
 *  Module Notes :
 *
 *  Protoypes for useful missing functions.
 *
 *
 *  Original Author : Kev
 *
 **************************************************************************/

#ifndef __DB_UTILS_H__
#define __DB_UTILS_H__

#include <diamond/mystring.h>

char* strNcpy(char* d, char* s, int n);

class dbStrArray {
	size_t size;
	dbString** data;
public:
	dbStrArray(void) { data = 0; size = 0; }
	~dbStrArray();
	size_t getSize(void) { return size; }
	void increase(void);
	dbString& operator++(void);
	dbString& operator++(int);
	dbString& operator[](size_t i) { return *data[i]; }
	void reset(void);
	dbString& add(const dbString& s)
	{
		dbString& newStr = ++(*this);
		newStr = s;
		return newStr;
	}
};
#endif

///////////////////////////////////////////////////////////////////////////
// Revision History:
//
// $Log: utils.h,v $
// Revision 1.5  1994/09/08  06:55:52  kevinl
// Added increase prototype.
//
// Revision 1.4  1994/09/07  07:57:41  kevinl
// Fixed up prefix/postfix ++ operator
//
// Revision 1.3  1994/05/15  05:11:22  kevinl
// Added dbStrArray.
//
// Revision 1.2  1994/02/03  05:54:19  kevinl
// Moved include files to diamond/ and fixed HAVE_MALLOC_H
//
// Revision 1.1  1993/11/03  10:05:33  kevinl
// Initial revision
//
///////////////////////////////////////////////////////////////////////////
