/**************************************************************************
 * Source Id :
 *
 * $Id: nserver.h,v 1.13 1994/02/03 05:54:19 kevinl Exp $
 *-------------------------------------------------------------------------
 * Project Notes :
 *
 *  Diamond Base
 *  ============
 *      A solid database implementation, spurred on by the continuing
 *  Metal (Lead) Base saga.
 *
 *  Project Team :
 *        A. Davison
 *        K. Lentin
 *        D. Platt
 *
 *	Project Commenced : 05-02-1993
 *
 *-------------------------------------------------------------------------
 *  Module Notes :
 *
 *    Name Server Class : This will return the path leading to the database
 *   files related a relation by its name.
 *
 *  Original Author :
 *		Andy
 *
 **************************************************************************/

#ifndef __DB_NSERVER_H__
#define __DB_NSERVER_H__

#include <ctype.h>
#include <string.h>
#include <diamond/defs.h>
#include <diamond/dbbst.h>
#include <diamond/mystring.h>

#define MAX_RELATIONS 20

struct NameNode : public DBBSTNode
{
	dbString	pathName;
	dbString	relName;

	NameNode(dbString a, dbString b) { pathName = a; relName = b;}
	virtual int compare(DBBSTNode* a, DBBSTNode* b)
	{
		return strcmp(((NameNode*)a)->relName, ((NameNode*)b)->relName);
	}
	virtual void show() 
	{	
		cout << "Relation: " << relName << endl
		     << "PathName: " << pathName << endl
			 << "Tag: " << (long)this << endl
			 << "------------------------------------" << endl;
	}

};

class TNameServer
{
//	char	PathName[MAX_RELATIONS][200];
//	char	RelName[MAX_RELATIONS][40];

	int		NumNames;

	DBBST	tree;

	bool	allowAll;
protected:
	bool	nsOpen;
public:
					TNameServer();
			int		loadConfig(const char* name);
			char*	queryName(const char*, long& nameId);
	const	char*	verStr(void) const;
	const	bool	ok(void) const { return nsOpen; }
			void	dumpNS() { tree.inorder();}
};

#endif

//////////////////////////////////////////////////////////////////////////
// Revision History:
//
// $Log: nserver.h,v $
// Revision 1.13  1994/02/03  05:54:19  kevinl
// Moved include files to diamond/ and fixed HAVE_MALLOC_H
//
// Revision 1.12  1994/01/24  04:48:41  kevinl
// Include listable.h
//
// Revision 1.11  1994/01/24  03:02:42  davison
// NameServer now uses a binary search tree and requires a call to
// loadConfig to be initialised.
//
// Revision 1.10  1993/12/23  22:58:48  kevinl
// dbErr uses dbString, autoconf stuff, moved logs, added const and size_t
//
// Revision 1.9  1993/11/04  14:57:06  kevinl
// Added allowAll and isOpen and took care of unnamed relations "" being
// added to the array
//
// Revision 1.8  1993/07/11  08:46:18  kevinl
// Minor compile time thingos
//
// Revision 1.7  1993/07/11  08:19:19  kevinl
// Stopped NameServer exiting when config file is empty/missing
//
// Revision 1.6  1993/05/11  14:44:50  kevinl
// Added version number output
//
// Revision 1.5  1993/04/27  07:03:31  kevinl
// Comments
//
// Revision 1.4  1993/03/25  22:21:42  davison
// queryName now takes a const char*
//
// Revision 1.3  1993/03/20  15:12:56  davison
// Now returns a name ID, so that only one dbobject for each relation is
// available at any time.
//
// Revision 1.2  1993/02/22  05:40:05  davison
// Fixed RCS Header.
//
//////////////////////////////////////////////////////////////////////////
