/**************************************************************************
 * Source Id :
 *
 * $Id: nserver.cc,v 1.27 1994/05/15 04:58:56 kevinl Exp $
 *-------------------------------------------------------------------------
 * Project Notes :
 *
 *  Diamond Base
 *  ============
 *      A solid database implementation, spurred on by the continuing
 *  Metal (Lead) Base saga.
 *
 *  Project Team :
 *        A. Davison
 *        K. Lentin
 *        D. Platt
 *
 *	Project Commenced : 05-02-1993
 *
 *-------------------------------------------------------------------------
 *  Module Notes :
 *
 *    Name Server Class : This will return the path leading to the database
 *   files related a relation by its name.
 *
 *  Original Author :
 *		Andy
 *
 **************************************************************************/

#include <stdlib.h>

#include <diamond/dbconf.h>

#if HAVE_MALLOC_H && !MALLOC_H_INCLUDED
extern "C" {
#include <malloc.h>
}
#define MALLOC_H_INCLUDED 1
#endif
#include <diamond/nserver.h>
#include <iostream.h>
#include <fstream.h>
#include <diamond/dberr.h>

const char*
TNameServer::verStr(void) const
{
	return "$Id: nserver.cc,v 1.27 1994/05/15 04:58:56 kevinl Exp $";
}

TNameServer::TNameServer()
{
	NumNames=0;
	allowAll = false;
	nsOpen = false;
	dbErr(db_ok);
	return;
}

int TNameServer::loadConfig(const char* dbcName)
{
	if (strcmp(dbcName,"") == 0)
	{
		NumNames = 0;
		allowAll = true;
		nsOpen = true;
		dbErr(db_ok);
		return 0;
	}
	ifstream is(dbcName);

	if (!is.good()) {
		dbErr(db_nfound, "database configuration file");
		NumNames = 0;
		return db_badName;
	}

	// File is of the form:
	// relation=path
	// .
	// .

	unsigned char relName[200];
	unsigned char pathName[200];
	while(is.good()) 
	{
		is.getline(relName,40,' ');
		is.getline(pathName,200);
		if (relName[0] && pathName[0])
		{
			if (tree.insert(new NameNode(pathName, relName)) == 0)
			{
				// Insert failed. What to do ?
				dbErr(db_alreadyregistered,(char*)relName);
				return db_alreadyregistered;
			} 
			relName[0] = pathName[0] = 0;
			NumNames++;
		}
	}
	nsOpen = true;
	dbErr(db_ok);
	return 0;
}
// Fetch a path for a particular relation database.

char* TNameServer::queryName(const char *name, long& nameId)
{
	NameNode  info("",name);
	DBBSTNode* node = tree.lookup((DBBSTNode*)&info);
	if (!node) {
		if (allowAll)
			node = tree.insert(new NameNode(".", name));
		else
		{
			cerr << "Relation name server lookup failed for '" << name <<"'" << endl;
			exit(1);
		}
	}
	nameId = (long)node;
//	char* newName = strdup((char*)((NameNode*)node)->pathName);
//	return newName;
	return (char*)((NameNode*)node)->pathName;
}

///////////////////////////////////////////////////////////////////////////
// Revision History:
//
// $Log: nserver.cc,v $
// Revision 1.27  1994/05/15  04:58:56  kevinl
// Type fixups.
//
// Revision 1.26  1994/02/10  00:22:33  davison
// Fixed return codes fdor or loadConfig
//
// Revision 1.25  1994/02/03  06:01:42  kevinl
// Moved include files to diamond/ and fixed HAVE_MALLOC_H
//
// Revision 1.24  1994/01/28  04:34:14  davison
// No longer returns a copy of the path requested, only a pointer to it's
// string
//
// Revision 1.23  1994/01/28  04:26:04  davison
// Fixed the "return a copy" problem in queryName.
//
// Revision 1.22  1994/01/24  03:02:42  davison
// NameServer now uses a binary search tree and requires a call to
// loadConfig to be initialised.
//
// Revision 1.21  1993/12/23  22:58:48  kevinl
// dbErr uses dbString, autoconf stuff, moved logs, added const and size_t
//
// Revision 1.20  1993/11/09  04:12:09  kevinl
// Fixed includes
// moved logs
//
// Revision 1.19  1993/11/09  01:31:32  kevinl
// Might fix the error reporting
//
// Revision 1.18  1993/11/04  14:57:06  kevinl
// Added allowAll and isOpen and took care of unnamed relations "" being
// added to the array
//
// Revision 1.17  1993/10/18  11:21:08  kevinl
// Allow use of "" as a database config file
//
// Revision 1.16  1993/07/11  08:46:18  kevinl
// Minor compile time thingos
//
// Revision 1.15  1993/07/11  08:19:14  kevinl
// Stopped NameServer exiting when config file is empty/missing
//
// Revision 1.14  1993/06/23  05:21:22  kevinl
// Mallocs are now in angular brackets
//
// Revision 1.13  1993/05/26  01:01:39  kevinl
// MALLOC_H_MISSING
//
// Revision 1.12  1993/05/11  14:44:50  kevinl
// Added version number output
//
// Revision 1.11  1993/05/06  04:00:19  kevinl
// SASC define for malloc.h
//
// Revision 1.10  1993/05/03  01:33:03  kevinl
// Cosmetic (mainly) changes for CC
//
// Revision 1.9  1993/04/27  07:03:31  kevinl
// Comments
//
// Revision 1.8  1993/04/15  04:21:52  kevinl
// Moved malloc.h
//
// Revision 1.7  1993/04/07  08:29:46  kevinl
// NameServer now displays correct dbc filename when it's not found
//
// Revision 1.6  1993/03/29  13:09:23  kevinl
// Now outputs requested relation name not array pointer
//
// Revision 1.5  1993/03/29  08:20:09  darrenp
// Added new malloc library support
//
// Revision 1.4  1993/03/25  22:21:12  davison
// queryName now takes a const char*.
//
// Revision 1.3  1993/03/20  15:11:47  davison
// Now returns a name ID, so that only one dbobject for each relation is
// available at any time.
//
// Revision 1.2  1993/02/22  05:39:54  davison
// Fixed RCS Header.
//
///////////////////////////////////////////////////////////////////////////
