/**************************************************************************
 * Source Id :
 *
 * $Id: mystring.h,v 1.33 1994/09/07 07:58:37 kevinl Exp $
 *-------------------------------------------------------------------------
 * Project Notes :
 *
 *  Diamond Base
 *  ============
 *      A solid database implementation, spurred on by the continuing
 *  Metal (Lead) Base saga.
 *
 *  Project Team :
 *        A. Davison
 *        K. Lentin
 *        D. Platt
 *
 *	Project Commenced : 05-02-1993
 *
 *-------------------------------------------------------------------------
 *  Module Notes :
 *
 *  mystring.h:
 *  A the variable length string class for variable length records
 *
 *  Original Author : Kev
 *
 **************************************************************************/

#pragma interface

#ifndef __DB_MYSTRING_H__
#define __DB_MYSTRING_H__

#include <diamond/dbconf.h>
#include <stdlib.h>

#if HAVE_MALLOC_H && !MALLOC_H_INCLUDED
extern "C" {
#include <malloc.h>
}
#define MALLOC_H_INCLUDED 1
#endif
#include <strstream.h>
#include <string.h>
#include <diamond/defs.h>

class dbString;

class dbData
{

	friend class dbString;

	unsigned char dummyc[2];
	unsigned char isstr; // Extra space needed on end of data
	size_t size;  // How much memory do we need for the char*;
public:
	unsigned char *data;  // The data being played with

	const char* verStr(void) { return "$Id"; }
	dbData(const unsigned char e = 0) : isstr(e) { data=0; size=0; }
	dbData(const dbData& D) : isstr(D.isstr) { createDbData(D); }
	dbData(const dbData& D, const char e) : isstr(e) { createDbData(D); }
	dbData(const char* s, const unsigned char e = 0) : isstr(e) { createCharPtr(s); }
	dbData(const unsigned char* s, const unsigned char e = 0) : isstr(e) { createCharPtr((const char*)s); }
#ifndef __BROKEN_SIGNED_CHAR
	dbData(const signed char* s, const unsigned char e = 0) : isstr(e) { createCharPtr((const char*)s); }
#endif
	void createDbData(const dbData& D);
	void createCharPtr(const char* s);
	dbData(const void* s, const size_t newlen, const char e = 0);
	~dbData(void) { if (data) free(data); data=0; size=0; }
	size_t len(void) const { return (isstr)?(data?strlen((char*)data):0):size; }
	size_t setSize(const size_t newLen);
	long getSize(void) const
	{
		return size;
	}
	char* cat(const char* s);
	char* cat(const unsigned char* s) { return cat((const char*)s); }
#ifndef __BROKEN_SIGNED_CHAR
	char* cat(const signed char* s) { return cat((const char*)s); }
#endif
	char* cat(const dbData& d);
	char* cpy(const char* s);
	char* cpy(const unsigned char* s) { return cpy((const char*) s); }
#ifndef __BROKEN_SIGNED_CHAR
	char* cpy(const signed char* s) { return cpy((const char*) s); }
#endif
	char* cpy(const dbData& d);
	void fill(const char c, size_t count = 0);
	void fill(const unsigned char c, size_t count = 0) { fill((const char)c, count); }
#ifndef __BROKEN_SIGNED_CHAR
	void fill(const signed char c, size_t count = 0) { fill((const char)c, count); }
#endif
	void clr(void);
	void dispose(void) { if (data) free(data); data=0; size=0; }
	operator char*() const { return (char*)data; }
	operator unsigned char*() const { return (unsigned char*)data; }
#ifndef __BROKEN_SIGNED_CHAR
	operator signed char*() const { return (signed char*)data; }
#endif
	operator void*() const { return (void*)data; }
	bool empty(void) const { return (bool)((data == 0) || (*data==0)); }
	friend dbData operator + (const dbData& S, const char* s);
	friend dbData operator + (const dbData& S, const unsigned char* s);
#ifndef __BROKEN_SIGNED_CHAR
	friend dbData operator + (const dbData& S, const signed char* s);
#endif
	friend dbData operator + (const dbData& S, const dbData& s);
	friend ostream& operator << (ostream& o, const dbData& s);
	friend istream& operator >> (istream& i, dbData& s);
	unsigned char& operator [] (size_t i) { return (data && i < size)?data[i]:dummyc[0]; }
	dbData& operator = (const char* s)
	{
		cpy(s);
		return *this;
	}
	dbData& operator = (const unsigned char* s) { return (*this) = (const char*)s; }
#ifndef __BROKEN_SIGNED_CHAR
	dbData& operator = (const signed char* s) { return (*this) = (const char*)s; }
#endif
	dbData& operator = (const dbData& d)
	{
		cpy(d);
		return *this;
	}
	dbData& operator = (const char c)
	{
		dummyc[0] = c;
		dummyc[1] = 0;
		cpy(dummyc);
		return *this;
	}
	dbData& operator += (const char* s)
	{
		cat(s);
		return *this;
	}
	dbData& operator += (const unsigned char* s) { return (*this) += (const char*)s; }
#ifndef __BROKEN_SIGNED_CHAR
	dbData& operator += (const signed char* s) { return (*this) += (const char*)s; }
#endif
	dbData& operator += (const dbData& d)
	{
		cat(d);
		return *this;
	}
	dbData& operator += (const char c)
	{
		dummyc[0] = c;
		dummyc[1] = 0;
		cat(dummyc);
		return *this;
	}
#if 0
	long operator = (const long s)
	{
		long sz = setSize(s);
		if (isstr && s)
			data[s-1] = 0;
		return sz;
	}
#endif
//	long operator += (const size_t s)
	size_t addSize(const size_t s)
	{
		return setSize(size+s);
	}
//	long operator -= (const size_t s)
	size_t subSize(size_t s)
	{
		if (s > size)
			s = size;
		s = size - s;
		size_t sz = setSize(s);
		if (isstr && s)
			data[s-1] = 0;
		return sz;
	}
};

class dbString : public dbData
{
public:
	dbString(void) : dbData(1) { }
	dbString(const dbData& D) : dbData((char*)D, 1) { }
	dbString(const dbString& D) : dbData(D, 1) { }
	dbString(const char* s) : dbData(s, 1) { }
	dbString(const unsigned char* s) : dbData(s, 1) { }
#ifndef __BROKEN_SIGNED_CHAR
	dbString(const signed char* s) : dbData(s, 1) { }
#endif
	dbString& operator = (const char* s)
	{
		cpy(s);
		return *this;
	}
	dbString& operator = (const unsigned char* s) { return (*this) = (const char*)s; }
#ifndef __BROKEN_SIGNED_CHAR
	dbString& operator = (const signed char* s) { return (*this) = (const char*)s; }
#endif

	dbString& operator = (const dbData& d)
	{
		cpy(d);
		return *this;
	}
	dbData& operator = (const char c)
	{
		dummyc[0] = c;
		dummyc[1] = 0;
		cpy(dummyc);
		return *this;
	}
	int operator == (const char* str)
	{
		return !strcmp((const char*)data, str);
	}
	int operator == (const unsigned char* str) { return (*this) == (const char*) str; }
#ifndef __BROKEN_SIGNED_CHAR
	int operator == (const signed char* str) { return (*this) == (const char*) str; }
#endif
	int operator != (const char* str)
	{
		return strcmp((const char*)data,str);
	}
	int operator != (const unsigned char* str) { return (*this) != (const char*) str; }
#ifndef __BROKEN_SIGNED_CHAR
	int operator != (const signed char* str) { return (*this) != (const char*) str; }
#endif
	int operator == (const dbString& d)
	{
		return !strcmp((const char*)data, d);
	}
	int operator != (const dbString& d)
	{
		return strcmp((const char*)data, d);
	}
	int operator > (const dbString& d)
	{
		return (strcmp((const char*)data, d) > 0);
	}
	int operator < (const dbString& d)
	{
		return (strcmp((const char*)data, d) < 0);
	}
	int operator > (const char* str)
	{
		return (strcmp((const char*)data, str) > 0);
	}
	int operator > (const unsigned char* str) { return (*this) > (const char*) str; }
#ifndef __BROKEN_SIGNED_CHAR
	int operator > (const signed char* str) { return (*this) > (const char*) str; }
#endif
	int operator < (const char* str)
	{
		return (strcmp((const char*)data, str) < 0);
	}
	int operator < (const unsigned char* str) { return (*this) < (const char*) str; }
#ifndef __BROKEN_SIGNED_CHAR
	int operator < (const signed char* str) { return (*this) < (const char*) str; }
#endif
	int operator >= (const char* str)
	{
		return !operator < (str);
	}
	int operator >= (const unsigned char* str) { return (*this) >= (const char*) str; }
#ifndef __BROKEN_SIGNED_CHAR
	int operator >= (const signed char* str) { return (*this) >= (const char*) str; }
#endif
	int operator <= (const char* str)
	{
		return !operator > (str);
	}
	int operator <= (const unsigned char* str) { return (*this) <= (const char*) str; }
#ifndef __BROKEN_SIGNED_CHAR
	int operator <= (const signed char* str) { return (*this) <= (const char*) str; }
#endif
	int operator >= (const dbString& d)
	{
		return !operator < (d);
	}
	int operator <= (const dbString& d)
	{
		return !operator > (d);
	}
};
#endif

///////////////////////////////////////////////////////////////////////////
// Revision History:
//
// $Log: mystring.h,v $
// Revision 1.33  1994/09/07  07:58:37  kevinl
// added stdlib.h
//
// Revision 1.32  1994/05/15  05:07:23  kevinl
// Type fixups. Moved out some inline functions into .cc
//
// Revision 1.31  1994/02/25  03:13:55  darrenp
// Changes for DOS binary compatibility.
//
// Revision 1.29  1994/02/03  05:54:19  kevinl
// Moved include files to diamond/ and fixed HAVE_MALLOC_H
//
// Revision 1.28  1994/01/11  22:58:09  kevinl
// OK OK. So empty is when there's nothing there. Big deal. Only 50% wrong.
//
// Revision 1.27  1993/12/23  22:58:48  kevinl
// dbErr uses dbString, autoconf stuff, moved logs, added const and size_t
//
// Revision 1.26  1993/11/30  03:23:31  kevinl
// More operators
//
// Revision 1.25  1993/11/18  02:59:27  kevinl
// Moved logs
// Fixedaggregate type returning/passing
//
// Revision 1.24  1993/11/09  00:26:49  davison
// added != operator to dbString
//
// Revision 1.23  1993/11/05  12:45:05  kevinl
// Fixed problems that CC picked up (and some multi bugs)
//
// Revision 1.22  1993/10/28  13:31:20  davison
// Changed clear() method to clr().
//
// Revision 1.21  1993/10/24  15:36:12  kevinl
// A spelling error and a dbString copy constructor
//
// Revision 1.20  1993/10/24  11:43:46  davison
// Fixed up operator +=(char) and =operator =(char).
// They now ensure that dummyc[1] = 0.
//
// Revision 1.19  1993/10/24  10:09:38  kevinl
// Removed a const
//
// Revision 1.18  1993/10/24  09:14:48  kevinl
// dummyc is now a char[2] so we can remove the aggregate initialiser
// from the char operators
//
// Revision 1.17  1993/10/19  11:59:05  kevinl
// copying (char*)0 or a totally empty dbData/dbString now truncates
//
// Revision 1.16  1993/10/18  09:07:23  davison
// Killed unsigned int manipulations.
// Added addSize & subSize.
// Added char concatination method.
//
// Revision 1.15  1993/10/18  05:55:51  davison
// Added a string comparison operator to dbString. Compiled ok. Hope it
// works :-)
//
// Revision 1.14  1993/10/05  07:34:31  kevinl
// Now handles dbData AND dbString properly
//
// Revision 1.13  1993/09/26  08:34:32  kevinl
// Fixed ambiguous constructors
//
// Revision 1.12  1993/08/29  12:56:27  kevinl
// Fixed problems of assigning relations to each other.
//
// Revision 1.11  1993/07/20  12:59:30  kevinl
// Some unisgned int vs long problems
//
// Revision 1.10  1993/07/19  11:57:58  kevinl
// Added some dummy cahrs to remove Borland warnings re temporaries
// Added some {} to remove Borland's confusion about multiple if/elses
//
// Revision 1.9  1993/07/13  00:18:08  kevinl
// We weren't setting size in cat/cpy johnb@kea.grace.cri.nz (John Burnell)
//
// Revision 1.8  1993/07/11  10:49:21  kevinl
// dbString version
//
// Revision 1.7  1993/07/11  09:42:05  kevinl
// Changed String to dbString
//
// Revision 1.6  1993/07/11  08:20:17  kevinl
// Fixed [] operator
// Added CHUNKSIZE
//
// Revision 1.5  1993/07/09  06:26:52  kevinl
// Made some operators that take String
//
// Revision 1.4  1993/07/09  03:57:55  kevinl
// Removed realloc of null pointers.
//
// Revision 1.3  1993/06/20  23:29:05  kevinl
// Added -=
//
// Revision 1.2  1993/06/20  13:38:27  kevinl
// Fixed multiple mallocs
// longs now unsigned int, cat/cpy return the string
// added fill, =,+= unsigned int and moved += operator in
//
// Revision 1.1  1993/06/18  12:31:14  kevinl
// Initial revision
//
///////////////////////////////////////////////////////////////////////////
