/**************************************************************************
 * Source Id :
 *
 * $Id: mystring.cc,v 1.15 1994/07/19 04:19:58 darrenp Exp $
 *-------------------------------------------------------------------------
 * Project Notes :
 *
 *  Diamond Base
 *  ============
 *      A solid database implementation, spurred on by the continuing
 *  Metal (Lead) Base saga.
 *
 *  Project Team :
 *        A. Davison
 *        K. Lentin
 *        D. Platt
 *
 *	Project Commenced : 05-02-1993
 *
 *-------------------------------------------------------------------------
 *  Module Notes :
 *
 *  mystring.cc:
 *  Operators for the variable length string class.
 *
 *  Original Author : Kev
 *
 **************************************************************************/

#pragma implementation

#include <ctype.h>
#include <diamond/mystring.h>

const CHUNKSIZE = 256;

void
dbData::fill(const char c, size_t count)
{
	if (count == 0) {
		if (size == 0)
			return;
		else
			count = size-isstr;
	} else
		setSize(count+isstr);
	memset(data, c, (size_t)count);
	if (isstr)
		data[count] = 0;
}

dbData operator + (const dbData& S, const char* s)
{
	dbData res(S);
	res.cat(s);
	return res;
}
dbData operator + (const dbData& S, const dbData& s)
{
	dbData res(S);
	res.cat(s);
	return res;
}
ostream& operator << (ostream& o, const dbData& s)
{
	if (s.isstr)
		o << (char*)s;
	else
		o.write((char*)s, (size_t)s.getSize());
	return o;
}
istream& operator >> (istream& i, dbData& s)
{
	s.clr();
	s.setSize(CHUNKSIZE);
	size_t curLen = 0; // Speeds things up
	s[curLen] = 0;
	int c;
	if (s.isstr) {
		do {
			c = i.get();
			if (c == '\n' || c == EOF || !i.good())
				return i;
		} while (isspace(c));
		i.putback(c);
	}
	while (i.good()) {
		c = i.get();
		if (c == EOF || !i.good())
			break;
		else if (s.isstr)
			if (c == '\n' || isspace(c)) {
				i.putback(c);
				break;
			}
		if (curLen >= s.getSize()-1)
			s+=CHUNKSIZE;
		s[curLen++] = c;
	}
	if (s.isstr)
		s[curLen] = 0;
	s.setSize(curLen);
	return i;
}

void
dbData::createDbData(const dbData& D)
{
	dummyc[1] = 0;
	if (D.data) {
		size=D.len()+isstr;
		// data = new unsigned char[size];
		data = (unsigned char *)malloc(size);
		bcopy(D.data, data, (size_t)size);
	} else {
		size=0;
		data=0;
	}
}

void
dbData::createCharPtr(const char* s)
{
	dummyc[1] = 0;
	if (s) {
		data = (unsigned char*)strdup(s);
		size = strlen(s)+1;
	} else {
		size=0;
		data=0;
	}
}

dbData::dbData(const void* s, const size_t newlen, const char e) : isstr(e)
{
	dummyc[1] = 0;
	if (s) {
		data = new unsigned char[newlen];
		bcopy((char*)s, data, (size_t)newlen);
		size = newlen;
	} else {
		size=0;
		data=0;
	}
}

size_t
dbData::setSize(const size_t newLen)
{
	if (isstr && newLen < size) {
		// Nothing
	} else {
		if (data) {
			data = (unsigned char*)realloc(data, (size_t)newLen);
		} else {
			data = new unsigned char[newLen];
			if (isstr) *data = 0;
		}
		size = newLen;
	}
	return size;
}

char*
dbData::cat(const char* s)
{
	if (s) {
		size_t slen = strlen(s);
		size_t newsize = len()+slen+1; // always 1 'cos adding a string
		size_t oldsize = len();
		setSize(newsize);
		bcopy(s, data+oldsize,slen+1);
	}
	return (char*)data;
}

char*
dbData::cat(const dbData& d)
{
	if (d.data) {
		size_t newsize = len()+d.len()+isstr;
		size_t oldsize = len();
		setSize(newsize);
		bcopy(d.data, data+oldsize, d.len()+isstr);
	}
	return (char*)data;
}

char*
dbData::cpy(const char* s)
{
	if (s) {
		size_t slen = strlen(s);
		setSize(slen+1);
		bcopy(s, data, (size_t)(slen+1));
	} else {
		setSize(isstr);
		if (isstr)
			*data = 0;
	}
	return (char*)data;
}

char*
dbData::cpy(const dbData& d)
{
	if (d.data) {
		setSize(d.len()+isstr);
		bcopy(d.data, data, (size_t)(d.len()+isstr));
	} else {
		setSize(isstr);
		if (isstr)
			*data = 0;
	}
	return (char*)data;
}

void
dbData::clr(void)
{
	if (isstr) {
		if (data) {
			data[0] = 0;
		}
	} else
		dispose();
}

///////////////////////////////////////////////////////////////////////////
// Revision History:
//
// $Log: mystring.cc,v $
// Revision 1.15  1994/07/19  04:19:58  darrenp
// Fixed handling of multi identifier index names.
//
// Revision 1.14  1994/05/15  04:58:56  kevinl
// Moved many inlines from .h to here to keep CC happy.
//
// Revision 1.13  1994/03/17  04:34:45  kevinl
// Added \n as separator
//
// Revision 1.12  1994/02/24  06:35:30  darrenp
// DOS/Windows modifications.
//
// Revision 1.11  1994/02/03  06:01:42  kevinl
// Moved include files to diamond/ and fixed HAVE_MALLOC_H
//
// Revision 1.10  1993/12/23  22:58:48  kevinl
// dbErr uses dbString, autoconf stuff, moved logs, added const and size_t
//
// Revision 1.9  1993/11/18  02:59:27  kevinl
// Moved logs
// Fixedaggregate type returning/passing
//
// Revision 1.8  1993/10/28  13:31:20  davison
// Changed clear() method to clr().
//
// Revision 1.7  1993/10/05  07:34:31  kevinl
// Now handles dbData AND dbString properly
//
// Revision 1.6  1993/08/29  12:56:27  kevinl
// Fixed problems of assigning relations to each other.
//
// Revision 1.5  1993/07/11  09:42:05  kevinl
// Changed String to dbString
//
// Revision 1.4  1993/07/11  08:20:42  kevinl
// Fixed >> operator. Now gets enough memory for itself.
//
// Revision 1.3  1993/06/23  05:21:22  kevinl
// Mallocs are now in angular brackets
//
// Revision 1.2  1993/06/20  13:40:01  kevinl
// Fixed multiple mallocs
// += removed and put in header
//
// Revision 1.1  1993/06/18  12:31:14  kevinl
// Initial revision
//
///////////////////////////////////////////////////////////////////////////
