/**************************************************************************
 * Source Id :
 *
 * $Id: diagrel.h,v 1.11 1994/02/03 05:54:19 kevinl Exp $
 *-------------------------------------------------------------------------
 * Project Notes :
 *
 *  Diamond Base
 *  ============
 *      A solid database implementation, spurred on by the continuing
 *  Metal (Lead) Base saga.
 *
 *  Project Team :
 *        A. Davison
 *        K. Lentin
 *        D. Platt
 *
 *	Project Commenced : 05-02-1993
 *
 *-------------------------------------------------------------------------
 *  Module Notes :
 *
 *
 * The diaGRel class is used to provide generalised access to relations
 * without the need for associated compiled comparison code. It effectively
 * sits on top of a diaRel class and provides comparison, load and store
 * support for the object methods (must inherit an object base class too).
 *
 *  Original Author : Daz
 *
 **************************************************************************/

#ifndef __DB_DIAGREL_H__
#define __DB_DIAGREL_H__

#include <diamond/diarel.h>
#include <diamond/idxinfo.h>

#define MFII MAX_FIELDS_IN_INDEX

//
// This class provides access to generic relations.
// It uses the diaRel class to define its interface to
// users, and an object to define its responsibility to
// the database engine. It effectively provides an interpretted
// replacement for the DSC generated comparison code.
//

class diaGRel : public diaRel {
	private:
		// ----------------------------
		// Methods in object which
		// we must override to fulfill the db engines
		// requests.
		// ----------------------------
		operator 	void*() const;
		virtual	void 		getData(void) const;
		virtual	void 		putData(void) const;
		virtual	void 		startData(void) const;
		virtual	void 		endData(void) const;
		pKeyType 	getKey(const long keyNum=0) const;
		bool 		hasUnique(void) const;
		long		getUnique(void) const;
		void 		setUnique(const long uniq);
		long 		getKeyLength(const long keyNum=0) const;
		void 		setKey(const pKeyType newKey, const long keyNum=0);
		long 		compare(const pKeyType key, const long keyNum=0) const;
		bool 		isUnique(const long keyNum=0) const;
		//dbObjData*	data;

		_db_strStruct*	theArray;
		long* 		getLong(const long num) const;
		const _db_strStruct* getArray(void) const;

	public:
		dbData*		getString(const long num) const;
		long 		getDataLength(void) const; // Public so that
										// we know how long theData is
		long		fieldNum(const char* name) const;
		long*		uniqOffset;		// Pointer into unique in theData
		void		*theData; 		// Where we hold the record.
		long 		numStrings(void) const;
					diaGRel(const char *relName, void* newData = 0);
};
#endif

//////////////////////////////////////////////////////////////////////////
// Revision History:
//
// $Log: diagrel.h,v $
// Revision 1.11  1994/02/03  05:54:19  kevinl
// Moved include files to diamond/ and fixed HAVE_MALLOC_H
//
// Revision 1.10  1994/01/24  04:48:28  kevinl
// Made getString public
//
// Revision 1.9  1993/12/23  22:58:48  kevinl
// dbErr uses dbString, autoconf stuff, moved logs, added const and size_t
//
// Revision 1.8  1993/11/09  05:55:14  darrenp
// Fixed typo in multi include protection.
//
// Revision 1.7  1993/10/28  07:49:01  kevinl
// Added diaGRel dbString/dbData support
//
// Revision 1.6  1993/10/18  11:33:17  kevinl
// Added fieldNum
//
// Revision 1.5  1993/10/18  10:59:43  darrenp
// Moved some things into public
//
// Revision 1.4  1993/10/05  07:32:11  kevinl
// Moved all info out and into dbObj. Made all accesses to relation data
// via dbObjData pointer.
//
// Revision 1.3  1993/09/28  13:04:39  kevinl
// Can now pass data pointer to constructor
//
// Revision 1.2  1993/09/26  23:35:07  darrenp
// Fixed indexedOn allocation bug, expanded test code.
//
//////////////////////////////////////////////////////////////////////////
