/**************************************************************************
 * Source Id :
 *
 * $Id: dbmaint.cc,v 1.1 1994/08/02 11:30:47 kevinl Exp $
 *-------------------------------------------------------------------------
 * Project Notes :
 *
 *  Diamond Base
 *  ============
 *      A solid database implementation, spurred on by the continuing
 *  Metal (Lead) Base saga.
 *
 *  Project Team :
 *        A. Davison
 *        K. Lentin
 *        D. Platt
 *
 *	Project Commenced : 05-02-1993
 *
 *-------------------------------------------------------------------------
 *  Module Notes :
 *
 *  This is a generic relation maintenance utility.
 *  Started 6 July 1994
 *
 *  Original Author : Kev
 *
 **************************************************************************/

#include <stdlib.h>
#include <diamond/dbconf.h>

#if HAVE_MALLOC_H && !MALLOC_H_INCLUDED
extern "C" {
	#include <malloc.h>
}
#define MALLOC_H_INCLUDED 1
#endif

#include <iostream.h>
#include <limits.h>
#include <diamond/diagrel.h>
#include <diamond/generate.h>


#define OUT(data,off,typ) *((typ*)(((char*)data)+off))

void
outputField(ostream& o, void* data, long off, unsigned char type, long count, long strNum, dbData* dbDat)
{
	if (count != 1)
		o << "[" << count << "]";
	o << " ";
	if (type == D_CHAR)
		o << ((char*)data)+off;
	else
		for (int i=0; i<count; i++) {
			switch (type) {
				case D_SHORT:
					o << OUT(data,off,short);
					break;
				case D_USHORT:
					o << OUT(data, off, unsigned short);
					break;
				case D_DATA:
				{
					//dbData s;
					//ms->getString(s, OUT(data, off, long));
					o << *dbDat << " @ " << OUT(data, off, long);
					break;
				}
				case D_STRING:
				{
					//dbString s;
					//ms->getString(s, OUT(data, off, long));
					o << *dbDat << " @ " << OUT(data, off, long);
					break;
				}
				case D_LONG:
					o << OUT(data, off, long);
					break;
				case D_ULONG:
					o << OUT(data, off, unsigned long);
					break;
				case D_DOUBLE:
					o << OUT(data, off, double);
					break;
				case D_FLOAT:
					o << OUT(data, off, float);
					break;
				case D_MONEY:
					o << OUT(data, off, moneyType);
					break;
				case D_DATE:
					o << OUT(data, off, dateType);
					break;
				case D_UNIQUE:
					o << OUT(data, off, uniqueType);
					break;
				default:
					dbErr("Unknown type");
			}
			off++;
			o << " ";
		}
}

void
info(diaGRel& rel)
{
	int i, stringCount;
	const dbObjData* d = rel.getObjData();

	cout << "\nrelation" << endl << "{" << endl;
	for (i = 0, stringCount = 0; i < d->numFields; i++)
	{
		cout << '\t' << typeName(d->fieldType[i],true);
		int count = d->fieldLength[i] / mySizeOf(d->fieldType[i]);
		if (count != 1)
			cout << "[" << count << "]";
		cout << " " << d->fieldName[i] << ';' << endl;
	}
	cout << endl;
	for (i = 0; i < d->numIndices; i++)
	{
		cout << "\tindex " << i << " on ";
		for (int j = 0; d->indexedOnC[i][j] != -1; j++)
		{
			if (j)
				cout << ',';
			cout << d->fieldName[d->indexedOnC[i][j]];
		}
		cout << ';' << endl;
	}
	cout << "}\n\n";
}

void
display(diaGRel& rel)
{
	int i, stringCount;
	cout << "REC " << rel.getRecNum() << endl;
	const dbObjData* d = rel.getObjData();
	for (i = 0, stringCount = 0; i < d->numFields; i++)
	{
		cout << "FLD " << i << ": " << d->fieldName[i] << " " << typeName(d->fieldType[i],true);
		outputField(cout, rel.theData, d->fieldOffset[i], d->fieldType[i], d->fieldLength[i] / mySizeOf(d->fieldType[i]), stringCount, (d->fieldType[i]==D_STRING || d->fieldType[i]==D_DATA)?rel.getString(stringCount++):0);
		cout << endl;
	}
}

extern diamondBase theDiamondBase;

int main(int argc, char** argv)
{

	if ((argc != 2) && (argc != 3)) {	
		cerr << "Syntax: " << argv[0] << " [config file] relation" << endl;
		exit (1);
	}

	int opt=1;
	// Tell the Diamond base object to search the current path for 
	// relation files.
	if (argc == 3)
	{
		if (theDiamondBase.loadConfig(argv[1]))
		{
			cerr <<"Error reading config file." << endl;
			exit(2);
		}
		opt = 2;
	} else
		if(theDiamondBase.loadConfig(""))
		{
			cerr <<"Error reading config file." << endl;
			exit(2);
		}

	cout << "Trying to open Relation " << argv[opt] << endl;
	diaGRel rel(argv[opt]);
	if (!rel.ok()) {
		rel.perror("Can't open relation");
		exit (2);
	}

	rel.begin();
	bool gotit = false;
	char c;
	do {
		dbError err;
		cout << "rnpdxqih: ";
		cin >> c;
		cin.ignore(LONG_MAX, '\n');
		switch (c)
		{
			case 'h':
				cout << "Commands: (r)ead, (n)ext, (p)rev, (d)isplay, inde(x), (i)nfo, (q)uit, (h)elp" << endl;
				break;
			case 'q':
				break;
			case 'n':
				err = rel.next();
				gotit = true;
				if (err == db_ok)
					display(rel);
				else
					dbErr("Next: ");
				break;
			case 'p':
				err = rel.prev();
				gotit = true;
				if (err == db_ok)
					display(rel);
				else
					dbErr("Prev: ");
				break;
			case 'd':
				if (gotit)
					display(rel);
				else
					cout << "No current record" << endl;
				break;
			case 'i':
				info(rel);
				break;
			case 'x':
			{
				long idx;
				cout << "Previous position be relation will be lost." << endl
				     << "Enter index # or leave blank to make no change." << endl;
				cin >> idx;
				if (!cin.good())
				{
					idx = -1;
					cin.clear();
				}
				cout << endl;
				if (idx < 0 || idx > rel.getObjData()->numIndices)
				{
					cout << "Invalid index requested" << endl;
				}
				else
				{
					dbError err = rel.begin(idx);
					if (err == db_ok)
					{
						cout << "New query started with index " << idx << endl;
					}
					else
					{
						dbErr("Starting new query");
					}
				}
				cin.ignore(LONG_MAX, '\n');
				break;
			}
			case 'r':
				cout << "Not so quickly!" << endl;
				break;
			default:
				cout << "BAD COMMAND" << endl;
		}
	} while (c != 'q');
	rel.end();
	return 0;
}

///////////////////////////////////////////////////////////////////////////
// Revision History:
//
// $Log: dbmaint.cc,v $
// Revision 1.1  1994/08/02  11:30:47  kevinl
// Initial revision
//
// Revision 1.9  1994/07/04  12:16:06  kevinl
// Added a missing return
//
// Revision 1.8  1994/05/15  04:55:16  kevinl
// Type fixups
//
// Revision 1.7  1994/02/03  05:54:19  kevinl
// Moved include files to diamond/ and fixed HAVE_MALLOC_H
//
// Revision 1.6  1994/01/24  04:47:50  kevinl
// Removed explciit memServer 'cos dbobj does it.
//
// Revision 1.5  1994/01/24  02:58:27  davison
// Changed to use the new name server.
// Also now takes an otional first parameter, being the qualified
// name of a database config file.
//
// Revision 1.4  1993/12/23  22:58:48  kevinl
// dbErr uses dbString, autoconf stuff, moved logs, added const and size_t
//
// Revision 1.3  1993/10/28  07:49:01  kevinl
// Added diaGRel dbString/dbData support
//
// Revision 1.2  1993/10/18  08:03:10  kevinl
// Spelling mistook
//
// Revision 1.1  1993/10/10  23:25:28  kevinl
// Initial revision
//
///////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
// Revision History:
//
// $Log: dbmaint.cc,v $
// Revision 1.1  1994/08/02  11:30:47  kevinl
// Initial revision
//
////////////////////////////////////////////////////////////////////////////
