/**************************************************************************
 * Source Id :
 *
 * $Id: dbbst.h,v 1.4 1994/05/15 05:01:32 kevinl Exp $
 *-------------------------------------------------------------------------
 * Project Notes :
 *
 *  Diamond Base
 *  ============
 *      A solid database implementation, spurred on by the continuing
 *  Metal (Lead) Base saga.
 *
 *  Project Team :
 *        A. Davison
 *        K. Lentin
 *        D. Platt
 *
 *	Project Commenced : 05-02-1993
 *
 *-------------------------------------------------------------------------
 *  Module Notes :
 *
 *		A simple BST implementation
 *
 *  Original Author :
 *		Andy
 *
 **************************************************************************/

#ifndef __DB_BST_H__
#define __DB_BST_H__

#include <iostream.h>

struct DBBSTNode
{
	DBBSTNode*	_left;
	DBBSTNode*	_right;

		DBBSTNode(void) {_left = _right = 0;}

	virtual int compare(DBBSTNode*, DBBSTNode*) = 0;
	virtual void show() = 0;

	DBBSTNode* 	insert(DBBSTNode* node);
	DBBSTNode*	lookup(DBBSTNode* node);

	void inorder();

};

class DBBST
{
	DBBSTNode*	tree;

public:
		DBBST() {tree = 0;}

		DBBSTNode* insert(DBBSTNode* node)
		{
			DBBSTNode* res;
			if (tree == 0)
			{
				res = tree = node;
			}
			else
			{
				res = tree->insert(node); 
			}
			return res;
		}
		DBBSTNode* lookup(DBBSTNode* node)
		{
			return tree?tree->lookup(node):0;
		}

		void inorder()
		{
			if (tree != 0)
				tree->inorder();
		}
};

#endif

//////////////////////////////////////////////////////////////////////////
// $Log: dbbst.h,v $
// Revision 1.4  1994/05/15  05:01:32  kevinl
// Changing char* to dbString
//
// Revision 1.3  1994/02/03  05:50:31  kevinl
// Moved include files to diamond/ and fixed HAVE_MALLOC_H
//
// Revision 1.2  1994/01/24  05:05:04  kevinl
// Added a log
//
//////////////////////////////////////////////////////////////////////////
