/**************************************************************************
 * Source Id :
 *
 * $Id: dbbst.cc,v 1.2 1994/02/03 05:54:19 kevinl Exp $
 *-------------------------------------------------------------------------
 * Project Notes :
 *
 *  Diamond Base
 *  ============
 *      A solid database implementation, spurred on by the continuing
 *  Metal (Lead) Base saga.
 *
 *  Project Team :
 *        A. Davison
 *        K. Lentin
 *        D. Platt
 *
 *	Project Commenced : 05-02-1993
 *
 *-------------------------------------------------------------------------
 *  Module Notes :
 *
 *  Binary search tree for the nameserver.
 *
 *
 *  Original Author : Andy
 *
 **************************************************************************/

#include <diamond/dbbst.h>

DBBSTNode* DBBSTNode::insert(DBBSTNode* node)
{
	int side = compare(node, this);
	if (side < 0) {
		if (_left == 0)
			_left = node;
		else
			_left->insert(node);
		return this;
	} else if (side > 0) {
		if (_right ==0)
			_right = node;
		else
			_right->insert(node);
		return this;
	}
	// The element is already in there. Delete it and return an error.
	delete &node;
	return 0;
}

DBBSTNode* DBBSTNode::lookup(DBBSTNode* node)
{
	int side = compare(node,this);
	if (side == 0)
		return this;
	else if (side < 0)
	{
		if (_left == 0)
			return 0;
		else
			return _left->lookup(node);
	}
	else
	{
		if (_right == 0)
			return 0;
		else
			return _right->lookup(node);
	}
}

void DBBSTNode::inorder()
{
	if (_left != 0)
		_left->inorder();
	show();
	if(_right != 0)
		_right->inorder();
}

///////////////////////////////////////////////////////////////////////////
// Revision History:
//
// $Log: dbbst.cc,v $
// Revision 1.2  1994/02/03  05:54:19  kevinl
// Moved include files to diamond/ and fixed HAVE_MALLOC_H
//
///////////////////////////////////////////////////////////////////////////
