/**************************************************************************
 * Source Id :
 *
 * $Id: bucket.h,v 1.7 1994/05/15 05:01:32 kevinl Exp $
 *-------------------------------------------------------------------------
 * Project Notes :
 *
 *  Diamond Base
 *  ============
 *      A solid database implementation, spurred on by the continuing
 *  Metal (Lead) Base saga.
 *
 *  Project Team :
 *        A. Davison
 *        K. Lentin
 *        D. Platt
 *
 *	Project Commenced : 05-02-1993
 *
 *-------------------------------------------------------------------------
 *  Module Notes :
 *
 *  Include file for bucket.cc. Created far too late in the piece!
 *
 *
 *  Original Author : Kev
 *
 **************************************************************************/

#ifndef __DB_BUCKET_H__
#define __DB_BUCKET_H__

#include <diamond/defs.h>
#include <diamond/dberr.h>

//enum e_leaf {INNER, LEAF};

class object;
class bucket;

// Data stored at the head of each bucket's data area.

struct headerData
{
	// This is a bit ugly - we really want an enumated e_leaf type here,
	// but we have to ensure binary compatibility, so we make it a 32 bit number.
	// e_leaf		leaf;
	int32		leaf;
	bucketId	parentId;
	bucketId	nextBucket;
	bucketId	prevBucket;
	int32		activeKeys;
};

// Class definition for the bucket.

class bucket
{
	long*		data; // This is long* so that the headerData is aligned right
	bucketId	id;
	size_t		keyLength;
	long		numKeys;
	long		size;
	long		keyNum;
	size_t		myTupleSize;

public:
//-----
	bucket(const bucketId newId, const size_t newKeyLength, const long newSize, const e_leaf newLeaf, const bucketId newParentId, const bucketId newNextBucket, const bucketId newPrevBucket, const long NewkeyNum=0);
//	bucket(long newKeyNum=0 ) {};
	~bucket();
	inline bucketId	getId(void) const
		{
			return id;
		}
	void	info(void) const;
	inline	size_t headerSize(void) const
		{
			return sizeof(headerData);
		}

	inline	size_t tupleSize(void) const
		{
			return myTupleSize;
		}

	inline	headerData* header(void) const
		{
		// Return a correctly typed pointer to the header data.
		// This gives access to private data and should probably be
		// replaced with access methods for all header data individually.

			return (headerData*)data;
		}

	inline	char* firstTuple(void) const
		{
		// The keys and links in the bucket are numbered as follows:
		//    +-+-+-+-+-+-+-+
		//    |L|K|L|K|L|K|L|  L = Link,  K = Key
		//    +-+-+-+-+-+-+-+
		//     0 1 1 2 2 3 3
		//

		// Return the address of the
		// start of the Tuple space (i.e.
		// the address of Link 0).

			return (char*)data + headerSize();
		}

	inline	pKeyType getKeyAddr(const size_t pos) const
		{
		// Return a pointer to the pos'th
		// Key in the Tuple space.
		// Note we explicitly use long values for the database
		// storage.
			pKeyType key = (pKeyType)(firstTuple() + (pos-1) * tupleSize() +sizeof(int32));
			return key;
		}

	inline	char* getLinkAddr(const size_t pos) const
		{
		// Return a pointer to the pos'th link
		// in the Tuple space.
		// char * so no unaligned long accesses with keys not a multiple
		// of 4 long. This problem now removed with keys rounded up to
		// multiples of 4 long

			char* tempLink = (firstTuple()+pos*tupleSize());
			return tempLink;
		}

	bucketId	getLink(const size_t pos) const;
	void		setLink(const size_t pos, const bucketId link);
	bool 	searchForKey(const object& theObject, size_t& ptr) const;
	void	findIndex(size_t& ind, bool& found) const;
	void	insert(const object& theObject, const long link);
	dbError	del(const size_t pos);
	inline  bool	full(void) const
		{
			return (bool)(numKeys == header()->activeKeys);
		}

	inline  bool	empty(void) const
		{
		// Leaf buckets are considered empty when 0 keys are present.
		// Inner buckets still contain a link at this point so we test for -1.
		// A slight adaptation to the delete mechanism, with appropriate care
		// for balancing might not require this strange treatment.

			return (bool)(header()->activeKeys == ((header()->leaf==LEAF)?0:-1));
		}

	inline  pKeyType allocTmpKey(void)
		{
		// The bucket is in charge of allocating temporary key areas but
		// the deleting is left to the caller.

			return (pKeyType)new char[keyLength];
		}

	void	sploosh(bucket* newBucket, pKeyType in, pKeyType out, const object& theObject, const long link);

	// A couple of access to functions to keep our data safe...

	inline	void setActiveKeys(const long keys)
		{
			header()->activeKeys = keys;
		}

	inline	bucketId getParent(void) const
		{
			return header()->parentId;
		}

	inline	void setParent(bucketId parent)
		{
			header()->parentId = parent;
		}

	void	dump(void) const;
	inline	void*	getData(void) const
		{
			return (void*)data;
		}
	 const char* verStr(void) const;

friend class bTree;

}; //---- class def for Buckets...

#endif

////////////////////////////////////////////////////////////////////////////
// Revision History:
//
// $Log: bucket.h,v $
// Revision 1.7  1994/05/15  05:01:32  kevinl
// Type fixups.
//
// Revision 1.6  1994/02/25  03:15:56  darrenp
// Changes for DOS binary compatibility.
//
// Revision 1.4  1994/02/03  05:50:31  kevinl
// Moved include files to diamond/ and fixed HAVE_MALLOC_H
//
// Revision 1.3  1993/12/23  22:58:48  kevinl
// dbErr uses dbString, autoconf stuff, moved logs, added const and size_t
//
// Revision 1.2  1993/11/18  02:54:20  kevinl
// Fixed variable shadowing
//
// Revision 1.1  1993/11/09  04:20:02  kevinl
// Initial revision
//
////////////////////////////////////////////////////////////////////////////
