/**************************************************************************
 * Source Id :
 *
 * $Id: btdump.cc,v 1.6 1994/07/04 12:15:18 kevinl Exp $
 *-------------------------------------------------------------------------
 * Project Notes :
 *
 *  Diamond Base
 *  ============
 *      A solid database implementation, spurred on by the continuing
 *  Metal (Lead) Base saga.
 *
 *  Project Team :
 *        A. Davison
 *        K. Lentin
 *        D. Platt
 *
 *	Project Commenced : 05-02-1993
 *
 *-------------------------------------------------------------------------
 *  Module Notes :
 *
 *  Dump a btree
 *
 *
 *  Original Author : Krazy Kev
 *
 **************************************************************************/

#include <iostream.h>
#include <diamond/btree.h>

#if HAVE_MALLOC_H && !MALLOC_H_INCLUDED
#define MALLOC_H_INCLUDED 1
extern "C" {
#include <malloc.h>
}
#endif

#include <stdlib.h>

int
main(int argc, char **argv)
{
	if (argc != 2)
	{
		cerr << "Syntax: " << argv[0] << " filename" << endl;
		exit (1);
	}

	bTree bt(argv[1], 0);
	bt.dump();
	return 0;
}

///////////////////////////////////////////////////////////////////////////
// Revision History:
//
// $Log: btdump.cc,v $
// Revision 1.6  1994/07/04  12:15:18  kevinl
// Added a missing return
//
// Revision 1.5  1994/02/03  05:54:19  kevinl
// Moved include files to diamond/ and fixed HAVE_MALLOC_H
//
// Revision 1.4  1993/05/26  01:01:39  kevinl
// MALLOC_H_MISSING
//
// Revision 1.3  1993/05/06  04:00:19  kevinl
// SASC define for malloc.h
//
// Revision 1.2  1993/04/08  15:14:02  davison
// included stdlib.h
//
// Revision 1.1  1993/04/05  00:00:53  kevinl
// Initial revision
//
///////////////////////////////////////////////////////////////////////////
