/**************************************************************************
 * Source Id :
 *
 * $Id: utils.cc,v 1.6 1994/09/07 07:57:41 kevinl Exp $
 *-------------------------------------------------------------------------
 * Project Notes :
 *
 *  Diamond Base
 *  ============
 *      A solid database implementation, spurred on by the continuing
 *  Metal (Lead) Base saga.
 *
 *  Project Team :
 *        A. Davison
 *        K. Lentin
 *        D. Platt
 *
 *	Project Commenced : 05-02-1993
 *
 *-------------------------------------------------------------------------
 *  Module Notes :
 *
 *
 *
 *
 *  Original Author :
 *
 **************************************************************************/

#include <diamond/dbconf.h>
#include <string.h>
#include <utils.h>

char* strNcpy(char* d, char* s, int n)
{
	char* tmp = strncpy(d, s, n);
	d[n-1] = 0;
	return tmp;
}

dbStrArray::~dbStrArray()
{
	reset();
}

void
dbStrArray::increase(void)
{
	if (size)
		data = (dbString**)realloc(data, (size+1)*sizeof(dbString*));
	else
		data = (dbString**)malloc(sizeof(dbString*));
	data[size] = new dbString;
	size += 1;
}

dbString&
dbStrArray::operator++(int) // postfix
{
	increase();
	return (*this)[(size>1)?(size-2):(size-1)];
}

dbString&
dbStrArray::operator++(void) // prefix
{
	increase();
	return (*this)[size-1];
}

void
dbStrArray::reset(void)
{
	for (size_t i=0; i<size; i++)
	{
		delete data[i];
	}
	if (data)
		free(data);
	data = 0;
	size = 0;
}

///////////////////////////////////////////////////////////////////////////
// Revision History:
//
// $Log: utils.cc,v $
// Revision 1.6  1994/09/07  07:57:41  kevinl
// Fixed up prefix/postfix ++ operator
//
// Revision 1.5  1994/05/15  04:58:56  kevinl
// Added dbStrArray
//
// Revision 1.4  1994/02/03  06:01:42  kevinl
// Moved include files to diamond/ and fixed HAVE_MALLOC_H
//
// Revision 1.3  1993/12/23  22:58:48  kevinl
// dbErr uses dbString, autoconf stuff, moved logs, added const and size_t
//
// Revision 1.2  1993/11/03  12:31:59  davison
// Removed the "extern "c""
//
// Revision 1.1  1993/11/03  10:05:33  kevinl
// Initial revision
//
///////////////////////////////////////////////////////////////////////////
