/**************************************************************************
 * Source Id :
 *
 * $Id: rserv.h,v 1.22 1994/05/15 05:11:22 kevinl Exp $
 *-------------------------------------------------------------------------
 * Project Notes :
 *
 *  Diamond Base
 *  ============
 *      A solid database implementation, spurred on by the continuing
 *  Metal (Lead) Base saga.
 *
 *  Project Team :
 *        A. Davison
 *        K. Lentin
 *        D. Platt
 *
 *	Project Commenced : 05-02-1993
 *
 *-------------------------------------------------------------------------
 *  Module Notes :
 *
 *  recServer module
 *
 *  Original Author : Darren Platt
 *
 **************************************************************************/

#ifndef __DB_RSERV_H__
#define __DB_RSERV_H__

#include <diamond/d_types.h>
#include <diamond/defs.h>
#include <diamond/bucket.h>
#include <diamond/cache.h>

// Default number of entries in the cache

const DEF_RS_CACHE_SIZE = 10;
struct rsHeader;

// the bitPool is a bitmap of used/unused records

struct bitPool {
	int16	bitsUsed;
	unsigned	char	map[512];
	inline void	zero(void) {
				// warning - method unfriendly.
				// memset(&dummy,0,sizeof dummy);
				// Yet again... tut tut tut
				memset(map, 0, sizeof map);
				bitsUsed = 0;
			}
		inline bitPool(void) { zero();}
};

struct rsHeader {
	int32	recLength; // size_t b/c otherwise new will choke.
	int32		totalRecs;
	int32		recsUsed;
};

class recServer : public cache {
	public:
//		dbError status;
//		inline dbError rserror(dbError err) { return (status = err); };

		recServer(const char *name, const int32 offset=0, const size_t cSize = DEF_RS_CACHE_SIZE);
		recServer(void);
		~recServer();
		dbError	createDb(
						const char *name,
						const int32 recLen,
						const int32 offset=0,
						const size_t cSize = DEF_RS_CACHE_SIZE);

		dbError getRec(const int32 idx,void *buffer);
		dbError putRec(const int32 idx,void *buffer);
		dbError newRec(int32 &newIdx);
		dbError delRec(const int32 idx);
		bool 	writeData(const int32 offset, void *theData, const int32 length);
		bool	readData(const int32 offset, void *theData, const int32 length);
		bool	isOpen;
		int		fileNo(void) const { return fd; }
		dbError	lock(const bool lockit, const bool block = false);
		void	flushCache(void) { cache::flushCache(); flushed = true; }
		int32	recordCount(void) { return header.recsUsed; }
	private:
		bool	flushed;
		int		fd;
		bool	locked;
		void	commonInit(void);
		bool	getBitPool(const int32 idx, bitPool &bp);
		bool	putBitPool(const int32 idx, bitPool &bp);
		bool	refresh(void);
		int16	bitPoolBits; // how many bits stored in
		int32	currentPool;
		int16	bitPoolBytes;
		int16	bitPoolRecs; // 2^bitPoolRecs
		int32	idx2offset(const int32 idx) const;
		int32	bpIdx2Offset(const int32 idx) const;
		bool	readHeader(rsHeader &);
		bool	writeHeader(rsHeader &);
		int32	headerOffset;
		int32	dataOffset;
		int32	blockLength; // Length of one pool/block of records.
		bitPool	indelPool;
	protected:
		rsHeader header;
};
#endif

////////////////////////////////////////////////////////////////////////////
// Revision History:
//
// $Log: rserv.h,v $
// Revision 1.22  1994/05/15  05:11:22  kevinl
// Added flushCache and refresh
//
// Revision 1.21  1994/04/23  02:40:29  kevinl
// recordCount added for diarel record counting
//
// Revision 1.20  1994/03/17  04:34:45  kevinl
// Added fileNo, lock, locked?
//
// Revision 1.19  1994/02/25  03:11:27  darrenp
// Changes to make DOS binary compatible witht eh world
//
// Revision 1.18  1994/02/03  05:54:19  kevinl
// Moved include files to diamond/ and fixed HAVE_MALLOC_H
//
// Revision 1.17  1993/12/23  22:58:48  kevinl
// dbErr uses dbString, autoconf stuff, moved logs, added const and size_t
//
// Revision 1.16  1993/11/09  04:14:49  kevinl
// Moved logs
// included bucket.h
//
// Revision 1.15  1993/06/23  05:21:22  kevinl
// Mallocs are now in angular brackets
//
// Revision 1.14  1993/05/03  23:34:29  kevinl
// writeData and readData use theData instead of data
//
// Revision 1.13  1993/05/01  14:43:11  kevinl
// Removed ;'s from inlines
//
// Revision 1.12  1993/04/28  11:29:22  kevinl
// Fixing up some inlines
//
// Revision 1.11  1993/04/27  06:59:47  kevinl
// Comments
//
// Revision 1.10  1993/04/04  23:59:57  kevinl
// Added cache support
//
// Revision 1.9  1993/03/28  11:51:24  kevinl
// Modified for dbErr
//
// Revision 1.8  1993/03/28  19:09:22  davison
// deleted pError member.
//
// Revision 1.7  1993/03/26  06:16:38  darrenp
// standardized error codes.
//
// Revision 1.6  1993/03/24  06:21:47  kevinl
// Added error handling code
//
// Revision 1.5  1993/03/11  06:22:33  kevinl
// Added $ onto $Id and $Log in header
//
////////////////////////////////////////////////////////////////////////////
