/**************************************************************************
 * Source Id :
 *
 * $Id: idxinfo.h,v 1.13 1994/02/25 03:11:27 darrenp Exp $
 *-------------------------------------------------------------------------
 * Project Notes :
 *
 *  Diamond Base
 *  ============
 *      A solid database implementation, spurred on by the continuing
 *  Metal (Lead) Base saga.
 *
 *  Project Team :
 *        A. Davison
 *        K. Lentin
 *        D. Platt
 *
 *	Project Commenced : 05-02-1993
 *
 *-------------------------------------------------------------------------
 *  Module Notes :
 *
 *  Index/Field Information Headers.
 *
 *
 *  Original Author : Andy
 *
 **************************************************************************/

#ifndef __DB_IDXINFO_H__
#define __DB_IDXINFO_H__

#include <string.h>
#include <iostream.h>
#include <fstream.h>
#include <diamond/d_types.h>

const int32 IDX_SINGLE        = 0x01;
const int32 IDX_MULTIPLE      = 0x02;
const int32 IDX_FIRST         = 0x04;
const int32 IDX_SECOND        = 0x08;
const int32 IDX_DUPLICATES    = 0x10;
const int32 IDX_NODUPLICATES  = 0x20;

const int32 IDX_INFO_MAGIC    = 0xFEED;
const int32 IDX_LIST_MAGIC    = 0x1DEA;
const int32 FLD_LIST_MAGIC    = 0xBEAD;
const int32 FLD_INFO_MAGIC    = 0xBABE;

const int32 MAX_FIELDS_IN_INDEX = 10;
const int32 MAX_NAME_LENGTH = 300;

//---- Misc rountines...

void checkStream(ifstream&);
void checkStream(ofstream&);

// Special signed version of size_t
typedef int ssize_t;

typedef int32 TIndicies[MAX_FIELDS_IN_INDEX];
struct indexInfo
{
	int32			idxType;
	int32			idxFields[MAX_FIELDS_IN_INDEX];
	indexInfo*		nextIdx;

	// Moved the definition of the constructor into the .cc file
	// to stop complaints about it not getting expanded inline.

	indexInfo(const int32 type, const TIndicies indicies );
/*	{
		idxType = type;
		for(int i=0;i<MAX_FIELDS_IN_INDEX;i++)
		{
			idxFields[i] = indicies[i];
		}
		nextIdx = 0;
	}
*/
	~indexInfo();
friend ostream& operator << (ostream&, const indexInfo&);
friend ofstream& operator << (ofstream&, const indexInfo&);
};

// Holds the list of indicies
struct indexList
{
	int32			numIndicies;
	indexInfo*	indicies;

	indexList() {numIndicies = 0; indicies = 0;}
	~indexList()
	{
		delete indicies;
	}
//	long number(const char* name);

friend ostream& operator << (ostream&, const indexList&);
friend ofstream& operator << (ofstream&, const indexList&);
friend ifstream& operator >> (ifstream&, indexList&);

};


// Holds the info on a field
struct fieldInfo
{
	int32			fldType;
	int32			fldSize;
	char*				fldName;
	fieldInfo*		nextFld;

	fieldInfo(const char* name, const int32 ty, const int32 sz);
	~fieldInfo();
friend ostream& operator << (ostream&, const fieldInfo&);
friend ofstream& operator << (ofstream&, const fieldInfo&);

};

// Holds the list of fields

struct fieldList
{
	int32		numFields;
	fieldInfo*	fields;
	fieldList() {fields = 0; numFields = 0;}

	~fieldList()
	{
		delete fields;
	}
friend ostream& operator << (ostream&, const fieldList&);
friend ofstream& operator << (ofstream&, const fieldList&);
friend ifstream& operator >> (ifstream&, fieldList&);

};

#endif

///////////////////////////////////////////////////////////////////////////
// Revision History:
//
// $Log: idxinfo.h,v $
// Revision 1.13  1994/02/25  03:11:27  darrenp
// Changes to make DOS binary compatible witht eh world
//
// Revision 1.12  1994/02/03  05:54:19  kevinl
// Moved include files to diamond/ and fixed HAVE_MALLOC_H
//
// Revision 1.11  1993/12/23  22:58:48  kevinl
// dbErr uses dbString, autoconf stuff, moved logs, added const and size_t
//
// Revision 1.10  1993/10/18  11:35:01  kevinl
// Added number()
//
// Revision 1.9  1993/05/03  01:35:37  kevinl
// Got rid of externs on the consts
//
// Revision 1.8  1993/04/28  11:31:09  kevinl
// Fixed up inlines
//
// Revision 1.7  1993/04/27  07:00:19  kevinl
// Comments
//
// Revision 1.6  1993/04/15  06:06:38  davison
// Fixed up inline not expanded errors etc
//
// Revision 1.5  1993/04/15  04:21:52  kevinl
// Moved malloc.h
//
// Revision 1.4  1993/03/21  01:15:33  davison
// Ooops. Fixed that last one proper like now ...
//
// Revision 1.3  1993/03/21  01:02:11  davison
// Made a couple of const's #defines.
//
// Revision 1.2  1993/03/15  19:24:05  davison
// Implemented a few nice things, like more than 2 index fields, line number
// reporting on syntax errors, and usage reporting.
//
// Just for you, Daz :-)
//
// Revision 1.1  1993/03/15  19:22:53  davison
// Initial revision
//
///////////////////////////////////////////////////////////////////////////
