/**************************************************************************
 * Source Id :
 *
 * $Id: generate.h,v 1.14 1994/05/15 05:07:23 kevinl Exp $
 *-------------------------------------------------------------------------
 * Project Notes :
 *
 *  Diamond Base
 *  ============
 *      A solid database implementation, spurred on by the continuing
 *  Metal (Lead) Base saga.
 *
 *  Project Team :
 *        A. Davison
 *        K. Lentin
 *        D. Platt
 *
 *	Project Commenced : 05-02-1993
 *
 *-------------------------------------------------------------------------
 *  Module Notes :
 *
 *  Header file for code generator
 *
 *
 *  Original Author : Krazy Kev
 *
 **************************************************************************/

#ifndef __DB_GENERATE_H__
#define __DB_GENERATE_H__

#include <diamond/defs.h>

bool generateStart(ofstream& hf, ofstream& cf, const dbString& filename);
bool generateClass(ofstream& hf, ofstream& cf, const long recLen, const indexList* idxList, const fieldList* fldList, const dbString& structName, const dbString& className, const int stringCount, const indexList* consList, dbString * const defaults);
bool generateEnd(ofstream& hf, ofstream& cf);
bool generateDerived(const dbString& base, const dbString& derive, const dbString& deriveName, const fieldList* fldList, const indexList* consList, const unsigned char* basePath, const unsigned char* baseHeader);
long const mySizeOf(const int32 tp);
dbString const typeName(const long tp, const bool realData=false);

#endif

///////////////////////////////////////////////////////////////////////
// Revision History:
//
// $Log: generate.h,v $
// Revision 1.14  1994/05/15  05:07:23  kevinl
// Type fixups. Conversaion of char* to dbString
//
// Revision 1.13  1994/02/03  05:54:19  kevinl
// Moved include files to diamond/ and fixed HAVE_MALLOC_H
//
// Revision 1.12  1993/12/23  22:58:48  kevinl
// dbErr uses dbString, autoconf stuff, moved logs, added const and size_t
//
// Revision 1.11  1993/11/18  02:58:33  kevinl
// Moved logs
// Fixed variable shadows
// Renamed some badle named variables in the generated code to remove clashes
//
// Revision 1.10  1993/11/15  04:19:48  davison
// Changed generateStart proto
//
// Revision 1.9  1993/10/25  08:37:21  kevinl
// Added realData to typeName
//
// Revision 1.8  1993/10/24  15:35:45  kevinl
// Added derived class generation
//
// Revision 1.7  1993/10/19  11:43:02  kevinl
// Default values
//
// Revision 1.6  1993/10/18  08:01:41  kevinl
// Added constructors and fixed some probs
//
// Revision 1.5  1993/07/11  09:42:05  kevinl
// Changed String to dbString
//
// Revision 1.4  1993/06/23  05:21:22  kevinl
// Mallocs are now in angular brackets
//
// Revision 1.3  1993/06/20  13:39:04  kevinl
// New members for String support
//
// Revision 1.2  1993/05/07  13:54:35  kevinl
// Added outputFieldList so fields were in correct order for alignment
//
// Revision 1.1  1993/03/21  23:38:35  kevinl
// Initial revision
//
///////////////////////////////////////////////////////////////////////
