/**************************************************************************
 * Source Id :
 *
 * $Id: diarel.h,v 1.26 1994/04/23 02:40:29 kevinl Exp $
 *-------------------------------------------------------------------------
 * Project Notes :
 *
 *  Diamond Base
 *  ============
 *      A solid database implementation, spurred on by the continuing
 *  Metal (Lead) Base saga.
 *
 *  Project Team :
 *        A. Davison
 *        K. Lentin
 *        D. Platt
 *
 *	Project Commenced : 05-02-1993
 *
 *-------------------------------------------------------------------------
 *  Module Notes :
 *
 * The diaRel is inherited into application classes to provide database
 * functionality.
 *
 *  Original Author : Daz
 *
 **************************************************************************/

#ifndef __DB_DIAREL_H__
#define __DB_DIAREL_H__

#include <diamond/object.h>

#ifdef MULTI
#  include <diamond/dclient.h>
class dbObjData;
#else
#  include <diamond/dbase.h>
extern diamondBase theDiamondBase;
#endif

#include <diamond/d_types.h>
#include <diamond/dberr.h>

const char* const diaVerStr(void);

class diaRel : public object { // protected really
	private:
		long	refId;		// Used for correspondance with server.
	public:
		dbObjData* objData;
		long	getRefId(void) const { return refId; }
		const char*	verStr(void) const;
		dbError status;
		virtual	~diaRel		(void);
		void	perror		(const char *);
		dbError	diaErr		(const dbError);
				diaRel		(const char *name);
		const dbObjData* getObjData(void) const { return objData; }

		// operator= must not copy the refId.
		diaRel& operator=(const diaRel& X);

		// Was the last operation successful
		inline	bool	ok	() const { return (bool)(status==db_ok); }

		dbError flush		(void);
		dbError lock		(const bool block = false);
		dbError unlock		(void);
		dbError add			(void);
		dbError del			(void);
		dbError put			(void);
		dbError begin		(const int idx=0);
		dbError end			(void);
		dbError get			(const int idx=0);
		dbError find		(void);
		dbError seek		(void);
		dbError extract		(void);
		dbError seekFirst	(void);
		dbError first		(void);
		dbError seekLast	(void);
		dbError last		(void);
		dbError next		(void);
		dbError peekNext	(void);
		dbError peekPrev	(void);
		dbError prev		(void);
		dbError write		(void);
		int32	recordCount	(void);
		void	stats		(void);
};
#endif

/////////////////////////////////////////////////////////////////////
// Revision History:
//
// $Log: diarel.h,v $
// Revision 1.26  1994/04/23  02:40:29  kevinl
// recordCount added for diarel record counting
//
// Revision 1.25  1994/03/17  04:34:45  kevinl
// Added flush,lock,unlock
//
// Revision 1.24  1994/02/09  22:05:49  darrenp
// Put an extra const in the diaVerStr prototype.
//
// Revision 1.23  1994/02/03  05:54:19  kevinl
// Moved include files to diamond/ and fixed HAVE_MALLOC_H
//
// Revision 1.22  1994/01/24  04:48:56  kevinl
// extern diamondBase
//
// Revision 1.21  1993/12/23  22:58:48  kevinl
// dbErr uses dbString, autoconf stuff, moved logs, added const and size_t
//
// Revision 1.20  1993/10/24  15:05:33  darrenp
// Changed the MULTI dependent compilation parts.
//
// Revision 1.19  1993/10/18  11:01:26  darrenp
// Inhibited some code when compiled with MULTI
//
// Revision 1.18  1993/10/05  07:33:35  kevinl
// Now handles dbObjData
//
// Revision 1.17  1993/08/29  13:08:35  kevinl
// Problems with relation assignment
//
// Revision 1.16  1993/07/05  05:35:41  darrenp
// Added MULTI specific includes
//
// Revision 1.15  1993/06/23  05:21:22  kevinl
// Mallocs are now in angular brackets
//
// Revision 1.14  1993/05/11  14:44:50  kevinl
// Added version number output
//
// Revision 1.13  1993/05/01  14:40:14  kevinl
// Stripped ;'s in inlines
//
// Revision 1.12  1993/04/27  07:19:18  kevinl
// Added write
//
// Revision 1.11  1993/04/26  01:20:56  kevinl
// Comments
//
// Revision 1.10  1993/04/11  05:49:02  kevinl
// Rationalised find/seek/peek methods etc
//
// Revision 1.9  1993/04/09  13:00:29  kevinl
// Stats can be called from diaRel now.
//
// Revision 1.8  1993/04/04  23:59:17  kevinl
// destructor to detach
//
// Revision 1.7  1993/04/01  04:24:26  kevinl
// Added/changed transactions
// Now we have get, extract and find
//
// Revision 1.6  1993/03/30  14:38:35  kevinl
// Modified index passing to database transactions
//
// Revision 1.5  1993/03/30  07:39:26  kevinl
// Made status public
//
// Revision 1.4  1993/03/29  23:27:37  kevinl
// Now holds it's own copy of last error
//
// Revision 1.3  1993/03/26  05:49:24  darrenp
// changed error codes.
//
// Revision 1.2  1993/03/24  06:16:38  kevinl
// Changed constructor to remove pTransferArea
//
/////////////////////////////////////////////////////////////////////
