/**************************************************************************
 * Source Id :
 *
 * $Id: defs.h,v 1.44 1994/09/09 09:32:29 darrenp Exp $
 *-------------------------------------------------------------------------
 * Project Notes :
 *
 *  Diamond Base
 *  ============
 *      A solid database implementation, spurred on by the continuing
 *  Metal (Lead) Base saga.
 *
 *  Project Team :
 *        A. Davison
 *        K. Lentin
 *        D. Platt
 *
 *	Project Commenced : 05-02-1993
 *
 *-------------------------------------------------------------------------
 *  Module Notes :
 *
 *  Common types and definitions
 *
 *
 *  Original Author : Dunno. Andy started it. Kev finished it.
 *
 **************************************************************************/

#ifndef __DEFS_H__
#define __DEFS_H__

// Would like to include this, but then trouble ensues, so copy
// the defs we need out of it :(
// #include <diamond/d_types.h>

// dbconf.h is generated by autoconf or the user creates it.
// It defines the things used below to determine what we've got and what
// we've not.

#include <diamond/dbconf.h>



//
// Find a 32 bit quantity.
//
//----------------------------------------
#if SIZEOF_LONG == 4
	typedef long int32;
#elif SIZEOF_INT == 4
	typedef int int32;
#elif SIZEOF_SHORT == 4
	typedef short int32;
#else
#error Cannot find a 32 bit integer
#endif

//
// Do the same for the 16 bit quantity.
//
//----------------------------------------
#if SIZEOF_LONG == 2
	typedef long int16;
#elif SIZEOF_INT == 2
	typedef int int16;
#elif SIZEOF_SHORT == 2
	typedef short int16;
#else
#error Cannot find a 16 bit integer
#endif

//
// Some useful types...
//
typedef unsigned short ushort;
typedef unsigned long ulong;
typedef unsigned char uchar;

typedef int32 bucketId;

// --------------------------------

#if HAVE_BSTRING_H
#include <bstring.h>
#define HAVE_BCOPY 1
#endif /* HAVE_BSTRING_H */

#if !HAVE_BCOPY_PROTO && HAVE_BCOPY

//
// This may well be the wrong thing to do, but if you 
// have no prototype but you have a function, the chances are
// you're dealing with a screwed up system compiler, which means
// the function (if it is one) is likely to be in 'C'
//
extern "C" {
void bcopy(const char *,char *,int);
}

#endif

//
// Major #if block
// --------------------------------

#if STDC_HEADERS || HAVE_STRING_H
#include <string.h>

/* An ANSI string.h and pre-ANSI memory.h might conflict.  */
#if !STDC_HEADERS && HAVE_MEMORY_H
#include <memory.h>
#endif /* not STDC_HEADERS and HAVE_MEMORY_H */


// ----------------------
#ifndef HAVE_INDEX
#define index strchr
#endif

// ----------------------
#ifndef HAVE_RINDEX
#define rindex strrchr
#endif

// ----------------------
#ifndef HAVE_BCOPY
#define bcopy(s, d, n) memmove ((d), (s), (n))
#define bcmp(s1, s2, n) memcmp ((s1), (s2), (n))
#define bzero(s, n) memset ((s), 0, (n))
#endif

////////////////
#else /* not STDC_HEADERS and not HAVE_STRING_H */
////////////////

#include <strings.h>
// memory.h and strings.h conflict on some systems. 

//
// not STDC_HEADERS and not HAVE_STRING_H 
// --------------------------------------

#endif 

//
// Handle the slow onset bool intrinsic phenomenon.
//
#if !defined(BOOL_DEFINED) && !(defined _bool_h)
#define BOOL_DEFINED
enum bool {false=0,true=1};
#endif

enum e_leaf {INNER, LEAF};

//
// Borland and Unix don't share a memory move/copy routine that understands
// overlaps. Also the two have different argument orderings. Some would call
// it cold blooded malicious sabotage.
//

#ifdef __BORLANDC__
#include <mem.h>
#define strcasecmp(a,b) stricmp(a,b)
#define strncasecmp(a,b,c) strnicmp(a,b,c)
#else
extern "C" {
#if !defined(HAVE_STRCASECMP_PROTO)
int strncasecmp(const char*, const char*, const size_t);
int strcasecmp(const char*, const char*);
#endif
}
#endif

// maximum number of btree queries
#define MAX_QUERY 10

// All keys stored in buckets are of this type. Objects should cast these
// as appropriate.

typedef char* pKeyType;

#include <sys/types.h>

#endif

//////////////////////////////////////////////////////////////////////////
// Revision History:
//
// $Log: defs.h,v $
// Revision 1.44  1994/09/09  09:32:29  darrenp
// Added bcopy prototypes and fiddled with some headers.
//
// Revision 1.43  1994/09/09  00:01:56  darrenp
// Moved the point of inclusion of dbconf.h
//
// Revision 1.42  1994/09/08  23:54:37  darrenp
// can't -> cannot in #error, to avoid unterminated char constant.
//
// Revision 1.41  1994/09/08  08:14:39  kevinl
// Some type sizes etc
//
// Revision 1.40  1994/08/03  09:47:54  darrenp
// Don't #undef FALSE and TRUE anymore
//
// Revision 1.39  1994/08/01  00:14:28  darrenp
// removed TRUE and FALSE
//
// Revision 1.38  1994/07/04  12:19:13  kevinl
// removed compiler depandancies for STRCASECMP.
// Now uses autoconf variable
//
// Revision 1.37  1994/05/15  05:04:54  kevinl
// Fixed up for autoconf stuff
//
// Revision 1.36  1994/02/25  03:11:27  darrenp
// Changes to make DOS binary compatible witht eh world
//
// Revision 1.35  1994/02/03  05:54:19  kevinl
// Moved include files to diamond/ and fixed HAVE_MALLOC_H
//
// Revision 1.34  1994/01/28  00:39:58  kevinl
// Fixed up for use with malloc library
//     Now includes sys/types.h and only defines bzero/bcopy etc if they are
//     not set already.
//
// Revision 1.33  1993/12/23  22:58:48  kevinl
// dbErr uses dbString, autoconf stuff, moved logs, added const and size_t
//
// Revision 1.32  1993/12/03  01:24:27  kevinl
// More bool gaurding
//
// Revision 1.31  1993/11/09  04:10:50  kevinl
// Moved logs
// Got rid of bucket declaration and some associated stuff.
//
// Revision 1.30  1993/11/08  10:25:30  kevinl
// Need strcasecmp AND strncasecmp
//
// Revision 1.29  1993/11/05  12:45:05  kevinl
// Fixed problems that CC picked up (and some multi bugs)
//
// Revision 1.28  1993/11/04  22:24:32  darrenp
// Avoided prototype for strcasesmp for linux as it already has one.
//
// Revision 1.27  1993/11/03  10:04:46  kevinl
// Added ichar and utils.{h,cc}
//
// Revision 1.26  1993/10/24  15:35:08  kevinl
// Fix for strcasecmp vs stricmp
//
// Revision 1.25  1993/10/18  11:19:12  kevinl
// Added strNcpy
//
// Revision 1.24  1993/10/05  07:31:29  kevinl
// Had problems with some sytems #define'ing TRUE and FALSE
//
// Revision 1.23  1993/06/23  05:21:22  kevinl
// Mallocs are now in angular brackets
//
// Revision 1.22  1993/05/11  14:44:50  kevinl
// Added version number output
//
// Revision 1.21  1993/05/03  23:33:53  kevinl
// long aligned data
//
// Revision 1.20  1993/05/03  01:33:03  kevinl
// Cosmetic (mainly) changes for CC
//
// Revision 1.19  1993/05/01  14:39:19  kevinl
// Got rid of ints
//
// Revision 1.18  1993/04/30  07:45:45  kevinl
// Some optimizing
//
// Revision 1.17  1993/04/29  07:22:23  kevinl
// Removed some bucket::'s
//
// Revision 1.16  1993/04/28  11:30:15  kevinl
// Fixed up inlines
//
// Revision 1.15  1993/04/27  10:31:23  darrenp
// Added BOOL_DEFINED flag.
//
// Revision 1.14  1993/04/26  00:35:30  kevinl
// Comments
//
// Revision 1.13  1993/04/15  07:58:17  kevinl
// Added findIndex, del and empty
//
// Revision 1.12  1993/04/04  23:58:41  kevinl
// Added get & setParent
//
// Revision 1.11  1993/03/26  06:16:38  darrenp
// standardized error codes.
//
// Revision 1.10  1993/03/21  23:35:44  kevinl
// Added typedefs for unsigned types
// Changd pKeyType to a char*
//
// Revision 1.9  1993/03/17  14:28:34  kevinl
// newKeyNum argument in bucket constructors
// changed some int data members to long
//
// Revision 1.8  1993/03/15  14:19:33  kevinl
// Fixed up BORLANDC probs
// Changed some int's to long
// added empty bucket() constructor
// added setParent
//
// Revision 1.7  1993/02/17  12:15:16  kevinl
// Fixed pointer alignment problems by adding getLink and setLink
//
// Revision 1.6  1993/02/13  00:56:04  kevinl
// long's replaced with bucketId
// getShot nuked
//
// Revision 1.5  1993/02/11  03:53:38  kevinl
// a few fixes.
//
// Revision 1.4  1993/02/10  07:59:03  darrenp
// Global definitions of things like bool.
//
// Revision 1.3  1993/02/08  14:36:00  darrenp
// sploosh added, some output routines in class bucket
// enum for leaf and some Borlandc/Unix confrontation added
//
// Revision 1.2  1993/02/08  00:13:21  kevinl
// Kevin adds a constructor for the bucket class...
//
// Revision 1.1  1993/02/06  16:33:53  kevinl
// Initial revision
//
//////////////////////////////////////////////////////////////////////////
