/**************************************************************************
 * Source Id :
 *
 * $Id: dclient.h,v 1.8 1994/09/30 07:38:37 darrenp Exp $
 *-------------------------------------------------------------------------
 * Project Notes :
 *
 *  Diamond Base
 *  ============
 *      A solid database implementation, spurred on by the continuing
 *  Metal (Lead) Base saga.
 *
 *  Project Team :
 *        A. Davison
 *        K. Lentin
 *        D. Platt
 *
 *	Project Commenced : 05-02-1993
 *
 *-------------------------------------------------------------------------
 *  Module Notes :
 *     Defines a multi diamondBase object in the client for the
 *     multi-db
 *  Original Author : daz.
 *
 **************************************************************************/

#ifndef __DB_DCLIENT_H__
#define __DB_DCLIENT_H__

#include <diamond/defs.h>
#include <diamond/dcdefs.h>
#include <diamond/dberr.h>
#include <diamond/bucket.h>
#include <diamond/nserver.h>

// Message ids for communication between clients and server

// Dummy class defintion - the
// single user version allows data to be registered with the
// dbObjs - but we aren't premitting this in the multi user
// version. But, it's a defined part of the diamondBase interface
// unfortunately, so we must provide it.

class dbObjData {
	public:
};

//
// We don't really want to have a name server, but we need it to
// keep the structs laid out the same way.
//

class diamondBase  : public TNameServer
{
	public:
		enum transId {ti_add,ti_del,ti_begin,ti_end,ti_get,ti_put,ti_extract,
			ti_seekFirst,ti_first,ti_next,ti_prev,ti_seekLast,ti_last,
			ti_peekNext,ti_peekPrev,ti_seek,ti_find,ti_stats,ti_write};

		char* verStr(void);
		char* version(bool full = false);
		diamondBase(char* name = 0);
		dbError detach(long refId);
//		dbError attach(const char* name, object* resBuffer, long& refId,
//			dbObjData *&);

			dbError attach(dbString& name, object* resBuffer, long& refId, 
				dbObjData* & objData);


		dbError trans(long refId,transId id,long idx=0);
		int32 intTrans(const long refId, const transId id, const long idx=0);
		~diamondBase();
	private:
		long	msqId; // Id for connection to server
		long	shmId; // Id for memory transfer to server
		long	sendChannel;
		long	recChannel;
		void	sendLong(long);
		bool	sendMess(void *,long len,long chan=-1);
		bool	recMess(void *,long len);
		char	*transArea; // Data transfer area to server.
};
#endif

///////////////////////////////////////////////////////////////////////////
// Revision History:
//
// $Log: dclient.h,v $
// Revision 1.8  1994/09/30  07:38:37  darrenp
// Changed to include TNameserver into diamondBase class.
//
// Revision 1.7  1994/09/09  08:50:46  darrenp
// Updates to new version of engine for 0.3 release.
//
// Revision 1.6  1994/02/03  05:54:19  kevinl
// Moved include files to diamond/ and fixed HAVE_MALLOC_H
//
// Revision 1.5  1993/10/13  10:26:28  daz
// *** empty log message ***
//
// Revision 1.4  1993/07/21  14:25:42  daz
// *** empty log message ***
//
// Revision 1.3  1993/07/04  16:08:03  daz
// *** empty log message ***
//
// Revision 1.2  1993/07/04  13:42:19  daz
// *** empty log message ***
//
// Revision 1.1  1993/07/04  02:21:13  daz
// Initial revision
//
///////////////////////////////////////////////////////////////////////////
