/**************************************************************************
 * Source Id :
 *
 * $Id: db2txt.cc,v 1.9 1994/07/04 12:16:06 kevinl Exp $
 *-------------------------------------------------------------------------
 * Project Notes :
 *
 *  Diamond Base
 *  ============
 *      A solid database implementation, spurred on by the continuing
 *  Metal (Lead) Base saga.
 *
 *  Project Team :
 *        A. Davison
 *        K. Lentin
 *        D. Platt
 *
 *	Project Commenced : 05-02-1993
 *
 *-------------------------------------------------------------------------
 *  Module Notes :
 *
 *	Convert a dbObject to text format, outputing in index 0 order.
 *
 *  Original Author : Kev
 *
 **************************************************************************/

#include <iostream.h>
#include <stdlib.h>
#include <diamond/diagrel.h>
#include <diamond/generate.h>


#define OUT(data,off,typ) *((typ*)(((char*)data)+off))

void
outputField(ostream& o, void* data, long off, unsigned char type, long count, long strNum, dbData* dbDat)
{
	if (count != 1)
		o << "[" << count << "]";
	o << " ";
	if (type == D_CHAR)
		o << ((char*)data)+off;
	else
		for (int i=0; i<count; i++) {
			switch (type) {
				case D_SHORT:
					o << OUT(data,off,short);
					break;
				case D_USHORT:
					o << OUT(data, off, unsigned short);
					break;
				case D_DATA:
				{
					//dbData s;
					//ms->getString(s, OUT(data, off, long));
					o << *dbDat << " @ " << OUT(data, off, long);
					break;
				}
				case D_STRING:
				{
					//dbString s;
					//ms->getString(s, OUT(data, off, long));
					o << *dbDat << " @ " << OUT(data, off, long);
					break;
				}
				case D_LONG:
					o << OUT(data, off, long);
					break;
				case D_ULONG:
					o << OUT(data, off, unsigned long);
					break;
				case D_DOUBLE:
					o << OUT(data, off, double);
					break;
				case D_FLOAT:
					o << OUT(data, off, float);
					break;
				case D_MONEY:
					o << OUT(data, off, moneyType);
					break;
				case D_DATE:
					o << OUT(data, off, dateType);
					break;
				case D_UNIQUE:
					o << OUT(data, off, uniqueType);
					break;
				default:
					dbErr("Unknown type");
			}
			off++;
			o << " ";
		}
}

extern diamondBase theDiamondBase;

int main(int argc, char** argv)
{

	if ((argc != 2)&&(argc != 3)) {	
		cerr << "Syntax: " << argv[0] << " [config file] relation" << endl;
		exit (1);
	}

	int opt=1;
	// Tell the Diamond base object to search the current path for 
	// relation files.
	if (argc == 3)
	{
		if (theDiamondBase.loadConfig(argv[1]))
		{
			cerr <<"Error reading config file." << endl;
			exit(2);
		}
		opt = 2;
	} else
		if(theDiamondBase.loadConfig(""))
		{
			cerr <<"Error reading config file." << endl;
			exit(2);
		}

	cout << "Trying to read Relation " << argv[opt] << endl;
	diaGRel rel(argv[opt]);
	if (!rel.ok()) {
		rel.perror("Can't open relation");
		exit (2);
	}

//
//	memServer* ms = 0;
//	if (rel.numStrings())
//	{
//		dbString strName = argv[opt];
//		strName += ".str";
//		ms = new memServer(strName);
//	}

	cout << "REL " << argv[opt] << endl;
	rel.begin();
	while (rel.next() != db_eof) {
		cout << "REC " << rel.getRecNum() << endl;
		const dbObjData* d = rel.getObjData();
		for (int i = 0, stringCount = 0; i < d->numFields; i++) {
			cout << "FLD " << d->fieldName[i] << " " << typeName(d->fieldType[i],true);
			outputField(cout, rel.theData, d->fieldOffset[i], d->fieldType[i], d->fieldLength[i] / mySizeOf(d->fieldType[i]), stringCount, (d->fieldType[i]==D_STRING || d->fieldType[i]==D_DATA)?rel.getString(stringCount++):0);
			cout << endl;
		}
	}
	rel.end();
	return 0;
}

///////////////////////////////////////////////////////////////////////////
// Revision History:
//
// $Log: db2txt.cc,v $
// Revision 1.9  1994/07/04  12:16:06  kevinl
// Added a missing return
//
// Revision 1.8  1994/05/15  04:55:16  kevinl
// Type fixups
//
// Revision 1.7  1994/02/03  05:54:19  kevinl
// Moved include files to diamond/ and fixed HAVE_MALLOC_H
//
// Revision 1.6  1994/01/24  04:47:50  kevinl
// Removed explciit memServer 'cos dbobj does it.
//
// Revision 1.5  1994/01/24  02:58:27  davison
// Changed to use the new name server.
// Also now takes an otional first parameter, being the qualified
// name of a database config file.
//
// Revision 1.4  1993/12/23  22:58:48  kevinl
// dbErr uses dbString, autoconf stuff, moved logs, added const and size_t
//
// Revision 1.3  1993/10/28  07:49:01  kevinl
// Added diaGRel dbString/dbData support
//
// Revision 1.2  1993/10/18  08:03:10  kevinl
// Spelling mistook
//
// Revision 1.1  1993/10/10  23:25:28  kevinl
// Initial revision
//
///////////////////////////////////////////////////////////////////////////
