#include <ctype.h>                     // isdigit
#include <stdio.h>

FILE *old, *new;
int c, n;                              // current and next character
int col;                               // current column
int t;                                 // next tab stop
int ta;                                // tab adjustment

void main(int argc, char *argv[])
{
   if (argc != 3)
      return;
   old = fopen(argv[1], "r");
   new = fopen(argv[2], "w");

   do
   {
      col = 1;
      ta = 0;
      if ((c = getc(old)) == EOF)
         break;
      if (c == '\f')
      {
         putc(c, new);
         c = getc(old);
      }
      if (c != 'C' && c != 'c' && c != '!' && c != '\n') // genuine code line
      {
         for (; c != '\t'; col++)                        // label
         {
            putc(c, new);
            c = getc(old);
         }
         for (; col < 6; col++)
            putc(' ', new);
         ta = 2;

         c = getc(old);                             // continuation indicator
         if ((n = getc(old)) == '\t' || (n == ' ' && isdigit(c)))
         {
            putc(c, new);
            c = getc(old);
            if (n == '\t')
               ta += 8;
            else
               ta += 1;
         }
         else if (isdigit(c))
         {
            putc(c, new);
            c = n;
         }
         else
         {
            putc(' ', new);
            ungetc(n, old);
         }
         col++;
      }

      if (c != '\n')
         do                                    // code
         {
            n = getc(old);
            if (c == ' ' && n == '!' && col < 49)
            {
               c = '\t';
               ta = 0;
            }
            if (c == '\t' && n == '!' && col > 47)
               c = ' ';
            ungetc(n, old);
            if (c == '\t')
               for (t = (col + ta + 7) / 8 * 8 + 1, ta = 0; col < t; col++)
                  putc(' ', new);
            else
            {
               putc(c, new);
               col++;
            }
         }
         while ((c = getc(old)) != '\n' && c != EOF);
      if (c == '\n')
         putc(c, new);
   }
   while (c != EOF);

   fclose(old);
   fclose(new);
   return;
}
