/*  Copyright (C) Hummingbird Communications Ltd. 1990-1993	       */

#include <stdio.h>
#include <string.h>
#include "extend.h"

extern XID dosid;
extern Display *dpy;

char *myname;

int version = {0x101};

struct OptionDef opts[2] = {
    {"display", 1},
    {"pw", 1}};

char message[] = "test";

char **parm;

usage()
{
    fprintf(stderr, "usage: %s [-display host] [-pw password]\n", myname);
    exit(1);
}

processError(ecode)
int ecode;
{
    switch(ecode) {
    case EFAULT:
	printf("Driver not responding\n");
	break;
    case EACCES:
	printf("Function not supported\n");
	break;
    case ENOMEM:
	printf("Server reports insufficient memory\n");
	break;
    case E2BIG:
	printf("Data size passsed to server is too large\n");
	break;
    case ERANGE:
	printf("Warning: Driver returned data was truncated\n");
	break;
    case 0:
	printf("No memory to allocate buffers\n");
	break;
    default:
	printf("Unknown error %d\n", ecode);
	break;
    }
    XCloseDisplay(dpy);
    exit(1);
}


main(argc, argv)
unsigned int argc;
char *argv[];
{
    int error;
    int ilen, olen, clen, control, status;
    char *obuf;

    myname = argv[0];
    if (option_test(argc, argv, opts, 2, &parm, 0) != 0) usage();
    openDisplay(opts[0].data, opts[1].data);
    control = 0xAAAB;
    status = 0;
    error = XeXtPCint(dpy, dosid, 0, &control, &status, NULL, &ilen, NULL);
    if (error) processError(error);
    printf("Max data transfer to driver: %d\n", ilen);
    control = 0xAAAB;
    status = 0;
    error = XeXtPCint(dpy, dosid, 1, &control, &status, NULL, &olen, NULL);
    if (error) processError(error);
    printf("Max data transfer from driver: %d\n", olen);
    obuf = (char *)Xmalloc(ilen);
    if (!obuf) processError(0);
    if (ilen < sizeof(message)) {
	printf("Driver will not accept test message\n");
	XCloseDisplay(dpy);
	return(1);
    }
    clen = sizeof(message);
    control = 0xAAAB;
    status = 0x34;
    error = XeXtPCint(dpy, dosid, 2, &control, &status, message, &clen, obuf);
    if (error) processError(error);
    XCloseDisplay(dpy);
    printf("Returned control = %04X, status %02X, dataLen %d\n",
	control, status, clen);
    if (clen)
	printf("Returned data: '%s'\n", obuf);
    return(0);
}
