/*  Copyright (C) Hummingbird Communications Ltd. 1990-1993	       */

#include <stdio.h>
#include <string.h>
#include "extend.h"

extern XID dosid;
extern Display *dpy;
extern int eXtinterrupt;
extern int RbufLen;
extern int maxeXtDOSbuf;

char *myname;

int version = {0x101};

struct OptionDef opts[2] = {
    {"display", 1},
    {"pw", 1}};

char **parm;

usage()
{
    fprintf(stderr, "usage: %s [options]\n", myname);
    fprintf(stderr, "  -display display-name\n");
    fprintf(stderr, "  -pw  password\n");
    exit(1);
}

main(argc, argv)
unsigned int argc;
char *argv[];
{
    unsigned char *buffer;
    int userPathSize;
    int homePathSize;
    int fileSystemSize;
    int version;
    int i;

    myname = argv[0];
    if (option_test(argc, argv, opts, 2, &parm, 0) != 0) usage();
    openDisplay(opts[0].data, opts[1].data);
    version = XeXtIdent(dpy, dosid, &buffer, &homePathSize, &userPathSize, &fileSystemSize);
    if (version == -1) {
	fprintf(stderr, "%s: Bad Access\n", myname);
	return(1);
    }
    printf("\nProtocol extension version = %d\n", version);
    printf("Maximum server read/write buffer size = %d\n", maxeXtDOSbuf);
    if (homePathSize)
	printf("Home path = %s\n", buffer + userPathSize + fileSystemSize);
    if (userPathSize)
	printf("User path = %s\n", buffer);
    buffer += userPathSize;
    if (fileSystemSize == 1 && *buffer == 0)
	printf("File system identified as DOS\n\n");
    else {
	printf("File system encoding:\n");
	for (i = 0; i < fileSystemSize; ++i) {
	    printf(" %02x", buffer[i]);
	    if ((i & 0xF) == 0xF) printf("\n");
	}
	printf("\n\n");
    }
    XCloseDisplay(dpy);
    return(eXtinterrupt);
}
