/*  Copyright (C) Hummingbird Communications Ltd. 1990-1993	       */

#include <stdio.h>
#include "extend.h"

char *myname;

extern XID dosid;
extern Display *dpy;
extern int maxeXtDOSbuf;
extern int eXtinterrupt;
extern int RbufLen;

int version = {0x104};

/*	type a file  */


DumpFile(name)
char *name;
{
    XID fid;
    int i, truelength, buflen;
    char buffer[1026];

    fid = XeXtOpenDOSFile(dpy, dosid, name, 0, 0);
    if (fid == -1) {
	fprintf(stderr, "%s: cannot open '%s'\n", myname, name);
	eXtinterrupt = 1;
	return;
    }
    buflen = maxeXtDOSbuf;
    if (RbufLen < buflen) buflen = RbufLen;
    for( ; ;) {
	if (eXtinterrupt) break;
	truelength = XeXtReadDOSFile(dpy, dosid, fid, buffer, buflen);
	if (truelength == 0) break;
	if (truelength == -1) {
	    fprintf(stderr, "%s: error reading '%s'\n", myname, name);
	    eXtinterrupt = 1;
	    break;
	}
	buffer[truelength] = 0;
	printf("%s", buffer);
    }
    printf("\n");
    if (XeXtCloseDOSFile(dpy, dosid, fid) == -1) {
	fprintf(stderr, "%s: error closing '%s'\n", myname, name);
	eXtinterrupt = 1;
    }
}

struct OptionDef opts[3] = {
    {"display", 1},
    {"pw", 1},
    {"size", 1}};

char **parm;

usage()
{
    fprintf(stderr, "usage: %s spec [-display host] [-pw password] [-size size]\n", myname);
    exit(1);
}

main(argc, argv)
unsigned int argc;
char *argv[];
{
    myname = argv[0];
    if (option_test(argc, argv, opts, 3, &parm, 1) != 1) usage();
    openDisplay(opts[0].data, opts[1].data);
    setup_size(2, opts);
    DumpFile(parm[0]);
    XCloseDisplay(dpy);
    return(eXtinterrupt);
}
