/*  Copyright (C) Hummingbird Communications Ltd. 1990-1993	       */

#include <stdio.h>
#include <string.h>
#include <time.h>
#include "extend.h"

extern XID dosid;
extern Display *dpy;

char *myname;
static int err = 0;

int version = {0x101};

extern struct linkage *head;
extern int eXtinterrupt;
extern char DirNewPath[256];
extern int dontCheckForSubDir;

struct OptionDef opts[2] = {
    {"display", 1},
    {"pw", 1}
    };

char buff[256];

char **parm;

usage()
{
    fprintf(stderr, "usage: %s [MMddhhmm[yy]] spec\n", myname);
    fprintf(stderr, "\tMM   month  (1-12)\n");
    fprintf(stderr, "\tdd   day    (1-31)\n");
    fprintf(stderr, "\thh   hour   (0-23)\n");
    fprintf(stderr, "\tmm   minute (0-59)\n");
    fprintf(stderr, "\tyy   year since 1900 (0-99)\n");
    exit(1);
}

int ext(data, lo, hi)
char *data;
int lo, hi;
{
    char temp[3];
    char *ep;
    int v;

    temp[0] = *data;
    temp[1] = *(data+1);
    temp[2] = 0;
    v = strtol(temp, &ep, 10);
    if (*ep) usage();
    if (v < lo || v > hi) usage();
    return(v);
}

main(argc, argv)
unsigned int argc;
char *argv[];
{
    int count, drive;
    char path[256];
    int year, month, day, hour, mins, secs, len;
    struct tm *ts;
    time_t tt;
    char *spec;

    myname = argv[0];
    count = option_test(argc, argv, opts, 2, &parm, 2);
    time(&tt);
    ts = (struct tm *)localtime(&tt);
    year = ts->tm_year + 1900;
    if (count == 2) {
	len = strlen(parm[0]);
	if (len != 8 && len != 10) usage();
	month = ext(&parm[0][0], 1, 12);
	day   = ext(&parm[0][2], 1, 31);
	hour  = ext(&parm[0][4], 0, 23);
	mins  = ext(&parm[0][6], 0, 59);
	secs  = 0;
	if (len == 10)
	    year = ext(&parm[0][8], 0, 99) + 1900;
	spec = parm[1];
    }
    else if (count == 1) {
	month = ts->tm_mon + 1;
	day = ts->tm_mday;
	hour = ts->tm_hour;
	mins = ts->tm_min;
	secs = ts->tm_sec;
	spec = parm[0];
    }
    else
	usage();
    openDisplay(opts[0].data, opts[1].data);
    dontCheckForSubDir = 1;
    if (XeXtReadDOSDir(dpy, dosid, spec, 0) == -1) {
	fprintf(stderr, "%s: error performing directory request\n", myname);
	err = 1;
    }
    else if (head == NULL)
	printf("no matching files for '%s'\n", spec);
    else {
	for (; head && !eXtinterrupt; head = head->next) {
	    MKpath(DirNewPath, head->r.name, path, 0);
	    if (XeXtTouchFile(dpy, dosid, path, year, month, day, hour, mins, secs) == -1)
		fprintf(stderr, "%s: Access denied\n", path);
	}
	if (eXtinterrupt)
	    err = 1;
    }
    XCloseDisplay(dpy);
    return(err);
}
