/*  Copyright (C) Hummingbird Communications Ltd. 1990-1994  */

#include <stdio.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Xaw/Cardinals.h>
#include <X11/X.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <X11/Shell.h>
#include <time.h>
#include "extend.h"

extern XID dosid;
extern Display *dpy;
extern int RbufLen;
extern int atoi();

int version = {0x107};

char *myname;

struct OptionDef opts[14] = {
    {"display", 1},
    {"pw", 1},
    {"size", 1},
    {"fg", 1},
    {"bg", 1},
    {"bc", 1},
    {"name", 1},
    {"new", 0},
    {"wc", 1},
    {"sep", 1},
    {"bw", 1},
    {"fn", 1},
    {"ts",  0},
    {"nts", 0}
};

char **parm;

usage()
{
    fprintf(stderr, "usage: %s [options] [clipfile-name]\n", myname);
    fprintf(stderr, "  -display display-name\n");
    fprintf(stderr, "  -pw  password\n");
    fprintf(stderr, "  -size size       transfer block size\n");
    fprintf(stderr, "  -fg color        foreground color\n");
    fprintf(stderr, "  -bg color        background color\n");
    fprintf(stderr, "  -bw width        border width. default 0\n");
    fprintf(stderr, "  -bc color        border color. default foreground color\n");
    fprintf(stderr, "  -wc color        parent window color. default background color\n");
    fprintf(stderr, "  -fn font         font name. default fixed\n");
    fprintf(stderr, "  -name win_name   window name. default DosPaste\n");
    fprintf(stderr, "  -new             create a new clipfile\n");
    fprintf(stderr, "  -sep pattern     separator pattern\n");
    fprintf(stderr, "  -ts              time stamp each separator line\n");
    fprintf(stderr, "  -nts             do not time stamp\n");
    exit(1);
}

static XSizeHints mm;
static char SDbuf[128];
static char *fname;
static XSetWindowAttributes att;
static XGCValues gcval;
static XID dst_fid;
static char DefName[] = "DosPaste";
static char NL[] = "\n";
static unsigned long fgcp, bgcp, offset, Lsize, bwgcp, pwgcp;
static Window rootwin, win, winp, winq;
static GC gcwin, gcRwin, gcLwin;
static Atom str, prim, incr, sel0;
static XEvent event;
static Colormap cmap;
static unsigned long niterm, bytesAfter;
static unsigned char *data;
static int dret, fa, fd, wnamelen;
static int sepdatalen;
static XCharStruct or, or2;
static char *dosfile, *wname, *sepdata;
static int x, y, x2, y2, scrin, width, height;
static XColor sdef, edef;

int docolor(colorStr)
char *colorStr;
{
    if (!XAllocNamedColor(dpy, cmap, colorStr, &sdef, &edef)) {
	fprintf(stderr, "%s: Cannot allocate color %s\n", myname, colorStr);
	return(0);
    }
    return(1);
}


dispWinP(gf, gb)
GC gf, gb;
{
    XFillRectangle(dpy, winp, gb, 0, 0, width, height);
    XDrawString(dpy, winp, gf, x, y, "Paste", 5);
}


dispWinQ(gf, gb)
GC gf, gb;
{
    XFillRectangle(dpy, winq, gb, 0, 0, width, height);
    XDrawString(dpy, winq, gf, x2, y2, "Quit", 4);
}

int gprop(first)
int first;
{
    int format;
    Atom atomret;

    if (XGetWindowProperty(dpy, win, sel0, offset, Lsize,
	    True, AnyPropertyType, &atomret,
	    &format, &niterm, &bytesAfter, &data) != Success) {
	fprintf(stderr, "%s: error reading property\n", myname);
	exit(1);
    }
    if (first && atomret == incr) {
	XFree(data);
	return(True);
    }
    if (format != 8) {
	fprintf(stderr, "%s: invalid property format type\n", myname);
	exit(1);
    }
    return(False);
}

wrDOS(data, len)
unsigned char *data;
unsigned int len;
{
    if (XeXtWriteDOSFile(dpy, dosid, dst_fid, data, len) == -1) {
	fprintf(stderr, "%s: write error\n", myname);
	exit(1);
    }
}

closeDF()
{
    wrDOS(NL, 1);
    if (XeXtCloseDOSFile(dpy, dosid, dst_fid) == -1) {
	fprintf(stderr, "%s: error closing destination '%s'\n", myname, dosfile);
	exit(1);
    }
}

writeDOSchunk()
{
    unsigned long buflen;

    if (niterm < RbufLen)
	buflen = niterm;
    else
	buflen = RbufLen;
    wrDOS(data, buflen);
    offset += (unsigned long)niterm >> 2;
    XFree(data);
}

unsigned long ColOp(index, res, alt)
int index;
char *res;
unsigned long alt;
{
    char *p;

    if (!opts[index].found) {
	p = XGetDefault(dpy, myname, res);
	if (p && docolor(p))
	    return(sdef.pixel);
    }
    else if (docolor(opts[index].data))
	return(sdef.pixel);
    return(alt);
}

char *StrOp(index, res, def)
int index;
char *res, *def;
{
    char *p;

    if (opts[index].found)
	return(opts[index].data);
    else {
	p = XGetDefault(dpy, myname, res);
	if (p)
	    return(p);
    }
    return(def);
}

setRect(win)
Window win;
{
    XDrawRectangle(dpy, win, gcLwin, 1, 1, width-3, height-3);
}

main(argc, argv)
int argc;
char *argv[];
{
    int count, bww, qdown, pdown, pin, qin;
    int height2, width2, exspace, eyspace, eyspace2, exspace2;
    int working, incrMethod;
    char *p;
    time_t CurTime;

    myname = argv[0];
    count = option_test(argc, argv, opts, 14, &parm, 1);
    openDisplay(opts[0].data, opts[1].data);
    resolve_option(opts, 12, 13, "timestamp", "yes");
    setup_size(2, opts);
    if (!opts[10].found) {
	opts[10].data = XGetDefault(dpy, myname, "borderwidth");
	if (opts[10].data) opts[10].found = 1;
    }
    if (opts[10].found) {
	bww = atoi(opts[10].data);
	if (bww < 0) {
	    fprintf(stderr, "%s: invalid border width", myname);
	    exit(1);
	}
    }
    else
	bww = 0;
    if (count == 1)
	dosfile = parm[0];
    else {
	dosfile = XGetDefault(dpy, myname, "clipfile");
	if (!dosfile)
	    dosfile = "dospaste.dat";
    }
    Lsize = (unsigned long)RbufLen >> 2;
    fname = StrOp(11, "fontname", "fixed");
    wname = StrOp(6, "windowname", DefName);
    wnamelen = strlen(wname);
    sepdata = NULL;
    if (opts[9].found) {
	sepdata = opts[9].data;
	if (strlen(sepdata) > 80) {
	    fprintf(stderr, "%s: separator data too long\n", myname);
	    exit(1);
	}
    }
    else
	sepdata = XGetDefault(dpy, myname, "separator");
    if (!sepdata)
	sepdata = "-----";
    if (!opts[7].found) {
	p = XGetDefault(dpy, myname, "newfile");
	if (p && strcmp(p, "yes") == 0) opts[7].found = 1;
    }
    if (opts[7].found)
	XeXtDelDOSFile(dpy, dosid, dosfile);
    working = 0;
    rootwin = XDefaultRootWindow(dpy);
    scrin = XDefaultScreen(dpy);
    cmap =  XDefaultColormap(dpy, scrin);
    fgcp =  ColOp(3, "foregroundcolor", XBlackPixel(dpy, scrin));
    bgcp =  ColOp(4, "backgroundcolor", XWhitePixel(dpy, scrin));
    bwgcp = ColOp(5, "bordercolor", fgcp);
    pwgcp = ColOp(8, "maincolor", bgcp);
    gcval.font = XLoadFont(dpy, fname);
    XQueryTextExtents(dpy, gcval.font, "Paste", 5, &dret, &fa, &fd, &or);
    XQueryTextExtents(dpy, gcval.font, "Quit", 4, &dret, &fa, &fd, &or2);
    exspace = or.width / 5;
    width = or.width + (2 * exspace);
    eyspace = or.ascent + or.descent;
    height = eyspace * 3;
    exspace2 = or2.width / 4;
    width2 = or2.width + (2 * exspace2);
    eyspace2 = or2.ascent + or2.descent;
    height2 = eyspace2 * 3;
    if (eyspace < eyspace2) eyspace = eyspace2;
    if (exspace < exspace2) exspace = exspace2;
    if (width < width2) width = width2;
    if (height < height2) height = height2;

    x = ((width - or.width) / 2) - or.lbearing;
    y = eyspace + or.ascent;
    x2 = ((width - or2.width) / 2) - or2.lbearing;
    y2 = eyspace + or2.ascent;

    mm.flags = PMinSize;
    mm.min_width  = (2*width)+19;
    mm.min_height = height+12;

    att.border_pixel = bwgcp;
    att.background_pixel = pwgcp;
    att.event_mask = ExposureMask | PropertyChangeMask;
    win = XCreateWindow(dpy, rootwin, 0, 0, mm.min_width, mm.min_height,
	      bww, CopyFromParent, InputOutput, CopyFromParent,
	      CWEventMask | CWBackPixel | CWBorderPixel, &att);
    att.background_pixel = bgcp;
    att.event_mask = ButtonPressMask | ButtonReleaseMask | EnterWindowMask |
			LeaveWindowMask | ExposureMask;
    winp = XCreateWindow(dpy, win, 6, 6, width, height,
	      1, CopyFromParent, InputOutput, CopyFromParent,
	      CWEventMask | CWBackPixel, &att);
    winq = XCreateWindow(dpy, win, width + 13, 6, width, height,
	      1, CopyFromParent, InputOutput, CopyFromParent,
	      CWEventMask | CWBackPixel, &att);

    XChangeProperty(dpy, win, XA_WM_NAME, XA_STRING, 8,
		    PropModeReplace, wname, wnamelen);
    str = XInternAtom(dpy, "STRING", False);
    prim = XInternAtom(dpy, "PRIMARY", False);
    incr = XInternAtom(dpy, "INCR", False);
    sel0 = XInternAtom(dpy, "SEL0", False);

    gcval.foreground = fgcp;
    gcval.background = bgcp;
    gcwin = XCreateGC(dpy, win, GCFont | GCForeground | GCBackground, &gcval);
    gcval.line_width = 3;
    gcLwin = XCreateGC(dpy, win, GCForeground | GCLineWidth, &gcval);
    gcval.foreground = bgcp;
    gcval.background = fgcp;
    gcRwin = XCreateGC(dpy, win, GCFont | GCForeground | GCBackground, &gcval);

    XSetNormalHints(dpy, win, &mm);
    XMapWindow(dpy, win);
    XMapWindow(dpy, winp);
    XMapWindow(dpy, winq);

    pin = qin = qdown = pdown = 0;
    while (1) {
	XNextEvent(dpy, &event);
	switch(event.type) {
	case EnterNotify:
	    if (event.xcrossing.window == winp) {
		pin = 1;
		setRect(winp);
	    }
	    else {
		qin = 1;
		setRect(winq);
	    }
	    break;
	case LeaveNotify:
	    if (event.xcrossing.window == winq) {
		dispWinQ(gcwin, gcRwin);
		qdown = qin = 0;
	    }
	    else {
		dispWinP(gcwin, gcRwin);
		pin = pdown = 0;
	    }
	    break;
	case ButtonPress:
	    if (event.xbutton.button != 1) break;
	    if (event.xbutton.window == winq)
		qdown = 1;
	    else
		pdown = 1;
	    break;
	case ButtonRelease:
	    if (event.xbutton.button != 1) break;
	    if (event.xbutton.window == winq) {
		if (qdown)
		    exit(0);
	    }
	    else if (pdown)
		XConvertSelection(dpy, prim, str, sel0,win,event.xbutton.time);
	    break;
	case SelectionNotify:
	    if (event.xselection.property != sel0 ||
		    event.xselection.selection != prim || working) {
		XBell(dpy, 100);
		break;
	    }
	    incrMethod = False;
	    if (event.xselection.target != str) {
		XBell(dpy, 100);
		break;
	    }
	    dispWinP(gcRwin, gcwin);
	    dst_fid = XeXtOpenDOSFile(dpy, dosid, dosfile, 0, 2);
	    if (dst_fid == (XID)(-1L)) {
		fprintf(stderr, "%s: cannot create '%s'\n", myname, dosfile);
		exit(1);
	    }
	    time(&CurTime);
	    if (opts[12].found)
		sprintf(SDbuf, "\n%s %s\n", sepdata, ctime(&CurTime));
	    else
		sprintf(SDbuf, "\n%s\n\n", sepdata);
	    sepdatalen = strlen(SDbuf);

	    wrDOS(SDbuf, sepdatalen);
	    working = 1;
	    offset = 0L;
	    if (gprop(1)) {
		incrMethod = True;
		break;
	    }
	    while (1) {
		writeDOSchunk();
		if (!bytesAfter) break;
		gprop(0);
	    }
	    closeDF();
	    dispWinP(gcwin, gcRwin);
	    setRect(winp);
	    working = 0;
	    break;
	case PropertyNotify:
	    if (!working || event.xproperty.state != PropertyNewValue)
		break;
	    offset = 0L;
	    while (1) {
		gprop(0);
		if (offset == 0L && niterm == 0) {
		    XFree(data);
		    working = 0;
		    closeDF();
		    dispWinP(gcwin, gcRwin);
		    setRect(winp);
		    break;
		}
		writeDOSchunk();
		if (!bytesAfter) break;
	    }
	    break;
	case Expose:
	    if (event.xexpose.count) break;
	    if (event.xexpose.window == win)
		XClearWindow(dpy, win);
	    else if (event.xexpose.window == winp) {
		dispWinP(gcwin, gcRwin);
		if (pin) setRect(winp);
	    }
	    else {
		dispWinQ(gcwin, gcRwin);
		if (qin) setRect(winq);
	    }
	    break;
	} /* switch */
    } /* loop */
}
