/*  Copyright (C) Hummingbird Communications Ltd. 1990-1993	       */

#include <stdio.h>
#include <string.h>
#include "extend.h"

extern XID dosid;
extern Display *dpy;
extern int entries;
extern struct linkage *head;

static int err = 0;
char *myname;

struct OptionDef opts[4] = {
    {"display", 1},
    {"pw", 1},
    {"p", 0},
    {"np", 0}};

char **parm;

int version = {0x103};

usage()
{
    fprintf(stderr, "usage: %s [-p] [-np] [-display displayname] [-pw password] src dst\n", myname);
    exit(1);
}

static RenameFile(src, dst)
char *src, *dst;
{
    int len;
    char buff[512], path[256];

    EstablishDest(src, dst, path);
    dst = path;
    if (opts[2].found)
	printf("%s: moving %s to %s ...\n", myname, src, dst);
    len = strlen(src) + strlen(dst) + 2;
    strcpy(buff, src);
    strcpy(buff+1+strlen(src), dst);
    if (XeXtRenDOSFile(dpy, dosid, buff, len) == -1) {
	fprintf(stderr, "%s: cannot rename '%s' to '%s'\n", myname, src, dst);
	err = 1;
    }
}

main(argc, argv)
unsigned int argc;
char *argv[];
{
    char path[256], Dest[256];
    int err;

    myname = argv[0];
    if (option_test(argc, argv, opts, 4, &parm, 2) != 2) usage();
    openDisplay(opts[0].data, opts[1].data);
    resolve_option(opts, 2, 3, "prompt", "yes");

    err = XeXtIsDOSDir(dpy, dosid, parm[1]);
    if (err > 0) {
	strcpy(Dest, parm[1]);
	strcat(Dest, "/*.*");
	parm[1] = Dest;
    }
    else if (err < 0) {
	err = 1;
	goto getout;
    }
    if (!wildcards(parm[0]))
	RenameFile(parm[0], parm[1]);
    else if (XeXtReadDOSDir(dpy, dosid, parm[0], 0xff) == -1) {
	fprintf(stderr, "%s: error performing directory request\n", myname);
	err = 1;
    }
    else if (entries == 0) {
	fprintf(stderr, "%s: no matching files.\n", myname);
	err = 1;
    }
    else {
	for (; head && !err; head = head->next) {
	    MKpath(parm[0], head->r.name, path, 0);
	    RenameFile(path, parm[1]);
	}
    }
getout:
    XCloseDisplay(dpy);
    return(err);
}
