/*  Copyright (C) Hummingbird Communications Ltd. 1990-1993  */

#include <stdio.h>
#include <string.h>
#include "extend.h"

extern XID dosid;
extern Display *dpy;
extern int eXtinterrupt;
extern struct linkage *head;
extern char *FilenamePart();

static int qual = 0;

int version = {0x201};

struct OptionDef opts[8] = {
    {"display", 1},
    {"pw", 1},
    {"1", 0},
    {"l", 0},
    {"attr", 1},
    {"w", 0},
    {"lc", 0},
    {"uc", 0}};

char **parm;

char *myname;

static char *lowerstring(name)
char *name;
{
    char *init;

    for (init = name; *name; ++name)
	*name = lower(*name);
    return(init);
}

static doListing(attr)
int attr;
{
    struct linkage *cur;
    char buf[10], nbuf[40], *name;
    int tcnt;

    tcnt = 0;
    for (cur = head; cur; cur = cur->next) {
	cur->r.attribute &= 0x3F;
	if (cur->r.attribute == 0)
	    cur->r.attribute = 0x80;
	cur->r.attribute &= attr;
	if (cur->r.attribute) ++tcnt;
    }
    if (tcnt == 0) {
	fprintf(stderr, "%s: no matching files.\n", myname);
	eXtinterrupt = 1;
	return;
    }
    tcnt = 0;
    for (cur = head; cur; cur = cur->next)  {
	if (eXtinterrupt) break;
	if (cur->r.attribute == 0) continue;
	if ((cur->r.attribute & 0x10) && !qual != 2) {
	    strcpy(nbuf, cur->r.name);
	    strcat(nbuf, "/");
	    name = nbuf;
	}
	else
	    name = (char *)cur->r.name;
	if (opts[6].found)
	    lowerstring(name);
	if (qual == 2) {
	    if (cur->r.attribute & 0x10)
		 strcpy(buf, "<DIR>");
	    else
		 sprintf(buf, "%d", cur->r.size);
	    printf(
		   "%-14s%8s %02d/%02d/%02d %02d:%02d:%02d %c%c%c%c%c%c\n",
			   name, buf, ((cur->r.date>>9)&0x7F)+80,
		   (cur->r.date>>5)&0xF,
		   cur->r.date&0x1F, (cur->r.time>>11)&0x1F,
		   (cur->r.time>>5)&0x3F,
		   (cur->r.time&0x1F)<<1,
		   (cur->r.attribute & 1) ? 'r' : '-',
			   (cur->r.attribute & 2) ? 'h' : '-',
		   (cur->r.attribute & 4) ? 's' : '-',
		   (cur->r.attribute & 8) ? 'v' : '-',
		   (cur->r.attribute & 0x10) ? 'd' : '-',
		   (cur->r.attribute & 0x20) ? 'a' : '-');
	}
	else if (qual == 1)
	    printf("%s\n", name);
	else if (tcnt == 4) {
	    printf("%s\n", name);
	    tcnt = 0;
	}
	else {
	    printf("%-15s", name);
	    ++tcnt;
	}
    }
    if (tcnt != 0) printf("\n");
}

usage()
{
    fprintf(stderr, "usage: %s [options] [spec]\n", myname);
    fprintf(stderr, "  -display display-name\n");
    fprintf(stderr, "  -pw  password\n");
    fprintf(stderr, "  -1               single column format\n");
    fprintf(stderr, "  -w               multi-column format (default)\n");
    fprintf(stderr, "  -l               full information\n");
    fprintf(stderr, "  -uc              display upper case file names (default)\n");
    fprintf(stderr, "  -lc              display lower case file names\n");
    fprintf(stderr, "  -attr mask       attribute mask\n");
    fprintf(stderr, "     X             all files (default)\n");
    fprintf(stderr, "     N             normal files (no attributes)\n");
    fprintf(stderr, "     R             read-only files\n");
    fprintf(stderr, "     H             hidden files\n");
    fprintf(stderr, "     S             system files\n");
    fprintf(stderr, "     V             volumn id\n");
    fprintf(stderr, "     D             sub-directories\n");
    fprintf(stderr, "     A             archive attribute\n");
    exit(1);
}

main(argc, argv)
unsigned int argc;
char *argv[];
{
    int count, attr;
    char *p;

    myname = argv[0];
    count = option_test(argc, argv, opts, 8, &parm, 1);
    openDisplay(opts[0].data, opts[1].data);
    if (!count) parm[0] = "";

    if (opts[3].found)
	qual = 2;
    else if (opts[5].found)
	qual = -1;
    else if (opts[2].found)
	qual = 1;
    if (qual == 0) {
	p = XGetDefault(dpy, myname, "format");
	if (p != NULL) {
	    if (strcmp(p, "all") == 0)
		qual = 2;
	    else if (strcmp(p, "list") == 0)
		qual = 1;
	    else if (strcmp(p, "cols") == 0)
		qual = -1;
	}
    }
    resolve_option(opts, 6, 7, "case", "lower");
    if (opts[4].found)
	p = opts[4].data;
    else {
	p = XGetDefault(dpy, myname, "attr");
	if (p == NULL)
	    p = "X";
    }
    for (attr = 0; *p; ++p) {
	switch(upper(*p)) {
	case 'X':
	    attr = 0xBF;
	    break;
	case 'A':
	    attr |= 0x20;
	    break;
	case 'R':
	    attr |= 0x01;
	    break;
	case 'D':
	    attr |= 0x10;
	    break;
	case 'H':
	    attr |= 0x02;
	    break;
	case 'S':
	    attr |= 0x04;
	    break;
	case 'V':
	    attr |= 0x08;
	    break;
	case 'N':
	    attr |= 0x80;
	    break;
	}
    }


    if (XeXtReadDOSDir(dpy, dosid, parm[0], attr) != -1)
	doListing(attr);
    else {
	fprintf(stderr, "%s: error performing directory request\n", myname);
	eXtinterrupt = 1;
    }
    XCloseDisplay(dpy);
    return(eXtinterrupt);
}
