/*  Copyright (C) Hummingbird Communications Ltd. 1990-1993	       */

#include <stdio.h>
#include <string.h>
#include "extend.h"

extern XID dosid;
extern Display *dpy;

char *myname;
static int err = 0;

int version = {0x101};

struct OptionDef opts[2] = {
    {"display", 1},
    {"pw", 1}};

char buff[256];

char **parm;

usage()
{
    fprintf(stderr, "usage: %s [disk] [-display host] [-pw password]\n", myname);
    exit(1);
}

main(argc, argv)
unsigned int argc;
char *argv[];
{
    long dfree, dtotal;
    int count, drive;

    myname = argv[0];
    count = option_test(argc, argv, opts, 2, &parm, 1);
    if (count == 0)
	drive = 0;
    else {
	if (strlen(parm[0]) != 1) {
	    fprintf(stderr, "%s: Invalid disk\n", myname);
	    exit(1);
	}
	drive = parm[0][0];
    }
    openDisplay(opts[0].data, opts[1].data);
    if (XeXtGetDiskInfo(dpy, dosid, drive, &dfree, &dtotal) == -1) {
	err = 1;
	fprintf(stderr, "%s: Cannot get disk information\n", myname);
    }
    else {
	if (drive == 0) {
	    drive = '?';
	    if (XeXtGetDOSDir(dpy, dosid, buff, sizeof(buff)) == -1) {
		fprintf(stderr, "%s: Cannot get current directory\n\n", myname);
		err = 1;
	    }
	    else if (buff[1] == ':')
		drive = buff[0];
	}
	if (!err) {
	    printf("\ndisk %c:\n", drive);
	    printf("\t%12lu bytes total disk space\n", dtotal);
	    printf("\t%12lu bytes used\n", dtotal - dfree);
	    printf("\t%12lu bytes available on disk\n\n", dfree);
	}
    }
    XCloseDisplay(dpy);
    return(err);
}
