/*  Copyright (C) Hummingbird Communications Ltd. 1990-1993	       */

#include <stdio.h>
#include <string.h>
#include "extend.h"

extern XID dosid;
extern Display *dpy;
extern int maxeXtDOSbuf;
extern int eXtinterrupt;

extern int eXtinterrupt;
extern int entries;
extern struct linkage *head;
extern int RbufLen;
extern char *FilenamePart();

static char buffer[MAXBUF];

int version = {0x104};

Display *dpys;
Display *dpyd;
XID dosids;
XID dosidd;


char *myname;

struct OptionDef opts[11] = {
    {"display", 1},
    {"pw", 1},
    {"p", 0},
    {"size", 1},
    {"np", 0},
    {"v", 0},
    {"nv", 0},
    {"sdisplay", 1},
    {"spw", 1},
    {"ddisplay", 1},
    {"dpw", 1}
    };

char **parm;

usage()
{
    fprintf(stderr, "usage: %s [options] src dst\n", myname);
    fprintf(stderr, "  -display display-name   default display\n");
    fprintf(stderr, "  -pw  password    default password\n");
    fprintf(stderr, "  -sdisplay display-name  explicit source display\n");
    fprintf(stderr, "  -spw  password   explicit source password\n");
    fprintf(stderr, "  -ddisplay display-name  explicit destination display\n");
    fprintf(stderr, "  -dpw  password   explicit destination password\n");
    fprintf(stderr, "  -p               displays the name of each file being copied\n");
    fprintf(stderr, "  -np              does not display the name of each file. (default)\n");
    fprintf(stderr, "  -size size       transfer block size\n");
    fprintf(stderr, "  -v               verify file deletions. (default)\n");
    fprintf(stderr, "  -nv              do not verify file deletions\n");
    exit(1);
}

int verify_del(path)
char *path;
{
    int i;

    dpy = dpyd;
    i = verify_deletion(path);
    dpy = dpys;
    return(i);
}

do1(src, dst)
char *src, *dst;
{
    int count, buflen;
    XID dst_fid, src_fid;
    char path[256];

    EstablishDest(src, dst, path);
    dst = path;
    if (!opts[6].found && !verify_del(dst)) return;
    if (opts[2].found)
	printf("%s: copying %s to %s ...\n", myname, src, dst);
    dst_fid = XeXtOpenDOSFile(dpyd, dosidd, dst, 1, 1);
    if (dst_fid == -1) {
	fprintf(stderr, "%s: cannot create '%s'\n", myname, dst);
	eXtinterrupt = 1;
	return;
    }
    buflen = maxeXtDOSbuf;
    if (RbufLen < buflen) buflen = RbufLen;
    src_fid = XeXtOpenDOSFile(dpys, dosids, src, 1, 0);
    if (src_fid == -1) {
	fprintf(stderr, "%s: cannot open '%s'\n", myname, src);
	eXtinterrupt = 1;
	goto getout0;
    }
    for ( ; ;) {
	if (eXtinterrupt) break;
	count = XeXtReadDOSFile(dpys, dosids, src_fid, buffer, buflen);
	if (count == 0) break;
	if (count < 0) {
	    fprintf(stderr, "%s: error reading '%s'\n", myname, src);
	    eXtinterrupt = 1;
	    break;
	}
	if (XeXtWriteDOSFile(dpyd, dosidd, dst_fid, buffer, count) == -1) {
	    fprintf(stderr, "%s: error writing '%s'\n", myname, dst);
	    eXtinterrupt = 1;
	    break;
	}
    }
    if (XeXtCloseDOSFile(dpys, dosids, src_fid) == -1) {
	fprintf(stderr, "%s: error closing '%s'\n", myname, src);
	eXtinterrupt = 1;
    }
getout0:
    if (XeXtCloseDOSFile(dpyd, dosidd, dst_fid) == -1) {
	fprintf(stderr, "%s: error closing '%s'\n", myname, dst);
	eXtinterrupt = 1;
    }
}

main(argc, argv)
unsigned int argc;
char *argv[];
{
    char ipath[256], tbuf[256], Dest[256];

    myname = argv[0];
    if (option_test(argc, argv, opts, 11, &parm, 2) != 2) usage();
    if (!opts[7].found)
	opts[7].data = opts[0].data;
    if (!opts[8].found)
	opts[8].data = opts[1].data;
    if (!opts[9].found)
	opts[9].data = opts[0].data;
    if (!opts[10].found)
	opts[10].data = opts[1].data;
    if (opts[7].data == opts[9].data && opts[8].data != opts[10].data) {
	fprintf(stderr, "Same display, different passwords\n");
	return(1);
    }
    openDisplay(opts[7].data, opts[8].data);
    dpys = dpy;
    dosids = dosid;
    if (opts[7].data == opts[9].data) {
	dpyd = dpys;
	dosidd = dosids;
    }
    else {
	openDisplay(opts[9].data, opts[10].data);
	dpyd = dpy;
	dosidd = dosid;
	dpy = dpys;
	dosid = dosids;
    }
    resolve_option(opts, 2, 4, "prompt", "yes");
    resolve_option(opts, 6, 5, "verify", "no");
    setup_size(3, opts);

    if (XeXtIsDOSDir(dpyd, dosidd, parm[1]) > 0) {
	strcpy(Dest, parm[1]);
	strcat(Dest, "/*.*");
	parm[1] = Dest;
    }
    if (eXtinterrupt) goto getout;
    if (XeXtReadDOSDir(dpys, dosids, parm[0], 0) == -1) {
	fprintf(stderr, "%s: error performing directory request\n", myname);
	eXtinterrupt = 1;
    }
    else if (entries == 0) {
	fprintf(stderr, "%s: no matching files.\n", myname);
	eXtinterrupt = 1;
    }
    else {
	for (; head && !eXtinterrupt; head = head->next) {
	    MKpath(parm[0], head->r.name, ipath, 0);
	    do1(ipath, parm[1]);
	}
    }
getout:
    XCloseDisplay(dpys);
    if (dpyd != dpys)
	XCloseDisplay(dpyd);
    return(eXtinterrupt);
}
