/*  Copyright (C) Hummingbird Communications Ltd. 1990-1993  */

#include <stdio.h>
#include "extend.h"

extern XID dosid;
extern Display *dpy;

static int err = 0;
char *myname;

int version = {0x103};

static int ChangeDrive(drv)
char drv;
{
    if (XeXtChangeDOSDrive(dpy, dosid, drv) == -1) {
	fprintf(stderr, "%s: cannot change drive to '%c:'\n", myname, drv);
	err = 1;
    }
    return(err);
}

static int ChangeDir(path)
char *path;
{
    int i;

    for (i=0; i < strlen(path); i++)
	if (path[i] == '\\') path[i] = '/';
    if (XeXtChangeDOSDir(dpy, dosid, path)) {
	fprintf(stderr, "%s: cannot set directory to '%s'\n", myname, path);
	err = 1;
    }
    return(err);
}

static int GetCWD()
{
    int err;
    char current_path[200];

    if (XeXtGetDOSDir(dpy, dosid, current_path, sizeof(current_path))) {
	fprintf(stderr, "%s: cannot read directory information\n", myname);
	err = 1;
    }
    else
	printf("Current DOS Dir = %s\n", current_path);
    return(err);
}

struct OptionDef opts[2] = {
    {"display", 1},
    {"pw", 1}};

char **parm;

usage()
{
    fprintf(stderr, "usage: %s [spec] [-display host] [-pw password]\n", myname);
    exit(1);
}

main(argc, argv)
unsigned int argc;
char *argv[];
{
    int count;
    char *p;

    myname = argv[0];
    count = option_test(argc, argv, opts, 2, &parm, 1);
    if (count > 1) usage();
    openDisplay(opts[0].data, opts[1].data);

    if (count == 1) {
	p = parm[0];
	if (*(p+1) == ':') {
	    if (!ChangeDrive(*p))
		if (*(p+2)) ChangeDir(p+2);
	}
	else
	    ChangeDir(p);
    }
    if (!err) GetCWD();
    XCloseDisplay(dpy);
    return(err);
}
