/*  Copyright (C) Hummingbird Communications Ltd. 1990-1993  */

#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <ctype.h>
#include "extend.h"

extern XID dosid;
extern Display *dpy;
extern int maxeXtDOSbuf;
extern int eXtinterrupt;
extern char DirNewPath[256];
extern struct linkage *head;
extern int entries;
extern int RbufLen;

int version = {0x304};

struct known_struct {
    int     qual;
    char    tag[4];
    struct  known_struct *next;
};

struct known_struct *khead = {NULL};

static char buffer[MAXBUF];

char *myname;

struct OptionDef opts[16] = {
    {"display", 1},
    {"pw", 1},
    {"b", 0},
    {"lc", 0},
    {"p", 0},
    {"size", 1},
    {"uc", 0},
    {"a", 0},
    {"np", 0},
    {"v", 0},
    {"nv", 0},
    {"nk", 0},
    {"k", 1},
    {"ka", 0},
    {"nka", 0},
    {"f", 1}};

char **parm;

usage()
{
    fprintf(stderr, "usage: %s [options] src [dst]\n", myname);
    fprintf(stderr, "  -display display-name\n");
    fprintf(stderr, "  -pw  password\n");
    fprintf(stderr, "  -a               ascii file transfer (default)\n");
    fprintf(stderr, "  -b               binary file transfer\n");
    fprintf(stderr, "  -uc              create upper case file names if dst is omitted (default)\n");
    fprintf(stderr, "  -lc              create lower case file names if dst is omitted\n");
    fprintf(stderr, "  -p               displays the name of each file being copied\n");
    fprintf(stderr, "  -np              does not display the name of each file. (default)\n");
    fprintf(stderr, "  -v               verify file deletions. (default)\n");
    fprintf(stderr, "  -nv              do not verify file deletions.\n");
    fprintf(stderr, "  -size size       transfer block size\n");
    fprintf(stderr, "  -k file          'file' contains 'known' extensions\n");
    fprintf(stderr, "  -nk              ignore any known extensions\n");
    fprintf(stderr, "  -ka              prompt for transfer type for unknown extensions\n");
    fprintf(stderr, "  -nka             disable -ka functionality\n");
    fprintf(stderr, "  -f               src is a description file\n");
    fprintf(stderr, "\nResolve codes:\n");
    fprintf(stderr, "  A                ASCII\n");
    fprintf(stderr, "  A+               ASCII for subsequent transfers\n");
    fprintf(stderr, "  A++              same as A+ and save in known file if used\n");
    fprintf(stderr, "  B[+][+]          same as A, but Binary\n");
    fprintf(stderr, "  S[+][+]          same as A, but skip the file\n");
    fprintf(stderr, "\nDescription file line format:\n");
    fprintf(stderr, "  src  dst         source and destination spec\n");
    fprintf(stderr, "  src              source spec, dst assumed to be '*.*'\n");
    exit(1);
}

static transName(name, doit)
char *name;
int doit;
{
    int i;

    if (doit) {
	for (i = strlen(name); i; --i) {
	    if (name[i-1] == '/')
		break;
	    else
		name[i-1] = lower(name[i-1]);
	}
    }
}

addNode(qual, tag)
int qual;
char *tag;
{
    struct known_struct *k;

    k = (struct known_struct *)Xmalloc(sizeof(struct known_struct));
    if (!k) {
	fprintf(stderr, "%s: insufficient memory to store known entries\n",myname);
	return;
    }
    if (qual == 'S')
	k->qual = -1;
    else
	k->qual = qual - 'A';
    strcpy(k->tag, tag);
    k->next = khead;
    khead = k;
}

int readKnown()
{
    FILE *kfile;
    char name[256];
    char new[4];
    struct known_struct *k;
    int count;

    kfile = fopen(opts[12].data, "r");
    if (!kfile) {
	if (opts[13].found)
	    return(1);
	else {
	    fprintf(stderr, "%s: cannot open '%s'\n", myname, opts[12].data);
	    return(0);
	}
    }
    while (fscanf(kfile, "%s", name) != EOF) {
	if (islower(name[0]))
	    name[0] = toupper(name[0]);
	if ((name[0] != 'A' && name[0] != 'B' && name[0] != 'S') ||
		    name[1] != '.') {
ie:	    fprintf(stderr, "%s: invalid entry in 'known' file '%s'\n", myname, name);
	    return(0);
	}
	for (count = 0; name[count+2]; ++count) {
	    if (count == 3) goto ie;
	    if (islower(name[count+2]))
		new[count] = toupper(name[count+2]);
	    else
		new[count] = name[count+2];
	}
	new[count] = '\0';
	for (k = khead; k; k = k->next) {
	    if (strcmp(k->tag, new) == 0) {
		fprintf(stderr, "%s: known entry specified more than once '%s'\n",
			    myname, new);
		return(0);
	    }
	}
	addNode(name[0], new);
    }
    fclose(kfile);
    return(1);
}


addEntry(qual, tag, strong)
int qual, strong;
char *tag;
{
    FILE *kfile;

    if (opts[12].found && strong) {
	kfile = fopen(opts[12].data, "a");
	if (!kfile) {
	    fprintf(stderr, "%s: cannot open/create '%s'\n", myname, opts[12].data);
	    eXtinterrupt = 1;
	    return;
	}
	fprintf(kfile, " %c.%s\n", qual, tag);
	fclose(kfile);
    }
    addNode(qual, tag);
}

int resolve_type(path)
char *path;
{
    char tag[4], *ptr;
    int i, addit, strong;
    struct known_struct *k;
    char buffer[80];

    ptr = NULL;
    for (i = strlen(path) - 1; i; --i) {
	if (path[i] == '.') {
	    ptr = &path[i+1];
	    break;
	}
	else if (path[i] == ':' || path[i] == '\\' || path[i] == '/')
	    break;
    }
    if (ptr) {
	strcpy(tag, ptr);
	for (i = 0; tag[i]; ++i)
	    if (islower(tag[i]))
		tag[i] = toupper(tag[i]);
    }
    else
	tag[0] = 0;
    for (k = khead; k; k = k->next)
	if (strcmp(tag, k->tag) == 0)
	    return(k->qual);
    if (opts[13].found) {
	for ( ; ; ) {
	    printf("%s: Resolve extension for '%s'\n", myname, path);
	    printf("\t\tEnter A[+][+]=ASCII B[+][+]=Binary S[+][+]=skip: ");
	    buffer[0] = 0;
	    fgets(buffer, 80, stdin);
	    if (islower(buffer[0]))
		buffer[0] = toupper(buffer[0]);
	    if (buffer[1] == '+') {
		addit = 1;
		if (buffer[2] == '+')
		    strong = 1;
		else
		    strong = 0;
	    }
	    else
		strong = addit = 0;
	    switch(buffer[0]) {
	    case 'A':
		if (addit) addEntry('A', tag, strong);
		return(0);
	    case 'B':
		if (addit) addEntry('B', tag, strong);
		return(1);
	    case 'S':
		if (addit) addEntry('S', tag, strong);
		return(-1);
	    }
	}
    }
    return(opts[2].found);
}

int do1req(src, dst)
char *src, *dst;
{
    int count, buflen, qual;
    char path[256], ibuffer[80], npath[256];
    XID src_fid;
    FILE *df;

    if (XeXtReadDOSDir(dpy, dosid, src, 0) == -1) {
	fprintf(stderr, "%s: error performing directory request\n", myname);
	eXtinterrupt = 1;
	return(1);
    }
    if (head == NULL) {
	printf("no matching files for '%s'\n", src);
	return(0);
    }
    for (; head && !eXtinterrupt; head = head->next) {
	MKpath(DirNewPath, head->r.name, path, 0);
	EstablishUnixDest(path, dst, npath);
	transName(npath, opts[3].found);
	qual = resolve_type(path);
	if (eXtinterrupt) return(1);
	if (qual == -1) continue;
	if (!opts[10].found) {
	    if (!access(npath, 0)) {
		printf("%s: delete existing %s? ", myname, npath);
		ibuffer[0] = 0;
		fgets(ibuffer, 80, stdin);
		if (ibuffer[0] != 'Y' && ibuffer[0] != 'y')
		    continue;
	    }
	}
	if (opts[4].found) printf("%s: copying %s %s to %s ...\n", myname,
		(qual ? "Binary" : "ASCII "), path, npath);
	src_fid = XeXtOpenDOSFile(dpy, dosid, path, qual, 0);
	if (src_fid == (XID)(-1L)) {
	    fprintf(stderr, "%s: cannot open '%s'\n", myname, path);
	    eXtinterrupt = 1;
	    return(1);
	}
	df = fopen(npath, "w");
	if (df == NULL) {
	    fprintf(stderr, "%s: cannot create '%s'\n", myname, npath);
	    eXtinterrupt = 1;
	    goto erex;
	}
	buflen = maxeXtDOSbuf;
	if (RbufLen < buflen) buflen = RbufLen;
	for( ; ;) {
	    if (eXtinterrupt) break;
	    count = XeXtReadDOSFile(dpy, dosid, src_fid, buffer, buflen);
	    if (count == 0) break;
	    if (count == -1) {
		fprintf(stderr, "%s: error reading '%s'\n", myname, path);
		eXtinterrupt = 1;
		break;
	    }
	    fwrite(buffer, 1, count, df);
	    if (ferror(df)) {
		fprintf(stderr, "%s: error writing '%s'\n", myname, npath);
		eXtinterrupt = 1;
		break;
	    }
	}
	if (fclose(df)) {
	    fprintf(stderr, "%s: error closing destination '%s'\n", myname, npath);
	    eXtinterrupt = 1;
	}
erex:
	if (XeXtCloseDOSFile(dpy, dosid, src_fid) == -1) {
	    fprintf(stderr, "%s: error closing source '%s'\n", myname, path);
	    eXtinterrupt = 1;
	}
    }
    return(eXtinterrupt);
}


main(argc, argv)
unsigned int argc;
char *argv[];
{
    int count, override;
    char *p;
    char ibuffer[256], src[256], dst[256];
    FILE *df;
    int dummy, line;
    struct linkage *n;

    myname = argv[0];
    override = 0;
    count = option_test(argc, argv, opts, 16, &parm, 2);
    if (!opts[15].found) {
	if (count == 0) usage();
	if (count == 1) parm[1] = "*.*";
    }
    openDisplay(opts[0].data, opts[1].data);

    resolve_option(opts, 2, 7, "format", "binary");
    resolve_option(opts, 3, 6, "case", "lower");
    resolve_option(opts, 4, 8, "prompt", "yes");
    resolve_option(opts, 10, 9, "verify", "no");
    resolve_option(opts, 13, 14, "ask", "yes");
    setup_size(5, opts);
    if (opts[11].found) {
	opts[12].found = 0;
    }
    else if (!opts[12].found) {
	opts[12].data = XGetDefault(dpy, myname, "known");
	if (opts[12].data)
	    opts[12].found = 1;
    }
    if (opts[12].found) {
	if (!readKnown()) {
	    eXtinterrupt = 1;
	    goto getout;
	}
    }

    if (!opts[15].found)
	do1req(parm[0], parm[1]);
    else {
	df = fopen(opts[15].data, "r");
	if (!df) {
	    fprintf(stderr, "%s: Cannot open -f '%s'\n", myname, opts[15].data);
	    goto getout;
	}
	line = 0;
	while (fgets(ibuffer, sizeof(ibuffer), df)) {
	    ++line;
	    count = sscanf(ibuffer, " %s %s %c", src, dst, &dummy);
	    if (count == 0 || count == EOF) continue;
	    if (count < 1 || count > 2) {
		fprintf(stderr, "%s: syntax error on line %d '%s'\n",
			    myname, line, opts[15].data);
		break;
	    }
	    if (count == 1)
		strcpy(dst, "*.*");
	    if (do1req(src, dst))
		break;
	    while(head) {
		n = head->next;
		Xfree(head);
		head = n;
	    }
	}
	fclose(df);
    }
getout:
    XCloseDisplay(dpy);
    return(eXtinterrupt);
}
