program Sample;

(*

 This is a sample program that demonstrates the usage of the sample database
 code provided for developers with Wildcat 4.0. The main unit upon which
 the sample database code is built upon is the WcDb unit. This unit contains
 an object that encapsulates a IsamFileBlockPtr that the main database
 routines in Btree Filer utilize.


***** TFileBlock *****

 Here is a list of routines in TFileBlock object contained in WcDb and
 their instructions

 procedure Lock;
   {-Locks the fileblock of the current database. This routine can be
     called multiple times and it will increment a lock count. Unlock
     must be called the same number of times to unlock the database}

 procedure Unlock;
   {-Unlocks the fileblock of the database}

 function BuildKey(const Data; Key : Integer) : IsamKeyStr; virtual;
   {-Builds a database key based on the record passed into the Data
     parameter and the Key that is specified. This routine is overriden
     in each of the database units to returns the proper type of key for
     each database}

 {The following routines work exactly like their counterparts in Filer
  (BtGetRec, BtAddRec, BtPutRec) except you don't have to pass in the
  FileBlockPtr because it is part of the object. In the TVFileBlock
  object these routines are overriden to call the appropriate Filer
  routines from the VRec unit}
 procedure GetRec(RefNr : LongInt; var Data); virtual;
 procedure AddRec(var RefNr : LongInt; var Data); virtual;
 procedure PutRec(RefNr : LongInt; var Data); virtual;


 {The following routines work exactly like their counterparts in
  Filer (BtDeleteRec, BtAddKey, BtDeleteKey, BtDeleteAllKeys, BtRecLen,
  BtFileLen, BtFreeRecs, BtUsedRecs, BtUsedKeys, BtClearKey, BtNextDiffKey,
  BtPrevDiffKey, BtSearchKey, BtKeyExists) except that you don't have to
  pass in the IsamFileBlockPtr parameter that the Filer versions require}
 procedure DelRec(RefNr : LongInt); virtual;
 procedure AddKey(KeyNr : Integer; RefNr : LongInt; Key : IsamKeyStr);
 procedure DeleteKey(KeyNr : Integer; RefNr : LongInt; Key : IsamKeyStr);
 procedure DeleteAllKeys(KeyNr : Integer);
 function RecLen : Word;
 function FileLen : LongInt;
 function FreeRecs : LongInt;
 function UsedRecs : LongInt;
 function UsedKeys(KeyNr : Integer) : LongInt;
 procedure ClearKey(KeyNr : Integer);
 procedure NextDiffKey(KeyNr : Integer; var RefNr : LongInt; var Key : IsamKeyStr);
 procedure PrevDiffKey(KeyNr : Integer; var RefNr : LongInt; var Key : IsamKeyStr);
 procedure SearchKey(KeyNr : Integer; var RefNr : LongInt; var Key : IsamKeyStr);
 function KeyExists(KeyNr : Integer; RefNr : LongInt; Key : IsamKeyStr) : Boolean;


 {The following routines work exactly like their counterparts in
  Filer (BtFindKey, BtNextKey, BtPrevKey) except that you don't have to
  pass the IsamFileBlockPtr to them like the Filer routines. Also these
  routines all return a parameter indicating the success of the operation}
 function FindKey(KeyNr : Integer; var RefNr : LongInt; Key : IsamKeyStr) : Boolean;
 function NextKey(KeyNr : Integer; var RefNr : LongInt; var Key : IsamKeyStr) : Boolean;
 function PrevKey(KeyNr : Integer; var RefNr : LongInt; var Key : IsamKeyStr) : Boolean;

 {The following routines are high level routines for adding, deleting, and
  updating records in the database. Each of these routines will automatically
  add or delete keys for the record in the database. You should use these
  routines for adding, deleting, or updating records in the database
  rather then the lower level versions above}

 function AddRecord(var RefNr : LongInt; var Data) : Boolean; virtual;
  {-Adds a new record to the database and the keys for the record. RefNr
    returns the reference to the new record is added. Data is record to be
    added}
 procedure UpdateRecord(var OldData, NewData);
  {-Update a record in the database, automatically deletes the old
    keys and adds new keys if necessary. OldData is the old record,
    NewData is the new record}
 procedure UpdateRecordKey(const Key : IsamKeyStr; var NewData);
  {-Does a search on the primary key for the database and updates the
    record that the key points to with the new record contained in
    NewData. Automatically updates any keys}
 function DeleteRecord(var Data) : Boolean;
  {-Delete the record Data that is passed in and removes any keys
    associated with that record}
 function DeleteRecordKey(const Key : IsamKeyStr) : Boolean;
  {-Does a search on the primary key of the database and deletes the
    record that uses the Key that is passed in}

 {The following routines are used internally by the database object
  and it's various decendents. You should not have to call these
  routines when using the object}

 procedure FatalDBError(const S : String); virtual;
 procedure LogDBError(const S : String); virtual;
 procedure GetCreateInfo(var Len : Word; var Keys : Integer; var IID : IsamIndDescr); virtual;
 procedure PostCreate; virtual;
 function LockOkay : Boolean;
 procedure PutRecordPrim(RefNr : LongInt; var OldData, NewData); virtual;
 procedure DeleteRecordPrim(RefNr : LongInt; var Data); virtual;

(*************************** TVFileBlock *****************************

 Here is a list of routines from the TVFileBlock object. The TVFileBlock
 object is a object that encapulates a Filer IsamFileBlockPtr that is
 being used to access a database that contains variable sized records using
 the VRec unit that comes with Btree Filer:

 function DataLen(const Data) : Word; virtual;
  {-Returns the len of the variable sized record that is passed in the
    Data parameter}
 procedure GetRec(RefNr : LongInt; var Data); virtual;
  {-Overrides the TFileBlock.GetRec and makes the proper call to load a
    variable sized record}
 procedure AddRec(var RefNr : LongInt; var Data); virtual;
  {-Overrides the TFileBlock.AddRec and makes the proper call to load a
    variable sized record}
 procedure PutRec(RefNr : LongInt; var Data); virtual;
  {-Overrides the TFileBlock.PutRec and makes the proper call to load a
    variable sized record}
 procedure DelRec(RefNr : LongInt); virtual;
  {-Overrides the TFileBlock.DelRec and makes the proper call to load a
    variable sized record}
 procedure GetRecPart(RefNr : LongInt; var Data; Len : Word);
  {-Exactly the same as the BtGetVariableRecPart routine that is in the VRec
    unit except that you don't have to pass the IsamFileBlockPtr paramter}

 {the following routines allow you to get, add, delete, and update fixed
  sized records in a VRec database}
 procedure GetFixedRec(RefNr : LongInt; var Data);
 procedure AddFixedRec(var RefNr : LongInt; var Data);
 procedure DelFixedRec(RefNr : LongInt);
 procedure PutFixedRec(RefNr : LongInt; var Data);

(*************************** TFileDb *****************************

 The TFileDb object is used in accessing the file database. It is
 derived from the TVFileBlock and the TFileBlock objects. This means
 that you can call any routines that are in those objects from this
 object.

 The only methods in this object override methods from the other
 two objects. You should add, delete, and update records in the
 file database calling the high level database routines in the TFileBlock.

 Here is an example of using the file database object:

 var
   RefNr : LongInt;
   Key : IsamKeyStr;


 if FileDb.Init then


(*************************** TUserDb *****************************

 The TUserDb object is used in accessing the user database. It is
 derived from the TFileBlock objects This means that you can call any
 routines that are in TFileBlock from this object.

 The only methods in this object override methods from the other
 two objects. You should add, delete, and update records in the
 user database calling the high level database routines in the TFileBlock.

 The user database only offers access to the fixed portion of a user record.
 Wildcat also keeps a secondary database to store the data that Wildcat
 stores on a conference by conference basis. In order to access this
 information on a user you need to use the TUserWrapper object which hides
 all of the messy stuff for getting access to the conference data. In order
 to construct a TUserWrapper you must first have a TUserRec filled with
 User information from the user database.

 To load a user record you might do something like this:

 var
   RefNr : LongInt;
   UserRec : TUserRec;
   LastRead : Word;

 if not UserDb.Init then begin
   WriteLn('Unable to open the user database');
   Exit;
 end;
 if UserDb.FindKey(UserRealKey, RefNr, 'SCOTT HUNTER') then begin
   UserDb.GetRec(RefNr, UserRec);

 At this point we have a user record loaded and now we will create a
 UserWrapper to access the conference data such as the users last message
 read in a conference.

 UserConfPtr = New(TUserWrapper, Init(@UserRec));
 if UserConfPtr = nil then begin
   {out of memory, display error message}
   Exit;
 end;

 LastRead := UserConfPtr^.GetLastRead(4); {this gets the users last read
                                           message from conference 4}

 Then when we are done with accessing the user record we free the pointer
 to the TUserWrapper:

 Dispose(UserConfPtr, Done);

 Note: You only have to do the work of allocating a UserWrapper if you need
 access to the conference members of a user record. For just accessing a
 TUserRec you don't need any of the following steps.


 constructor Init(var UserRec : TUserRec);
  {-This is used to initial a TUserWrapper for use, pass in the UserRec
    parameter the user whom you wish to do operations on}
 destructor Done; virtual;
  {-Call this when you no longer need your user wrapper}
 procedure SetDirty;
  {-The user wrapper caches data in pages in order to be fast, however
    sometimes you need to force a reload of the data from disk to see
    if changed}
 function GetFlags(Conf : Word) : Byte;
  {-Returns the conference flags for a user in Conf conference. See the
    cuf* flags in WCTYPE.PAS for these flags}
 function FlagIsSet(Mask : Byte; Conf : Word) : Boolean;
  {-Returns a boolean indicating if the flags passed in Mask are set in Conf
   for the user}
 function NextSet(Mask : Byte; Current : Word) : Word;
  {-Will return the next conference after Current that the flags set in
    Mask are set. If none are found the routine will return NoMoreBits}
 function PrevSet(Mask : Byte; Current : Word) : Word;
  {-Will return the previous conference before Current that the flags set in
   Mask are set. If none are found the routine will return NoMoreBits}
 function FirstSet(Mask : Byte) : Word;
  {-Returns the first conference the user has the flags set in Mask set.
    If none are found the routine will return NoMoreBits}
 function LastSet(Mask : Byte) : Word;
  {-Returns the first conference the user has the flags set in Mask set.
    If none are found the routine will return NoMoreBits}
 function FlagsSet(Mask : Byte) : Word;
  {-Returns a count of how many conference the flags past in Mask are set
    for the user}
 procedure SetAllFlags(Mask : Byte);
  {-Sets the flags specified in Mask for all conferences}
 procedure ClearAllFlags(Mask : Byte);
  {-Clears the flags specified in Mask for all conferences}
 procedure ToggleFlag(Mask : Byte; Conf : Word);
  {-Toggles the flags specified in Mask for all conferences}
 function GetLastRead(Conf : Word) : Word;
  {-Returns the user last message read pointer for Conf conference}
 function GetFirstUnread(Conf : Word) : Word;
  {-Returns the first unread message # to the user in conference Conf}
 procedure SetFlags(Conf : Word; NewFlags : Byte);
  {-Sets the flags in NewFlags for the user in conference Conf}
 procedure SetLastRead(Conf, NewLastRead : Word);
  {-Sets the users last read pointer in conference Conf to NewLastRead}
 procedure SetFirstUnread(Conf, NewFirstUnread: Word);
  {-Sets the users first unread pointer in conference Conf to NewFirstUnread}
 procedure SetFlags_LastRead(Conf : Word; NewFlags : Byte; NewLastRead : Word);
  {-Set the users flags to NewFlags and last message read to NewLastRead
    in conference Conf}

 {The following routines are used internally by the user wrapper and
  should not be called directly by your code}
 function GetConfPage(Conf : Word) : Integer;
 procedure LoadConfPage(Conf : Word; ForceLoad : Boolean);
 procedure SaveConfPage;

*)

(*************************** TMsgDb *****************************

 The TMsgDb object is a special object in that with Wildcat 4.0 for the
 first time we are not using Btree Filer for the message sub-system. We
 now use a flat file message system that allows for much faster adding
 of messages to the database. This object still behaves very much like
 a Filer object. You can check IsamOk to check for errors just like you
 would in the other objects. To use the object you call the contructor
 with the conference you wish to access and then call the various members.

 Here is a short example of opening a conference and reading message
 number 100 from conference 0.

 var
   RefNr : LongInt;
   MsgHdr : TMsgHeader;


 if not MsgDb.Init(0) then begin
   WriteLn('Unable to open the message database');
   Exit;
 end;
 RefNr := FindMsg(100);
 if IsamOk then begin
    GetMsgHeaderAndText(RefNr, MsgHdr, 0, SizeOf(Buffer));
    if not IsamOk then
      WriteLn('Error loading message');
 end else
   WriteLn('Unable to find message 100');


 constructor Init(AConf : Word);
  {-Initialize a message database object for the given conference number}
 destructor Done; virtual;
  {-Shut down a conference object, must be called to close files}
 procedure Lock;
  {-Lock the database, used internally by AddMsg and MarkMsgRead}
 procedure Unlock;
  {-UnlockkkkkkkkkkkbBwnc RefNr :ctorref
   ReiNr : Lonmsg   MsgHdr : Tnmsgtext: PMsggHeaonf : Word) : BoolRefInitialize ew record to thet for nitialize hdr :  (msg) to acturn(msgtext)n Mask ord;
  {-Re with  given confereou
h   operation}
 funNr :msgonfnit(ACo
   ReiNr : BoolG for nitialize onfere,
  {-efNr
    returns the onfereoat unit upoffert uasf none operation}
procedNr :msgonfnit(ACo
   ReiNr : BoolG for nitialize onfere,
  {-efNr
    returns the onfereo a relupoffetialize ee sy the useactlyce flllineritialize onfere (ia relupoffe veres   atialize onfere doesRec ectioarkMsgRead}
  funNr :ctorref
   ReiNr: TUserRec);
es and it will inturns the onfereoon't At treferencextplay error meyStr);
 procNr :ctorref
   ReiNr: TUserRec);
es andeit will inturns the onfereoon't At trefereneturn thelay error meyStr);
 egin
Status( Lonmsr   MsgStatus: TUserRec);
es an
  {-Will r ther to liner tord lonfereo a active (noask areould ad)dding
 of a record in thor meyStr);
 egin
Hdr : (ref
   ReiNr : Lonmsg   MsgHdr : : TUserRec);
es angd);
  tialize hdr :  nce flt for turns the onfereor meyStr);
 egin
Hdr : tMsgHeadref
   ReiNr : Lonmsg   MsgHdr : Tnb, Siz: PMsggHea;abassw yolennit(AConf : Wond Ms;
  tialize hdr :  FileBloccturnnce flt for turns the onferen Mask ****bassw o NewFenerRec
   s;
end theneyStr);
eConfPage;cord MasDosold rCrtold rWcTypeold rWcGlobalold rWc


old rWcbegin
old rWc
 ifold rWc
isc,erparts isage 100eration}
rd); like
f : Word) : BoamOk then bBtrd);   i(NetSupthe Type(Mwtor ig.Netto d), MinimizebegOfN
 UslHeap, 0Of(Bufferd); like
f=    if f(Buf  Exit;
100eration}
ord;Makethat( LonMwtor ig
   Makewhatec :
f : Word) : Boce 0.

 F
f  liko a  Makewhatec f(Buffeproc likMdata LastRead : oamOk then bord;Makewhatd;
 alsef(BuffeAssign(F, 'MAKEWILD.DATe databaeproc likMdata =  likMdatdatabae likMdata = SharkMdatdatabaeReset(F)databae likMdata = Sroc likMdatf(Buffer))IoResult <> 0not IsamOk thse');
 baeRead(F, Mwtor ig)databaeord;Makewhatd;
IoResult = 0databaeCalle(F)databaer))IoResult = 0not IsamOk th{ignore}f(Buf  Exit;
100eration}
Regior muf : Word) : BoamOk then bRegior muf
 alsef(Buffer));
 ord;Makethat(Mwtor ig)not IsamOk thse');
 baer));
  d); like
ot IsamOk thse');
 baeOpen lik(Node Get lik, Mwtor ig.Node GetPath+'NODEINFO.DATe MsgHdr, TMfor m GeteOf(BuffeRegior muf
Truef(Buf  Exit;
100esgRead}
 prRegior m : BoamOk then bCalle lik(Node Get lik)f(Buf  Exit;
ce 0.
Highf Usf : Word) :
 var
   RefNr : LoKey : t;
   Key : IsaongInt;
   UserRec : T;
100esgRead}
 CsamOCt down a on DataNctlyr(const ask : , onf to NewFInit(AConf : ce 0.

 Ceturnf : Word) :

 var
   RefNr : LonngInt;
   MsgHdr : TMsgHBoamOk then bif

 if OpenirstUnr alse)not IsamOk thamOk then b

 Ceturnf= 0databae :

 var
=

 if  funNr :onf to NewF)databae :

r));
    if not IsamOk thk then
      WriteLn('Unablfor thr loading messsssssswhliko   if ndosamOk thk thamOk then b

 ufferdc(Ceturg messssssssLonngInDB.egin
Hdr : (erAndText(Refg messssssssLonntructgInt;
dosamOk thk th :

r)) function mags t, mfRecet is)not IsamOk thmOk thk then
     lly 'Text(Nnfere:5, '.

marku doed. Det is,netur link = 'TsamOk thmOk thk thhhhhhhhhproc, NewFi5, '.cextplink = 'T  fun, NewFi5)samOk thmOk thk ');
 end thmOk thk then
     lly 'Text(Nnfere:5, '.

ers firrrrrrrrrrrr,netur link = 'TsamOk thmOk thk thhhhhhhhhproc, NewFi5, '.cextplink = 'T  fun, NewFi5) messssssssLonnif

 Hdr. fun, NewF >

 Hdr.xt(Nnferenot IsamOk thmOk thk amOk then b

 uffe :

 var
=

 if  funNr :
 Hdr. fun, NewF) messssssssLonn :

r));
    if not IsamOk thk thk thk then
      WriteUnablcextplay errtReadhainng messssssssk thk 'ns last read
  ');
 end thmOk thk    if nf
 alsef(Buffek thk 'nsdatabae :

r))Ceturn= 0not IsamOk thk then
     Nodding
 of none,lfor ters fir);
erongng messssssss
 if estrumessssss'ns last ');
 end then
      WriteLn('u wish ut down a c',sk : )f(Buf  Exit;
ce 0.
eys, BtRI thmOk thk f : Word) :NctlyOk thk f const [25]rd) :Io,erpartf to NewFInit(ACrd) :F thmOk thk f  likrd) :Fnone k thk f :eyStr) : BoolamOk thenr));
 Regior muot IsamOk amOk then b
en
      WriteLn('id);
  {-.ng messssssse');
 bae  Exit;
 {.

 The userich
 }thenr));
 
 if not UserDbsamOk amOk then b
en
      WriteLn('Unable to open the use.ng messssssse');
 bae  Exit;
 Inf
1;
 bwhliko  <= PRec
CeturndosamOk amOk then b
Nctlyr=
Nctly+ ' ' + TeteRPRec
Str(I)g messssssrdc(I);
 bae  Exit;
 r))Length(Nctl)n= 0not IsamOk Nctlyr=
'Paul Davis'xit;
 Nctlyr=
TeteRNctl);
 ben
    Nctl);
 bFnone f
 alsef(B
 b
 if not ; {rd);
  {-IgInDB using the ob;
 end;
 if UserDb.FindKey(UserRealKeStUpcase Nctl))not IsamOk amOk then b
begin
   UserDb.GetRec(RefNr, Uae :

r))   if not IsamOk thk amOk then b

 ufc));
 if Us:erConfPtr = New(TUserWraper, Init(@Useeeeeeeeeence Inf
0Ln('Mwtor ig.Maxtor Areas - 1
dosamOk thk th :amOk then b

 uffe :rtf to NewFInLastRead := UserCocedure SetFiIg messssssssk thk tr;
f to NewFI> 0not IsamOk ththmOk thk amOk then b

 uffe :

then
     laiand c',sIg messssssssk thk 

 CsamOCt down a oNctl,sI, onf to NewFg messssssssk thk 

 Fnone f
Truef(Bufssssssssk thk 'nsf(Bufssssssssk 'nsf(Bufssssssssr));
 Fnone are then b

 uffeen
      ence thenor thl waiean ng messssssssk pper:

 Dispose(UserConfPtrssssssk 'nsf(Bufss'ns las');
 end en
      WriteLn('Unabl'T  ctl);
saongrRegior m : 'ns.
