
/************************************************************************
 *
 *	Copyright (c) 1993, 1994 Micro Focus Ltd.
 *
 *	All  rights reserved.  No part of this program or  publication
 *	may  be  reproduced,  transmitted,  transcribed,  stored  in a
 *	retrieval system,  or translated into any language or computer
 *	language, in any form or by any means, electronic, mechanical,
 *	magnetic,  optical, chemical, manual or otherwise, without the
 *	prior written permission of:
 *
 *	Micro Focus Ltd,
 *	26 West Street, Newbury, Berkshire, United Kingdom.             
 *	(0635) 32646
 *
 *	Header structures for CCI modules on all platforms.
 *
 *	Source Module cci.h	Sccs Identification 1.2
 *
 *	Last Modified on 94/02/14 at 12:24:54
 *
 ************************************************************************/

/*
* 	header file for CCI interfacing C module needing support for ANSI
*	style prototyping and K&R style function pointer tables.
*
*	eg. Microsoft C version5.1 upwards, BSD4.4 upwards, and SVR4 upwards.
*	and some UNIX (K&R style)
*	written by SPE 10/9/92 onwards
*/

/* expected definitions

 * #define UNIX		UNIX (all)
 * #define WIN		Windows 3.1
 * #define WIN32	Windows_NT
 * #define OS2		OS/2 16-bit
 * #define OS2_32	OS/2 32-bit
 * #define PROTO	Force ANSI prototyping
 * #define RETTYPE	Standard system return value type

 */

/***************************************************************************
 *
 * 	This file requires definition for a specific CCI protocol to be 
 * 	linked with, this should be specified as follows:
 *
 * 	-DXXXX
 *
 *	Where XXXX is any of the following list:
 *
 *	IPX,ASYNC,NAMP,NAMPU,TCP,NETB,LU2,APPC
 *
 *	This has the effect of defining the entry points for using a single 
 * 	protocol with CCI. 
 *
 *	Alternatively the function pointer table "JMPTAB" may be used to 
 *	effect direct calls into any CCI module without specifically
 * 	coding to use the individual protocol entry points directly.
 *
 *	For applications that wish to utilise multiple CCI protocol suppport
 *	module concurrenntly a single definition should be made to initialise
 *	the JMPTAB, and all access to CCI (with the exception of the first,
 *	initialisation calls) should be made using the supplied function
 *	pointer tables tha addresses of which are provided within the 
 *	parameter block which is returned from the initialisation calls.
 *
 ***************************************************************************/

#ifdef IPX
#define    CCI_Closeserver    CCI_IPX_Closeserver
#define    CCI_Connect	      CCI_IPX_Connect
#define    CCI_Geterror       CCI_IPX_Geterror
#define    CCI_Hangup	      CCI_IPX_Hangup
#define    CCI_Initclient     CCI_IPX_Initclient
#define    CCI_Initserver     CCI_IPX_Initserver
#define    CCI_Query	      CCI_IPX_Query
#define    CCI_Receive	      CCI_IPX_Receive
#define    CCI_Receiveall     CCI_IPX_Receiveall
#define    CCI_Resumeclient   CCI_IPX_Resumeclient
#define    CCI_Resumeserver   CCI_IPX_Resumeserver
#define    CCI_Send	      CCI_IPX_Send
#define    CCI_Suspendclient  CCI_IPX_Suspendclient
#define    CCI_Suspendserver  CCI_IPX_Suspendserver
#define    CCI_Transact       CCI_IPX_Transact
#define    CCI_Wait	      CCI_IPX_Wait
#define    CCI_Trace	      CCI_IPX_Trace
#define    CCI_Timeout	      CCI_IPX_Timeout
#define    CCI_Sleep	      CCI_IPX_Sleep
#endif

#ifdef TCP
#define    CCI_Closeserver    CCI_TCP_Closeserver
#define    CCI_Connect	      CCI_TCP_Connect
#define    CCI_Geterror       CCI_TCP_Geterror
#define    CCI_Hangup	      CCI_TCP_Hangup
#define    CCI_Initclient     CCI_TCP_Initclient
#define    CCI_Initserver     CCI_TCP_Initserver
#define    CCI_Query	      CCI_TCP_Query
#define    CCI_Receive	      CCI_TCP_Receive
#define    CCI_Receiveall     CCI_TCP_Receiveall
#define    CCI_Resumeclient   CCI_TCP_Resumeclient
#define    CCI_Resumeserver   CCI_TCP_Resumeserver
#define    CCI_Send	      CCI_TCP_Send
#define    CCI_Suspendclient  CCI_TCP_Suspendclient
#define    CCI_Suspendserver  CCI_TCP_Suspendserver
#define    CCI_Transact       CCI_TCP_Transact
#define    CCI_Wait	      CCI_TCP_Wait
#define    CCI_Trace	      CCI_TCP_Trace
#define    CCI_Timeout	      CCI_TCP_Timeout
#define    CCI_Sleep	      CCI_TCP_Sleep
#endif

#ifdef ASYNC
#define    CCI_Closeserver    CCI_ASYNC_Closeserver
#define    CCI_Connect	      CCI_ASYNC_Connect
#define    CCI_Geterror       CCI_ASYNC_Geterror
#define    CCI_Hangup	      CCI_ASYNC_Hangup
#define    CCI_Initclient     CCI_ASYNC_Initclient
#define    CCI_Initserver     CCI_ASYNC_Initserver
#define    CCI_Query	      CCI_ASYNC_Query
#define    CCI_Receive	      CCI_ASYNC_Receive
#define    CCI_Receiveall     CCI_ASYNC_Receiveall
#define    CCI_Resumeclient   CCI_ASYNC_Resumeclient
#define    CCI_Resumeserver   CCI_ASYNC_Resumeserver
#define    CCI_Send	      CCI_ASYNC_Send
#define    CCI_Suspendclient  CCI_ASYNC_Suspendclient
#define    CCI_Suspendserver  CCI_ASYNC_Suspendserver
#define    CCI_Transact       CCI_ASYNC_Transact
#define    CCI_Wait	      CCI_ASYNC_Wait
#define    CCI_Trace	      CCI_ASYNC_Trace
#define    CCI_Timeout	      CCI_ASYNC_Timeout
#define    CCI_Sleep	      CCI_ASYNC_Sleep
#endif

#ifdef NAMP
#define    CCI_Closeserver    CCI_NAMP_Closeserver
#define    CCI_Connect	      CCI_NAMP_Connect
#define    CCI_Geterror       CCI_NAMP_Geterror
#define    CCI_Hangup	      CCI_NAMP_Hangup
#define    CCI_Initclient     CCI_NAMP_Initclient
#define    CCI_Initserver     CCI_NAMP_Initserver
#define    CCI_Query	      CCI_NAMP_Query
#define    CCI_Receive	      CCI_NAMP_Receive
#define    CCI_Receiveall     CCI_NAMP_Receiveall
#define    CCI_Resumeclient   CCI_NAMP_Resumeclient
#define    CCI_Resumeserver   CCI_NAMP_Resumeserver
#define    CCI_Send	      CCI_NAMP_Send
#define    CCI_Suspendclient  CCI_NAMP_Suspendclient
#define    CCI_Suspendserver  CCI_NAMP_Suspendserver
#define    CCI_Transact       CCI_NAMP_Transact
#define    CCI_Wait	      CCI_NAMP_Wait
#define    CCI_Trace	      CCI_NAMP_Trace
#define    CCI_Timeout	      CCI_NAMP_Timeout
#define    CCI_Sleep	      CCI_NAMP_Sleep
#endif

#ifdef NAMPU
#define    CCI_Closeserver    CCI_NAMPU_Closeserver
#define    CCI_Connect	      CCI_NAMPU_Connect
#define    CCI_Geterror       CCI_NAMPU_Geterror
#define    CCI_Hangup	      CCI_NAMPU_Hangup
#define    CCI_Initclient     CCI_NAMPU_Initclient
#define    CCI_Initserver     CCI_NAMPU_Initserver
#define    CCI_Query	      CCI_NAMPU_Query
#define    CCI_Receive	      CCI_NAMPU_Receive
#define    CCI_Receiveall     CCI_NAMPU_Receiveall
#define    CCI_Resumeclient   CCI_NAMPU_Resumeclient
#define    CCI_Resumeserver   CCI_NAMPU_Resumeserver
#define    CCI_Send	      CCI_NAMPU_Send
#define    CCI_Suspendclient  CCI_NAMPU_Suspendclient
#define    CCI_Suspendserver  CCI_NAMPU_Suspendserver
#define    CCI_Transact       CCI_NAMPU_Transact
#define    CCI_Wait	      CCI_NAMPU_Wait
#define    CCI_Trace	      CCI_NAMPU_Trace
#define    CCI_Timeout	      CCI_NAMPU_Timeout
#define    CCI_Sleep	      CCI_NAMPU_Sleep
#endif

#ifdef NETB
#define    CCI_Closeserver    CCI_NETB_Closeserver
#define    CCI_Connect	      CCI_NETB_Connect
#define    CCI_Geterror       CCI_NETB_Geterror
#define    CCI_Hangup	      CCI_NETB_Hangup
#define    CCI_Initclient     CCI_NETB_Initclient
#define    CCI_Initserver     CCI_NETB_Initserver
#define    CCI_Query	      CCI_NETB_Query
#define    CCI_Receive	      CCI_NETB_Receive
#define    CCI_Receiveall     CCI_NETB_Receiveall
#define    CCI_Resumeclient   CCI_NETB_Resumeclient
#define    CCI_Resumeserver   CCI_NETB_Resumeserver
#define    CCI_Send	      CCI_NETB_Send
#define    CCI_Suspendclient  CCI_NETB_Suspendclient
#define    CCI_Suspendserver  CCI_NETB_Suspendserver
#define    CCI_Transact       CCI_NETB_Transact
#define    CCI_Wait	      CCI_NETB_Wait
#define    CCI_Trace	      CCI_NETB_Trace
#define    CCI_Timeout	      CCI_NETB_Timeout
#define    CCI_Sleep	      CCI_NETB_Sleep
#endif

#ifdef APPC
#define    CCI_Closeserver    CCI_APPC_Closeserver
#define    CCI_Connect	      CCI_APPC_Connect
#define    CCI_Geterror       CCI_APPC_Geterror
#define    CCI_Hangup	      CCI_APPC_Hangup
#define    CCI_Initclient     CCI_APPC_Initclient
#define    CCI_Initserver     CCI_APPC_Initserver
#define    CCI_Query	      CCI_APPC_Query
#define    CCI_Receive	      CCI_APPC_Receive
#define    CCI_Receiveall     CCI_APPC_Receiveall
#define    CCI_Resumeclient   CCI_APPC_Resumeclient
#define    CCI_Resumeserver   CCI_APPC_Resumeserver
#define    CCI_Send	      CCI_APPC_Send
#define    CCI_Suspendclient  CCI_APPC_Suspendclient
#define    CCI_Suspendserver  CCI_APPC_Suspendserver
#define    CCI_Transact       CCI_APPC_Transact
#define    CCI_Wait	      CCI_APPC_Wait
#define    CCI_Trace	      CCI_APPC_Trace
#define    CCI_Timeout	      CCI_APPC_Timeout
#define    CCI_Sleep	      CCI_APPC_Sleep
#endif

#ifdef LU2
#define    CCI_Closeserver    CCI_LU2_Closeserver
#define    CCI_Connect	      CCI_LU2_Connect
#define    CCI_Geterror       CCI_LU2_Geterror
#define    CCI_Hangup	      CCI_LU2_Hangup
#define    CCI_Initclient     CCI_LU2_Initclient
#define    CCI_Initserver     CCI_LU2_Initserver
#define    CCI_Query	      CCI_LU2_Query
#define    CCI_Receive	      CCI_LU2_Receive
#define    CCI_Receiveall     CCI_LU2_Receiveall
#define    CCI_Resumeclient   CCI_LU2_Resumeclient
#define    CCI_Resumeserver   CCI_LU2_Resumeserver
#define    CCI_Send	      CCI_LU2_Send
#define    CCI_Suspendclient  CCI_LU2_Suspendclient
#define    CCI_Suspendserver  CCI_LU2_Suspendserver
#define    CCI_Transact       CCI_LU2_Transact
#define    CCI_Wait	      CCI_LU2_Wait
#define    CCI_Trace	      CCI_LU2_Trace
#define    CCI_Timeout	      CCI_LU2_Timeout
#define    CCI_Sleep	      CCI_LU2_Sleep
#endif

#ifdef DDE
#define    CCI_Closeserver    CCI_DDE_Closeserver
#define    CCI_Connect	      CCI_DDE_Connect
#define    CCI_Geterror       CCI_DDE_Geterror
#define    CCI_Hangup	      CCI_DDE_Hangup
#define    CCI_Initclient     CCI_DDE_Initclient
#define    CCI_Initserver     CCI_DDE_Initserver
#define    CCI_Query	      CCI_DDE_Query
#define    CCI_Receive	      CCI_DDE_Receive
#define    CCI_Receiveall     CCI_DDE_Receiveall
#define    CCI_Resumeclient   CCI_DDE_Resumeclient
#define    CCI_Resumeserver   CCI_DDE_Resumeserver
#define    CCI_Send	      CCI_DDE_Send
#define    CCI_Suspendclient  CCI_DDE_Suspendclient
#define    CCI_Suspendserver  CCI_DDE_Suspendserver
#define    CCI_Transact       CCI_DDE_Transact
#define    CCI_Wait	      CCI_DDE_Wait
#define    CCI_Trace	      CCI_DDE_Trace
#define    CCI_Timeout	      CCI_DDE_Timeout
#define    CCI_Sleep	      CCI_DDE_Sleep
#endif

/* specify special system call conventions */
#if defined(DOS)
#    define CCICALLTYPE  _far _pascal
#endif

#if defined(OS2)
#    define CCICALLTYPE  _far _pascal
#endif

#if defined(WIN)
#   define CCICALLTYPE  _far _export _pascal
#   include <windows.h>
#endif

#if defined(WIN32)
#   include <windows.h>
#   include <windowsx.h>
#endif

/* no special call convention specified, use system default */
#ifndef CCICALLTYPE
#   define CCICALLTYPE	 
#endif

/* no special return type specified, use default */
#ifndef RETTYPE
#   define RETTYPE int
#endif

/* Windows specific call convention */
#if defined(WIN) || defined(WIN32)
#   define CALLBACK CALLBACK
#endif

/* no special type for call-back functions, use system default */
#ifndef CALLBACK
#   define CALLBACK
#endif

#include "mf_types.h"		/* standard Micro Focus type definitions
				   used to enhance portability, this file
				   is shipped with toolset, toolbox and 
				   worklbench products from Micro Focus */

#if defined(PROTO) || defined(__STDC__)
/*****************************************************************************/
/*									     */
/*     Definition of CCI-Sleep call-back routine			     */
/*									     */
/* This function is user defined, except for the call interface. It is	     */
/* called when an event occurs that has been given to CCI-Sleep which is     */
/* available in version 4 or above of CCI on all platforms.		     */
/*									     */
/* If an async handle is active it means that there is an event which has    */
/* occured during the execuion of the outstanding asynchronous call. This    */
/* event could be completion notification, error notification, or time-out   */
/* notification. The asynch handle should be given to CCI-Query to determine */
/* what has occurred.							     */
/*									     */
/* If a session handle is active (not NULL), it means that an event has      */
/* occured on the session given, which has been previously posted as an event*/
/* generated session in a call to CCI-Sleep. A CCI-Read call should be made  */
/* on the sessions concerned to determine what actually happened.	     */
/*									     */
/* If a server handle is active (not NULL) it means that a new connection has*/
/* been detected by CCI and that a CCI-Receiveall or CCI-Connect should be   */
/* issued to accept it, or that new data has been detected destined for a    */
/* session that is associated with this serverhandle. A CCI-Receiveall should*/
/* be issued to accept the incoming data. 				     */
/*									     */
/*****************************************************************************/

RETTYPE CALLBACK call_back(mf_uns32 *,	/* server-handle active (or NULL)   */
			mf_uns32 *,	/* sessionid active (or NULL)	    */
			mf_uns32 *,	/* async handle active (or NULL)    */ 
			mf_uns32 *,	/* status (reason for call)	    */
			mf_uns32 *,	/* unused */
			mf_uns32 *,	/* unused */
			mf_uns32 *);	/* unused */


/*****************************************************************************/
/*     Structure for ANSI CCI routines jump table                            */
/*****************************************************************************/
struct JMPTAB
{
    RETTYPE (CCICALLTYPE *JMP_Initserver)	(char *,
 					 mf_s32 *,
 					 mf_uns32 *);
 
    RETTYPE (CCICALLTYPE *JMP_Closeserver)	(mf_s32 *);
 
    RETTYPE (CCICALLTYPE *JMP_Initclient)	(char *,
 					 char *,
 					 mf_s32 *,
 					 mf_s32 *,
 					 mf_uns32 *);
 
    RETTYPE (CCICALLTYPE *JMP_Closeclient)	(mf_s32 *);
 
    RETTYPE (CCICALLTYPE *JMP_Hangup)	(mf_s32 *);
 
    RETTYPE (CCICALLTYPE *JMP_Send)	(mf_s32 *,
 					 char *,
 					 mf_uns32 *,
 					 mf_s32 *,
 					 mf_uns32 *);
 
    RETTYPE (CCICALLTYPE *JMP_Receive)	(mf_s32 *,
 					 char *,
 					 mf_uns32 *,
 					 mf_uns32 *,
 					 mf_s32 *,
 					 mf_uns32 *);
 
    RETTYPE (CCICALLTYPE *JMP_Receiveall)	(mf_s32 *,
 					 mf_s32 *,
 					 char *,
 					 mf_uns32 *,
 					 mf_uns32 *,
 					 mf_s32 *,
 					 mf_uns32 *);
 
    RETTYPE (CCICALLTYPE *JMP_Transact)	(mf_s32 *,
 					 char *,
 					 mf_uns32 *,
 					 mf_uns32 *,
 					 mf_uns32 *,
 					 mf_uns32 *);
 
    RETTYPE (CCICALLTYPE *JMP_Connect)	(mf_s32 *,
 					 mf_s32 *,
 					 mf_s32 *,
 					 mf_uns32 *);
 
    RETTYPE (CCICALLTYPE *JMP_Wait)	(mf_s32 *);

    RETTYPE (CCICALLTYPE *JMP_Query) 	(mf_s32 *);
 
    RETTYPE (CCICALLTYPE *JMP_Resumeclient)(mf_s32 *,
 					 mf_s32 *,
 					 mf_uns32 *);
 
    RETTYPE (CCICALLTYPE *JMP_Suspendclient) (mf_s32 *);
 
    RETTYPE (CCICALLTYPE *JMP_Resumeserver)(mf_s32 *,
 					 mf_s32 *,
 					 mf_uns32 *);
 
    RETTYPE (CCICALLTYPE *JMP_Suspendserver) (mf_s32 *);
 
    RETTYPE (CCICALLTYPE *JMP_Geterror)	(char *,
 					 mf_uns32 *,
 					 mf_uns32 *);
 
    RETTYPE (CCICALLTYPE *JMP_Trace)	(mf_uns32 *,
					 char *,
					 mf_uns32 *);
    RETTYPE (CCICALLTYPE *JMP_Timeout)	(mf_uns32 *,
					 mf_uns32 *,
					 mf_uns32 *,
					 mf_uns32 *);
    RETTYPE (CCICALLTYPE *JMP_Sleep)	(mf_uns32 *,
					 mf_uns32 *,
					 mf_uns32 *,
					 mf_uns32 *,
					 mf_uns32 *);
 
};
 
/*****************************************************************************/
/*     Structure for ANSI CCI signature block                                */
/*****************************************************************************/
struct SIGNATURE
{
    unsigned char   CCIsign[6];
    unsigned char   CCItype[8];
    unsigned char   CCIversn[6];
    struct  JMPTAB *CCItabptr;
};

/*****************************************************************************/
/*     Entry point definitions                                               */
/*     Entry point function prototypes                                       */
/*****************************************************************************/

#if defined(OS2_32) || defined(WIN32)

/* define the real entry points used in 32-bit CCI modules */
RETTYPE CCICALLTYPE CCINP32(struct SIGNATURE *);
RETTYPE CCICALLTYPE CCINU32(struct SIGNATURE *);
RETTYPE CCICALLTYPE CCIIX32(struct SIGNATURE *);
RETTYPE CCICALLTYPE CCINB32(struct SIGNATURE *);
RETTYPE CCICALLTYPE CCIAP32(struct SIGNATURE *);
RETTYPE CCICALLTYPE CCITC32(struct SIGNATURE *);
RETTYPE CCICALLTYPE CCIL232(struct SIGNATURE *);
RETTYPE CCICALLTYPE CCIDE32(struct SIGNATURE *);
RETTYPE CCICALLTYPE CCIAS32(struct SIGNATURE *);

/* re-define existing entry points so you don't have to change code */
#define CCINAMP  	CCINP32
#define CCINAMPU	CCINU32
#define CCIIPX		CCIIX32
#define CCINETB		CCINB32
#define CCIAPPC		CCIAP32
#define CCITCP		CCITC32
#define CCILU2		CCIL232
#define CCIDDE		CCIDE32
#define CCIASYNC	CCIAS32

#else

/* define CCI entry points 16-bit and UNIX 32-bit */
RETTYPE CCICALLTYPE CCINAMP(struct SIGNATURE *);
RETTYPE CCICALLTYPE CCINAMPU(struct SIGNATURE *);
RETTYPE CCICALLTYPE CCIIPX(struct SIGNATURE *);
RETTYPE CCICALLTYPE CCINETB(struct SIGNATURE *);
RETTYPE CCICALLTYPE CCIAPPC(struct SIGNATURE *);
RETTYPE CCICALLTYPE CCITCP(struct SIGNATURE *);
RETTYPE CCICALLTYPE CCILU2(struct SIGNATURE *);
RETTYPE CCICALLTYPE CCIDDE(struct SIGNATURE *);
RETTYPE CCICALLTYPE CCIASYNC(struct SIGNATURE *);

#endif


RETTYPE CCICALLTYPE CCI_Closeclient    	(mf_uns32 *);
RETTYPE CCICALLTYPE CCI_Closeserver    	(mf_uns32 *);
RETTYPE CCICALLTYPE CCI_Connect        	(mf_uns32 *,
                    			mf_uns32 *,
                    			mf_s32 *,
		    			mf_uns32 *);
RETTYPE CCICALLTYPE CCI_Geterror       	(char *,
                    			mf_uns32 *,
                    			mf_uns32 *);
RETTYPE CCICALLTYPE CCI_Hangup         	(mf_uns32 *);
RETTYPE CCICALLTYPE CCI_Initclient     	(char *,
                    			char *,
                    			mf_uns32 *,
                    			mf_s32 *,
                    			mf_uns32 *);
RETTYPE CCICALLTYPE CCI_Initserver     	(char *,
                    			mf_uns32 *,
                    			mf_uns32 *);
RETTYPE CCICALLTYPE CCI_Query          	(mf_s32 *);
RETTYPE CCICALLTYPE CCI_Receive         (mf_uns32 *,
                                        char *,
                                        mf_uns32 *,
                                        mf_uns32 *,
                                        mf_s32 *,
                                        mf_uns32 *);
RETTYPE CCICALLTYPE CCI_Receiveall      (mf_uns32 *,
                                        mf_uns32 *,
                                        char *,
                                        mf_uns32 *,
                                        mf_uns32 *,
                                        mf_s32 *,
					mf_uns32 *);

RETTYPE CCICALLTYPE CCI_Resumeclient     (mf_uns32 *,
					mf_uns32 *,
					mf_uns32 *);
RETTYPE CCICALLTYPE CCI_Resumeserver    (mf_uns32 *,
					mf_s32 *,
					mf_uns32 *);
RETTYPE CCICALLTYPE CCI_Send            (mf_uns32 *,
                              		char *,
                              		mf_uns32 *,
                              		mf_s32 *,
                              		mf_uns32 *);
RETTYPE CCICALLTYPE CCI_Suspendclient  (mf_uns32 *);
RETTYPE CCICALLTYPE CCI_Suspendserver  (mf_uns32 *);
RETTYPE CCICALLTYPE CCI_Transact       (mf_uns32 *,
					char *,
					mf_uns32 *,
					mf_uns32 *,
					mf_uns32 *,
					mf_uns32 *);
RETTYPE CCICALLTYPE CCI_Wait             (mf_s32 *);
RETTYPE CCICALLTYPE CCI_Timeout		(mf_uns32 *,
					 mf_uns32 *,
					 mf_uns32 *,
					 mf_uns32 *);
RETTYPE CCICALLTYPE CCI_Sleep		(mf_uns32 *,
					 mf_uns32 *,
					 mf_uns32 *,
					 mf_uns32 *,
					 mf_uns32 *);
 
#else /* NON-ANSI type definitions from here downwards */

/****************************************************************************
 *	definition of user procedure call_back, please see the ANSI
 *	definitions section above for details of call_back and its
 * 	use.
 ****************************************************************************/
RETTYPE CALLBACK call_back();

/*****************************************************************************/
/*     Entry point definitions                                               */
/*****************************************************************************/

#if defined(OS2_32) || defined(WIN32)

/* define the real entry points used in 32-bit CCI modules */
RETTYPE CCICALLTYPE CCINU32();
RETTYPE CCICALLTYPE CCIIX32();
RETTYPE CCICALLTYPE CCINB32();
RETTYPE CCICALLTYPE CCIAP32();
RETTYPE CCICALLTYPE CCITC32();
RETTYPE CCICALLTYPE CCIL232();
RETTYPE CCICALLTYPE CCIDE32();
RETTYPE CCICALLTYPE CCIAS32();

/* re-define existing entry points so you don't have to change code */
#define CCINAMP  	CCINP32
#define CCINAMPU	CCINU32
#define CCIIPX		CCIIX32
#define CCINETB		CCINB32
#define CCIAPPC		CCIAP32
#define CCITCP		CCITC32
#define CCILU2		CCIL232
#define CCIDDE		CCIDE32
#define CCIASYNC	CCIAS32

#else

/* define CCI entry points 16-bit and UNIX 32-bit */
RETTYPE CCICALLTYPE CCINAMP();
RETTYPE CCICALLTYPE CCINAMPU();
RETTYPE CCICALLTYPE CCIIPX();
RETTYPE CCICALLTYPE CCINETB();
RETTYPE CCICALLTYPE CCIAPPC();
RETTYPE CCICALLTYPE CCITCP();
RETTYPE CCICALLTYPE CCILU2();
RETTYPE CCICALLTYPE CCIDDE();
RETTYPE CCICALLTYPE CCIASYNC();

#endif


RETTYPE CCICALLTYPE CCI_Closeclient();
RETTYPE CCICALLTYPE CCI_Closeserver();
RETTYPE CCICALLTYPE CCI_Connect();
RETTYPE CCICALLTYPE CCI_Geterror();
RETTYPE CCICALLTYPE CCI_Hangup();
RETTYPE CCICALLTYPE CCI_Initclient();
RETTYPE CCICALLTYPE CCI_Initserver();
RETTYPE CCICALLTYPE CCI_Query();
RETTYPE CCICALLTYPE CCI_Receive();
RETTYPE CCICALLTYPE CCI_Receiveall();
RETTYPE CCICALLTYPE CCI_Resumeclient();
RETTYPE CCICALLTYPE CCI_Resumeserver();
RETTYPE CCICALLTYPE CCI_Send();
RETTYPE CCICALLTYPE CCI_Suspendclient();
RETTYPE CCICALLTYPE CCI_Suspendserver();
RETTYPE CCICALLTYPE CCI_Transact();
RETTYPE CCICALLTYPE CCI_Wait();
RETTYPE CCICALLTYPE CCI_Timeout();
RETTYPE CCICALLTYPE CCI_Sleep();
 
/*****************************************************************************/
/*     Structure for NON-ANSI CCI routines function pointer table            */
/*****************************************************************************/
struct JMPTAB 
{
    RETTYPE (CCICALLTYPE *JMP_Initserver)();
    RETTYPE (CCICALLTYPE *JMP_Closeserver)();
    RETTYPE (CCICALLTYPE *JMP_Initclient)();
    RETTYPE (CCICALLTYPE *JMP_Closeclient)();
    RETTYPE (CCICALLTYPE *JMP_Hangup)();
    RETTYPE (CCICALLTYPE *JMP_Send)();
    RETTYPE (CCICALLTYPE *JMP_Receive)();
    RETTYPE (CCICALLTYPE *JMP_Receiveall)();
    RETTYPE (CCICALLTYPE *JMP_Transact)();
    RETTYPE (CCICALLTYPE *JMP_Connect)();
    RETTYPE (CCICALLTYPE *JMP_Wait)();
    RETTYPE (CCICALLTYPE *JMP_Query)();
    RETTYPE (CCICALLTYPE *JMP_Resumeclient)();
    RETTYPE (CCICALLTYPE *JMP_Suspendclient)();
    RETTYPE (CCICALLTYPE *JMP_Resumeserver)();
    RETTYPE (CCICALLTYPE *JMP_Suspendserver)();
    RETTYPE (CCICALLTYPE *JMP_Geterror)();
    RETTYPE (CCICALLTYPE *JMP_Trace)();
    RETTYPE (CCICALLTYPE *JMP_Timeout)();
    RETTYPE (CCICALLTYPE *JMP_Sleep)(); 
};

/*****************************************************************************/
/*     Structure for ANSI CCI signature block				     */
/*****************************************************************************/
struct SIGNATURE
{
    unsigned char   CCIsign[6];
    unsigned char   CCItype[8];
    unsigned char   CCIversn[6];
    struct  JMPTAB *CCItabptr;
};
#endif


