; ---------------------------------------------------------------------
;
; MathDisp.Asm - Math Components Dispatch - QuickTime for Windows
;
;                Version 1.0
;
;                (c) 1988-1993 Apple Computer, Inc. All Rights Reserved.
;
; ---------------------------------------------------------------------


        .MODEL SMALL, C
        .386

        .CODE

         ASSUME DS: DGROUP


;///////////////////////////////////////////////////////////////////////////
; ComponentFunc Macro
;    Define code to create a table entry for each function

ComponentFunc MACRO sel:req, name:req
   EXTERN   cf&name:NEAR               ; declare the name external
   DW       cf&name                    ; define the table entry
ENDM


;///////////////////////////////////////////////////////////////////////////
; AddJumpTable
;    Create the Jump Table for all Add functions

AddJumpTable:
   INCLUDE addfs.inc


;///////////////////////////////////////////////////////////////////////////
; AddSelectorTable
;    Create the Selector Table for all Add functions

AddSelectorTable:
   EXTERN  C cfAddOpenSelect:NEAR
   DW        cfAddOpenSelect
   EXTERN  C cfAddCloseSelect:NEAR
   DW        cfAddCloseSelect
   EXTERN  C cfAddCanDoSelect:NEAR
   DW        cfAddCanDoSelect
   EXTERN  C cfAddVersionSelect:NEAR
   DW        cfAddVersionSelect
   EXTERN  C cfAddRegisterSelect:NEAR
   DW        cfAddRegisterSelect
   EXTERN  C cfAddTargetSelect:NEAR
   DW        cfAddTargetSelect

;///////////////////////////////////////////////////////////////////////////
; AddEntryPoint
;    Add Entry Point from Component Manager

AddEntryPoint PROC FAR
   cmp   bx, 0                         ; see if selector is special negative
   jl    NegativeSelector              ; yes, go deal with it
   cmp   bx, kAddFunctionCount         ; ensure function selector within range
   jge   BadSelector                   ; no  - error return
   add   bx, bx                        ; yes - build jump table pointer
   mov   ax, DGROUP                    ; set DS for this DLL
   mov   ds, ax
   jmp   WORD PTR cs:AddJumpTable [bx] ; jump into selected function
NegativeSelector:
   neg   bx                            ; make positive
   dec   bx                            ; make base zero
   add   bx, bx                        ; make selector table pointer
   mov   ax, DGROUP                    ; set DS for this DLL
   mov   ds, ax
   jmp   WORD PTR cs:AddSelectorTable [bx] ; jump into selector function
BadSelector:
   mov   dx, 08000h                    ; load special error return
   mov   ax, 08002h                    ; badComponentSelector
   ret
AddEntryPoint ENDP


;///////////////////////////////////////////////////////////////////////////
; SumJumpTable
;    Create the Jump Table for all Sum functions

SumJumpTable:
   INCLUDE sumfs.inc


;///////////////////////////////////////////////////////////////////////////
; SumSelectorTable
;    Create the Selector Table for all Sum functions

SumSelectorTable:
   EXTERN  C cfSumOpenSelect:NEAR
   DW        cfSumOpenSelect
   EXTERN  C cfSumCloseSelect:NEAR
   DW        cfSumCloseSelect
   EXTERN  C cfSumCanDoSelect:NEAR
   DW        cfSumCanDoSelect
   EXTERN  C cfSumVersionSelect:NEAR
   DW        cfSumVersionSelect
   EXTERN  C cfSumRegisterSelect:NEAR
   DW        cfSumRegisterSelect
   EXTERN  C cfSumTargetSelect:NEAR
   DW        cfSumTargetSelect


;///////////////////////////////////////////////////////////////////////////
; SumEntryPoint
;  Sum Entry Point from Component Manager

SumEntryPoint PROC FAR
   cmp   bx, 0                         ; see if selector is special negative
   jl    NegativeSelector              ; yes, go deal with it
   cmp   bx, kSumFunctionCount         ; ensure function selector within range
   jge   BadSelector                   ; no  - error return
   add   bx, bx                        ; yes - build jump table pointer
   mov   ax, DGROUP                    ; set DS for this DLL
   mov   ds, ax
   jmp   WORD PTR cs:SumJumpTable [bx] ; jump into selected function
NegativeSelector:
   neg   bx                            ; make positive
   dec   bx                            ; make base zero
   add   bx, bx                        ; make selector table pointer
   mov   ax, DGROUP                    ; set DS for this DLL
   mov   ds, ax
   jmp   WORD PTR cs:SumSelectorTable [bx] ; jump into selector function
BadSelector:
   mov   dx, 08000h                    ; load special error return
   mov   ax, 08002h                    ; badComponentSelector
   ret
SumEntryPoint ENDP

END
