
// ---------------------------------------------------------------------
//
// BigEight.c - Sample QuickTime for Windows Application
//
//              (c) 1988-1992 Apple Computer, Inc. All Rights Reserved.
//
// ---------------------------------------------------------------------

#include <windows.h>
#include <stdlib.h>
#include <qtw.h>
#include "bigeight.h"

long FAR PASCAL __export WndProc (HWND, UINT, WPARAM, LPARAM);

MovieController mcController;

int PASCAL WinMain (HINSTANCE hInstance, HINSTANCE hPrevInstance,
   LPSTR lpszCmdParam, int nCmdShow)
   {
   static char szAppName[] = "BigEight";
   HWND        hWnd;
   MSG         msg;
   WNDCLASS    wndclass;
   Movie       mMovie;
   RECT        rcMovie, rcMovieBox;
   MovieFile   mfMovie;

// Establish links to QuickTime for Windows

   if (QTInitialize (NULL))
      {
      MessageBox (NULL, "QTInitialize failure", szAppName, MB_OK);
      return 0;
      }

// Allocate memory required for playing movies

   if (EnterMovies ())
      {
      MessageBox (NULL, "EnterMovies failure", szAppName, MB_OK);
      return 0;
      }

// Register and create main window

   if (!hPrevInstance)
      {
      wndclass.style         = CS_DBLCLKS | CS_HREDRAW | CS_VREDRAW;
      wndclass.lpfnWndProc   = WndProc;
      wndclass.cbClsExtra    = 0;
      wndclass.cbWndExtra    = 0;
      wndclass.hInstance     = hInstance;
      wndclass.hIcon         = LoadIcon (NULL,IDI_APPLICATION);
      wndclass.hCursor       = LoadCursor (NULL, IDC_ARROW);
      wndclass.hbrBackground = (HBRUSH) (COLOR_WINDOW + 1);
      wndclass.lpszMenuName  = szAppName;
      wndclass.lpszClassName = szAppName;

      if (!RegisterClass (&wndclass))
         {
         MessageBox (NULL, "RegisterClass failure", szAppName, MB_OK);
         return 0;
         }
      }

   hWnd = CreateWindow (szAppName, szAppName, WS_OVERLAPPEDWINDOW |
      WS_CLIPCHILDREN, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
      CW_USEDEFAULT, NULL, NULL, hInstance, NULL);

   if (hWnd == NULL)
      {
      MessageBox (NULL, "CreateWindow failure", szAppName, MB_OK);
      return 0;
      }

// Instantiate the movie

   if (OpenMovieFile ("SAMPLE.MOV", &mfMovie, OF_READ) != noErr)
      {
      MessageBox (NULL, "OpenMovieFile failure", szAppName, MB_OK);
      return 0;
      }

   NewMovieFromFile (&mMovie, mfMovie, NULL, NULL, 0, NULL);
   CloseMovieFile (mfMovie);

// Instantiate the movie controller

   GetMovieBox (mMovie, &rcMovieBox);
   OffsetRect(&rcMovieBox, -rcMovieBox.left, -rcMovieBox.top);

   GetClientRect (hWnd, &rcMovie);
   rcMovie.top = (rcMovie.bottom / 2) - (rcMovieBox.bottom / 2);
   rcMovie.bottom = rcMovie.top + rcMovieBox.bottom;
   rcMovie.left = (rcMovie.right / 2) - (rcMovieBox.right / 2);
   rcMovie.right = rcMovie.left + rcMovieBox.right;

   mcController = NewMovieController (mMovie, &rcMovie,
      mcTopLeftMovie + mcScaleMovieToFit + mcWithBadge, hWnd);

// Make the movie paused initially

   MCDoAction (mcController, mcActionPlay, 0);

// Enable the keyboard interface

   MCDoAction (mcController, mcActionSetKeysEnabled, (LPVOID) TRUE);

// Make the movie active

   SetMovieActive (mMovie, TRUE);

// Make the main window visible

   ShowWindow (hWnd, nCmdShow);
   UpdateWindow (hWnd);

// Play the movie

   while (GetMessage (&msg, NULL, 0, 0))
      {
      TranslateMessage (&msg);
      DispatchMessage (&msg);
      }

// Destroy the movie controller

   DisposeMovieController (mcController);

// Destroy the movie

   DisposeMovie (mMovie);

// Cut the connections to QuickTime for Windows

   ExitMovies ();
   QTTerminate ();

// Return to Windows

   return msg.wParam;
   }

long FAR PASCAL __export WndProc (HWND hWnd, UINT message, WPARAM wParam,
   LPARAM lParam)
   {
   PAINTSTRUCT ps;
   RECT        rcGrowBox;

   static BOOL bControllerVisible = TRUE;
   static BOOL bGrowBoxVisible = TRUE;
   static BOOL bKeysEnabled = TRUE;
   static BOOL bLoopingEnabled = FALSE;
   static BOOL bPalindromeEnabled = FALSE;
   static BOOL bSoundEnabled = TRUE;
   static BOOL bSpeakerVisible = TRUE;
   static BOOL bSteppersVisible = TRUE;

// Drive the movie controller

   if (MCIsPlayerMessage (mcController, hWnd, message, wParam, lParam))
      return 0;

// Process the windows message

   switch (message)
      {
      case WM_COMMAND:
         {
         HANDLE hMenu;

         hMenu= GetMenu (hWnd);

         switch (wParam)
            {
            case IDM_CONTROLLER:
               {
               if (bControllerVisible == FALSE)
                  {

               // Change the controller menu item

                  ModifyMenu (hMenu, IDM_CONTROLLER, MF_BYCOMMAND |
                     MF_STRING, IDM_CONTROLLER,
                     (LPSTR) "Hide Controller");
                  bControllerVisible = TRUE;

               // Show the controller

                  MCSetVisible (mcController, TRUE);

               // Ungray the other menu itmes

                  EnableMenuItem (hMenu, IDM_STEP_BUTTONS, MF_ENABLED);
                  EnableMenuItem (hMenu, IDM_SPEAKER_BUTTON, MF_ENABLED);
                  EnableMenuItem (hMenu, IDM_GROW_BOX, MF_ENABLED);
                  EnableMenuItem (hMenu, IDM_KEYBOARD, MF_ENABLED);
                  EnableMenuItem (hMenu, IDM_SOUND, MF_ENABLED);
                  EnableMenuItem (hMenu, IDM_LOOPING, MF_ENABLED);
                  EnableMenuItem (hMenu, IDM_PALINDROME, MF_ENABLED);
                  }

               else
                  {

               // Change the controller menu item

                  ModifyMenu (hMenu, IDM_CONTROLLER, MF_BYCOMMAND |
                     MF_STRING, IDM_CONTROLLER,
                     (LPSTR) "Show Controller");
                  bControllerVisible = FALSE;

               // Hide the controller

                  MCSetVisible (mcController, FALSE);

               // Grey the rest of the menu items

                  EnableMenuItem (hMenu, IDM_STEP_BUTTONS, MF_GRAYED);
                  EnableMenuItem (hMenu, IDM_SPEAKER_BUTTON, MF_GRAYED);
                  EnableMenuItem (hMenu, IDM_GROW_BOX, MF_GRAYED);
                  EnableMenuItem (hMenu, IDM_KEYBOARD, MF_GRAYED);
                  EnableMenuItem (hMenu, IDM_SOUND, MF_GRAYED);
                  EnableMenuItem (hMenu, IDM_LOOPING, MF_GRAYED);
                  EnableMenuItem (hMenu, IDM_PALINDROME, MF_GRAYED);
                  }
               }
               break;

            case IDM_STEP_BUTTONS:
               {
               LONG lFlags;

               if (bSteppersVisible == FALSE)
                  {

               // Change the step button menu item

                  ModifyMenu (hMenu, IDM_STEP_BUTTONS, MF_BYCOMMAND |
                     MF_STRING, IDM_STEP_BUTTONS,
                     (LPSTR) "Hide Step Buttons");
                  bSteppersVisible = TRUE;

               // Restore the step buttons

                  MCDoAction (mcController, mcActionGetFlags, &lFlags);
                  lFlags &= ~mcFlagSuppressStepButtons;
                  MCDoAction (mcController, mcActionSetFlags,
                     (LPVOID) lFlags);
                  }

               else
                  {

               // Change the step button menu item

                  ModifyMenu (hMenu, IDM_STEP_BUTTONS, MF_BYCOMMAND |
                     MF_STRING, IDM_STEP_BUTTONS,
                     (LPSTR) "Show Step Buttons");
                  bSteppersVisible = FALSE;

               // Hide the step buttons

                  MCDoAction (mcController, mcActionGetFlags, &lFlags);
                  lFlags |= mcFlagSuppressStepButtons;
                  MCDoAction (mcController, mcActionSetFlags,
                     (LPVOID) lFlags);
                  }
               }
               break;

            case IDM_SPEAKER_BUTTON:
               {
               LONG lFlags;

               if (bSpeakerVisible == FALSE)
                  {

               // Change the speaker button menu item

                  ModifyMenu (hMenu, IDM_SPEAKER_BUTTON, MF_BYCOMMAND |
                     MF_STRING, IDM_SPEAKER_BUTTON,
                     (LPSTR) "Hide Speaker Button");
                  bSpeakerVisible = TRUE;

               // Restore the speaker button

                  MCDoAction (mcController, mcActionGetFlags, &lFlags);
                  lFlags &= ~mcFlagSuppressSpeakerButton;
                  MCDoAction (mcController, mcActionSetFlags,
                     (LPVOID) lFlags);
                  }

               else
                  {

               // Change the speaker button menu item

                  ModifyMenu (hMenu, IDM_SPEAKER_BUTTON, MF_BYCOMMAND |
                     MF_STRING, IDM_SPEAKER_BUTTON,
                     (LPSTR) "Show Speaker Button");
                  bSpeakerVisible = FALSE;

               // Hide the speaker button

                  MCDoAction (mcController, mcActionGetFlags, &lFlags);
                  lFlags |= mcFlagSuppressSpeakerButton;
                  MCDoAction (mcController, mcActionSetFlags,
                     (LPVOID) lFlags);
                  }
               }
               break;

            case IDM_GROW_BOX:
               {
               if (bGrowBoxVisible == FALSE)
                  {

               // Change the grow box menu item

                  ModifyMenu (hMenu, IDM_GROW_BOX, MF_BYCOMMAND |
                     MF_STRING, IDM_GROW_BOX,
                     (LPSTR) "Hide Grow Box");
                  bGrowBoxVisible = TRUE;

               // Set the grow box bounds to make it visible

                  GetClientRect (hWnd, &rcGrowBox);
                  MCDoAction (mcController, mcActionSetGrowBoxBounds,
                     &rcGrowBox);
                  }

               else
                  {

               // Change the grow box menu item

                  ModifyMenu (hMenu, IDM_GROW_BOX, MF_BYCOMMAND |
                     MF_STRING, IDM_GROW_BOX,
                     (LPSTR) "Show Grow Box");
                  bGrowBoxVisible = FALSE;

               // Set the grow box bounds to all zeros to hide it

                  SetRectEmpty (&rcGrowBox);
                  MCDoAction (mcController, mcActionSetGrowBoxBounds,
                     &rcGrowBox);
                  }
               }
               break;

            case IDM_KEYBOARD:
               {
               if (bKeysEnabled == FALSE)
                  {

               // Change the keyboard interface menu item

                  ModifyMenu (hMenu, IDM_KEYBOARD, MF_BYCOMMAND |
                     MF_STRING, IDM_KEYBOARD,
                     (LPSTR) "Disable Keyboard Interface");
                  bKeysEnabled = TRUE;

               // Enable the keyboard interface

                  MCDoAction (mcController, mcActionSetKeysEnabled,
                     (LPVOID) TRUE);
                  }

               else
                  {

               // Change the keyboard interface menu item

                  ModifyMenu (hMenu, IDM_KEYBOARD, MF_BYCOMMAND |
                     MF_STRING, IDM_KEYBOARD,
                     (LPSTR) "Enable Keyboard Interface");
                  bKeysEnabled = FALSE;

               // Disable the keyboard interface

                  MCDoAction (mcController, mcActionSetKeysEnabled,
                     (LPVOID) FALSE);
                  }
               }
               break;

            case IDM_SOUND:
               {
               SFIXED sfxVolume;

               if (bSoundEnabled == FALSE)
                  {

               // Change the sound menu item

                  ModifyMenu (hMenu, IDM_SOUND, MF_BYCOMMAND |
                     MF_STRING, IDM_SOUND, (LPSTR) "Disable Sound");

               // Restore the sound

                  MCDoAction (mcController, mcActionGetVolume,
                     (LPVOID) &sfxVolume);
                  sfxVolume = abs (sfxVolume);
                  MCDoAction (mcController, mcActionSetVolume,
                     (LPVOID) sfxVolume);

                  bSoundEnabled = TRUE;
                  }

               else
                  {

               // Change the sound menu item

                  ModifyMenu (hMenu, IDM_SOUND, MF_BYCOMMAND |
                     MF_STRING, IDM_SOUND, (LPSTR) "Enable Sound");

               // Mute the sound

                  MCDoAction (mcController, mcActionGetVolume,
                     (LPVOID) &sfxVolume);
                  sfxVolume = - (abs (sfxVolume));
                  MCDoAction (mcController, mcActionSetVolume,
                     (LPVOID) sfxVolume);

                  bSoundEnabled = FALSE;
                  }
               }
               break;

            case IDM_LOOPING:
               {
               if (bLoopingEnabled == FALSE)
                  {

               // Change the looping menu item

                  ModifyMenu (hMenu, IDM_LOOPING, MF_BYCOMMAND |
                     MF_STRING, IDM_LOOPING, (LPSTR) "Disable Looping");
                  bLoopingEnabled = TRUE;

               // Enable looping

                  MCDoAction (mcController, mcActionSetLooping,
                     (LPVOID) TRUE);
                  }

               else
                  {

               // Change the looping menu item

                  ModifyMenu (hMenu, IDM_LOOPING, MF_BYCOMMAND |
                     MF_STRING, IDM_LOOPING, (LPSTR) "Enable Looping");
                  bLoopingEnabled = FALSE;

               // Disable looping

                  MCDoAction (mcController, mcActionSetLooping,
                     (LPVOID) FALSE);
                  }
               }
               break;

            case IDM_PALINDROME:
               {
               if (bPalindromeEnabled == FALSE)
                  {

               // Change the palindrome menu item

                  ModifyMenu (hMenu, IDM_PALINDROME, MF_BYCOMMAND |
                     MF_STRING, IDM_PALINDROME,
                     (LPSTR) "Disable Palindrome Looping");
                  bPalindromeEnabled = TRUE;

               // Enable palindrome looping

                  MCDoAction (mcController, mcActionSetLooping,
                     (LPVOID) TRUE);
                  MCDoAction (mcController, mcActionSetLoopIsPalindrome,
                     (LPVOID) TRUE);
                  }

               else
                  {

               // Change the palindrome menu item

                  ModifyMenu (hMenu, IDM_PALINDROME, MF_BYCOMMAND |
                     MF_STRING, IDM_PALINDROME,
                     (LPSTR) "Enable Palindrome Looping");
                  bPalindromeEnabled = FALSE;

               // Disable palindrome looping

                  MCDoAction (mcController, mcActionSetLooping,
                     (LPVOID) FALSE);
                  MCDoAction (mcController, mcActionSetLoopIsPalindrome,
                     (LPVOID) FALSE);
                  }
               }
               break;
            }
         }
         return 0;

      case WM_PAINT:

         if (!BeginPaint (hWnd, &ps))
            return 0;
         EndPaint (hWnd, &ps);
         return 0;

      case WM_DESTROY:

         PostQuitMessage (0);
         return 0;

      }

// Return to Windows

   return DefWindowProc (hWnd, message, wParam, lParam);
   }

