TechFlash:TF-P-11255

How NCP Packet Signature Works
NCP packet signature is an enhanced security feature that protects
servers and clients using the NetWare Core Protocol by preventing
packet forgery.

Without the NCP packet signature installed, it is possible for a
network client posing as a more privileged client to send a forged
NCP request to a NetWare server. By forging the proper NCP request
packet, an intruder could gain SUPERVISOR rights and access to all
network resources.

NCP packet signature prevents packet forgery by requiring the
server and the client to "sign" each NCP packet. The packet
signature changes with every packet.

NCP packets with incorrect signatures are discarded without
breaking the client's connection with the server. However, an alert
message about the invalid packet is sent to the error log, the
affected client, and the server console. The alert message contains
the LOGIN name and the station address of the affected client.

A two-part process between the client and the NetWare server
determines the NCP packet signature:

*    At LOGIN, the server and the client determine a shared, secret
     key known as the session key.

*    For each request or response packet, the server and the client
     calculate a signature based on the session key, a
     "fingerprint" algorithm, and the previous packet's signature.
     The unique signature is appended to the NCP packet.

If NCP packet signature is installed correctly on the server and
all of its clients, it is virtually impossible to forge a valid NCP
packet.


Packet Signature Options

Because the packet signature process consumes CPU resources and
slows performance, both for the client and the NetWare server, NCP
packet signature is optional.

Several signature options are available, ranging from never signing
NCP packets to always signing NCP packets. NetWare servers have
four settable signature levels, and network clients also have four
signature levels.

The signature options for servers and clients combine to determine
the level of NCP packet signature on the network.

NOTE:     Some combinations of server and client packet signature
          levels may slow performance. However, low CPU-demand
          systems may not show any performance degradation. Network
          supervisors can choose the packet signature level that
          meets both their performance needs and their security
          requirements.


Server Levels

Server packet signature levels are assigned by a new SET parameter:

     SET NCP Packet Signature Option = [number]

Replace [number] with 0, 1, 2, or 3. The default is 2.


Number    Explanation

0         Server does not sign packets (regardless of the client
          level)

1         Server signs packets only if the client requests it
          (client level is 2 or higher)

2         Server signs packets if the client is capable of signing
          (client level is 1 or higher)

3         Server signs packets and requires all clients to sign
          packets (or logging in will fail)


Client Levels

Client signature levels are assigned by a new NET.CFG parameter:

     signature level = [number]

Replace [number] with 0, 1, 2, or 3. The default is 1.


Number    Explanation

0         Client does not sign packets

1         Client signs packets only if the server requests it
          (server option is 2 or higher)

2         Client signs packets if the server is capable of signing
          (server option is 1 or higher)

3         Client signs packets and requires the server to sign
          packets (or logging in will fail)
