{$I DEFINE.INC}

program DemoPal4;

{ FastVGA 1.0, (C)1993, 1994 by Tal Cohen }

{ This program is one version of the infamous "wormhole" (sometimes
  called "vortex") effect. The entire action is done using only
  palette slides! }

uses FastVGA,FastGFX,Crt;

procedure MakeImage;
 { This procedure draws the complex image used in
   the demo. Note that normally, you'll use
   calculations like these to draw the image only
   palette only once, and then save it to a .PCX
   file. }

{ The procedure is based on WGEN.PAS, by Alex Chalfin,
  published in the May, 1994 edition of SWAG. This
  version, however, is optimized for speed by a several
  dozen times - and that, without resorting to assembly ... }

 const Stretch = 15;
       XCenter = 160;
       YCenter = 50;
       Divs = 1200;
       Spokes = 2400;

 var Temp1,Temp2:LongInt;
     x,y,i,j,Temp3:Integer;

     SinVals,CosVals:array [0..Spokes-1] of LongInt;

 begin
  { Show a "Please wait" message: }
  DirectVideo:=False;
  Write ('Creating image - please wait ...');
  { Create the image: }
  for i:=0 to Spokes-1 do
   begin
    SinVals[i]:=Round(240*sin(2*Pi*i/Spokes)/Divs*65536);
    CosVals[i]:=Round(320*cos(2*Pi*i/Spokes)/Divs*65536);
   end;
  Temp2:=XCenter ShL 16;
  for j:=1 to Divs do
   begin
    Temp1:=Round((YCenter-Ln(2*j/Divs)*Stretch-1)*65536);
    Temp3:=15*((j div 6) mod 15)+1;
    for i:=1 to Spokes-1 do
     begin
      y:=(SinVals[i]*j+Temp1) ShR 16;
      if (y>=0) and (y<=199) then
       begin
        x:=(CosVals[i]*j+Temp2) ShR 16;
        if (x>=0) and (x<=319) then
         VGAScreenPtr^[y][x]:=((i ShR 3) mod 15)+Temp3;
       end; { if }
     end; { for i }
   end; { for j }
 end;

type { Two ways to look at 225 bytes: }
     T15  = array [1..15] of array [1..15] of Byte;
     T225 = array [1..225] of Byte;

const V15A:T15 =  { The letters "FVGA": }
          (( 15, 15, 15, 15,  0, 15,  0,  0,  0, 15,  0,  0,  0,  0,  0),
           ( 15,  0,  0,  0,  0, 15,  0,  0,  0, 15,  0,  0,  0,  0,  0),
           ( 15, 15, 15,  0,  0, 15,  0,  0,  0, 15,  0,  0,  0,  0,  0),
           ( 15,  0,  0,  0,  0,  0, 15,  0, 15,  0,  0,  0,  0,  0,  0),
           ( 15,  0,  0,  0,  0,  0,  0, 15,  0,  0,  0,  0,  0,  0,  0),
           (  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0),
           (  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0),
           (  0,  0, 15, 15, 15, 15,  0,  0, 15, 15, 15, 15,  0,  0,  0),
           (  0,  0, 15,  0,  0,  0,  0,  0, 15,  0,  0, 15,  0,  0,  0),
           (  0,  0, 15,  0, 15, 15,  0,  0, 15, 15, 15, 15,  0,  0,  0),
           (  0,  0, 15,  0,  0, 15,  0,  0, 15,  0,  0, 15,  0,  0,  0),
           (  0,  0, 15, 15, 15, 15,  0,  0, 15,  0,  0, 15,  0,  0,  0),
           (  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0),
           (  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0),
           (  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0));

var V15:T15;
    V225:T225 absolute V15;  { The very same array; we can look at it
                               in either way now, by refering to either
                               V15 or V255. }
    P,P1:PaletteType;
    i,j:Byte;

procedure Cycle (a,b:Byte);
 { Cycles the palette "P" at area "a" thru "b",
   until a key is pressed. }

 begin
  repeat
   VSync;
   SetActivePalette (P,1,225);
   SlidePalette (P,a,b);
  until KeyPressed;
  ReadKey;
  if KeyPressed then ReadKey; { In case of a double-key }
 end;

begin
 { Create the bitmap image: }
 GoVGA256;
 MakeImage;
 { Create the desired palette: }
 GetActivePalette (P1,0,255);
 P1[101][RGBRed]:=0;
 P1[101][RGBGreen]:=0;
 P1[101][RGBBlue]:=10;
 P1[108][RGBRed]:=0;
 P1[108][RGBGreen]:=0;
 P1[108][RGBBlue]:=63;
 P1[115]:=P1[101];
 Gradient (P1,101,108);
 Gradient (P1,108,115);
 FillChar (P,SizeOf(P),0);
 for i:=1 to 15 do
  V15[i]:=V15A[16-i];
 for i:=1 to 225 do
  P[i]:=P1[V225[i]];
 { Do the first vortex effect: }
 Cycle (0,225);
 { Add vertical blue lines: }
 for i:=1 to 15 do
  for j:=1 to 15 do
   if V15[i][j]=0 then V15[i][j]:=100+j;
 for i:=1 to 225 do
  P[i]:=P1[V225[i]];
 { Now the second vortex effect: }
 Cycle (225,1);
 { Add frame: }
 for i:=1 to 15 do
  begin
   V15[2][i]:=15;
   V15[i][14]:=15;
  end;
 for i:=1 to 225 do
  P[i]:=P1[V225[i]];
 { And finally, the final vortex effect: }
 Cycle (1,225);
 RestoreMode;
end.
