{$I DEFINE.INC}

program Demo2;

{ FastVGA 1.0, (C)1993, 1994 by Tal Cohen }

{ This program demonstrates the following points:

   Using pixies.
   Animating multiple pixies (or sprites.)
   Reading pixies (or sprites) from files.
   Fading-out while the program is still active.
   Using pointers to store pixies on the heap.

}

uses FastGlobals,FastVGA,FastTimer,PCXUnit,Crt;

const ShipCount = 4;

var i,j,Speed:Byte;
    P1,Black:PaletteType;
    Ship:array [1..ShipCount] of Pixie;
    ShipBMP:array [1..ShipCount] of array [1..4] of PixieBitmapPtr;
    XMove,YMove:array [1..ShipCount] of ShortInt;
    K:Char;
    Done,Fade:Boolean;

begin
 if TestVGA=0 then
  begin
   WriteLn ('This program requires a VGA/MCGA card.');
   Halt;
  end;
 if MaxAvail<ShipCount*4 then
  begin
   WriteLn ('Not enought free memory.');
   Halt;
  end;
 WriteLn ('In the following demo program, use the PLUS key to put the ships in high');
 WriteLn ('gear, and the MINUS key to return them to low gear. Use ESC to exit.');
 WriteLn ('Four pixies are animated, so with slow machines (esp. XTs) the difference');
 WriteLn ('between the SLOW and FAST modes is hardly noticeable.');
 WriteLn;
 Write ('Press any key to start ... ');
 ReadKey;
 for i:=1 to ShipCount do
  for j:=1 to 4 do
   begin
    New(ShipBMP[i][j]);
    FVCheck (LoadPIX (ShipBMP[i][j],'SHIP.PIX',(i-1)*4+j));
   end;
 GoVGA256;
 FadeToRGB (0,0,0,0);  { Set the entire palette to black with zero delay }
 FVCheck (LoadPCXPage2 ('FASTVGA.PCX',P1));
 CopyFromPage2;  { Nothing will be shown, since the entire palette is black }
 FadeToPalette (P1,0,255,73); { 4 seconds fade into picture }
 i:=1;
 for j:=1 to ShipCount do
  begin
   AssignPixie (@Ship[j],ShipBMP[j][1]);
   PutPixie (@Ship[j],Random(319-PixXLen),Random(199-PixYLen));
   XMove[j]:=Random(3)-1; { 1, 0, or -1 }
   YMove[j]:=Random(3)-1;
  end;
 Speed:=1;
 K:=#0;
 Done:=False;
 Fade:=False;
 FillChar (Black,SizeOf(Black),0); { Zero-out the palette to all-black }
 repeat
  StartTimer;
  Inc(i);
  if i>4 then i:=1;
  for j:=1 to ShipCount do
   begin
    AssignPixie (@Ship[j],ShipBMP[j][i]);
    if Random<0.1 then { 10% likely to change direction }
     begin
      Inc(XMove[j],Random(3)-1); { Add 1, -1, or none }
      Inc(YMove[j],Random(3)-1);
      { Max.Speed: 3 Pixels }
      if XMove[j]>3 then XMove[j]:=3; if XMove[j]<-3 then XMove[j]:=-3;
      if YMove[j]>3 then YMove[j]:=3; if YMove[j]<-3 then YMove[j]:=-3;
     end;
    if (Ship[j].X+XMove[j]<0) or (Ship[j].X+XMove[j]>320) then
     XMove[j]:=-XMove[j];
    if (Ship[j].Y+YMove[j]<0) or (Ship[j].Y+YMove[j]>200) then
     YMove[j]:=-YMove[j];
   end;
  { Moving multiple pixies is a ready-set-go operation. }
  ReadyMoveSprites;                            { READY ... }

  { If you'd like to do any changes to the
    background, this is where to act. These
    changes should be done ONLY on page 2;
    the GoMoveSprites operation coming soon
    will make them visible. The changes will
    appear BEHIND the pixies }

  for j:=1 to ShipCount do
   SetMovePixie (@Ship[j],XMove[j],YMove[j]);  { ... SET ... }

  { Changes made here on Page 2 will appear
    IN FRONT of the pixies }

  GoMoveSprites;                               { GO !! }

  { If you've drawn ANYTHING on page 2, make
    sure you updated LoX, LoY, HiX, and HiY
    to show these changes BEFORE calling
    GoMoveSprites }

  SlidePalette (P1,160,175);     { Change the color of the ships' Headlight }
  SetActivePalette (P1,160,175);
  if KeyPressed then
   begin
    K:=ReadKey;
    if K='+' then Speed:=0 { High speed }
    else if K='-' then Speed:=1 { Low speed }
    else if K=#27 then Fade:=True;
   end;
  if Fade then
   begin
    PullToPalette (P1,Black,0,255,Done);
    SetActivePalette (P1,0,255);
   end;
  WaitFor (Speed); { Wait 1 or no clock-ticks }
 until Done;
 TextMode (Co80);
end.
