{ DEFINE.INC:  A standard include file with all the compiler directives
               for FastVGA units and demo programs.

               Define "DEBUG" for debugging mode for one unit.

               Define "GLOBALDEBUG" for debugging mode for all units,
               starting from where it was first defined.

               Define "NODPMI" for no-DPMI mode (e.g. in sound modules.)

               Define "DYNAMIC" for Moveable, DemandLoad, Discardable mode
               under DPMI (e.g. in file-handling units.) The default is
               Fixed, Preload, Permanent, for speed's sake.

               Define "OVERLAY" to compile an overlay-enabled unit.

}

{$IFDEF WINDOWS}
  'Will not compile in Windows mode.'
{$ENDIF}

{$IFDEF GLOBALDEBUG}
 {$DEFINE DEBUG}
{$ENDIF}

{$IFDEF OVERLAY}
 {$O+}
{$ELSE}
 {$O-}
{$ENDIF}

{$IFDEF DEBUG}
 {$D+,I+,L+,R+,S+}
{$ELSE}
 {$D-,I-,L-,R-,S-}
{$ENDIF}

{$IFDEF Ver70}
{ Compiler directives for Borland Pascal 7.0 }
{$A+,B-,F-,P+,Q-,T-,V-,X+}
{$IFDEF DPMI}
 {$IFDEF NODPMI}
  'Will not compile in DPMI mode.'
 {$ELSE}
  {$G+}
  {$IFDEF DYNAMIC}
   {$C MOVEABLE DEMANDLOAD DISCARDABLE}
  {$ELSE}
   {$C FIXED PRELOAD PERMANENT}
  {$ENDIF}
 {$ENDIF}
{$ELSE}
 {$G-}
{$ENDIF}
{$M 16384,0,655360}
{$ENDIF}

{$IFDEF Ver60}
{ Compiler directives for Turbo Pascal 6.0 }
{$A+,B-,F-,G-,V-,X+}
{$M 16384,0,655360}
{$ENDIF}

{ All related defines are LOCAL, except GLOBALDEBUG: }

 {$UNDEF DEBUG}
 {$UNDEF DYNAMIC}
 {$UNDEF NODPMI}
 {$UNDEF OVERLAY}
