/************************************************************************/
/*			1_AXIS.C						05-01-94					*/
/*											rev1.00						*/
/* The following sample cource code for C compilers for DOS, shows the	*/
/* simple case of a Single Axis to move at a specified velocity			*/
/* and acceleration, to a given target position. For simplicity, it is 	*/
/* assumed that the PID	values (Servo) or Steps/Lines (Stepper - CL)	*/
/* are already set for this Axis.										*/
/************************************************************************/

#include <stdio.h>
#include <conio.h>
#include <nulib02.h>			/*nuLogic c function library */

#define PROF_COMPL	0x400		/*profile complete bit in 'per Axis' hardware status */
#define MOTOR_OFF	0x04		/*motor off bit */
#define MOTOR_RUNNING	0x80           	/*motor running bit */

int WaitForMoveComplete(WORD BoardAddr, WORD BoardType, BYTE Axis, WORD TimeOutSecs);


void main(void) {
  int retstat;
  BYTE Axis;
  WORD BoardAddr, BoardType;
  WORD StepsPerRev;
  WORD TimeOutSecs;
  double Vel, Accel;
  long int Position;

  	BoardAddr = 0x398;		/*Board address is set with DIP switches on the board */
  	BoardType = 1;			/*Board Type 1 means an open loop stepper */
  	Axis = 1;				/*Controlling Axis 1	*/
  	StepsPerRev = 1000;     /*Steps Per Revolution (Stepper) */
							/*Lines Per Revolution (Servo - Encoder) */

  	Vel = 100;				/*100 RPM	*/
  	retstat = load_rpm(BoardAddr, BoardType, Axis, StepsPerRev, Vel); /*load velocity in RPM*/
  	if (retstat) printf("Load RPM Error!");

  	Accel = 100;			/*100 RPS/S */
  	retstat = load_rpsps(BoardAddr, BoardType, Axis, StepsPerRev, Accel); /*load accel in rpsps*/
  	if (retstat) printf("Load RPSPS Error!");

    	Position = 10000;		/*Choose to go to position 10000 (10000 step counts from abs 0)*/
    	retstat = load_target_pos(BoardAddr, BoardType, Axis, Position); /*load target position */
  	if (retstat) printf("Load Target Pos Error!");

  	retstat = start_motion(BoardAddr, BoardType, Axis); /* start motion on single Axis */
  	if (retstat) printf("Start Motion Error!");

    	TimeOutSecs = 15; /*wait 15 seconds before giving up and returning a timeout error */
    	retstat = WaitForMoveComplete(BoardAddr, BoardType, Axis, TimeOutSecs);
  	if (retstat) printf("Timeout Error!");

  	retstat = read_pos(BoardAddr, BoardType, Axis, &Position);
  	if (retstat) printf("Read Pos Error!");
	printf("Position is now = %d\n",Position);

}

/************************************************************************************/
/* Wait For Move Complete -- This function waits for an Axis to complete its move	*/
/*  and returns a 0 status. If the number of timeout seconds specified is greater 	*/
/*  than 10000, this routine will return an error (-1) . 							*/
/* If you give a timeout of 0, the routine will only return when the move completes.*/
/* In other words a timeout value of 0 is effectively an Infinite timeout.			*/
/* If the timeout actually happens, we return a (-2);								*/
/* Other error numbers can be returned from the library call, see your library doc- */
/* ument for more detail.															*/
/************************************************************************************/
/* BoardAddr - The ISA bus board address											*/
/* BoardType - The nuLogic board type (1-stepper ol, 2-stepper cl, 3-servo4a, etc.)	*/
/* TimeOutSecs - Number of seconds before routine quits looking for move complete	*/
/* returns a 0 if successful, -1 if timeout parm too large, -2 if timeout occurred	*/
/************************************************************************************/
int WaitForMoveComplete(WORD BoardAddr, WORD BoardType, BYTE Axis, WORD TimeOutSecs)
{
  int retstat;
  WORD AxisStat;
  DWORD TimeOutCycles, i;

  	if (TimeOutSecs>10000) return(-1); /*too big a number */

  	TimeOutCycles = 240 * TimeOutSecs; /*this is a rough estimate of cycles per second */
  	/*approx 240 read_axis_stat's per sec, can vary by how many axes are moving, etc. */
    	/*since this is just an error condition limit, it doesn't need to be very accurate*/

    AxisStat = 0; /*if timeoutsecs = 0, then timeout is infinite */
    for (i=0;((i<TimeOutCycles)||(TimeOutSecs==0));i++)  {

    	retstat = read_axis_stat(BoardAddr, BoardType, Axis, &AxisStat);
    	if (retstat) return(retstat); /*error checking */

		/* check if motor is not running ,and either profile is complete or motor is off*/
    	if ( (AxisStat&(PROF_COMPL|MOTOR_OFF)) && (!(AxisStat&MOTOR_RUNNING)) )
    	  return(0);
    }

    return(-2); /*timeout*/
}
