/*********************************************************************
			nuLib02.h			05-01-94
													v1.00

This is the header file for the nuLib02.LIB driver library that a
programmer can use to create a large memory-model DOS program.
Written by John Pelletier at nuLogic, Inc.
**********************************************************************
*/

 #define BYTE unsigned char
 #define WORD unsigned int
 #define DWORD unsigned long int

 #define TERMINATOR 0x000A
 #define SWAPTERM   0x0A00

/*function prototypes for motion02.c*/
long int getver(void);
int read_lim_stat_rdb(WORD boardaddr, WORD boardtype);
int read_lim_stat(WORD boardaddr, WORD boardtype,WORD *switchstatptr);
int set_step_mode_pol(WORD boardaddr, WORD boardtype, WORD mpdata);
int set_io_pol(WORD boardaddr, WORD boardtype, WORD pddata);
int set_io_output(WORD boardaddr, WORD boardtype, WORD podata);
int enable_io_trig(WORD boardaddr, WORD boardtype, WORD trigdata);
int read_io_port_rdb(WORD boardaddr, WORD boardtype);
int read_io_port(WORD boardaddr, WORD boardtype, WORD *iodataptr);
int trigger_io(WORD boardaddr, WORD boardtype, WORD portnum);
int read_axis_stat_rdb(WORD boardaddr, WORD boardtype, BYTE axis);
int read_axis_stat(WORD boardaddr, WORD boardtype, BYTE axis, WORD *statptr);
int set_lim_pol(WORD boardaddr, WORD boardtype, WORD polarity);
int enable_limits(WORD boardaddr, WORD boardtype, WORD enabledata);
int stop_motion(WORD boardaddr, WORD boardtype, BYTE axis);
int kill_motion(WORD boardaddr, WORD boardtype, BYTE axis);
int load_target_pos(WORD boardaddr, WORD boardtype, BYTE axis, DWORD position);
int load_vel(WORD boardaddr, WORD boardtype, BYTE axis, DWORD velocity);
int reset_pos(WORD boardaddr, WORD boardtype, BYTE axis);
int find_home(WORD boardaddr, WORD boardtype, BYTE axis, WORD direction);
int find_index_rdb(WORD boardaddr, WORD boardtype, BYTE axis, int revdata, WORD direction, WORD offset);
int find_index(WORD boardaddr, WORD boardtype, BYTE axis, int revdata,
							WORD direction, WORD offset, WORD *indexptr);
int read_pos_rdb(WORD boardaddr, WORD boardtype, BYTE axis);
int read_pos(WORD boardaddr, WORD boardtype, BYTE axis, DWORD *positionptr);
int read_steps_vel(WORD boardaddr, WORD boardtype, BYTE axis, DWORD *veloptr);
int read_vel_rdb(WORD boardaddr, WORD boardtype, BYTE axis);
int read_vel(WORD boardaddr, WORD boardtype, BYTE axis, WORD *velocityptr);
int set_stop_mode(WORD boardaddr, WORD boardtype, BYTE axis, WORD mode);
int load_fol_err(WORD boardaddr, WORD boardtype, BYTE axis, DWORD errorcount);
int load_steps_lines(WORD boardaddr, WORD boardtype, BYTE axis, DWORD stepslines);
int load_deriv_per(WORD boardaddr, WORD boardtype, BYTE axis, WORD period);
int load_prop_gain(WORD boardaddr, WORD boardtype, BYTE axis, WORD gain);
int read_encoder_rdb(WORD boardaddr, WORD boardtype, BYTE axis);
int read_encoder(WORD boardaddr, WORD boardtype, BYTE axis, DWORD *encoderptr);
int load_intg_gain(WORD boardaddr, WORD boardtype, BYTE axis, WORD gain);
int set_loop_mode(WORD boardaddr, WORD boardtype, BYTE axis, WORD mode);
int load_deriv_gain(WORD boardaddr, WORD boardtype, BYTE axis, WORD gain);
int set_base_vel(WORD boardaddr, WORD boardtype, BYTE axis, WORD basevelo);
int load_intg_lim(WORD boardaddr, WORD boardtype, BYTE axis, WORD limit);
int multi_start(WORD boardaddr, WORD boardtype, WORD startdata);
int trig_buff_delim(WORD boardaddr, WORD boardtype);
int acquire_samples(WORD boardaddr, WORD boardtype, WORD numsamples);
int begin_prestore(WORD boardaddr, WORD boardtype, WORD trigselect);
int end_prestore(WORD boardaddr, WORD boardtype);
int start_motion(WORD boardaddr, WORD boardtype, BYTE axis);
int load_accel(WORD boardaddr, WORD boardtype, BYTE axis, DWORD acceleration);
int load_accel_fact(WORD boardaddr, WORD boardtype, BYTE axis, WORD accfactor);
int set_direction(WORD boardaddr, WORD boardtype, BYTE axis, WORD direction);
int set_pos_mode(WORD boardaddr, WORD boardtype, BYTE axis, WORD posmode);
int load_pos_brk(WORD boardaddr, WORD boardtype, BYTE axis, DWORD breakpos);
int enable_brk(WORD boardaddr, WORD boardtype, BYTE axis, WORD func);
int load_time_brk(WORD boardaddr, WORD boardtype, BYTE axis, DWORD time);
int load_pos_ref(WORD boardaddr, WORD boardtype, BYTE axis, DWORD offset);
int load_pos_scale(WORD boardaddr, WORD boardtype, BYTE axis, DWORD scalefactor);
int set_scale_seq(WORD boardaddr, WORD boardtype, BYTE axis, WORD sequence);
int set_rs_pulse(WORD boardaddr, WORD boardtype, BYTE axis, WORD pulse);
int load_rot_counts(WORD boardaddr, WORD boardtype, BYTE axis, DWORD countdata);
int send_command(WORD boardaddr, WORD boardtype, BYTE axis, BYTE cmd, BYTE wcount, DWORD cmddata);
int read_rdb(WORD boardaddr, WORD boardtype, WORD *numptr, WORD *axisptr, WORD *cmdptr, DWORD *rdbptr);
int read_csr(WORD boardaddr, WORD boardtype,WORD *csrptr);
int flush_rdb(WORD boardaddr, WORD boardtype);
int in_pos(WORD boardaddr, WORD boardtype, BYTE axis, DWORD target, DWORD deadband, DWORD *resultptr);
int load_rpm(WORD boardaddr, WORD boardtype, BYTE axis, WORD revdata, double rpm);
int read_rpm(WORD boardaddr, WORD boardtype, BYTE axis, WORD revdata, double *rpm);
int load_rpsps(WORD boardaddr, WORD boardtype, BYTE axis, WORD revdata, double rpsps);
int verifyaddr(WORD baddr, WORD boardtype);

/*support routines*/ /*avoid calling these routines directly!! */
int getdbword(WORD boardaddr, BYTE newdriver, BYTE axis, BYTE cmd, WORD *rdbptr);
int getdbdword(WORD boardaddr, BYTE newdriver, BYTE axis, BYTE cmd, DWORD *rdbptr);
int checkpreviouserr(WORD boardaddr, BYTE newdriver);
int checkcurrenterr(WORD boardaddr);
int checknodata(WORD boardaddr);
int sendnowait(WORD boardaddr, BYTE newdriver, WORD *packetptr, BYTE packetsize);
void waitforpulse(WORD boardaddr);
WORD byteswap(WORD wordtoswap);
void waitforprocess(WORD boardaddr);
int testservoboard(WORD baddr, WORD btype);
int teststepclboard(WORD baddr, WORD btype);
int teststepboard(WORD baddr, WORD btype);
int testvalidboard(WORD baddr, WORD btype);

WORD read_cfgfile(WORD *bdtypeptr, WORD *addrptr);
WORD buildpacket(BYTE newdriver, BYTE axis, BYTE cmd, BYTE wcount, DWORD cmddata, WORD *packetptr);
WORD sendpacket(WORD boardaddr, BYTE newdriver, WORD *packetptr, BYTE packetsize);
WORD pollrtrandce(WORD boardaddr, BYTE newdriver);
WORD pollrtsandce(WORD boardaddr, BYTE newdriver);
WORD readytoreceive(WORD boardaddr, BYTE newdriver);
WORD datapending(WORD boardaddr, BYTE newdriver);
WORD chkcmdprocess(WORD boardaddr, BYTE newdriver);
WORD checkboarderr(WORD boardaddr, BYTE newdriver);
WORD clearcmderr(WORD boardaddr, BYTE newdriver);
void pulseholdoff (WORD boardaddr);
WORD byteswap(WORD wordtoswap);