=====

NOTE:

This is an unindexed and unpaginated rough draft ASCII version of the
CauseWay for Clarion 2.1 documentation.  No second pass -- let alone
professional -- editing, layout, or formatting has been performed at
this stage.  Chapter numbers should be considered invalid.  Much of the
text has been borrowed from previous language drafts, so the
documentation will vary from very good to awfully rough.

Basically, I'm just looking for large scale feedback at this
point (e.g. "hey you idiot, you forgot to mention what CWC does"
or "good grief, this explanation is completely incomprehensible even
allowing for future editing").


=====

Copyright 1992-1994 by Michael Devore and John Wildsmith.  All rights
reserved.

All company and/or product names are trademarks and/or registered
trademarks of their respective holders.

Last document revision 09/19/94, Michael Devore and Judy Cammelot.
Information contained within this document is subject to change without
notice.


CAUSEWAY LICENSE AGREEMENT

Michael Devore and John Wildsmith, the CauseWay authors, authorize you
to make archival copies of CauseWay only for the purpose of backing up
your software and thus protecting your investment.  You are bound by
this agreement to ensure that no unauthorized copies of CauseWay are
distributed, installed, or used in any manner.  Treat your copy of
CauseWay much like a book; you can use it anywhere but only in one
place at a time.

CauseWay carries a copyright (Copyright 1992-1994) by Michael Devore
and John Wildsmith.  Use of code or proprietary algorithms within
CauseWay, or disassembly of CauseWay code for purposes of using its
code or determining the nature of its algorithms for use in competition
with CauseWay, is an infringement of CauseWay's copyright.  All
copyright infringements will be prosecuted to the fullest extent of the
law.

CAUSEWAY WARRANTY

Michael Devore and John Wildsmith warrant the CauseWay material to be
free from physical defects in material and workmanship for a period of
ninety (90) days from date of purchase.  If a defect occurs during this
period, you may return the faulty material and it will be replaced free
of charge.

Michael Devore and John Wildsmith grant no other warranties, express or
implied, regarding CauseWay's fitness for any application, use, or
purpose.  Under no conditions will Michael Devore or John Wildsmith be
held liable for any special or consequential damages, either in
contract or tort, arising out of use of, or inability to use, CauseWay.

This license agreement and warranty is governed by the laws of the
State of Illinois.

RETURN POLICY

Should you experience a problem using CauseWay, the developers want to
know.  If they cannot resolve the problem to your satisfaction, they do
not expect you to spend money for a product you cannot use.  If you are
dissatisfied with the operation of CauseWay for any reason and have not
redistributed applications which use CauseWay, you may return the
CauseWay package for a full refund of purchase price.  The developers
would rather lose a sale than have a dissatisfied customer.



QUICK START INSTRUCTIONS FOR WARPLINK AND LPM-LINK USERS

Here are quick start instructions for getting CauseWay working with
your WarpLink or LPM-Link applications.  If you have any problems,
please read the rest of the manual to determine what to do.

At the simplest, you create a CauseWay application by linking with the
WL32 linker using the following command line:

WL32 /lc:warplink.def @<your link file>

The /lc option and configuration files are discussed in detail in the
WL32 option chapter.  Basically, the /lc option specifies a
configuration file, here named WARPLINK.DEF and included in this
package.  The WARPLINK.DEF file allows WL32 to properly interpret
various WarpLink or LPM-Link commands, as well as adding and deleting
appropriate files.  You may create your own configuration files to
support other linkers as well.  I recommend reading the documentation
file on using configuration files, but will go over each line in
WARPLINK.DEF here to help you better understand what's going on.

Line 1: /mx=/m

WL32 doesn't have a /mx option.  This command translates WarpLink (and
LPM-Link's) /mx option to the /m option of WL32 if encountered in a
link file.  Note that you probably shouldn't use the /m option if you
don't need to, as it slows down linker performance.

Line 2: /x+=NULL

WL32 doesn't have a /xt or /xp option.  This command forces WL32 to
discard any option that begins with "x", including /xt and /xp, when it
encounters them in any link file.

Line 3:  /cla=NULL

WL32 does not need a special Clarion setup so this option is not
present in WL32.

Line 12: /il=DEFAULT

/il is very similar to WarpLink's /i option.  If you specify /i in a
link file, WL32 will supply tediously detailed feedback on what it is
doing, greatly slowing down the link process.  This command
short-circuits the long display (/i) by forcing the display to be
limited to major link phases.  If you don't want any display at all,
remove this line from WARPLINK.DEF and make sure you don't have /i in
your link files.

Line 15: (=IGNORE

Most of your files are probably overlaid.  This command instructs WL32
to ignore a left parenthesis.  Without it, WL32 would try to interpret
the parenthesis as part of the file name.

Line 16: )=IGNORE

Same as the above command, but for right parentheses.

Line 17: CNOVLMGR.OBJ=FILEDELETE

Automatically remove CNOVLMGR.OBJ from WL32 processing, in case you use
overlays in your link file(s).  WL32 doesn't need an overlay manager
and this file would just add dead code.  You must supply an extension
for a file to be automatically deleted.  However, you need not (can't
in fact) supply a drive or path in the command file.  WL32 is
intelligent enough to recognize and remove the file from processing
even if there is a path or drive appended to the file name.

Line 18: LPM_VM.OBJ=FILEDELETE

Same as above, except allows for overlaying using an LPM version
overlay manager.

Line 19: LPM_RM.OBJ=FILEDELETE

Same as above.

Line 20: CLARION.OBJ=FILEDELETE

CLARION.OBJ needs to be replaced with a CauseWay-compliant version.
This command instructs WL32 to ignore CLARION.OBJ when it encounters it
in a link file.

Line 21: CLARION0.OBJ=FILEDELETE

Same as above with CLARION0.OBJ.

Line 22: dos1.boj=FILEDELETE

The Clarion supplied DOS1.BOJ is not CauseWay-compliant.  This removes
the file from processing if it is present in the link file.

Line 23: cwclar=OBJADD

This is the CauseWay-compliant version of CLARION.OBJ.  You must link
in this file instead of CLARION.OBJ for CauseWay to work.  This command
along with the previous FILEDELETE for CLARION.OBJ makes the process
automatic.

Line 24: cwcl0=OBJADD

Same as above, except for CLARION0.

Line 25: cwclar21=LIBADD

This is the library containing the CauseWay-compliant replacement
modules for CLARION1.LIB and CLARION2.LIB.  Over sixty Clarion runtime
modules are replaced by this library.  This library must be specified
before the CLARION?.LIB in order to ensure that the new versions of the
modules get linked in.  Placing the library in the configuration file
ensures this happens.  Alternately, you could list CWCLAR21.LIB first
before CLARION1.LIB and CLARION2.LIB in the library list, but that
would require modifying your link files.  This way is easier.

Line 26: cwdos1=OBJADD

This command may not be required.  It brings in the CauseWay-compliant
version of DOS1.BOJ, a file name CWDOS1.OBJ.  If you don't use DOS1.BOJ
in your programs, you may safely delete this line from WARPLINK.DEF.

Of course, you can also create your own configuration files and pass
them to WL32 via the /lc option.

If you require modified CauseWay-compliant LEM .BOJ files in your link
file, you may also remove the originals and specify the new file name
via the FILEDELETE and OBJADD commands.  CauseWay-modified versions of
COMM.BOJ and ALERTED.OBJ (CWCOMM.OBJ and CWALERTD.OBJ, respectively)
are available for those who require them.  Contact technical support
for further information.


WHAT DIFFERS FROM STANDARD CLARION PROGRAMS:

1. All Clarion VM support is shut off and those environment variables
and settings are ignored.  CauseWay has its own virtual memory
management.

2. The CLARION.DMP file has had a couple of lines removed that either
conflicted with CauseWay or made no sense in a protected mode
environment.

3.  RUN uses more DOS memory.  RUN is different when using CauseWay
than normal Clarion operation; no swap file is written out containing
the calling program image.  Because of this, 60-80K of DOS memory is
used by the program containing the RUN command.  If you continue to
shell out to a depth of several levels, you will eventually run out of
DOS memory to run CauseWay, even if you have extended memory left.

4.  RUN and RUNSMALL act identically.


TYPICAL CHANGES YOU MAY HAVE TO MAKE:

1.  Free memory displays will frequently overflow as memory available
can range into the megabytes.

2.  Homebrew or third party binary files may break protected mode rules
and cause a General Protection Fault (GPF).  You will either have to
modify these files or remove them from your program.


Chapter X   OVERVIEW


INTRODUCTION

What Is CauseWay for Clarion 2.1?  CauseWay is a 386 DOS extender
package for use with Clarion 2.1 programs.  It consists of a DOS
extender and a protected mode linker, bound together in one executable
file, a runtime library and object modules that allow Clarion to
operate in protected mode, as well as several support utilities.

CauseWay provides a simple method of allowing 16-bit DOS environments
to support access to very large amounts of memory for Clarion
applications on PC compatibles with an 80386SX processor or above,
without the need to use overlays.  To do this, the DOS extender runs
CauseWay-processed Clarion applications in protected mode, rather than
the real mode normally used in the DOS environment.  CauseWay makes
full use of 386-level chip capabilities including demand paging of code
and data, variable-sized segments up to 4G in length, and mixing 16-
and 32-bit data segments within the same program.  Implementation of
these powerful capabilities is transparent to the application user,
while providing all their benefits.

Clarion applications created using CauseWay are compatible with the
VCPI and DPMI standards and run equally well on systems with no
protected mode drivers or programs.  CauseWay applications work with
such diverse environments as normal DOS, DesqView, Windows 3.0 and
above in both standard and enhanced modes, as well as DOS windows
within OS/2 2.0 and above.  CauseWay allocates memory from DPMI, VCPI,
XMS, and INT 15h services, in addition to conventional DOS memory.
This allows Clarion applications to allocate memory through the
CauseWay DOS extender without the need to detect or manipulate the
various memory handling schemes.

A primary concern during development of CauseWay was to ensure minimum
effort would be needed by programmers to adapt their Clarion code to
work with the CauseWay DOS extender.  As a result, many Clarion
programs only need to be relinked with the CauseWay linker WL32 to
produce an operational 16-bit protected mode version.

NOTE:  Other versions of CauseWay are available for applications
not created using Clarion.


MINIMUM SYSTEM REQUIREMENTS

CauseWay for Clarion 2.1 requires a 386SX based computer or better and
100-150K free conventional memory plus an additional 350-400K of
extended memory (may also be conventional.  The required operating
environment is MS-DOS or PC-DOS 3.1 or higher, Windows 3.0 or higher,
OS/2 2.0 and above within a DOS window, or compatible operating system
that provides a DPMI or VCPI DOS environment.  Clarion version 2.1 is
also required.


OPERATING CAUSEWAY

When using CauseWay, simply follow the standard edit-compile-link
programming cycle that is familiar to Clarion programmers.  To create
CauseWay applications, first compile your Clarion source code to
produce object modules (.OBJ files).  Then link your object modules and
libraries using the WL32 protected mode linker rather than the linker
used previously.  Make sure that the CauseWay runtime library is linked
in prior to the other libraries.  This library addition can be handled
automatically by using configuration definition files.  See the
Configuration Files chapter for further details.

WL32 automatically adds the DOS extender to the resulting executable
file and, in conjunction with the CauseWay runtime library, formats the
application to run in protected mode.  Several batch files that permit
WL32 to emulate different linkers are included with the CauseWay
package to help ease your transition to creating CauseWay DOS-extended
applications.

When running the DOS-extended application, DOS first loads the CauseWay
DOS extender.  The DOS extender establishes the protected mode
environment, retrieves the Clarion application from the executable
file, sets up the application for execution, and finally passes control
to the application to begin operation.


ENVIRONMENT VARIABLES

CauseWay can make use of five environment variables. The WL32 protected
mode linker uses two environment variables when linking: OBJ and LIB.
The DOS extender can use the CAUSEWAY, TEMP, and TMP environment
variables when a CauseWay application runs.

OBJ Environment Variable

The OBJ environment variable contains the name of one or more
directories that are searched by WL32 if WL32 does not find an object
module in the current directory.  The OBJ environment variable is
identical to the LIB environment variable except WL32 searches for
object module names with the OBJ environment variable instead of
searching for library files.

For example, assume your current directory is C:\CLARWORK.  The
following command links CWCLAR.OBJ, CWCL0.OBJ, HELLO.OBJ and
ROUTINES.OBJ with CWCLAR21.LIB, CLARION1.LIB and CLARION2.LIB:

WL32 CWCLAR CWCL0 HELLO ROUTINES,HELLO,,CWCLAR21 CLARION1 CLARION2

Without an OBJ environment variable, if CWCLAR.OBJ, CWCL0.OBJ,
HELLO.OBJ or ROUTINES.OBJ are not in the C:\CLARWORK directory, WL32
issues a DOS error 2 (file not found) error.  To specify that object
modules may also be found in the \CLARWORK\SUPPORT directory on the
current drive or the \HARDWARE directory on the F drive, set the OBJ
environment variable as follows:

SET OBJ=\CLARWORK\SUPPORT;F:\HARDWARE

If HELLO.OBJ or ROUTINES.OBJ are not found in the C:\CLARWORK
directory, WL32 also searches the current drive's
\CLARWORK\SUPPORT directory and the F drive's \HARDWARE
directory for the object modules.


LIB Environment Variable

The LIB environment variable contains the name of one or more
directories that are searched by WL32 if WL32 does not find a library
file in the current directory.  The LIB environment variable is
identical to the OBJ environment variable except WL32 searches for
library files with the LIB environment variable instead of searching
for object modules.

For example, assume your current directory is C:\CLARWORK.  The
following command links CWCLAR.OBJ, CWCL0.OBJ, HELLO.OBJ and
ROUTINES.OBJ with CWCLAR21.LIB, CLARION1.LIB and CLARION2.LIB:

WL32 CWCLAR CWCL0 HELLO ROUTINES,HELLO,,CWCLAR21 CLARION1 CLARION2

Without a LIB environment variable, if CWCLAR21.LIB, CLARION1.LIB, or
CLARION2.LIB are not in the C:\CLARWORK directory, WL32 issues a DOS
error 2 (file not found) error.  To specify that library files may also
be found in the \CLARLIB or \LIB directories, set the LIB environment
variable as follows:

SET LIB=\CLARLIB;\LIB

In the example above, if CWCLAR21.LIB, CLARION1.LIB or CLARION2.LIB are
not found in the C:\CLARWORK directory, WL32 also searches the current
drive's \CLARLIB and
\LIB directories for the object modules.


TEMP and TMP Environment Variables

The TEMP and TMP environment variables specify the directory and drive
where a swap file is built by CauseWay's virtual memory manager (VMM)
in the DOS extender.  The path indicated by TEMP will be used if both
TEMP and TMP environment variables exist.

SET TMP=C:\SWAP

The example above directs the CauseWay DOS extender to create its swap
file, if required, in the C:\SWAP directory.  Since the WL32 linker
itself contains the CauseWay DOS extender, you may use the TEMP or TMP
environment variable to specify a swap file directory when linking a
program.

If the TEMP or TMP environment variable is not present, an invalid path
is used, or no drive is specified, then the current drive is used when
creating a swap file.  If free drive space is less than physical memory
(extended and conventional) available at start-up, then the DOS
extender VMM is automatically disabled and no swap file is created.


CAUSEWAY Environment Variable

CauseWay supports an environment variable "CAUSEWAY" with several
options.  These options will allow you to better tailor DOS extender
support for your CauseWay applications.

Arguments currently recognised are:

DPMI        Force DPMI usage when possible (recommended for 386^Max and
            BlueMax users for performance reasons).

LOWMEM:nn   Set DOS memory to reserve.  This is in addition to the 32K
            low DOS memory block always reserved by CauseWay.  'nn' is
            a decimal number of kilobytes.   If there is not enough
            memory to satisfy the 'nn' request, then CauseWay will
            leave all available conventional memory free that is not
            required by the extender.  Note this option doesn't
            guarantee the amount of free DOS memory, just how much
            needs to be free before CauseWay will use DOS memory if it
            exhausts all extended memory.

SWAP:d:\    Set swap file path.  This path has higher priority in
            choosing where a swap file is placed than the TEMP and TMP
            environment variables.



Chapter 2   WL32 LINKER


USING WL32

Operate the WL32 protected mode linker from the DOS command line or a
batch or make file.  There are no menus and operating modes.  Simply
type WL32 followed by specific command options and one or more
filenames.  Using WL32 is similar to using Borland's TLink or Microsoft
Link, although you may optionally make WL32 work like RTLink, PLink and
other linkers of that style.  (See the Configuration Files chapter for
more details on modifying WL32's behavior.)

Use the following format for running WL32 from the DOS prompt:

WL32 [command options] OBJECT_FILES, [program_file],[map_file],[library_files]

Items in brackets ([ ]) are optional.  Do not actually type the
brackets if you use the optional items.  Replace command options with
any of the WL32 options.

OBJECT_FILES indicates a list of one or more object module file names.
WL32 uses a default extension of .OBJ for object module files if none
is given.  You can override the default extension by explicit use of a
different extension in the file name.

program_file indicates the name of the executable file that WL32
creates as output.  WL32 uses a default extension of .EXE for
executable files if none is given.  You can override the default
extension by explicit use of a different extension in the file name.
If no executable file name is listed, WL32 uses the first .OBJ file
name with a .EXE extension as the executable file name.

map_file indicates the name of the map file WL32 creates that contains
information about the executable file.  WL32 uses a default extension
of .MAP for map files if none is given.  You can override the default
extension by explicit use of a different extension in the file name. If
no map file name is listed and the /m option is specified, Wl32 uses
the .EXE file name with a .MAP extension.  If a map file name is not
listed and the /m option is not used, a map file is not created.

library_files indicates a list of one or more library file names.  WL32
uses a default extension of .LIB for library files if none is given.
You can override the default extension by explicit use of a different
extension in the file name.

When entering more than one file name type, you must use commas as
shown.  They are not optional.  For example, when specifying a program
name and library name without a map file name, use two commas to
separate the file names.  However, do not use commas as separators
between the same file types.  In other words, do not place commas
between multiple object module file names or multiple library file
names.

It is possible to override the default link format through use of the
FREEFORMAT morphing command in a configuration definitions file.  Refer
to the Configuration Files chapter for more information.

The message "Link of executable file successfully completed" appears at
the end of the link if errors did not occur during linking.  If a link
error does occur, the application's executable and map file are
deleted.

Warnings during the link are NOT the same as errors.  Instead, they are
an indication that the linker has encountered an unusual situation
which could lead to a problem when operating the linked program.
Warnings do not abort the link process and the success message appears
even if warnings are present.  The total number of warnings will be
displayed by WL32 at the end of the link if any warnings do occur.


Chapter 3   RESPONSE FILES


Rather than supplying option and file information to WL32 on the DOS
command line, you can place the information in an ASCII text file,
called a response file.  Response files are often referred to as link
files, command scripts, or script files.  Use response files to ease
repetitive linking tasks and to allow longer entries than can be typed
on the DOS command line.  There is no limit to the number of options
and files you can list and there is no need to worry about introducing
typing errors with each link.


RESPONSE FILE FORMAT

Use the following format for using a response file with WL32:

WL32 @FILENAME.EXT

The at (@) symbol designates the file as a response file instead of a
.OBJ file or .LIB file.  You may list more than one response file when
linking and can nest one response file inside another.  This allows one
response file to specify other response files to be used by WL32 during
the link process.  Response files can be nested to a depth of ten
levels, that is, a response file can specify another response file
which in turn can specify another response file, up to a maximum of ten
layers.  Nesting response files is most useful when linking in the
FREEFORMAT mode described in the Configuration Files chapter.

The maxiumum line length for a response file is 125 characters.  There
is no restriction on total number of lines in a response file.


USING A RESPONSE FILE

A response file contains exactly what you would type after WL32 on the
DOS command line.  To break up a response file into several lines, use
a plus sign at the end of a line containing lists of .OBJ and .LIB
files.  A line that ends without a plus sign (+) or a comma (,)
indicates a new file type in the subsequent line.  For example, the
following response file:

MYFILE1+
MYFILE2
MYFILE3

causes WL32 to link MYFILE1.OBJ and MYFILE2.OBJ into MYFILE3.EXE
because the MYFILE2 line does not end of with the plus sign.  The same
effect can be achieved by this response file:

MYFILE1+
MYFILE2,MYFILE3

In contrast, the following response file:

MYFILE1+
MYFILE2+
MYFILE3

links together MYFILE1.OBJ, MYFILE2.OBJ, and MYFILE3.OBJ to create
MYFILE1.EXE because of a trailing plus sign after MYFILE2.

When linking with response files, you must specify the file extension
if one is required.  WL32 does not assume a .LNK or .RSP file
extension.  However, by using a configuration definitions file command
you may specify a default response file extension.  Refer to the
Configuration Files chapter for more information.

If a response file is not found in the current directory, WL32 will
search the LIB environment variable directories for the response file.


COMMENTS IN A RESPONSE FILE

You can add comments to WL32's response files for documentation
purposes.  Use the pound sign (#) to insert comments into a response
file.  All characters on a line after the pound sign are ignored by
WL32.  The comment character can be modified from a pound sign to a
different characters using a configuration definitions file command.
Read the Configuration Files chapter for more information.



Chapter 4   CONFIGURATION FILES


For maximum flexibility and ease of use, WL32 supports response or
linker script "morphing" commands.  Morphing capability allows WL32 to
read the link or response files and scripts of any linker without
changing those files to conform to WL32's commands and options.  This
capability includes support for both positional (e.g. Microsoft Link
and TLink) and freeformat (e.g.  RTLink) link files and scripts.

If a morphing command configuration definitions file is not
found in the current directory (e.g. EXOSPACE.DEF), WL32 will
look for the file in the directory containing WL32.EXE (i.e. the
invocation path of WL32).

To use the morphing feature, place the morphing commands in a linker
configuration definitions file and specify the file to WL32 through the
/lc:<filename> option.

With all morphing commands in a configuration file, case is significant
and WL32 returns an error for a lowercase command.  However, case is
not significant for the <string> or <option> listing that is translated
or morphed into an instruction understood by WL32.  For example,
LIB=LIBNAME and lib=LIBNAME are valid definition file lines,
LIB=libname and lib=libname are not.  Only one definition may be made
per linker definition file line.

An asterisk (*) character placed at the end of the <string> instructs
WL32 to ignore the entire response file or command line after
processing <string>.  This is commonly used to ignore characters after
a superfluous command, such as MODULE.

A plus (+) character placed at the end of the <string> instructs WL32
to ignore the rest of the current option or command text and
parameters, rather than the rest of the line.  This is commonly used to
ignore options and commands which have variable parameters, but which
are followed on the same line by other options and commands which you
do not want to ignore.

Brackets ([ and ]) in a <string> have special meaning.  Characters
within a bracket are optional when parsing <string>.  If the bracketed
text is not present, <string> will still be parsed and translated
correctly to the proper command.


MORPHING COMMANDS

All supported morphing commands and descriptions of their use follows:


<character>=COMMENT

Specify one character that WL32 recognizes as the beginning of a
comment line in a linker response file.  WL32 uses the pound sign (#)
by default.  This command allows changing comment recognition to
another character.

If more than one comment line character is listed in a configuration
file, only the last one specified is used.


<WL32 option>=DEFAULT

Specify a WL32 option that is set by default.  For example, using:

/b=DEFAULT

in a configuration file will cause WL32 to always beep at the end of
the link process, even if the link file does not contain the /b option.

Multiple DEFAULT morphing commands are supported by WL32.


<string>=EXENAME

Specify a string that instructs WL32 to begin parsing the executable
file name when in freeformat mode.  In most cases, use the following
command line.

OUTPUT=EXENAME


<file name>=FILEDELETE

Specify a file that will be removed from the link process if it is
encountered in a link file or command line.  The file will be deleted
even if it is listed in the link file with a drive or directory
specification.  Do not list <file name> with a drive or directory
specification.  <file name> must contain an extension if the file to be
removed has either an explicit or default extension.

This command is most useful for removing superfluous object modules or
libraries from link files without directly editing them.  For example,
overlay managers and libraries are not needed with the DOS extender and
will only add unnecessary code to the program.  For example, use the
following command to remove an overlay manager file called CNOVLMGR.OBJ
from the link process:

CNOVLMGR.OBJ=FILEDELETE

Multiple FILEDELETE morphing commands are supported by WL32.


FREEFORMAT

Switch the linker into freeformat parsing mode used by the RTLink and
PLink linkers, as opposed to the positional format used by the
Microsoft Link, TLink, and WarpLink.  You cannot switch back to
positional parsing mode after entering freeformat.  Several linker
definition commands are only valid for freeformat mode.


<character>=IGNORE

Specify one character to ignore when adjacent to or part of a file name
in a linker response file or command line.  This command allows
ignoring parentheses or brackets around overlaid file names without
modifying the script file.  The following two commands are commonly
used with the IGNORE command for Microsoft Link and WarpLink overlaid
files:

(=IGNORE
)=IGNORE

Up to 16 ignore characters can be specified in separate lines.  After
16 ignore characters are processed in the definitions file, the 17th
character listed overwrites the first ignore character specified, and
so on.


<file name>=LIBADD

Specify a library file to be linked into a program whenever the
configuration definitions file is used.  The library file will be added
to the library file list as soon as it is encountered in the
configuration file.  If the library file is not present in the current
directory or cannot be found in a directory listed via the LIB
environment variable, WL32 terminates with a file not found error.

This command is most useful for languages which need replacement
libraries to be used with the DOS extender.  Using Clarion 2.1 with
CauseWay requires linking in CWCLAR21.LIB.  The LIBADD command allows
their addition to the link process without modifying any response
files.

Multiple LIBADD morphing commands are supported by WL32.


<string>=LIBNAME

Specify a string when in freeformat mode that instructs WL32 to begin
parsing a list of library files.  The following three commands are
commonly used in a definitions file with freeformat link files:

LIB[RARY]=LIBNAME
SEA[RCH]=LIBNAME
ALL[OCATE]=LIBNAME

Multiple LIBNAME morphing commands are supported by WL32.


<string>=NULL

Specify any string of characters that should be ignored by the linker
in the definitions file by using the NULL command.  The asterisk (*)
character at the end of <string> instructs the linker to ignore the
entire response file or command line.  For example:

/DOSSEG=NULL

means ignore /DOSSEG in the linker script file or command line.  This
command:

MOD[ULE]*=NULL

means ignore the entire line starting with MODULE.  The ULE characters
are optional.  This command:

/op:+=NULL

means ignore /op: in a linker script file or command line and all
following characters up to the next option or command.

Multiple NULL morphing commands are supported by WL32.

NOTE:  If you wish to ignore an option in a link file that is a
substring of another option to be ignored, list the smaller option
second in the configuration definitions file.  Otherwise, the longer
option may be encountered in a link file and have only a portion of its
text ignored, leaving the remaining portion open to misinterpretation
by WL32.  For example, if you wish to ignore both the /s and /sp
options of WarpLink, you list /s=NULL first in the configuration file
before /sp=NULL and WL32 encounters /sp, it will remove the "/s" from
processing, leaving a "p" behind.  Depending upon where the /sp option
was positioned in the link file, the "p" could be interpreted as an
object or library file name.


<file name>=OBJADD

Specify an object module to be linked into a program whenever the
configuration file is used. This file is added as soon as the command
is encountered in the configuration file.  Therefore if you list the
configuration file before any object modules and do not specify an EXE
file name, the EXE file name is based on the object module file name in
the first OBJADD command.  If the object module is not present in the
current directory and cannot be found using the OBJ environment
variable, WL32 terminates with a file not found error.

This command is most useful for languages which need replacement object
modules to be used with the DOS extender.  Using Clarion 2.1 with
CauseWay requires linking in CWCLAR.OBJ and CWCL0.OBJ, and possibly
several binary (LEM) file replacements.  The OBJADD command allows
their addition to the link process without modifying any response
files.

Multiple OBJADD morphing commands are supported by WL32.


<file name>=OBJAPPEND

OBJAPPEND is very similar to the OBJADD morphing command except
OBJAPPEND allows you to specify an object module file or files that is
to be linked at the end of the object module list rather than at the
beginning as with OBJADD.

Multiple OBJADD morphing commands are supported by WL32.


<string>=OBJNAME

Specify a string that instructs WL32 to begin parsing a list of object
module files when in freeformat mode.  The following is commonly used
within the definitions file with freeformat link files:

FI[LE]=OBJNAME

Multiple OBJNAME morphing commands are supported by WL32.


<string>=RESPONSEEXT

Specify the default extension for a response or link file.  This
command allows emulation of linkers which automatically add the
extension on a linker response file, for example, .LNK.  If an
extension is explicitly passed to the linker, the extension will not be
appended.  A common use of this command would be:

.LNK=RESPONSEEXT

If more than one RESPONSEEXT command is encountered, the last specified
extension will be the one used by WL32.

Although the RESPONSEEXT command does allow adding a text suffix of up
to four characters to response file names by not specifying a leading
period in the RESPONSEEXT extension, the ability is of dubious value.


<character>=TERMINATION

Specify one character to terminate linker processing.  Typically
Microsoft Link users specify a semicolon (;), as follows:

;=TERMINATION

If more than one termination command line is listed, only the last one
specified is used by WL32.


<string>=<WL32 option>

Translate <string> to the listed WL32 option.  This command is most
useful for a linker response file that has an option directly
corresponding to a WL32 option, but with a different syntax.  Here are
a few common examples:

STACK=/st:
VERBOSE=/i
/nod=/nd

Multiple WL32 option morphing commands are supported by WL32.


CONFIGURATION FILE EXAMPLES

Two sample configuration definition files are included in the CauseWay
package.  WARPLINK.DEF ignores or translates several WarpLink options,
RTLINK.DEF engages freeformat parsing and translate or ignore standard
commands used by RTLink.  The command lists in each configuration file
are not exhaustive, but do cover the most commonly used commands and
options by these, and compatible, linkers.

Access definition files via the following format:

WL32 /lc:<configuration definitions file> @<link file>

For example, for the RTLink definitions configuration file use:

WL32 /lc:RTLINK.DEF @LINKFILE.LNK.

To ease transition from other linkers, the CauseWay distribution disk
includes batch files in the name of the two linkers above which specify
appropriate configuration definitions files.  Use the corresponding
batch files in place of the old linker to correctly process that
linker's response files when using CauseWay.

Once a definitions file is set for a particular link script style you
need not modify any of the existing link scripts associated with that
linker.

NOTES

You may use the /wu option with a configuration file to identify
options or commands which are being ignored by the linker, i.e.
unknown options.

The morphing ability allows you to set up link scripts that are
extremely opaque and impossible for other linkers to interpret.  For
example, you might create a configuration file with the following
morphing commands:

FREEFORMAT
/COW=/ex
LINKTHISFILE=OBJNAME
MYFILE3=OBJADD
LINKTHISONETOO=OBJNAME
HEREARELIBRARIES=LIBNAME
IGNORE[THIS]*=NULL
/DOESNOTHINGBUTIMPRESSIVELOOKINGOPTION*=NULL
@=IGNORE
-=IGNORE
"=IGNORE
TheStackOfToday=/st:
CREATE=EXENAME
~=COMMENT
/b=DEFAULT

Using the above configuration file, the following response file
links together MYFILE.OBJ, MYFILE2.OBJ, MYFILE3.OBJ, MYLIB1.LIB,
MYLIB2.LIB, and MYLIB3.LIB, to create a standard DOS EXE-format
file name MYEXE.EXE with a stack of 2K, and finally, beeps the
speaker at the end of the link.

/COW LINKTHISFILE @@myfile--
LINKTHISONETOO -myfile2"
HEREARELIBRARIES @mylib1@ -mylib2- @mylib3-
IGNORETHIS line altogether
/DOESNOTHINGBUTIMPRESSIVELOOKINGOPTION
TheStackOfToday 2048
IGNORE as well
CREATE MYEXE ~ make EXE name MYEXE.EXE



Chapter 5   WL32 OPTIONS

WL32 options lets you control how programs are linked and specify
linker output while creating the programs.  You can specify these
linker options from the DOS command line, in a batch or make file, or
in a response file.  If you are using the optional morphing command
feature described in the Configuration Files chapter, the options
listed below may not appear the same as in your command line, response,
batch, or make file.  The formats listed in this chapter, however, are
always valid.

All options are case insensitive, e.g. both /b and /B refer to the beep
when link is complete option.  Type WL32 without parameters at the DOS
command line to display a summary of linker options.


/b       Beep the speaker at linker completion.

This option causes WL32 to beep your speaker three times at the
completion of the linking process by writing three Control-G characters
to the standard output device.


/ex      Create DOS EXE-format file.

This option instructs WL32 to create a standard real mode DOS
EXE-format file, similar to those created by non-DOS extended linkers
such as TLink or Microsoft Link.  Creating a standard DOS EXE-format
file only works for programs which do not exceed the DOS memory limit
when fully loaded into memory.  Medium to large-sized programs which
require a DOS extender or overlays probably will not work when linked
using the /ex option.

/i       Display link process information.

This option provides extensive information about WL32 while it is
working.  When this option is specified, WL32 displays the current file
or library module being processed and the segments being written to the
executable file, as well as identifying the start of major link phases.

The /i option may help you troubleshoot any problems that occur when
using WL32 by narrowing down where the trouble spot lies.  Technical
support frequently requests a redirected output of the link process
using the /i option if you experience a problem with WL32.

NOTE:  This option may noticeably affect WL32 link speed and should not
be specified if it is not needed.


/il      Display link process information, Limit information
         displayed

This option is very similar to the /i option except that it only
displays the file being read by WL32 and the beginning of major link
phases.  The /i option display is more comprehensive than /il.  The /il
option makes the information display more manageable.  Also, because
limited information is displayed, linker execution speed is faster when
using the /il option as compared with the /i option.


/lc:<name>       Use link options configuration file name.

This /lc option supplies a configuration file name to WL32 for use with
the command morphing feature.  If no configuration file name is listed,
no morphing occurs.  The configuration file must be in the current
directory or be listed in the option with the drive and directory in
which the configuration file resides.  Multiple configuration files are
allowed.  They are processed in the order in which they are
encountered.


/m       Create MAP file.

The /m option creates a map file.  This option is also set if a map
file name is explicitly listed in a linker response file or command
line.

Map files contain the size, name, class, and count of segments in the
created program, the name, time, and date created of the executable
file, and the program entry point address.  Map files list the names
and addresses of public symbols in the program.  This information is
useful for debugging your program and identifying space requirements
for each segment.  The CauseWay debugger (CWD) can use map files to
display symbolic addresses of the CauseWay executable file being
debugged.  Symbols are present in a .MAP file only if they are declared
public in the module that defines the symbol.

NOTE:  This option may noticeably affect WL32 link speed and should not
be specified if it is not needed.


/nd      Do not use default library names in object modules.

Most language compilers and assemblers embed the name of one or more
runtime libraries directly into .OBJ files so that these libraries do
not have to be explicitly specified in the linker command line or
response file.  These .LIB files are called the default libraries.  You
can prevent WL32 from using the embedded default libraries by using the
/nd option.

The /nd option allows you to link programs without automatically
linking in default libraries.  This may be useful when linking in
replacement libraries or if you rename default libraries.


/st:<size>       Set program stack size in bytes.

This option modifies the linked program's stack size.  It overrides any
default stack set by the program modules if the default stack is
smaller than the size specified by the /st option. The value may range
from 1 to 65535 bytes.

If no stack is set by this option or by the program, a default 1K (1024
bytes) stack is created by WL32.  Executable programs should always
have a stack segment.


/sy      Create SYM file for CWD debugger.

The /sy option is only useful for operating a CauseWay application with
the CWD debugger.  When the option is set, WL32 creates a .SYM file
that contains information on the public symbols within the application.
When using MAP files that have many public symbols, CWD may take a long
time to process all of the symbolic information.  The .SYM contains
this information in an optimized form and allows an application to load
under CWD more quickly. CWD will first check for and use a .SYM file.
If no .SYM file is available then it uses a .MAP file (if present) for
symbolic information.

NOTE:  This option may noticeably affect WL32 link speed and should not
be specified if it is not needed.


/w1      Warnings generate exit code of 1, not zero.

Unlike errors, warnings do not normally generate a non-zero exit code
(also known as the DOS ERRORLEVEL or the return code) when WL32
finishes linking.  When the /w1 option is used, warnings cause a exit
code of 1 rather than 0 to be returned.  This behavior can be useful
when creating programs using make or batch files that need to detect
warning conditions.


/wu      Issue warning on unknown linker options or commands.

WL32 normally ignores without feedback an unknown linker option or
command provided that the unknown text is not preceded by a slash (/).
When the /wu option is set, all ignored text is listed by WL32 in a
warning message.  This option is most useful for detecting an unknown
command or option if you are using morphing configuration files with
the FREEFORMAT option.



Chapter X   SPEED CONSIDERATIONS

There are a few ways to speed up linking programs with WL32 as well as
to increase the operational efficiency of your CauseWay applications.


MEMORY SIZE

Almost without exception, the best way to increase link and runtime
performance of WL32 and all CauseWay applications is to ensure that
physical memory is large enough to meet all of the program's needs.
Performance suffers when CauseWay creates a temporary file for virtual
memory, swapping 4K blocks of the program's code and data to and from
disk.  Naturally this may not be possible in all cases, but it is a
worthy goal.  Generally the more physical memory, even when virtual
memory is being used, the better an application's performance.

If your program uses virtual memory, CauseWay's VMM creates a temporary
swap file.  If you have more than one disk drive, then you may wish to
direct creation of the swap file to the faster disk drive on your
system using the CAUSEWAY SWAP, TEMP, or TMP environment variables.  Do
not create a RAM disk if this will lower your physical memory because
this is less efficient than allowing CauseWay to use physical memory
itself.

Remember that virtual memory is part of total memory when using
CauseWay.  If your default drive, or the drive pointed to by the
CAUSEWAY SWAP, TEMP, or TMP environment variables has little free
space, this will be reflected in total memory available to the CauseWay
application.  If disk free space is less than physical memory, then
CauseWay shuts off all use of virtual memory.  Windows and OS/2 handle
virtual memory internally and supply it through the DPMI setting for
the application.


LINKING OPTIONS

To speed up the link performance of WL32, consider not using the /sy,
the /i, or the /m options, and not creating a map file by specifying a
map file name.  The additional overhead introduced by these options
slows down WL32 because of the extra file created or information
displayed.  Eliminating these options, if they are not needed, may
improve linker performance.


API DOS BUFFER SIZE

Try this speed tip only if you are comfortable directly calling the
CauseWay API.

If your CauseWay application reads and writes files using large amounts
of data on one read or write pass, you may wish to consider increasing
the size of the internal DOS memory transfer buffer used by CauseWay.
Refer to the SetDOSTrans and GetDOSTrans functions in the CauseWay API
chapter for more information.

Note that the internal 8K buffer is optimized for file transfers.
Average file transfers of greater than 8K will not necessarily improve
performance with an increase in the buffer size.  Generally speaking,
the average file transfer must be 32K or larger to gain any efficiency
with an increased buffer size.  Also, if you are using virtual memory,
increasing the buffer size may actually slow down performance due to
the decreased available physical memory.  Test your application with
both the default buffer and the desired new buffer size before
permanently increasing the buffer size beyond the default.


API MEMORY ALLOCATION

Try this speed tip only if you are comfortable directly calling the
CauseWay API.

Inveterate tweakers may try out the SetMCBMax and GetMCBSize functions
in the CauseWay API.  These functions allow fine-tuning of the
threshold used by CauseWay to allocate memory via a memory pool using
memory control blocks (MCBs) rather than via normal DPMI functions.
Since DPMI allocates memory in multiples of 4K, setting the MCB
threshold too low may result in a good deal of wasted memory and
subsequent performance degradation.



Chapter X   CAUSEWAY SERVICES

The following information is most useful for developing add-on routines
for Clarion written in C or assembly language.  It describes the
services available through CauseWay for low-level protected mode
compatible functions and interrupt servicing.

The CauseWay services support both 16- and 32-bit selectors.  Although
Clarion C and assembly language developers will typically use 16-bit
selectors for their routines, nothing precludes use of 32-bit
dynamically allocated data selectors with a Clarion CauseWay-extended
application.  Use of 32-bit selectors allows developers to directly
access many megabytes of memory in a Clarion program using only one
selector value.  In addition to the normal segment registers used in
Clarion programs, the additional segment registers FS and GS are always
available for use by developers to access memory.  Refer to a 386 chip
reference book for more information on 386-level registers and
instructions.


FUNCTIONS

The CauseWay functions are based on the DPMI 1.0 specification and
offer additional enhancements. This means that 99% of the DPMI 1.0
functions are available to the CauseWay programmer in all systems
providing access to lower level functions should you need them.



CAUSEWAY API

CauseWay provides an API for C and assembly language programmers as an
extension of the DPMI API via INT 31h.  Including the file CW.INC (for
assembly language programs) or CWAPI.H (for C programs) allows easy
access to this API through appropriately named functions.  You may also
call the CauseWay API directly with appropriate register setup.

CauseWay also provides a large number of the DPMI 1.0 API services on
systems without a true DPMI server.  The function numbers supported are
as follows:

0000h-0003h, 0006h-000Ch, 0100h-0102h, 0200h-0205h, 0300h-0301h,
0303h-0304h, 0400h, 0500h-0503h, 0600h-0604h, 0702h-0703h,
0800h-0801h, 0900h-0902h.

Some of the API services require pointers to a real mode
register list. The format of this list follows:

dword            EDI
dword            ESI
dword            EBP
dword            Reserved
dword            EBX
dword            EDX
dword            ECX
dword            EAX
word             Flags
word             ES
word             DS
word             FS
word             GS
word             IP
word             CS
word             SP
word             SS

The values are passed to the target routine without any
interpretation of their contents.  There is no need to set the
high words of the extended register entries unless the target
routine requires them.


STACK FRAMES

Stack frames for 16-bit interrupts are the same as for real mode.

The stack frame for 16-bit exceptions follows:

word SS          
word SP          - Original stack address
word Flags       
word CS          
word IP          - Original Flags:CS:IP values that caused the exception
word Err Code    - Processor supplied exception error code
word CS          
word IP          - Return address, returns to interrupt/exception dispatch code


DEFAULT API

The default CauseWay API follows.  Functions that end in the
text "Near" are solely intended for use with CauseWay's 32-bit
flat mode and should not be used by Clarion developers.  Flat
mode is incompatible with Clarion programs.  Near functions are
included here only for completeness of the API documentation.
The 32-bit versions of the API calls may be used with Clarion,
but require an assembly language interface to properly set up
the extended register as they are not used in normal Clarion
programs.  The assembly language program include file CW.INC
also contains the following list.


AliasSel    Create a read/write data selector from source selector.

Inputs:     AX= 0ff06h
            BX= Source selector

Outputs:    Carry set on error else,
            AX= New data selector

Errors:     If an invalid selector is passed in BX, this function returns
            with carry set.

Notes:      This function always creates a read/write data selector
            regardless of the source selector type.  It can be used to
            provide write access to variables in a code segment.

CodeSel     Make a selector execute/read type.

Inputs:     AX= 0ff05h
            BX= Selector
            CL= Default operation size. (0=16 bit,1=32 bit)

Outputs:    Carry set on error.

Errors:     If an invalid selector is passed in BX, this function returns
            with carry set.

Notes:      This functions allows a selector to be converted to a type
            suitable for execution.


FarCallReal Simulate real mode far call.

Inputs:     AX= 0ff02h
            ES:[E]DI= Real mode register list.

Outputs:    Register list updated.

Errors:     None.

Notes:      This function works much the same as IntXX but provides a
            16 bit FAR stack frame and the CS:IP values are used to pass
            control to the real mode code.


GetCallBack Allocate real mode call back address.

Inputs:     AX= 0303h
            DS:[E]SI= Call address.
            ES:[E]DI= Real mode register structure.

Outputs:    Carry set on error, else,
            CX:DX= Real mode address to trigger mode switch.

Errors:     Call-backs are a limited resource. Normally only 16 are
            available per virtual machine.  Use them carefully and release
            them as soon as they are no longer required.

Call-Back:  Interrupts disabled.
            DS:[E]SI = Selector:Offset of real mode SS:SP.
            ES:[E]DI = Selector:Offset of real mode call structure.
            SS:[E]SP = Locked protected mode stack.
            All other registers undefined

            To return from call-back procedure, execute an IRET to
            return.

            ES:[E]DI =  Selector:Offset of real mode call structure to
            restore.

Notes:      Real mode call-backs provide a means of switching from real
            mode to protected mode. This function returns a unique real
            mode address that when given control in real mode, switches
            to protected mode and passes control to the protected mode
            routine supplied at entry to this function.  On entry to the
            protected mode code the real mode register structure contains
            all the real mode register values.


GetDOSTrans      Get current address and size of the buffer used for DOS
                 memory transfers.

Inputs:     AX = 0ff25h

Outputs:    BX = Real mode segment of buffer.
            DX = Protected mode selector for buffer.
            ECX = Buffer size

Errors:     None

Notes:      This buffer is used by the INT API translation services, e.g.,
            INT 21h, AH=40h (write to file). The default buffer is 8k
            and uses memory that would otherwise be wasted. This
            default is sufficient for most file I/O but if you are writing a
            program that reads/writes large amounts of data you should
            consider allocating your own larger buffer and pass the
            buffer's address to CauseWay to speed file I/O.


GetEVect    Get Protected mode exception handler address.

Inputs:     AX= 0202h
            BL= Exception vector number.

Outputs:    Carry set on error else,
            CX:[E]DX= selector:offset of handler.

Errors:     The number in BL must be in the range 0-1Fh.  Anything
            outside this range returns carry set.


GetMCBSize  Get current memory control block (MCB) memory
            allocation block size.

Inputs:     AX = 0ff27h

Outputs:    ECX = Current threshold

Errors:     None

Notes:      See SetMCBMax


GetMem      Allocate a block of memory.

Inputs:     AX= 0ff0bh
            CX:DX= Size of block required in bytes. (use -1:-1 to get
            maximum memory size)

Outputs:    Carry set on error else,
            BX= Selector to access the block with or if CX:DX was -1,
            CX:DX= size of largest block available.

Errors:     The amount of memory available is limited by physical
            memory present and free disk space of the drive being used
            by the VMM.  If CauseWay is unable to find a large enough
            block this function returns carry set.

Notes:      This function allocates a block of extended (application)
            memory and allocates a selector with a suitable base and limit.


GetMemLinear     Allocate a block of memory without a selector.

Inputs:     AX= 0ff10h
            CX:DX= Size of block required in bytes.

Outputs:    Carry set on error else,
            SI:DI= Linear address of block allocated.

Errors:     If not enough memory is available to satisfy the request then
            this function returns carry set.

Notes:      Addresses returned by this function may be >16M.


GetMemLinear32    Allocate a block of memory without a selector.

Inputs:     AX= 0ff11h
            ECX= Size of block required in bytes.

Outputs:    Carry set on error else,
            ESI= Linear address of block allocated.

Errors:     See GetMemLinear

Notes:      Addresses returned by this function may be >16M.


GetMem32    Allocate a block of memory.

Inputs:     AX= 0ff0ch
            ECX= Size of block required in bytes. (-1 to get maximum
            memory size)

Outputs:    Carry set on error else,
            BX= Selector to access the block with or if ECX was -1,
            ECX= size of largest block available.

Errors:     See GetMem

Notes:      This function allocates a block of extended (application)
            memory and allocates a selector with a suitable base and limit.


GetMemDOS   Allocate a region of DOS (conventional) memory.


Inputs:     AX= 0ff21h
            BX= Number of paragraphs (16 byte blocks) required.

Outputs:    Carry set on error and BX= largest block size,
            AX=DOS error else, 
            AX= Initial real mode segment of allocated block  
            DX= Initial selector for allocated block

Errors:     If there are not enough selectors or memory available then this
            function returns carry set.

Notes:      If the size of the block requested is greater than 64K bytes
            (BX > 1000h) then contiguous descriptors are allocated. If
            more than one descriptor is allocated under 32-bit
            applications, the limit of the first descriptor is set to the size
            of the entire block.  All subsequent descriptors have a limit of
            64K except for the final descriptor which has a limit of block
            size MOD 64K. For 16-bit applications, always set the limit
            of the first descriptor to 64K.


GetMemNear  Allocate an application relative block of memory.

Inputs:     AX= 0ff16h
            EBX= Size of block required in bytes.

Outputs:    Carry set on error else,
            ESI= Application relative linear address of block allocated.

Errors:     If there is not enough memory available to satisfy the request
            then this function returns carry set.

Notes:      Addresses returned by this function are an offset from the
            start of the application's memory and are intended to be used
            with the NEAR memory  model.


GetRVect    Get real mode interrupt handler address.

Inputs:     AX= 0200h
            BL= Interrupt vector number.

Outputs:    CX:DX= selector:offset of handler.

Errors:     None.


GetSel      Allocate a new selector.

Inputs:     AX= 0ff03h

Outputs:    Carry set on error else,
            BX= Selector.

Errors:     Approximately 8192 selectors are available initially.  While
            this is a large quantity, it is obviously possible to run out.

Notes:      A selector is allocated and initialized with a base of 0, a limit
            of 0 and as read/write expand up data.  Use SetSelDet to
            make the selector useful, setting an appropriate base and limit.


GetSelDet   Get selector linear base and limit.

Inputs:     Carry set on error else,
            AX= 0ff07h
            BX= Selector

Outputs:    Carry set on error else,
            CX:DX= Linear base.
            SI:DI= Byte granular limit.

Errors:     If an invalid selector is passed in BX, this function returns
            with carry set.


GetSelDet32 Get selector linear base and limit.

Inputs:     AX= 0ff08h
            BX= Selector

Outputs:    Carry set on error else,
            EDX= Linear base.
            ECX= Byte granular limit.

Errors:     If an invalid selector is passed in BX, this function returns
            with carry set.


GetVect     Get Protected mode interrupt handler address.

Inputs:     AX= 0204h
            BL= Interrupt vector number.

Outputs:    CX:[E]DX= selector:offset of handler.

Errors:     None.


Info        Get system selectors/flags.

Inputs:     AX= 0ff00h

Outputs:    AX= Selector for real mode segment address of 00000h, 4G
            limit. 
            BX= Selector for current PSP segment. 100h limit. 
            [E]CX= DOS transfer buffer size. Always <64K. 
            DX= DOS transfer buffer real mode segment address.
            ES:[E]SI= DOS transfer buffer address. 
            ESI+ECX ALWAYS <64K
            EDI= System flags. Bits significant if set.0 - 32 bit code
            default.
            1 - Virtual memory manager functional.
            2 \ Mode, 0 - raw, 1 - VCPI, 2 - DPMI.
            3 /
            4 - DPMI available.
            5 - VCPI available.
            6 - No memory managers.
            7 - Descriptor table type. 0 - GDT, 1 - LDT.

Errors:     None

Notes:      Bits 1-2 of DI indicate the interface type being used by
            CauseWay.

            Bits 4-5 indicate the interface types that are available.  Bit 7
            indicates the descriptor table being used to allocate selectors to
            the application when on a raw/VCPI system. The DOS
            transfer buffer is the area CauseWay uses to transfer data
            between conventional and extended memory during DOS
            interrupts.  This memory can be used as temporary work
            space to access real mode code as long as you remember it
            may be overwritten the next time you issue an INT in
            protected mode that requires segment pointers.


IntXX       Simulate real mode interrupt.

Inputs:     AX= 0ff01h
            BL= Interrupt number.
            ES:[E]DI= Real mode register list.

Outputs:    Register list updated.

Errors:     None.

Notes:      The real mode register list referenced by ES:[E]DI should
            contain the register values you want passed to the real mode
            interrupt handler.  CauseWay fills in the SS:SP and Flags
            values to ensure that legal values are used and the CS:IP
            entries are ignored. This function bypasses protected mode
            interrupt handlers and provides access to INT APIs that
            require segment pointers.


Linear2Near Convert linear address to application relative address.

Inputs:     AX= 0ff19h
            ESI= Linear address to convert.

Outputs:    ESI= Application relative linear address.

Errors:     None


LockMem     Lock a region of memory.

Inputs:     AX= 0ff1bh
            BX:CX= Starting linear address of memory to lock.
            SI:DI= Size of region to lock in bytes.

Outputs:    Carry set on error.

Errors:     If any of the region specified is invalid or if not enough
            physical memory is available to fill the region specified, then
            none of the memory is locked and this function returns carry
            set.

Notes:      Memory that is locked cannot be swapped to disk by the
            VMM. Locking applies to memory on 4K boundaries. 
            Therefore, areas of memory below and above the memory
            being locked are locked if the specified region is not aligned
            to a 4K boundary.


LockMem32   Lock a region of memory.

Inputs:     AX= 0ff1ch
            ESI= Starting linear address of memory to lock.
            ECX= Size of region to lock in bytes.

Outputs:    Carry set on error.

Errors:     See LockMem.

Notes:      Memory that is locked cannot be swapped to disk by the
            VMM. Locking applies to memory on 4K boundaries. 
            Therefore, areas of memory below and above the memory
            being locked are locked if the specified region is not aligned
            to a 4K boundary.


LockMemNear Lock a region of memory using application relative
            address.

Inputs:     AX= 0ff1fh
            ESI= Starting linear address of memory to lock. 
            EBX= Size of region to lock in bytes.

Outputs:    Carry set on error.

Errors:     See LockMem

Notes:      Memory that is locked cannot be swapped to disk by the
            VMM. Locking applies to memory on 4K boundaries. 
            Therefore, areas of memory below and above the memory
            being locked are locked if the specified region is not aligned
            to a 4K boundary.


Near2Linear Convert application relative address to linear address.

Inputs:     AX= 0ff1ah
            ESI= Application relative linear address.

Outputs:    ESI= Linear address.

Errors:     None


RelCallBack Release a real mode call back entry.

Inputs:     AX= 0304h
            CX:DX= Real mode address returned by GetCallBack

Errors:     None.

Outputs:    None.

Notes:      Use this function to release call-back addresses once they are
            no longer needed.


RelMem      Release memory allocated by either GetMem or GetMem32.

Inputs:     AX= 0ff0fh
            BX= Selector for block to release.

Outputs:    Carry set on error.

Errors:     If an invalid selector is passed in BX or the memory was not
            allocated via GetMem or GetMem32, this function returns
            carry set.


RelMemDOS   Release a block of DOS (conventional) memory allocated
            by GetMemDOS.

Inputs:     AX= 0ff23h
            DX= Selector of block to free.

Outputs:    Carry set on error and AX= DOS error code.

Errors:     If an invalid block is passed, this function returns carry set.

Notes:      All descriptors allocated for the memory block are
            automatically freed and therefore should not be accessed once
            the block is freed by this function.


RelMemLinear     Release previously allocated block of memory (linear
                 address).

Inputs:     AX= 0ff14h
            SI:DI= Linear address of block to release.

Outputs:    Carry set on error.

Errors:     If the address passed in SI:DI is not a valid memory block,
            this function returns carry set.


RelMemLinear32   Release previously allocated block of memory
                 (linear address).

Inputs:     AX= 0ff15h
            ESI= Linear address of block to release.

Outputs:    Carry set on error.

Errors:     See RelMemLinear


RelMemNear  Release previously allocated application relative block of
            memory.

Inputs:     AX= 0ff18h
            ESI= Application relative linear address of block to release.

Outputs:    Carry set on error.

Errors:     If the address passed in ESI is not a valid memory block this
            function returns carry set.


RelSel      Release a selector.

Inputs:     AX= 0ff04h
            BX= Selector.

Outputs:    Carry set on error.

Errors:     If an invalid selector is passed in BX, this function returns
            with carry set.

Notes:      Use this function to release selectors allocated by GetSel or
            AliasSel.


ResMem      Resize a previously allocated block of memory.

Inputs:     AX= 0ff0dh
            BX= Selector for block.
            CX:DX= New size of block required in bytes.

Outputs:    Carry set on error.

Errors:     If an invalid selector is passed in BX or not enough memory
            is available when increasing the block size, then this function
            returns carry set.


Notes:      If the memory block cannot be resized in its current location,
            but a free block of memory of the new size exists, the
            memory is copied to a new block and the old one is released.
            The application is not affected as long as only the selector
            originally allocated with GetMem accesses the memory.


ResMem32    Resize a previously allocated block of memory.

Inputs:     AX= 0ff0eh
            BX= Selector for block.
            ECX= New size of block required in bytes.

Outputs:    Carry set on error.

Errors:     See ResMem

Notes:      If the memory block cannot be resized in its current location,
            but a free block of memory of the new size exists, the
            memory is copied to a new block and the old one released. 
            This is transparent to the application as long as only the
            selector originally allocated with GetMem is used to access the
            memory.


ResMemDOS   Resize a block of DOS (conventional) memory allocated
            with GetMemDOS.

Inputs:     AX= 0ff22h
            BX= New block size in paragraphs
            DX= Selector of block to modify

Outputs:    Carry set on error, AX= DOS error code, BX= Maximum
            block size in paragraphs.

Errors:     If an invalid block is passed or if not enough selectors or
            memory are available when expanding the block this function
            returns carry set.

Notes:      Growing a memory block is often likely to fail since other
            DOS block allocations prevent increasing the size of the
            block.  Also, if the size of a block grows past a 64K boundary
            then the allocation fails if the next descriptor in the LDT is
            not free.


ResMemLinear     Resize a previously allocated block of memory without a
                 selector.

Inputs:     AX= 0ff12h
            SI:DI= Linear address of block to resize.
            CX:DX= Size of block required in bytes.

Outputs:    Carry set on error else,
            SI:DI= New linear address of block.

Errors:     If not enough memory is available when extending the block
            size this function returns carry set.

Notes:      If the memory block cannot be expanded to the desired size,
            and a free block of sufficient size exists, the existing memory
            is copied to the free block and released.  The new block is
            allocated in place of the old.


ResMemLinear32   Resize a previously allocated block of memory
                 without a selector.

Inputs:     AX= 0ff13h
            ESI= Linear address of block to resize.
            ECX= Size of block required in bytes.

Outputs:    Carry set on error else,
            ESI= New linear address of block.

Errors:     See ResMemLinear

Notes:      If the memory block cannot be expanded to the desired size,
            and a free block of sufficient size exists, the existing memory
            is copied to the free block and released.  The new block is
            allocated in place of the old.


ResMemNear  Resize a previously allocated application relative block
            of memory.

Inputs:     AX= 0ff17h
            EBX= Size of block required in bytes.
            ESI= application relative linear address of block to resize.

Outputs:    Carry set on error else,
            ESI= New application relative linear address of block.

Errors:     If the address passed in ESI is not a valid memory block or
            there is not enough memory available when expanding the
            block this function returns carry set.

Notes:      If the memory block cannot be expanded to the desired size,
            and a free block of sufficient size exists, the existing memory
            is copied to the free block and released.  The new block is
            allocated in place of the old.


SetDOSTrans Set new address and size of the buffer used for DOS
            memory transfers.

Inputs:     AX = 0ff26h
            BX = Real mode segment of buffer.
            DX = Protected mode selector for buffer.
            ECX = Buffer size (should be <=64K)

Outputs:    None

Errors:     None

Notes:      The buffer must be in conventional memory and only the first
            64K will be used even if a bigger buffer is specified.
            CauseWay will automatically restore the previous buffer
            setting when the application terminates but GetDOSTrans can 
            be used to get the current buffer's settings if you only want
            the change to be temporary.

            You can still use the default buffer for your own purposes
            even after setting a new address.


SetEVect    Set Protected mode exception handler address.

Inputs:     AX= 0203h
            BL= Exception vector number.
            CX:[E]DX= selector:offset of new handler.

Outputs:    Carry set on error.

Errors:     The number in BL must be in the range 0-1Fh. Anything
            outside this range returns carry set.


SetMCBMax   Set new memory control block (MCB) memory
            allocation block size.

Inputs:     AX = 0ff28h
            ECX = New value to set (<=64K)

Outputs:    None

Errors:     Carry set on error

Notes:      The maximum block size that will be allocated from MCB
            memory is 16 bytes less than the value set by this function. 
            The default value is 16384.

            65536 is the maximum value this function will accept. Passing
            a value above this will return with the carry set and the 
            original value still in force.

            The CauseWay API memory allocation functions allocate
            memory from two sources.  Allocation requests below the
            value returned by this function are allocated from a memory
            pool controlled via conventional style MCB's. Requests above
            this value are allocated via the normal DPMI functions.
            Because DPMI memory is always allocated in multiples of 4K
            it can become very inefficient for any program that needs to
            allocate small blocks of memory. The value set by this
            function controls the size of memory chunks that will be 
            allocated to and managed by the MCB system.

            A value of zero can be passed to this function to disable the
            MCB allocation system.

            The value passed will be rounded up to the nearest 4K.


SetRVect    Set real mode interrupt handler address.

Inputs:     AX= 0201h
            BL= Interrupt vector number.
            CX:DX= selector:offset of new handler.

Outputs:    None.

Errors:     None.


SetSelDet   Set selector linear base and limit.

Inputs:     AX= 0ff09h
            BX= Selector.
            CX:DX= Linear base.
            SI:DI= Byte granular limit.

Outputs:    Carry set on error.

Errors:     If an invalid selector is passed in BX, this function returns
            with carry set.


SetSelDet32 Set selector linear base and limit.

Inputs:     AX= 0ff0ah
            BX= Selector.
            EDX= Linear base.
            ECX= Byte granular limit.

Outputs:    Carry set on error.

Errors:     If an invalid selector is passed in BX, this function returns
            with carry set.


SetVect     Set Protected mode interrupt handler address.

Inputs:     AX= 0205h
            BL= Interrupt vector number.
            CX:[E]DX= selector:offset of new handler.

Outputs:    None.

Errors:     None.


UnLockMem   Unlock a region of memory.

Inputs:     AX= 0ff1dh
            BX:CX= Starting linear address of memory to unlock
            SI:DI= Size of region to unlock in bytes

Outputs:    Carry set on error.

Errors      If any of the memory region specified is invalid this function
            returns carry set.

Notes:      This function allows the unlocked memory to be swapped to
            disk by the VMM if necessary.  Areas below and above the
            specified memory to the nearest 4K boundary are unlocked if
            the specified region is not aligned to a 4K boundary.

UnLockMem32 Unlock a region of memory.


Inputs:     AX= 0ff1eh
            ESI= Starting linear address of memory to unlock
            ECX= Size of region to unlock in bytes

Outputs:    Carry set on error.

Errors:     See UnLockMem

Notes:      This function allows the memory to be swapped to disk by the
            VMM if necessary.  Areas below and above the specified
            memory to the nearest 4K boundary are unlocked if the
            specified region is not aligned to a 4K boundary.


UnLockMemNear    Unlock a region of memory using application
                 relative address.

Inputs:     AX= 0ff20h
            ESI= Starting linear address of memory to unlock
            EBX= Size of region to unlock in bytes

Outputs:    Carry set on error.

Errors:     See UnLockMem

Notes:      This function allows the memory to be swapped to disk by the
            VMM if necessary.

            Areas below and above the specified memory to the nearest
            4K boundary are unlocked if the specified region is not
            aligned to a 4K boundary.


NOTES

A fixed segment selector at 40h is always available to the application.
This selector maps the real mode memory at 400h where most of the BIOS
variables can be found.  CauseWay also provides selectors at standard
video addresses 0B000h, 0B800h and 0A000h to ease conversion of real
mode code.

The environment variable block address in the Program Segment Prefix
(PSP) is a valid protected mode selector.  A valid protected mode
selector:offset is also placed in the PSP at offset 34h for the file
handle list pointer. Note that the default value in the program's PSP
will point to the real mode PSP, not the protected mode PSP, even if
the handle count is less than or equal to twenty. Code that makes use
of the handle list should use the address at PSP+34h rather than
assuming the list's position within the PSP.  Also, when an application
is operating non-DPMI conditions the handle table will have an entry
for CauseWay's VMM swap file.

DOS functions which use the obsolete file control blocks (FCBs) are not
supported by CauseWay.

CauseWay applications should terminate using INT 21H function 4Ch.  As
with real mode operation, the error level passed to this function in
the AL register is returned to the parent program or DOS.

If a CauseWay application needs to terminate and stay resident (TSR),
then INT 21H function 31h may be used.  Unlike real mode operation, no
memory value is required for this function.  All memory owned by the
application when the TSR function is issued remains the program's
property.   There is currently no way of removing the CauseWay
application from memory once it becomes a TSR without rebooting the
machine or using a third party TSR manager.  However, a TSR manager
will not automatically release extended memory allocated for the
CauseWay TSR.

Unhandled exceptions terminate the program with a register display dump
to screen and a text file called CW.ERR.  CW.ERR contains other
potentially useful information about the state of the application when
it terminated.  Refer to the appendices for more information on the
CW.ERR file information format.



Chapter 9   INTERRUPT SERVICES

EXTENDED OR ALTERED INTERRUPT SERVICES 

The size of register used by CauseWay's extended or modified
interrupt services depends on the limit of the selector.
Extended 32-bit registers are used for 32-bit sized selectors
and 16-bit registers are used for selectors within 16-bits.  To
reflect this, the convention of an [E] in brackets is used
before a listed register when it must be a 32-bit value with a
32-bit selector and a 16-bit value with a 16-bit selector.

Required registers that are not specified in this list should be
set up in the same way as required for normal DOS real mode
operation.  For INT APIs that are not listed and require segment
pointers, either handle them using the CauseWay IntXX function
or create your own interrupt translation code.


INT 10h

10h sub function 02h, [E]DX instead of DX.
10h sub function 09h, [E]DX instead of DX.
10h sub function 12h, [E]DX instead of DX.
10h sub function 17h, [E]DX instead of DX.
13h [E]BP instead of BP.
1Ch sub function 01h, [E]BX instead of BX.
1Ch sub function 02h, [E]BX instead of BX.


INT 21h

09h [E]DX instead of DX
0Ah [E]DX instead of DX
0Fh - 17H not supported; use corresponding file handle function.
1Ah [E]DX instead of DX
21h - 24h not supported; use corresponding file handle function.
25h [E]DX instead of DX. Protected mode vector will be set. 
26h - 29h not supported; use corresponding file handle function.
2Fh [E]BX instead of BX
31h No value is required in DX.
35h [E]BX instead of BX. Protected mode vector will be returned. 
39h [E]DX instead of DX
3Ah [E]DX instead of DX
3Bh [E]DX instead of DX
3Ch [E]DX instead of DX
3Dh [E]DX instead of DX
3Fh [E]DX instead of DX
40h [E]DX instead of DX
41h [E]DX instead of DX
43h [E]DX instead of DX
44h sub function 02h, use [E]DX instead
44h sub function 03h, use [E]DX instead
44h sub function 04h, use [E]DX instead
44h sub function 05h, use [E]DX instead
47h [E]SI instead of SI
48h Protected mode memory will be allocated
49h Protected mode memory will be released
4Ah Protected mode memory will be resized
4Bh [E]DX & [E]BX instead of DX & BX; 
    Parameter block offset entries are [d]word 
4Eh [E]DX instead of DX
56h [E]DX & [E]DI instead of DX & DI
5Ah [E]DX instead of DX
5Bh [E]DX instead of DX
62h Protected mode selector will be returned
6Ch [E]SI instead of SI


INT 23h  Control-C Handler Address

This interrupt is always reflected back to the protected mode
handler to ensure the CauseWay application can handle it
correctly.  The default handler aborts the application in the
same manner as DOS. If you need to terminate your application in
your own handler, perform an INT 21h, AH=4ch as normal.


INT 24h  Critical Error Handler Address

This interrupt is always reflected back to the protected mode handler
to ensure the CauseWay application can handle it correctly.  The
default handler behaves in the same way as the DOS handler and it
aborts your application, if appropriate.  If you install your own
handler, all memory accessed by this interrupt as code or data must be
locked.

The register values normally placed on the stack by DOS before entry to
the interrupt handler are not present in protected mode.  Only the
register values are valid.  You may terminate your application from
within this interrupt with INT 21h, AH=4ch as normal.


INT 33h

09h [E]DX instead of DX.
0Ch [E]DX instead of DX.
16h [E]DX instead of DX.
17h [E]DX instead of DX.


NOTES

With the exception of software interrupts that require segment pointers
as parameters, all interrupts can be issued as normal.  The most common
interrupt APIs that require segment pointers are intercepted by
CauseWay to provide normal access to these services.  Any other real
mode interrupt services that require segment pointers can be accessed
using CauseWay's simulate real mode interrupt/far call services.

Hardware interrupts are always reflected to protected mode handlers
even when signaled during real mode operations.  This ensures that
protected mode applications always retain control without requiring you
to patch real mode interrupt vectors.  The remaining interrupts are
serviced via the vector table appropriate to the mode.  Use the real to
protected mode call- back services to provide real mode code with
access to protected mode code, and allow any interrupt to be
re-signaled in protected mode.

If you add your own hardware interrupt handlers, such as the timer tick
at vector 08h, any memory that the handler reads or writes, including
its code, must reside in locked memory.  (CauseWay provides a locked
stack.)  This limitation is required because DOS not is not re-entrant
and hardware interrupts can occur at any time.  Interrupts occurring
during DOS activity prevent CauseWay's virtual memory manager from
accessing its swap file and locked memory will not move to the swap
file.



Chapter 10   CAUSEWAY FILE COMPRESSOR

The CauseWay file compressor (CWC.EXE) compresses executable CauseWay
applications to reduce their file size on disk.  Space savings of 50%
of the original executable file's original size frequently occur.  CWC
is simple to use.  There are no options or parameters to specify other
than name of executable file.  The command line follows this format:

CWC MYPROG

MYPROG indicates the name of the CauseWay executable file to be
compressed. If no extension follows MYPROG, .EXE is appended by CWC.

As CWC compresses the file, the percentage of file compressed is
dynamically displayed.  The total compression percentage is displayed
at the end of CWC's operation.

CWC has a /M option, the parameters are /M1, /M2, and /M3 with /M1 as
the default.  These parameter will trade off [de]compression speed for
better compression ratios.

Depending upon the speed of the machine running the CauseWay
application, most CWC-compressed applications demonstrate no noticeable
load time delay when run.  Applications that consist mostly of
executable code are those most affected by decompression times and may
load slightly slower than normal.  Applications operating on low-end
machines will be most affected by decompression-related load delays.
In the event that the additional load time delay becomes unacceptable,
do not use CWC to compress the file.

NOTE:  Do not use a standard DOS EXE-format file compressor, such as
PKLITE or LZEXE, on CauseWay applications.  They will either fail to
compress the program or cause program failure if compression is
completed.



Chapter 11   CAUSEWAY SYMBOLIC DEBUGGER

The CauseWay symbolic debugger consists of two files, CWD.EXE
and CWD.OVL.  To use the debugger, CWD.OVL and CWD.EXE must be
in the same directory.  To operate CWD, use the following format
on the command line:

CWD [CWD OPTIONS] MYPROG [MYPROG COMMAND LINE]

MYPROG indicates the CauseWay application to be debugged with CWD.  Any
commands specified on the command line after MYPROG are passed to
MYPROG as normal.  Specify any CWD options before the CauseWay
application name, MYPROG in the above example.

CWD searches the CauseWay application's .SYM or .MAP file, MYPROG.SYM
or MYPROG.MAP in the above example, for a list of symbols.  .SYM files
are created by linking the CauseWay application with WL32's /sy option.
.MAP files are created by linking with WL32's /m option or specifying a
map file name when linking.

CWD will find .SYM and .MAP files only if they are present in the
current directory.  CWD checks first for a .SYM file, then for a .MAP
file if no .SYM file is found.  When using .MAP files that have many
public symbols, CWD may take a long time to process all of the symbolic
information, causing delayed load times.  The .SYM file contains
symbolic information in an optimized form and allows much quicker CWD
loading.

Symbols will by displayed by the debugger when they match a code
routine or data variable address to improve readability of your
application.  The CauseWay debugger only supports symbols found in a
.SYM or .MAP file.  Symbols are present in a .SYM or .MAP file only if
they are declared public in the module that defines the symbol.

CWD OPTIONS

/dm       Use a monochrome monitor for output from CWD.
/eSYMBOL  Run the program until SYMBOL is reached. 


CS:EIP WINDOW

The quick help bar shows most of the available keypresses across the
bottom of the screen. To move within the current view, use the cursor
keys but remember that this doesn't alter the code in the CS:EIP
window.

The current CS:EIP position is marked by a greater than (>) symbol as
well as a green bar.

The current display position is marked by a blue bar.

Breakpoints are marked with an asterisk (*) symbol and a red bar with a
countdown value in brackets to the right of the asterisk.  Note that a
countdown value of 0 means the breakpoint will trigger next time the
code at the breakpoint address is executed. A value of 1 means the
count will be decremented next time the breakpoint address is
encountered but another pass will be needed to trigger a break.

The following chart shows the keypress and functions for the CS:EIP
window.


Keypress         Function

F1-User          Displays the user/application screen.

Alt-F1-Syms      Toggle on and off display of symbols from .SYM or .MAP file.

F2-Break         Sets or resets a break point at the current view point.

F3-Goto          Moves the display point to the expression specified when
                 prompted.  Expression used may contain symbols,
                 numbers or registers.  Segment and offset should be
                 separated by a colon.  For example, SS:ESP and DS:80h
                 are both valid expressions.  It is not possible to specify
                 both a register and a numeric/symbolic expression for
                 the offset, e.g. EBP+10h.

Alt-F3-List      Displays a sorted list of symbols. Highlight the symbol you
                 want to move the display to and press enter.  Symbols
                 are listed with names on the left and values on the right. 
                 The C or D displayed adjacent to the value indicates the
                 address type is CODE or DATA.  A speed search is
                 available by typing the desired symbol text.
                 Backspacing to eliminate typed characters is supported.

F4-Here          Executes instructions until the current view position is
                 reached.

F5-Data          Opens a data window with default assignments.
                 CWD supports multiple data windows.

F6-Skip          Steps CS:EIP over the current instruction without
                 executing it.

F7-Trace         Executes the next instruction only.

Alt-F7-Into      Trace into an interrupt (INT) instruction.

F8-Step          Executes instructions until the next instruction is
                 reached.

F9-Run           Starts normal execution which continues until either the
                 program terminates or a breakpoint condition is satisfied.

F10-Flip         Toggles the display flipping method between fast
                 (default) and complete (slow).  Use complete mode when
                 debugging applications that change the screen mode.

Alt-F10-Rest     Restart application and restore CWD to initial loaded
                 state.  Use this to do another debug pass on an
                 application that has terminated or to otherwise
                 restart and application to its original load condition.

+                When current display position is on a breakpoint, this
                 increments the breakpoint's trigger count.  The
                 countdown value display in brackets will be updated
                 with each keypress.

-                When current display position is on a breakpoint, this
                 decrements the breakpoint's trigger count.  The
                 countdown value display in brackets will be updated
                 with each keypress.

Alt-X            Exit to DOS.


DATA #?? WINDOW

The quick help bar shows most of the available keypresses across the
bottom of the screen.  Use the cursor keys to move around the display
and keys 0 to 9 and A to F to change values in any of the hexadecimal
display formats.  You can enter any value on the text display format,
including pressing ALT plus a number on the numeric keypad.  Multiple
data windows are supported by CWD.

The following chart shows the keypress and functions for the Data
window.

Keypress         Function

F3-Goto          Moves the display point to the expression specified when
                 prompted.  The expression used may contain symbols,
                 numbers or registers.  Segment and offset should be
                 separated by a colon.  For example, SS:ESP is a valid
                 expression as is DS:80h.  It is not possible to specify
                 both a register and a numeric/symbolic expression for
                 the offset, e.g. EBP+10h. If a register is used, then the
                 display dynamically tracks that register value as each
                 instruction is executed.

Alt-F3-List      Displays a sorted list of symbols. Highlight the symbol you
                 want to move the display to and press enter.  Symbols
                 are listed with names on the left and values on the right. 
                 The C or D displayed adjacent to the value indicates the
                 address type is CODE or DATA.  A speed search is
                 available by typing the desired symbol text.
                 Backspacing to eliminate mistyped characters is supported.

F4-Bytes         Display list of bytes.

F5-Words         Display list of words.

F6-Dwords        Display list of dwords.

F7-Text          Display ASCII string.

F8-Mixed         Display list of bytes followed by a list of ASCII
                 representations.

F10-Close        Closes the Data window.

Alt-X            Exit to DOS.

REGISTER WINDOW

The quick help bar shows most of the available keypresses across the
bottom of the screen. Use the cursor keys to move around the display and
the 0 to 9 and A to F keys to change the hexadecimal register values.

The following chart shows the keypress and functions for the Register
window.

Keypress         Function

F3-Expr          Allows entry of an expression to set the register value.

Alt-F3-List      Displays a list of symbols. Highlight the symbol you
                 want to move the display to and press enter.  Symbols
                 are listed with names on the left and values on the right. 
                 The C or D displayed adjacent to the value indicates the
                 address type is CODE or DATA.  A speed search is
                 available by typing the desired symbol text.
                 Backspacing to eliminate mistyped characters is supported.
                 Using this function on EIP sets CS and moves the
                 CS:EIP window to the chosen address.

+                Increments the current register value.

-                Decrements the current register value.

Alt-X            Exit to DOS.


GENERAL NOTES ON WINDOWING

To select any window other than the current foreground window, click
the mouse once with the cursor inside the desired window.  Release the
mouse button before making further selections.

To move a window, click on the title bar of the foreground window and
move the mouse while holding the mouse button down.

To adjust a window size, click on the bottom right corner of the
current window and move the mouse while holding the mouse button down.

To cycle through available windows, press TAB.

To cycle through windows in reverse order, press SHIFT-TAB.

For those working with graphics, mode 13h is directly supported.
However, the proliferation of numerous SVGA modes prohibits supporting
of all of them. Therefore, using a monochrome monitor helps you to
debug applications that use graphics modes.



Chapter 12   WARPWRAP

ENVIRONMENT VARIABLE BURN-IN UTILITY

WARPWRAP (WW.EXE) is a utility that allows control over the environment
variables accessible by an EXE program and allows setting uninitialized
conventional memory to a specific value upon program startup.
Environment variables can be preset to a particular value, deleted if
already present, or added if they do not already exist.  The individual
creating the EXE program controls these attributes, without enduser
intervention or the need for batch files.

WARPWRAP works by modifying an EXE file by adding code that is
immediately called when the EXE file is loaded by DOS.  It changes the
program's environment variable block (if necessary) so that the block
contains settings specified by the WARPWRAP user, and optionally sets
uninitialized memory to a selected value.  The code then transfers
operation back to the original program.  The enduser does not notice
any difference from normal EXE operation.  In effect, WARPWRAP "wraps"
a seamless shell around the EXE file.


USING WARPWRAP

You can use WARPWRAP in two different ways.  The simplest, but least
powerful, is to specify one environment variable to be added, or
replaced, on the command line along with the EXE file name to be
modified.  You simply use an exclamation point (!) followed by the
environment variable setting.  This format replaces only one
environment variable much like the burn-in capabilities of other
products.

For example:

WW !COW=MOO MYPROG

presents the environment variable setting COW=MOO to MYPROG.EXE as if
the user had typed SET COW=MOO prior to running the program.  If the
environment variable COW previously existed and contained a different
setting, for example COW=MILK, it would be changed to COW=MOO.  If it
did not previously exist, it would be created.  No other environment
variables are modified.  Note that the .EXE extension on the EXE file
name is optional.

A second way of using WARPWRAP replaces multiple environment variables,
as well as performs other tasks. You may specify a script definition
file to list the environment variable and memory setting manipulations
desired.  Precede the script definition file with the at-sign (@).  A
default extension of .DEF is assigned if none is specified.

For example:

WW @STUFF MYPROG

uses the contents of the definition file STUFF.DEF to modify the
environment variables passed to MYPROG.EXE.

If no environment setting or definition file name is listed (i.e. ! or
@ does not precede an EXE file name), WARPWRAP defaults to using a
definitions file called WARPWRAP.DEF.  If WARPWRAP.DEF does not exist,
WARPWRAP aborts processing.

For example:

WW MYPROG

uses the contents of the definition file WARPWRAP.DEF to modify the
environment variables passed to MYPROG.EXE.

WARPWRAP COMMANDS

WARPWRAP recognizes the following six commands within a script
definition file, in addition to the environment variable settings.  All
commands are preceded with a tilde (~).


~NEW             All environment variables on subsequent lines of the
                 definition file are added to the EXE file environment
                 block ONLY if they do not already exist.  If the
                 environment variable already exists, regardless of
                 setting, no changes are made.  ~NEW environment
                 variables must have a setting or else WARPWRAP
                 aborts with an error at the incorrect line.  ~NEW stays
                 in effect for all subsequent environment variables until a
                 ~REPLACE or ~DELETE command is encountered.

~REPLACE         All environment variables on subsequent lines of the
                 definition file are added to the EXE file environment
                 block regardless of whether or not they already exist. If
                 they already exist, they are replaced.  ~REPLACE
                 environment variables must have a setting or else
                 WARPWRAP aborts with an error at the incorrect line. 
                 ~REPLACE stays in effect for all following
                 environment variables until a ~NEW or ~DELETE
                 command is encountered. ~REPLACE is the default
                 condition in a definition file if no other command is
                 present, as if the definitions file started with a
                 ~REPLACE command.

~DELETE          All environment variables on subsequent lines of the
                 definition file that match a pre-existing environment
                 variable are removed from the EXE file environment
                 block.  If a ~DELETE environment variable is
                 specified but does not exist, then the ~DELETE
                 command is ignored for that variable without causing an
                 error.  ~DELETE environment variables must not have
                 a setting or else WARPWRAP aborts with an error at
                 the incorrect line.  ~DELETE stays in effect for all
                 following environment variables until a ~NEW or
                 ~REPLACE command is encountered.

~SAVECASE        Directs WARPWRAP to keep the exact case of all
                 following environment variables. By default, all
                 environment variables and their settings are changed to
                 uppercase.

~NOSAVECASE      Restores WARPWRAP to the default method of
                 changing environment variables and their setting
                 to uppercase.

~CLEAR           Clears all uninitialized conventional memory owned by
                 the program to zero or the hexadecimal value optionally
                 listed following the ~CLEAR command.  If no value is
                 listed, then zero is used.  Conventional memory is
                 initialized in 2-byte (word) increments, so the value may
                 range from 0 to FFFF.  Invalid values result in either a
                 zero value or an overflow setting of unknown value that
                 is used to clear memory.


Use a pound sign (#) at the beginning of any line in a definition file
to create a comment line.  Such lines are ignored by WARPWRAP when
processing.  Comment lines are useful for inserting remarks about the
definition file.

You can precede environment variables with the text SET and thus
mimic the DOS prompt for setting environment variables.  This
is most useful if you want to set environment variables that
match a WARPWRAP command without WARPWRAP interpreting the
environment variable setting as a command.

Script definition files and WARPWRAP itself are only necessary when
modifying an EXE file.  After an EXE file has been modified, it
no longer requires any WARPWRAP files.  The EXE file contains
all code and data required to perform the tasks specified by the
modified EXE file.

WARPWRAP EXAMPLES

Two files that are included on the CauseWay distribution disk,
SHOWEVAR.ASM and SHOWEVAR.OBJ, demonstrate WARPWRAP's operations.
SHOWEVAR.ASM is the source code to a small assembly language program
that displays the current environment variables passed to it.
SHOWEVAR.ASM was included for reference purposes to illustrate what the
SHOWEVAR program does.  It is not needed for testing WARPWRAP.

Link SHOWEVAR.OBJ to the executable file SHOWEVAR.EXE for use with
WARPWRAP.  You must relink SHOWEVAR.OBJ to try a new WARPWRAP setting
because you cannot restore a WARPWRAP-modified EXE file to its former
state.

Another file included on the CauseWay distribution disk, WARPWRAP.DEF,
demonstrates many of the features one might find in a WARPWRAP script
definition file.  Since this is the default script definition file
name, it can be used by WARPWRAP two ways.  Use the following format on
the command line:

WW <EXE program>

Within a program, use the following format to explicitly call
WARPWRAP:

WW @WARPWRAP <EXE program>

<EXE program> is the name of the EXE file to modify.

Refer to the WARPWRAP.DEF file included with CauseWay for a few tips
about using script definition files.


NOTES

WARPWRAP typically ignores leading and trailing spaces, although
they are not allowed within environment variable settings.  The
first of multiple commands or variables on the same line is
parsed by WARPWRAP.  The remainder are ignored.

WARPWRAP looks for data at the very end of the EXE file.
WARPWRAP will not operate correctly if another EXE-modifying
program appends additional data at the end of the EXE file after
WARPWRAP has processed the EXE file.

Do not modify WW.EXE.  Data is embedded in the WW.EXE file and
any modification made to it leads to program failure.

WARPWARP contains several error-checking features.  In the rare event
that an EXE file is too small to hold the environment variable
modifications and associated code, WARPWARP aborts the process with an
error.  WARPWRAP checks for previous processing and aborts the process
if an EXE file has already been processed by WARPWRAP.  You cannot --
and would not want to -- process an EXE file more than once with
WARPWRAP.  To restore an EXE file to unprocessed status or to change
the WARPWRAP environment variables and memory clearing information
within an EXE file, you need to rebuild the EXE file. Usually
rebuilding consists of relinking the program's object modules and
libraries to a new EXE.

WARPWRAP does not modify the master environment variable block that is
changed at the DOS prompt.  Only the environment variables inherited by
running programs are modified.

WARPWRAP and WARPWRAP processed files only work under MS-DOS or PC-DOS
version 3.0 and higher, or compatible operating systems.

You must list any environment variables that contain quotes in a
definition file rather than use the one string ! mode.



Chapter 13   TROUBLESHOOTING

This chapter provides a description of error and warning messages that
you may encounter when using CauseWay.  Suggested solutions to correct
the errors are included where possible.


DOS EXTENDER ERROR MESSAGES AND RETURN VALUES

DOS extender error messages are displayed by the CauseWay DOS
extender when a CauseWay application is running and encounters a
serious problem that it cannot recover from.  The DOS extender
then terminates the application with the appropriate return
code, displaying a dump of register values, and writing system
information to the file CW.ERR.  The WL32 linker itself is a
CauseWay application and some of these errors can occur when
using WL32 to link your application if the error condition is
present.

01 - Unable to resize program memory block.

     Generated if DOS reports an error when CauseWay tries to
     resize its real mode memory block.  As the block is always
     shrunk the only possible cause of this is corrupted memory
     control blocks (MCBs).  Reboot the system to correct this
     error.

02 - 386 or better required.

     Generated if CauseWay is run on any machine with a
     processor below a 386SX.  To correct this error, run the
     application on another machine or upgrade the machine's
     processor.

03 - Non-standard protected mode program already active.

     Generated if the system is already operating under the
     control of another protected mode program which doesn't
     conform to either VCPI or DPMI standards.   Identify and
     remove the other application before running the CauseWay
     application.

04 - DOS 3.1 or better required.

     Generated if DOS version is less than 3.1.  You need to
     upgrade the machine's DOS version or use another machine to
     operate the CauseWay application.

05 - Not enough memory for CauseWay.

     Generated if the system doesn't have enough free physical
     memory to initialize the CauseWay kernel code and data.
     Free additional memory before running the CauseWay
     application.  The memory can be any of the extended or
     conventional types supported by CauseWay.

06 - VCPI failed to switch into protected mode.

     Generated if a VCPI server is detected and the server fails
     to switch into protected mode when requested.  The only
     likely cause of this error is a corrupted system.  Reboot
     the system and try again.

07 - Unable to control A20.

     Generated if CauseWay detects an A20 line that doesn't
     respond to the normal control methods.  This may indicate
     either a hardware fault or a nonstandard system.  There is
     no software solution for these hardware problems.
     Installing an XMS driver such as HIMEM.SYS should address
     nonstandard systems.

08 - Selector allocation error.

     Generated if DPMI refuses to allocate enough selectors for
     CauseWay to function.  Remove one or more programs that are
     also using DPMI.

09 - Unrecoverable exception. Program terminated.

     Generated if a nonrecoverable exception occurs which
     suggests a bug in the application.  Use the register dump
     displayed with this message along with the information in
     CW.ERR and optionally the program's .MAP file to help track
     down the location and cause of the problem.

10 - Unable to find application to load.

     Generated if CauseWay is unable to find the application
     within the executable .EXE file.  This situation indicates
     a corrupted file.  Rebuild or obtain another copy of the
     application.

11 - DOS reported error while accessing application.

     Generated if any kind of error is detected while accessing
     the CauseWay application executable file.  This situation
     indicates a corrupted or missing file.  Rebuild or obtain
     another copy of the application.

12 - Not enough memory to load application

     Generated if CauseWay is unable to provide enough memory to
     load the application.  Free additional memory and/or disk
     space before running the application.  Check for TEMP and
     TMP environment variables that point to a disk with little
     free space.  If running under an operating system that
     provides DPMI per application, increase the application's
     DPMI allocation.

13 - DPMI failed to switch to protected mode.

     Generated if the machine is using a DPMI server and it
     fails to switch to protected mode.  If the DPMI server only
     supports multiple clients of the same type (either 16- or
     32-bit) then the problem is probably that different types of
     applications are already being run.  Remove the other type of
     DPMI application(s) before running the CauseWay
     application.

14 - Memory structures destroyed. Program terminated.

     Generated if internal memory management structures become
     corrupted.  This is caused by the CauseWay application
     writing to memory regions that have not been allocated to
     it and is a bug in the application.  Obtain a corrected
     version of the application to fix this error.

15 - DOS reported an error while accessing swap file. Program
     terminated.

     Generated if any level of error is detected while accessing
     the swap file.  The swap file has probably been deleted
     inadvertently by the application or perhaps marked as
     read-only.

16 - Unsupported DOS function call. Program terminated.

     The CauseWay application attempted to use an obsolete DOS
     function which used file control blocks (FCBs).  Use the
     file handle DOS functions in the application instead.


WL32 WARNING MESSAGES

Warning messages are displayed by the WL32 protected mode linker when
it encounters a problem while linking a CauseWay application.  Warning
messages are nonfatal and therefore the link process is not terminated.
Warning messages do not always indicate a problem which needs to be
resolved: see the explanations below for further details on situations
in which warnings may be ignored during the link process.

Symbol defined more than once: <symbol name>
Defined in <filename>, duplicated in <filename>

     This message appears if a program has two or more globally
     visible symbols with the same name.  Rename or make private
     or local one of the symbols to solve this problem.  Also,
     check for two or more occurrences of the same object module
     in the object module list. The first definition of the
     symbol has precedence over any definitions that may follow.

Unresolved externally declared symbol: <symbol name>
Declared in <filename>

     This message appears when a required object module or
     library file was not specified on the linker command line,
     or when the name of a function or procedure has been
     misspelled or not made publicly accessible for another
     module's use.  The linker cannot find a symbol needed by
     the program to resolve an external reference in a module.

     An unresolved external warning may be ignored if the symbol
     is never used by the program.

     Unresolved externals may also be present if you only link
     part of an application's code for testing.  As long as the
     application does not use the unresolved routines or
     variables specified by the symbol, you may ignore the
     warning(s).

Unknown linker option or command ignored: <command or option text>

     This message indicates the linker has encountered text
     which it cannot understand.  Since the text is not preceded
     by a slash (/), the condition does not stop the link
     process, but will simply ignore the text and continue
     linking.  This warning message will only be displayed if
     the /wu (warn on unknown options or commands) WL32 linker
     option is set.


WL32 ERROR MESSAGES AND RETURN VALUES

Linker error messages are displayed by the WL32 linker when it
encounters a serious problem while linking a CauseWay application that
WL32 cannot recover from.  Error messages are always immediately
followed by WL32 terminating the link process without creating an
executable file.

128 - Internal linker error occurred during linking process,
      value <number>

     Either a badly corrupted object module has confused WL32
     beyond its ability to recover or else you have discovered
     an error in the linker.  In either case, please call
     technical support for help.  Make a note of the <number>
     value to help technical support track down the error.

129 - MS-DOS or PC-DOS version must be 3.0 or above.

     The machine running WL32 must use MS-DOS or PC-DOS version
     3.0 or above, or compatible operating system.  Either
     upgrade the machine's version of DOS or link the program on
     a different machine.

130 - Response file line length exceeds 125 characters in <file name>

     Response files have no size limit, but lines within them
     do.  This message indicates that a line in <file name> is
     larger than 125 characters.  Either break up the line,
     using plus (+) signs for positional response file formats,
     or place the linker command in a subsequent line for
     freeformat response file formats.

131 - Invalid option: <option text>

     An invalid option or option setting was passed to WL32
     either at the DOS prompt or through a response, batch, or
     make file.  Refer to the WL32 Options chapter for a
     complete description of all valid WL32 options and their
     values.  This error commonly occurs when a configuration
     definitions file morphed option does not match the option
     listed in a response file.  See the Configuration Files
     chapter for more information on morphing options and
     commands.

132 - Response files nested more than 10 levels deep in <file name>

     There is no limit to the number of response files you can
     supply to WL32 but there is a limit to how deeply they can
     be nested. This message indicates <file name> exceeds a
     nesting deeper than ten levels.  Move the offending
     response files out of the tenth nesting level.

133 - Allocate memory attempt failed. Probably out of virtual
      memory.

     This error is most often caused when CauseWay's virtual
     memory manager runs out of conventional and extended memory
     and disk space is very low.  Free up more disk space or
     extended memory.  When using Windows or OS/2, allocate more
     DPMI memory for the linking session.

134 - Resize memory attempt failed.  Probably out of virtual memory.

     WL32 failed to increase the memory associated with a
     selector that was already allocated because there was no
     more memory available.  This error is most often caused
     when CauseWay's virtual memory manager runs out of
     conventional and extended memory and disk space is very
     low.  Free up more disk space or extended memory.  If you
     are using an operating system that uses DPMI, make sure
     enough DPMI is allocated to your program.  If you are using
     a TEMP or TMP environment variable, make sure it is not
     pointing to a disk with little free space.

135 - At least one object module file must be specified when linking.

     One or more options and possibly an EXE file name, MAP file
     name, or library files were listed in the linker command
     line or response file. However, an object module was not
     listed.  Supply at least one object module file name when
     linking.

136 - Bad object record type in <filename>, value <number>

     WL32 did not recognize an object record type in the file
     <filename>.  The value of the unrecognized object record is
     listed as <number>.

137 - Unsupported object record type in <file name>, value
     <number>

     WL32 recognizes the object record type, but cannot process
     it.  The most common reason for this situation is use of an
     obsolete record type that was created by a very old or
     nonstandard compiler or assembler.  If possible, inhibit
     generation of the unsupported object record type or upgrade
     the module containing the obsolete record.

138 - Object record length too large in <file name>

     To protect against internal buffer overflow, WL32 checks
     the size of object records.  Since the 4K size threshold is
     well above the object record size generated by any compiler
     or assembler under normal conditions, this message
     typically occurs when attempting to link a corrupted or
     invalid object module.

139 - Release memory attempt failed.

     This error should not occur in normal circumstances.  It
     indicates WL32 failed to release previously allocated
     memory.  Either there is an error in WL32 or the DOS
     extender, or some form of memory or DOS corruption has
     occurred.  Reboot the machine and determine conditions
     which make the error recur.

140 -  Poorly formed object record in <file name>, value
     <number>

     WL32 recognized the object record type in the file
     specified by <file name>, but the internal structure of the
     object record deviated from expectations.  Either an
     obsolete or brand new record type, or a corrupted object
     module is the likely cause.  Report the value of <number>
     to technical support to help determine the nature of the
     problem.

141 - Segment size exceeds 64K: <segment name>

     A 16-bit segment has become larger than 64K (65536 bytes)
     after combination of the same segment types.  Either reduce
     the code or data associated with that segment, or make the
     segment 32-bit.  You cannot make Clarion code a 32-bit
     segment and must always reduce the size of the offending
     segment.

142 - Bad or invalid library (.LIB) file format in <file name>

     This message indicates the library file listed has an
     unrecognizable format or is corrupted. WL32 supports the
     industry standard Microsoft .LIB format used by most
     languages including Clarion.  Proprietary formats
     incompatible with this library file standard will not work
     with WL32.

143 - 32-bit segment in DOS EXE file: <file name>

     CauseWay supports 32-bit segments.  Standard 16-bit DOS
     does not.  This message indicates the application was
     linked using the /ex option and one of the segments in an
     object module was flagged as 32-bit.  You must either
     create a DOS-extended EXE file by removing the /ex option
     or change the segment to 16-bit.

144 - Configuration file line length exceeds 125 characters in 
     <file name>

     Configuration files have no size limit.  However the length
     of any particular line in the file cannot be larger than
     125 characters.  Reduce the size of the offending line.

145 - Invalid configuration file line: <line text>

     This message indicates a configuration file was specified
     using the /lc option, but WL32 could not understand a
     command line with this file, shown as <line text>.  Refer
     to the Configuration Files chapter for a list of valid
     commands.

Variable - DOS error, value <number>, File: <file name>
     (<explanatory text>)

     A DOS error has occurred when linking.  <number> indicates
     the DOS error number.  If a file is associated with the DOS
     error its name is listed as well, as <file name>.  Several
     common DOS errors have short explanatory text (e.g. file
     not found) which is placed in parentheses at the end of the
     message.  Not all DOS errors have this explanatory text.

Variable - Unknown error occurred during linking process.

     This message should never appear.  It means that a problem
     does not match those supported by WL32's normal
     error-reporting routines.  Contact technical support to
     help track down the source of the error.



Chapter 14   TECHNICAL SUPPORT

As a registered CauseWay owner, you may contact CauseWay technical
support for help with any CauseWay-related problems that you cannot
solve on your own.


GETTING HELP

Before contacting technical support, please read the chapter titled
Troubleshooting.  The answer to your problem may be there, saving you
the time and effort involved in contacting CauseWay technical support.

If you cannot find an answer to your question, contact CauseWay
technical support.  You may telephone CauseWay technical support at
(708) 717-6369.  If no one is available when you call, please leave a
message.  You may FAX Technical Support at (708) 717-6373.

For electronic mail support, you may send CompuServe mail to Michael
Devore at CompuServe ID 71540,62.  CompuServe supports an Internet mail
gateway for those with Internet access to send mail to a CompuServe ID.
Use the ID format 71540.62@compuserve.com when sending mail through the
Internet.  In addition to CompuServe, several online other services
support Internet mail.  These include GEnie, America OnLine, Prodigy,
as well as many bulletin board systems (BBSs).  Please contact your
online service or BBS for details on sending mail through Internet.

CauseWay technical support cannot provide specific details on sending
electronic mail via any particular service.  Please be aware that there
can be delays of a few minutes up to several hours when sending mail
via Internet to CompuServe and that you cannot send non-ASCII or binary
files via the Internet to CompuServe at this time without special
processing.


CALLING TECHNICAL SUPPORT

When contacting technical support, please be prepared to provide the
following information:

-    The CauseWay options used when linking.

-    The language(s) and version you are using, including any
     third party products.

-    Your machine configuration, including:  free and total XMS
     and extended memory, memory manager version, operating
     system version, free conventional memory, device drivers,
     and other information that may pertain to the problem
     situation.

In cases where a problem cannot be duplicated by CauseWay technical
support, we may request you send copies of one or more of the
following: response file (link file), object modules, CONFIG.SYS,
AUTOEXEC.BAT, data files, and any third party or proprietary binary or
other files needed to link and run the program at the technical support
site.

All program files that are sent to technical support are erased after
testing is completed.  Requiring a specific nondisclosure agreement for
your proprietary files or data is usually acceptable, but may
unavoidably delay the testing process.  Required nondisclosure
agreements must be approved by CauseWay technical support before
testing begins.



Appendix A   Rules For Protected Mode Operation

The following information is most useful for developing third party
routines for Clarion that are written in C or assembly language.  It
covers additional restrictions for protected mode compatible code that
are not present when writing real mode compatible code.

Using protected mode rather than real mode requires following a few new
programming rules to prevent processor faults from being generated,
terminating the CauseWay application.  These processor faults occur
when an application breaks a protected mode programming rule.

Use the following rules for programming in protected mode:

1.   A selector value (referred to as a segment value in real
     mode) loaded into a segment register references an area of
     memory that may occur anywhere within the machine's
     physical address space. The operating system can
     dynamically move this area of memory.  Therefore, when
     dealing with selector values:

     a.  Never use segment registers as general purpose
         registers that can be loaded with arbitrary values.
         Every time a segment register is loaded with a value
         the processor checks the validity of the selector value
         and generates a fault if it is invalid.

     b.  Never perform segment arithmetic on a selector value.
         Segment arithmetic is usually performed in real mode
         code to either normalize a pointer, access a new
         paragraph of memory without changing an offset, or to
         access a single area of memory that is greater than 64K
         in size.  Since a selector value is an index into a
         table which contains the actual memory addresses,
         addition or subtraction of different selector values is
         meaningless and gives no useful results.  (There exist
         special cases where contiguous selector values can be
         added or subtracted from for useful effect, but these
         cases exceed the scope of this manual.)

     c.  Do not access data at an offset greater than the size
         of the associated selector.  Attempts to do so result
         in a fault.  This is one of the greatest strengths of
         protected mode because most obscure bugs in real mode
         code occur when a bad pointer value accesses the wrong
         area of memory, or when a buffer overflows and memory
         beyond the buffer is overwritten.

     d.  Do not attempt to write to or read from the NULL (zero
         value) segment.  Attempts to do so results in a fault.
         In addition to valid selector values, segment registers
         can be safely loaded with a value of 0 but this
         selector value cannot be used to access memory or
         execute code.

2.   Do not execute code in a data segment and do not write to
     data in the code segment.  Use the CauseWay AliasSel
     function to map a data selector to the same physical memory
     area shared by a code selector when necessary.  Even in
     this case, however, never write to memory using a cs:
     override because it always causes a processor fault.

3.   CauseWay handles most of the standard DOS interrupts
     transparently.  When passing pointers to buffers for
     software interrupt calls not handled by CauseWay, create
     the buffers in low (conventional) DOS memory.  In addition,
     convert the pointers from protected mode selector:offset
     pairs to real mode segment:offset pairs.



Appendix B  CW.ERR File Information Format

The following information is most useful for developing, debugging, or
using routines for Clarion written in C or assembly language.  It
describes the format of the CW.ERR file that CauseWay creates when an
exception occurs in a CauseWay application.  This information can be
very useful in tracking down exactly where and why an exception
occurred.

SEQUENCE

The first line in CW.ERR is the CauseWay copyright message including
the version of CauseWay used in the program.  The version number may
prove useful in tracking down problems that have been corrected in
later versions of CauseWay.

The version is followed by the exception number and error code.  These
numbers, as well as all others in the CW.ERR file, are in hexadecimal.
The values listed are those reported by the processor when the
exception occurred.  Detailed information about the significance of the
values can be obtained in most 386 and above reference books.
Typically the exception value will be 0DH, a General Protection Fault,
or 0CH, a stack fault usually due to stack overflow or underflow.

Next comes the general register values which indicate the state of the
program when the exception occurred. The significance of register
values is entirely dependent on the program being run at the time.
CS:EIP register values can help track down the problem area by
pinpointing exactly where in the code the exception occurred.  Other
register values may help determine why the exception occurred.  In
particular, look for use of registers as memory indices with values
beyond the limit of the associated selector.

Next, the segment register values are displayed as a real selector
value followed by the program relative value in bytes.  If the second
value is non-numeric (xxxxxxxx) then the segment register didn't
contain a selector value allocated to the program at load time,
although the value may be valid if it was dynamically allocated by the
operating program.  If there is a second value, it also appears in the
program's .MAP file.  Segment register values are also useful in
determining why an exception occurred.  One common error is using an
invalid selector value in DS, ES, FS, or GS.

Next, the processor control register values are listed.  These
registers are unlikely to be of much use for debugging and will only be
filled in when not running under a true DPMI server.  For an exception
0Eh (page fault), CR2 is the linear address that was accessed for which
no memory was mapped in.  This may help track down the problem area.

"Info Flags=" come next. This value is returned by CauseWay's sys Info
API function.  Check it against the documentation for sys Info in the
CauseWay API chapter to determine some aspects of the environment in
which the program was running when the exception occurred, e.g.
whether a DPMI server was being used.

The resource tracking details come next.

Selectors are listed with the following headings:

sel      base    limit    type D mem count

Where:

sel      Selector value.
base     Linear base address of selector.
limit    Limit of selector.
type     CODE or DATA.
D        16 or 32 to signify segment D bit.
mem      Y or N to indicate if the selector has a memory block
         associated with it.
count    segment count in MAP file, xxxx if dynamically allocated.

The selector list is finished off with a display of the total
number of selectors allocated to the program.  For example:

Total selectors: 0107


Linear memory blocks are listed following the selector list, and
contain the following headings:

handle   base    length 

Where:

handle   Linear memory [de]allocation uses handles to control
         the blocks.  This field is the block's handle.

base     Linear base address of the memory block.

length   Length of the block in bytes.

The linear memory list ends with a display of the total linear memory
allocated to the program, the real (rounded to 4K pages) memory
allocated in parentheses, and finally the total number of memory
blocks.  For example:

Total Linear memory: 000FEAC9 (001AA000) in 00000103 blocks

Entries in the selector list that have Y under "mem" should have a
corresponding entry in the linear memory list.


Linear memory locks are listed after the linear memory block
list and contain the following headings:

base    length 

Where:

base     Linear base of the locked region.

limit    Length of the locked region.

NOTE:  These values are passed by the program but the actual
values have the base rounded down a page and the length rounded
up a page to match 4K boundary restrictions on locking.  The
values are reported in CW.ERR using this unrounded format to
make it easier to cross reference this list to the other lists
in CW.ERR.


Next, protected mode interrupt vectors are listed with the
following headings:

No sel   offset 

Where:

No       Vector number.

sel      Selector value for handler.

offset   Offset value for handler.

This information allows a cross-reference with the other lists
to ensure CauseWay application installed handlers have been
properly made.

Next, protected mode exception vectors are listed using the same
format as protected mode interrupts.

After the protected mode exception vector list, real mode
interrupt vectors are listed.  They are shown in the same format
as protected mode interrupts although the selector values are
real mode segment values.

Only those interrupt and exception vectors altered by the
program will be listed.



Appendix C   WL32 Segment Type Criteria

The following information is most useful for developing routines for
Clarion written in C or assembly language.  It describes how WL32
assigns attributes to program segments.

In protected mode, several attributes control the use of segments.  The
most important one depends upon whether the segment contains code,
data, or stack.  Unlike real mode, in protected mode a code segment
must be execute-only or execute/read, and a data segment must be
read-only or read/write.  CauseWay creates code segments that are
execute/read and data and stack segments which are read/write.  (Future
versions of CauseWay may include additional segment types.)

WL32 uses the following selection criteria to determine and flag to the
DOS extender a segment type that is executable code, read/write data,
or stack.  Asterisk (*) stands for a wildcard character that replaces
zero or more characters of any type.

Code Segment (all classes and names case sensitive) if:
   segment class *CODE
   segment class CO*, segment name CO*
   segment class MISC, segment name MISC
   segment class CLARION, segment name _CODE* 
   segment class CLARION, segment name _CLA_MAIN* 
   segment class CLARION, segment name *_BIN_SEG

Stack Segment if:
   class *STACK, case sensitive

Data Segment if:
   no match on Code or Stack segment types



Appendix D   Glossary Of Terms

This glossary defines technical terms used in this manual.
Common programming terms are not listed.  These terms are
defined for completeness, and knowledge of their definitions is
not necessary to develop CauseWay applications.

3P   
     386 Protected mode file format, the file format used by
     CauseWay when building DOS extended executable files.

Aliasing
     Allocating a selector that has the same base and limit as
     another selector but not usually the same type.  Aliasing
     usually refers to creating a data selector that addresses
     the same memory as a code selector. Aliasing allows write
     access to variables within a code segment as long as the
     cs: instruction override is not used.  While aliasing isn't
     a particularly good term for this operation because the new
     selector doesn't track changes to the original selector, it
     is the term most commonly used by developers.

API
     Application Program Interface is the means by which an
     application communicates with the underlying operating
     system or environment.  With CauseWay, the API is handled
     through INT 31h calls with the appropriate register setup.

Call-back
     A mechanism which allows real mode code to switch the CPU
     to protected mode operation and continue execution.
     Call-backs are used by CauseWay to re-signal real mode
     hardware interrupts in protected mode.

CauseWay Application
     Any program linked with the CauseWay linker when the /ex option is
     not used.

Descriptor
     An eight-byte block of memory that describes the base
     address, limit, and type of a segment.  In protected mode
     operation, each segment always has one associated
     descriptor.

Devore, Michael
     One of the CauseWay developers.  Michael Devore wrote the
     WL32 protected mode linker, the replacement libraries, the
     CauseWay documentation, and the WARPWRAP utility.

DPMI
     DOS Protected Mode Interface is an API that defines a way
     for multiple protected mode applications to coexist
     peacefully in the same system.  It is mainly used with DOS
     extenders and not enduser applications.  DPMI is a more
     general API than the older Virtual Control Program
     Interface (VCPI) that it is replacing.

Exception
     A software interrupt associated with an error condition
     detected by the CPU.  Exceptions can either be an abort, a
     fault, or a trap.  These three types are simply indications
     of the severity and recoverability of the error.
     Frequently, the term exception is used interchangeably with
     fault without taking notice of any distinction.

Fault
     When the processor detects an error during the processing
     of a CPU instruction, a fault occurs.  Some faults are
     recoverable and are handled by the DOS extender.  Other
     faults however, are not recoverable and the DOS extender
     terminates the application that generated the fault.  The
     most common fault is a General Protection Fault or GPF.
     Interrupt 13 is the interrupt associated with a GPF.  GPFs
     are a catchall fault which are not covered by any other
     fault type.  They are typically caused by writing to or
     reading from memory beyond the limit of a segment or
     loading a segment with an invalid selector value.

Freeformat (response file format)
     An alternate response file (link file) format that WL32 can
     use if specified via the FREEFORMAT command in a
     configuration definitions file.  Freeformat is the default
     response file format used by RTLink and PLink.  In this
     format, text commands determine how a file name is
     interpreted, e.g. a map file.

GDT
     Global Descriptor Table.  80386 and above chips provide
     three types of descriptor tables when in protected mode.
     The GDT is the primary table intended for segments used by
     the operating system.  It is the only descriptor table that
     can contain call and interrupt gates, and other system type
     selectors. The GDT is not affected by task switch
     instructions, that is, it is available to all processes in
     an multi- tasking environment.  There is one and only one
     GDT in protected mode.

GPF
     General Protection Fault.  See Fault.

INT 15h
     Miscellaneous BIOS functions API.  One of these functions is
     reporting the amount of physical memory present in a machine.

INT 31h
     The DPMI API interrupt. DPMI & CauseWay services are provided
     via this interrupt.

LDT
     Local Descriptor Table.  The LDT holds segment descriptors
     much as the Global Descriptor Table (GDT), except that LDT
     descriptors are available only to tasks using that
     particular LDT.  The LDT is loaded from a task's state
     segment when task switch instructions are executed so each
     task can have its own LDT in a multi-tasking environment.
     There can be more than one or no LDTs at all present in
     protected mode.

Normalizing (a pointer)
     In real mode, 4096 segment values with differing offsets
     can be used to address the same memory address, e.g.
     5000:213h and 5020:13h. Converting to the largest possible
     segment value and the smallest offset value (in the range 0
     to 0fh) is called normalizing, e.g. 5021:3h.  When
     normalizing a pointer, use the largest possible segment
     value and the smallest possible offset value.  Protected
     mode does not support normalizing pointers because it
     performs arithmetic on selector values.  Libraries and
     routines which normalize pointers will need to be modified
     to work with CauseWay by removing the normalization code.

Physical memory
     Memory physically installed in the computer.  A combination
     of extended and conventional memory.

Positional (response file format)
     The default response file (link file) format that WL32
     uses, and the same format used by Microsoft Link, Borland's
     TLink, and WarpLink. In the positional format, the position
     of file names along with plus signs (+) and commas (,)
     within the response file determines how a file name is
     interpreted, e.g. a library file.

Protected Mode
     The native operating mode for 80386 and above chips which
     contains system resource protection features. Protected
     mode also provides enhanced features for memory addressing
     and manipulation.  Protected mode will not execute some
     real mode code without modifications.

Real Mode
     The operating mode for 8088, 8086, and 80186 CPUs. 80386
     chips and above are switched into this mode very soon after
     they start executing instructions and behave exactly like
     an 8086 with the exception of additional registers being
     available to the programmer.  Real mode is the mode DOS
     normally uses.

Selector
     When operating in protected mode, segment values do not
     directly address memory, but rather are an index into a
     descriptor table.  These indices are called selectors
     because they select the proper entry in the descriptor
     table.  A valid entry must be present in the descriptor
     table or else loading the segment register with the
     selector value causes a General Protection Fault, GPF.

VCPI
     Virtual Control Program Interface is an API that defines a
     way for multiple protected mode applications to coexist
     within the same system.  It is mainly used with DOS
     extenders and not enduser applications.

VMM
     Virtual Memory Manager.  CauseWay's virtual memory manager
     consists of the routines which handle swapping memory
     containing code and data, to and from the disk, from and to
     physical memory.

Wildsmith, John
     One of the CauseWay developers.  John Wildsmith wrote the
     CauseWay DOS extender and the CWC compression and CWD
     debugger utilities.

WL32
     The linker contained within the CauseWay software program.

XMS
     XMS stand for extended memory specification, a standard
     software interface for extended memory access.
